/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.embedder.execution;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.maven.MavenTools;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.embedder.Configuration;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.embedder.MavenEmbedderException;
import org.apache.maven.embedder.execution.MavenExecutionRequestPopulator;
import org.apache.maven.embedder.execution.SettingsAdapter;
import org.apache.maven.errors.CoreErrorReporter;
import org.apache.maven.errors.DefaultCoreErrorReporter;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.monitor.event.DefaultEventMonitor;
import org.apache.maven.monitor.event.EventMonitor;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.profiles.activation.DefaultProfileActivationContext;
import org.apache.maven.profiles.activation.ProfileActivationContext;
import org.apache.maven.realm.DefaultMavenRealmManager;
import org.apache.maven.realm.MavenRealmManager;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsConfigurationException;
import org.apache.maven.settings.SettingsUtils;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=MavenExecutionRequestPopulator.class)
public class DefaultMavenExecutionRequestPopulator
extends AbstractLogEnabled
implements MavenExecutionRequestPopulator {
    @Requirement
    private PlexusContainer container;
    @Requirement
    private WagonManager wagonManager;
    @Requirement
    private MavenSettingsBuilder settingsBuilder;
    @Requirement
    private MavenTools mavenTools;

    public MavenExecutionRequest populateDefaults(MavenExecutionRequest request, Configuration configuration) throws MavenEmbedderException {
        this.eventing(request, configuration);
        this.reporter(request, configuration);
        this.executionProperties(request, configuration);
        this.pom(request, configuration);
        this.settings(request, configuration);
        this.localRepository(request, configuration);
        this.snapshotPolicy(request, configuration);
        this.checksumPolicy(request, configuration);
        this.artifactTransferMechanism(request, configuration);
        this.realmManager(request, configuration);
        this.profileManager(request, configuration);
        this.processSettings(request, configuration);
        return request;
    }

    private void reporter(MavenExecutionRequest request, Configuration configuration) {
        if (request.getErrorReporter() == null) {
            if (configuration.getErrorReporter() != null) {
                request.setErrorReporter(configuration.getErrorReporter());
            } else {
                request.setErrorReporter((CoreErrorReporter)new DefaultCoreErrorReporter());
            }
        }
    }

    private void executionProperties(MavenExecutionRequest request, Configuration configuration) {
        Properties userProperties;
        Properties requestProperties = request.getProperties();
        if (requestProperties == null) {
            requestProperties = configuration.getSystemProperties();
            if (requestProperties == null) {
                requestProperties = System.getProperties();
            }
            request.setProperties(requestProperties);
        }
        if ((userProperties = request.getUserProperties()) != null) {
            for (String string : userProperties.keySet()) {
                if (requestProperties.containsKey(string)) continue;
                requestProperties.setProperty(string, userProperties.getProperty(string));
            }
        }
    }

    private void realmManager(MavenExecutionRequest request, Configuration configuration) {
        if (request.getRealmManager() == null) {
            if (configuration.getRealmManager() == null) {
                request.setRealmManager((MavenRealmManager)new DefaultMavenRealmManager(this.container, this.getLogger()));
            } else {
                request.setRealmManager(configuration.getRealmManager());
            }
        }
    }

    private void processSettings(MavenExecutionRequest request, Configuration configuration) {
        ProfileManager profileManager = request.getProfileManager();
        Settings settings = request.getSettings();
        List settingsProfiles = settings.getProfiles();
        List settingsActiveProfileIds = settings.getActiveProfiles();
        profileManager.explicitlyActivate(settingsActiveProfileIds);
        if (settingsProfiles != null && !settingsProfiles.isEmpty()) {
            for (org.apache.maven.settings.Profile rawProfile : settings.getProfiles()) {
                Profile profile = SettingsUtils.convertFromSettingsProfile((org.apache.maven.settings.Profile)rawProfile);
                profileManager.addProfile(profile);
                for (Repository r : profile.getRepositories()) {
                    ArtifactRepositoryPolicy releases = new ArtifactRepositoryPolicy();
                    if (r.getReleases() != null) {
                        releases.setChecksumPolicy(r.getReleases().getChecksumPolicy());
                        releases.setUpdatePolicy(r.getReleases().getUpdatePolicy());
                    } else {
                        releases.setChecksumPolicy("daily");
                        releases.setUpdatePolicy("warn");
                    }
                    ArtifactRepositoryPolicy snapshots = new ArtifactRepositoryPolicy();
                    if (r.getSnapshots() != null) {
                        snapshots.setChecksumPolicy(r.getSnapshots().getChecksumPolicy());
                        snapshots.setUpdatePolicy(r.getSnapshots().getUpdatePolicy());
                    } else {
                        snapshots.setChecksumPolicy("daily");
                        snapshots.setUpdatePolicy("warn");
                    }
                    ArtifactRepository ar = this.mavenTools.createRepository(r.getId(), r.getUrl(), snapshots, releases);
                    request.addRemoteRepository(ar);
                }
            }
        }
    }

    private void pom(MavenExecutionRequest request, Configuration configuration) {
        if (request.getPom() != null && request.getPom().getParentFile() != null) {
            request.setBaseDirectory(request.getPom().getParentFile());
        } else if (request.getPom() == null && request.getBaseDirectory() != null) {
            File pom = new File(request.getBaseDirectory(), "release-pom.xml");
            if (!pom.exists()) {
                pom = new File(request.getBaseDirectory(), "pom.xml");
            }
            request.setPom(pom);
        } else if (request.getBaseDirectory() == null) {
            request.setBaseDirectory(new File(System.getProperty("user.dir")));
        }
    }

    private void settings(MavenExecutionRequest request, Configuration configuration) {
        if (request.getSettings() == null) {
            if (configuration.getGlobalSettingsFile() != null) {
                request.setGlobalSettingsFile(configuration.getGlobalSettingsFile());
            }
            if (configuration.getUserSettingsFile() != null) {
                request.setUserSettingsFile(configuration.getUserSettingsFile());
            }
            try {
                Settings settings = this.settingsBuilder.buildSettings(request);
                request.setSettings((Settings)new SettingsAdapter(request, settings));
            }
            catch (Exception e) {
                request.setSettings((Settings)new SettingsAdapter(request, new Settings()));
            }
        }
    }

    private void localRepository(MavenExecutionRequest request, Configuration configuration) throws MavenEmbedderException {
        if (request.getLocalRepository() == null) {
            request.setLocalRepository(this.createLocalRepository(request, request.getSettings(), configuration));
        }
    }

    private void snapshotPolicy(MavenExecutionRequest request, Configuration configuration) {
        boolean snapshotPolicySet = false;
        if (request.isOffline()) {
            snapshotPolicySet = true;
        }
        if (!snapshotPolicySet) {
            if (request.isUpdateSnapshots()) {
                this.mavenTools.setGlobalUpdatePolicy("always");
            } else if (request.isNoSnapshotUpdates()) {
                this.getLogger().info("+ Supressing SNAPSHOT updates.");
                this.mavenTools.setGlobalUpdatePolicy("never");
            }
        }
    }

    private void checksumPolicy(MavenExecutionRequest request, Configuration configuration) {
        this.mavenTools.setGlobalChecksumPolicy(request.getGlobalChecksumPolicy());
    }

    private void artifactTransferMechanism(MavenExecutionRequest request, Configuration configuration) throws MavenEmbedderException {
        if (request.isOffline()) {
            this.wagonManager.setOnline(false);
        } else if (request.getSettings() != null && request.getSettings().isOffline()) {
            this.wagonManager.setOnline(false);
        } else {
            this.wagonManager.findAndRegisterWagons(this.container);
            this.wagonManager.setInteractive(request.isInteractiveMode());
            this.wagonManager.setDownloadMonitor(request.getTransferListener());
            this.wagonManager.setOnline(true);
        }
        try {
            this.resolveParameters(request.getSettings());
        }
        catch (Exception e) {
            throw new MavenEmbedderException("Unable to configure Maven for execution", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveParameters(Settings settings) throws ComponentLookupException, ComponentLifecycleException, SettingsConfigurationException {
        WagonManager wagonManager = (WagonManager)this.container.lookup(WagonManager.class);
        try {
            Proxy proxy = settings.getActiveProxy();
            if (proxy != null) {
                if (proxy.getHost() == null) {
                    throw new SettingsConfigurationException("Proxy in settings.xml has no host");
                }
                wagonManager.addProxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), proxy.getUsername(), proxy.getPassword(), proxy.getNonProxyHosts());
            }
            for (Server server : settings.getServers()) {
                wagonManager.addAuthenticationInfo(server.getId(), server.getUsername(), server.getPassword(), server.getPrivateKey(), server.getPassphrase());
                wagonManager.addPermissionInfo(server.getId(), server.getFilePermissions(), server.getDirectoryPermissions());
                if (server.getConfiguration() == null) continue;
                wagonManager.addConfiguration(server.getId(), (Xpp3Dom)server.getConfiguration());
            }
            RepositoryPermissions defaultPermissions = new RepositoryPermissions();
            defaultPermissions.setDirectoryMode("775");
            defaultPermissions.setFileMode("664");
            wagonManager.setDefaultRepositoryPermissions(defaultPermissions);
            for (Mirror mirror : settings.getMirrors()) {
                wagonManager.addMirror(mirror.getId(), mirror.getMirrorOf(), mirror.getUrl());
            }
        }
        finally {
            this.container.release((Object)wagonManager);
        }
    }

    public ArtifactRepository createLocalRepository(MavenExecutionRequest request, Settings settings, Configuration configuration) throws MavenEmbedderException {
        String localRepositoryPath = null;
        if (request.getLocalRepositoryPath() != null) {
            localRepositoryPath = request.getLocalRepositoryPath().getAbsolutePath();
        }
        if (StringUtils.isEmpty(localRepositoryPath) && configuration.getLocalRepository() != null) {
            localRepositoryPath = configuration.getLocalRepository().getAbsolutePath();
        }
        if (StringUtils.isEmpty((String)localRepositoryPath)) {
            localRepositoryPath = settings.getLocalRepository();
        }
        if (StringUtils.isEmpty((String)localRepositoryPath)) {
            localRepositoryPath = MavenEmbedder.defaultUserLocalRepository.getAbsolutePath();
        }
        try {
            return this.mavenTools.createLocalRepository(localRepositoryPath, "local");
        }
        catch (IOException e) {
            throw new MavenEmbedderException("Cannot create local repository.", e);
        }
    }

    private void eventing(MavenExecutionRequest request, Configuration configuration) {
        List configEventMonitors;
        if (request.getEventMonitors() == null || request.getEventMonitors().isEmpty()) {
            request.addEventMonitor((EventMonitor)new DefaultEventMonitor(this.getLogger()));
        }
        if ((configEventMonitors = configuration.getEventMonitors()) != null && !configEventMonitors.isEmpty()) {
            for (EventMonitor monitor : configEventMonitors) {
                request.addEventMonitor(monitor);
            }
        }
    }

    private void profileManager(MavenExecutionRequest request, Configuration configuration) {
        ProfileActivationContext activationContext = request.getProfileActivationContext();
        if (activationContext == null) {
            activationContext = new DefaultProfileActivationContext(request.getProperties(), false);
        }
        activationContext.setExplicitlyActiveProfileIds(request.getActiveProfiles());
        activationContext.setExplicitlyInactiveProfileIds(request.getInactiveProfiles());
        DefaultProfileManager globalProfileManager = new DefaultProfileManager(this.container, activationContext);
        request.setProfileManager((ProfileManager)globalProfileManager);
        request.setProfileActivationContext(activationContext);
    }
}

