/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.embedder;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.embedder.Configuration;
import org.apache.maven.embedder.ContainerCustomizer;
import org.apache.maven.embedder.MavenEmbedderLogger;
import org.apache.maven.errors.CoreErrorReporter;
import org.apache.maven.monitor.event.EventMonitor;
import org.apache.maven.realm.MavenRealmManager;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;

public class DefaultConfiguration
implements Configuration {
    private List inactives;
    private List actives;
    private File userSettings;
    private File globalSettings;
    private ContainerCustomizer customizer;
    private Properties systemProperties;
    private List extensions = new ArrayList();
    private MavenEmbedderLogger logger;
    private ClassWorld classWorld;
    private PlexusContainer parentContainer;
    private File localRepository;
    private MavenRealmManager realmManager;
    private CoreErrorReporter errorReporter;
    private List eventMonitors;

    public Configuration addActiveProfile(String profile) {
        this.getActiveProfiles().add(profile);
        return this;
    }

    public Configuration addInactiveProfile(String profile) {
        this.getInactiveProfiles().add(profile);
        return this;
    }

    public Configuration addActiveProfiles(List profiles) {
        this.getActiveProfiles().addAll(profiles);
        return this;
    }

    public Configuration addInactiveProfiles(List profiles) {
        this.getInactiveProfiles().addAll(profiles);
        return this;
    }

    public List getActiveProfiles() {
        if (this.actives == null) {
            this.actives = new ArrayList();
        }
        return this.actives;
    }

    public List getInactiveProfiles() {
        if (this.inactives == null) {
            this.inactives = new ArrayList();
        }
        return this.inactives;
    }

    public Configuration setUserSettingsFile(File user) {
        this.userSettings = user;
        return this;
    }

    public Configuration setGlobalSettingsFile(File global) {
        this.globalSettings = global;
        return this;
    }

    public File getUserSettingsFile() {
        return this.userSettings;
    }

    public File getGlobalSettingsFile() {
        return this.globalSettings;
    }

    public Configuration setConfigurationCustomizer(ContainerCustomizer customizer) {
        this.customizer = customizer;
        return this;
    }

    public ContainerCustomizer getContainerCustomizer() {
        return this.customizer;
    }

    public Configuration setSystemProperties(Properties properties) {
        this.systemProperties = properties;
        return this;
    }

    public Properties getSystemProperties() {
        return this.systemProperties != null ? this.systemProperties : System.getProperties();
    }

    public void addExtension(URL url) {
        this.extensions.add(url);
    }

    public List getExtensions() {
        return this.extensions;
    }

    public Configuration setMavenEmbedderLogger(MavenEmbedderLogger logger) {
        this.logger = logger;
        return this;
    }

    public MavenEmbedderLogger getMavenEmbedderLogger() {
        return this.logger;
    }

    public ClassWorld getClassWorld() {
        return this.classWorld;
    }

    public Configuration setClassWorld(ClassWorld classWorld) {
        this.classWorld = classWorld;
        return this;
    }

    public Configuration setClassLoader(ClassLoader loader) {
        this.classWorld = new ClassWorld("plexus.core", loader);
        return this;
    }

    public PlexusContainer getParentContainer() {
        return this.parentContainer;
    }

    public Configuration setParentContainer(PlexusContainer parentContainer) {
        this.parentContainer = parentContainer;
        return this;
    }

    public Configuration setLocalRepository(File localRepository) {
        this.localRepository = localRepository;
        return this;
    }

    public File getLocalRepository() {
        return this.localRepository;
    }

    public MavenRealmManager getRealmManager() {
        return this.realmManager;
    }

    public Configuration setRealmManager(MavenRealmManager realmManager) {
        this.realmManager = realmManager;
        return this;
    }

    public CoreErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public Configuration setErrorReporter(CoreErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        return this;
    }

    public Configuration addEventMonitor(EventMonitor eventMonitor) {
        if (this.eventMonitors == null) {
            this.eventMonitors = new ArrayList();
        }
        this.eventMonitors.add(eventMonitor);
        return this;
    }

    public List getEventMonitors() {
        return this.eventMonitors;
    }

    public Configuration setEventMonitors(List eventMonitors) {
        this.eventMonitors = eventMonitors;
        return this;
    }
}

