/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CLIManager {
    public static final char ALTERNATE_POM_FILE = 'f';
    public static final char BATCH_MODE = 'B';
    public static final char SET_SYSTEM_PROPERTY = 'D';
    public static final char OFFLINE = 'o';
    public static final char REACTOR = 'r';
    public static final char QUIET = 'q';
    public static final char DEBUG = 'X';
    public static final char ERRORS = 'e';
    public static final char HELP = 'h';
    public static final char VERSION = 'v';
    public static final char SHOW_VERSION = 'V';
    public static final char NON_RECURSIVE = 'N';
    public static final char UPDATE_SNAPSHOTS = 'U';
    public static final char ACTIVATE_PROFILES = 'P';
    public static final String FORCE_PLUGIN_UPDATES = "cpu";
    public static final String FORCE_PLUGIN_UPDATES2 = "up";
    public static final String SUPPRESS_PLUGIN_UPDATES = "npu";
    public static final String SUPRESS_SNAPSHOT_UPDATES = "nsu";
    public static final char CHECKSUM_FAILURE_POLICY = 'C';
    public static final char CHECKSUM_WARNING_POLICY = 'c';
    public static final char ALTERNATE_USER_SETTINGS = 's';
    public static final String ALTERNATE_GLOBAL_SETTINGS = "gs";
    public static final String FAIL_FAST = "ff";
    public static final String FAIL_AT_END = "fae";
    public static final String FAIL_NEVER = "fn";
    public static final String LOG_FILE = "l";
    private Options options = new Options();

    public CLIManager() {
        OptionBuilder.withLongOpt((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Force the use of an alternate POM file.");
        this.options.addOption(OptionBuilder.create((char)'f'));
        OptionBuilder.withLongOpt((String)"define");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Define a system property");
        this.options.addOption(OptionBuilder.create((char)'D'));
        OptionBuilder.withLongOpt((String)"offline");
        OptionBuilder.withDescription((String)"Work offline");
        this.options.addOption(OptionBuilder.create((char)'o'));
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"Display help information");
        this.options.addOption(OptionBuilder.create((char)'h'));
        OptionBuilder.withLongOpt((String)"version");
        OptionBuilder.withDescription((String)"Display version information");
        this.options.addOption(OptionBuilder.create((char)'v'));
        OptionBuilder.withLongOpt((String)"quiet");
        OptionBuilder.withDescription((String)"Quiet output - only show errors");
        this.options.addOption(OptionBuilder.create((char)'q'));
        OptionBuilder.withLongOpt((String)"debug");
        OptionBuilder.withDescription((String)"Produce execution debug output");
        this.options.addOption(OptionBuilder.create((char)'X'));
        OptionBuilder.withLongOpt((String)"errors");
        OptionBuilder.withDescription((String)"Produce execution error messages");
        this.options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.withLongOpt((String)"reactor");
        OptionBuilder.withDescription((String)"Execute goals for project found in the reactor");
        this.options.addOption(OptionBuilder.create((char)'r'));
        OptionBuilder.withLongOpt((String)"non-recursive");
        OptionBuilder.withDescription((String)"Do not recurse into sub-projects");
        this.options.addOption(OptionBuilder.create((char)'N'));
        OptionBuilder.withLongOpt((String)"update-snapshots");
        OptionBuilder.withDescription((String)"Forces a check for updated releases and snapshots on remote repositories");
        this.options.addOption(OptionBuilder.create((char)'U'));
        OptionBuilder.withLongOpt((String)"activate-profiles");
        OptionBuilder.withDescription((String)"Comma-delimited list of profiles to activate");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((char)'P'));
        OptionBuilder.withLongOpt((String)"batch-mode");
        OptionBuilder.withDescription((String)"Run in non-interactive (batch) mode");
        this.options.addOption(OptionBuilder.create((char)'B'));
        OptionBuilder.withLongOpt((String)"check-plugin-updates");
        OptionBuilder.withDescription((String)"Force upToDate check for any relevant registered plugins");
        this.options.addOption(OptionBuilder.create((String)FORCE_PLUGIN_UPDATES));
        OptionBuilder.withLongOpt((String)"update-plugins");
        OptionBuilder.withDescription((String)"Synonym for cpu");
        this.options.addOption(OptionBuilder.create((String)FORCE_PLUGIN_UPDATES2));
        OptionBuilder.withLongOpt((String)"no-plugin-updates");
        OptionBuilder.withDescription((String)"Suppress upToDate check for any relevant registered plugins");
        this.options.addOption(OptionBuilder.create((String)SUPPRESS_PLUGIN_UPDATES));
        OptionBuilder.withLongOpt((String)"no-snapshot-updates");
        OptionBuilder.withDescription((String)"Supress SNAPSHOT updates");
        this.options.addOption(OptionBuilder.create((String)SUPRESS_SNAPSHOT_UPDATES));
        OptionBuilder.withLongOpt((String)"strict-checksums");
        OptionBuilder.withDescription((String)"Fail the build if checksums don't match");
        this.options.addOption(OptionBuilder.create((char)'C'));
        OptionBuilder.withLongOpt((String)"lax-checksums");
        OptionBuilder.withDescription((String)"Warn if checksums don't match");
        this.options.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withLongOpt((String)"settings");
        OptionBuilder.withDescription((String)"Alternate path for the user settings file");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)"global-settings");
        OptionBuilder.withDescription((String)"Alternate path for the global settings file");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)ALTERNATE_GLOBAL_SETTINGS));
        OptionBuilder.withLongOpt((String)"fail-fast");
        OptionBuilder.withDescription((String)"Stop at first failure in reactorized builds");
        this.options.addOption(OptionBuilder.create((String)FAIL_FAST));
        OptionBuilder.withLongOpt((String)"fail-at-end");
        OptionBuilder.withDescription((String)"Only fail the build afterwards; allow all non-impacted builds to continue");
        this.options.addOption(OptionBuilder.create((String)FAIL_AT_END));
        OptionBuilder.withLongOpt((String)"fail-never");
        OptionBuilder.withDescription((String)"NEVER fail the build, regardless of project result");
        this.options.addOption(OptionBuilder.create((String)FAIL_NEVER));
        OptionBuilder.withLongOpt((String)"log-file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Log file to where all build output will go.");
        this.options.addOption(OptionBuilder.create((String)LOG_FILE));
        OptionBuilder.withLongOpt((String)"show-version");
        OptionBuilder.withDescription((String)"Display version information WITHOUT stopping build");
        this.options.addOption(OptionBuilder.create((char)'V'));
        OptionBuilder.withLongOpt((String)"no-plugin-registry");
        OptionBuilder.withDescription((String)"Ineffective, only kept for backward compatibility");
        this.options.addOption(OptionBuilder.create((String)"npr"));
    }

    public CommandLine parse(String[] args) throws ParseException {
        String[] cleanArgs = this.cleanArgs(args);
        GnuParser parser = new GnuParser();
        return parser.parse(this.options, cleanArgs);
    }

    private String[] cleanArgs(String[] args) {
        ArrayList<String> cleaned = new ArrayList<String>();
        StringBuffer currentArg = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            boolean addedToBuffer = false;
            if (arg.startsWith("\"")) {
                if (currentArg != null) {
                    cleaned.add(currentArg.toString());
                }
                currentArg = new StringBuffer(arg.substring(1));
                addedToBuffer = true;
            }
            if (arg.endsWith("\"")) {
                String cleanArgPart = arg.substring(0, arg.length() - 1);
                if (currentArg != null) {
                    if (addedToBuffer) {
                        currentArg.setLength(currentArg.length() - 1);
                    } else {
                        currentArg.append(' ').append(cleanArgPart);
                    }
                    cleaned.add(currentArg.toString());
                } else {
                    cleaned.add(cleanArgPart);
                }
                currentArg = null;
                continue;
            }
            if (addedToBuffer) continue;
            if (currentArg != null) {
                currentArg.append(' ').append(arg);
                continue;
            }
            cleaned.add(arg);
        }
        if (currentArg != null) {
            cleaned.add(currentArg.toString());
        }
        int cleanedSz = cleaned.size();
        String[] cleanArgs = null;
        cleanArgs = cleanedSz == 0 ? args : cleaned.toArray(new String[cleanedSz]);
        return cleanArgs;
    }

    public void displayHelp() {
        System.out.println();
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("mvn [options] [<goal(s)>] [<phase(s)>]", "\nOptions:", this.options, "\n");
    }
}

