/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.usability;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginParameterException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.usability.ErrorDiagnoser;
import org.codehaus.plexus.util.StringUtils;

public class PluginConfigurationDiagnoser
implements ErrorDiagnoser {
    private static final List UNMODIFIABLE_EXPRESSIONS;

    public boolean canDiagnose(Throwable error) {
        return error instanceof PluginConfigurationException;
    }

    public String diagnose(Throwable error) {
        if (error instanceof PluginParameterException) {
            PluginParameterException exception = (PluginParameterException)error;
            return this.buildDiagnosticMessage(exception);
        }
        return error.getMessage();
    }

    private String buildDiagnosticMessage(PluginParameterException exception) {
        StringBuffer messageBuffer = new StringBuffer();
        List params = exception.getParameters();
        MojoDescriptor mojo = exception.getMojoDescriptor();
        messageBuffer.append("One or more required plugin parameters are invalid/missing for '").append(mojo.getPluginDescriptor().getGoalPrefix()).append(":").append(mojo.getGoal()).append("'\n");
        int idx = 0;
        Iterator it = params.iterator();
        while (it.hasNext()) {
            Parameter param = (Parameter)it.next();
            messageBuffer.append("\n[").append(idx++).append("] ");
            this.decomposeParameterIntoUserInstructions(mojo, param, messageBuffer);
            messageBuffer.append("\n");
        }
        return messageBuffer.toString();
    }

    private void decomposeParameterIntoUserInstructions(MojoDescriptor mojo, Parameter param, StringBuffer messageBuffer) {
        String expression = param.getExpression();
        if (param.isEditable()) {
            messageBuffer.append("specify configuration for <" + param.getName() + ">VALUE</" + param.getName() + ">");
            String alias = param.getAlias();
            if (StringUtils.isNotEmpty((String)alias)) {
                messageBuffer.append(" (aliased as: <" + alias + ">VALUE</" + alias + ">)");
            }
            messageBuffer.append("\n    inside the <configuration/> section for " + mojo.getPluginDescriptor().getArtifactId());
        }
        if (StringUtils.isEmpty((String)expression)) {
            messageBuffer.append(".");
        } else {
            StringBuffer expressionMessageBuffer = new StringBuffer();
            if (param.isEditable()) {
                expressionMessageBuffer.append(", or\n    ");
            }
            Matcher exprMatcher = Pattern.compile("\\$\\{(.+)\\}").matcher(expression);
            boolean unmodifiableElementsFound = false;
            boolean activeElementsFound = false;
            int elementCount = 0;
            while (exprMatcher.find()) {
                ++elementCount;
                activeElementsFound = true;
                String subExpression = exprMatcher.group(1);
                StringTokenizer expressionParts = new StringTokenizer(subExpression, ".");
                String firstPart = expressionParts.nextToken();
                if ("project".equals(firstPart) && expressionParts.hasMoreTokens()) {
                    this.appendProjectSection(expressionParts, expressionMessageBuffer);
                    continue;
                }
                if ("reports".equals(firstPart)) {
                    expressionMessageBuffer.append("make sure the <reports/> section of the pom.xml contains valid report names\n");
                    continue;
                }
                if (UNMODIFIABLE_EXPRESSIONS.contains(subExpression)) {
                    unmodifiableElementsFound = true;
                    continue;
                }
                expressionMessageBuffer.append("Please provide the system property: ").append(subExpression).append("\n    (specified as '-D" + subExpression + "=VALUE' on the command line)\n");
            }
            if (activeElementsFound) {
                messageBuffer.append(expressionMessageBuffer);
            } else {
                messageBuffer.append("    (found static expression: '" + expression + "' which may act as a default value).\n");
            }
            if (unmodifiableElementsFound) {
                if (elementCount > 1) {
                    messageBuffer.append("    ");
                }
                messageBuffer.append("NOTE: One or more purely derived expression elements were detected in '" + expression + "'.\n    If you continue to get this error after any other expression elements are specified correctly," + "\n    please report this issue to the Maven development team.\n");
            }
        }
    }

    private void appendProjectSection(StringTokenizer expressionParts, StringBuffer messageBuffer) {
        messageBuffer.append("check that the following section of the pom.xml is present and correct:\n\n");
        Stack<String> nestedParts = new Stack<String>();
        String indentation = "      ";
        messageBuffer.append(indentation).append("<project>\n");
        nestedParts.push("project");
        indentation = indentation + "  ";
        while (expressionParts.hasMoreTokens()) {
            String nextPart = expressionParts.nextToken();
            messageBuffer.append(indentation).append("<").append(nextPart);
            if (expressionParts.hasMoreTokens()) {
                messageBuffer.append(">\n");
                indentation = indentation + "  ";
                nestedParts.push(nextPart);
                continue;
            }
            messageBuffer.append("/>\n");
            indentation = indentation.substring(2);
        }
        if (!nestedParts.isEmpty()) {
            while (nestedParts.size() > 0) {
                String prevPart = (String)nestedParts.pop();
                messageBuffer.append(indentation).append("</").append(prevPart).append(">\n");
                indentation = indentation.substring(2);
            }
        }
    }

    static {
        ArrayList<String> exprs = new ArrayList<String>();
        exprs.add("localRepository");
        exprs.add("settings");
        exprs.add("basedir");
        UNMODIFIABLE_EXPRESSIONS = exprs;
    }
}

