/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Reader;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultMavenSettingsBuilder
extends AbstractLogEnabled
implements MavenSettingsBuilder,
Initializable {
    public static final String userHome = System.getProperty("user.home");
    private String settingsPath;
    private File settingsFile;

    public void initialize() {
        this.settingsFile = this.getSettingsFile();
        this.getLogger().debug("Building Maven settings from: '" + this.settingsFile.getAbsolutePath() + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Settings buildSettings() throws IOException, XmlPullParserException {
        Settings settings = null;
        if (this.settingsFile.exists() && this.settingsFile.isFile()) {
            FileReader reader = null;
            try {
                reader = new FileReader(this.settingsFile);
                SettingsXpp3Reader modelReader = new SettingsXpp3Reader();
                settings = modelReader.read((Reader)reader);
            }
            catch (FileNotFoundException e) {
                try {
                    this.getLogger().warn("Settings file disappeared - ignoring", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(reader);
                    throw throwable;
                }
                IOUtil.close((Reader)reader);
            }
            IOUtil.close((Reader)reader);
        }
        if (settings == null) {
            this.getLogger().debug("Settings model not found. Creating empty instance of MavenSettings.");
            settings = new Settings();
        }
        if (settings.getActiveProfile() == null) {
            File mavenUserConfigurationDirectory = new File(userHome, ".m2");
            if (mavenUserConfigurationDirectory.exists() || !mavenUserConfigurationDirectory.mkdirs()) {
                // empty if block
            }
            String localRepository = new File(mavenUserConfigurationDirectory, "repository").getAbsolutePath();
            settings.initializeActiveProfile(localRepository);
        }
        return settings;
    }

    private File getSettingsFile() {
        String path = this.settingsPath;
        String userHome = System.getProperty("user.home");
        userHome = userHome.replaceAll("\\\\", "/");
        path = path.replaceAll("\\$\\{user.home\\}", userHome);
        path = path.replaceAll("\\\\", "/");
        path = path.replaceAll("//", "/");
        return new File(path);
    }
}

