/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.project.path.PathTranslator;
import org.apache.maven.reporting.MavenReport;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.introspection.ReflectionValueExtractor;

public class PluginParameterExpressionEvaluator
implements ExpressionEvaluator {
    private final PathTranslator pathTranslator;
    private final MavenSession context;
    private final Logger logger;

    public PluginParameterExpressionEvaluator(MavenSession context, PathTranslator pathTranslator, Logger logger) {
        this.context = context;
        this.pathTranslator = pathTranslator;
        this.logger = logger;
    }

    public Object evaluate(String expr) throws ExpressionEvaluationException {
        String val;
        int exprStartDelimiter;
        Object value = null;
        if (expr == null) {
            return null;
        }
        String expression = this.stripTokens(expr);
        if (expression.equals(expr)) {
            int lastIndex;
            int index = expr.indexOf("${");
            if (index >= 0 && (lastIndex = expr.indexOf("}", index)) >= 0) {
                String retVal = expr.substring(0, index);
                retVal = retVal + this.evaluate(expr.substring(index, lastIndex + 1));
                retVal = retVal + this.evaluate(expr.substring(lastIndex + 1));
                return retVal;
            }
            return expression;
        }
        if (expression.equals("reports")) {
            String role = PluginManager.ROLE;
            try {
                PluginManager pluginManager = (PluginManager)this.context.lookup(role);
                List reportPlugins = this.context.getProject().getReportPlugins();
                if (reportPlugins != null) {
                    Iterator it = reportPlugins.iterator();
                    while (it.hasNext()) {
                        Plugin plugin = (Plugin)it.next();
                        pluginManager.verifyPlugin(plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion(), this.context);
                    }
                }
            }
            catch (ComponentLookupException cle) {
                throw new ExpressionEvaluationException("Cannot lookup component: " + role + ".", (Throwable)cle);
            }
            catch (ArtifactResolutionException are) {
                throw new ExpressionEvaluationException("Cannot resolve component: " + role + ".", (Throwable)are);
            }
            catch (PluginManagerException pme) {
                throw new ExpressionEvaluationException("Cannot verify component: " + role + ".", (Throwable)pme);
            }
            role = MavenReport.ROLE;
            try {
                value = this.context.lookupMap(role);
                Iterator i = ((Map)value).keySet().iterator();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    this.logger.debug(key + " report is found.");
                }
            }
            catch (ComponentLookupException cle) {
                throw new ExpressionEvaluationException("Cannot lookup component: " + role + ".", (Throwable)cle);
            }
        }
        if (expression.equals("localRepository")) {
            value = this.context.getLocalRepository();
        } else if (expression.equals("project")) {
            value = this.context.getProject();
        } else if (expression.startsWith("project")) {
            try {
                int pathSeparator = expression.indexOf("/");
                if (pathSeparator > 0) {
                    String pathExpression = expression.substring(1, pathSeparator);
                    value = ReflectionValueExtractor.evaluate((String)pathExpression, (Object)this.context.getProject());
                    value = value + expression.substring(pathSeparator);
                }
                value = ReflectionValueExtractor.evaluate((String)expression.substring(1), (Object)this.context.getProject());
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression, (Throwable)e);
            }
        } else if ("settings".equals(expression)) {
            value = this.context.getSettings();
        } else if (expression.equals("basedir")) {
            value = this.context.getProject().getBasedir().getAbsolutePath();
        } else if (expression.startsWith("basedir")) {
            int pathSeparator = expression.indexOf("/");
            if (pathSeparator > 0) {
                value = this.context.getProject().getFile().getParentFile().getAbsolutePath() + expression.substring(pathSeparator);
            } else {
                this.logger.error("Got expression '" + expression + "' that was not recognised");
            }
        } else {
            value = System.getProperty(expression);
        }
        if (value instanceof String && (exprStartDelimiter = (val = (String)value).indexOf("${")) >= 0) {
            value = exprStartDelimiter > 0 ? val.substring(0, exprStartDelimiter) + this.evaluate(val.substring(exprStartDelimiter)) : this.evaluate(val.substring(exprStartDelimiter));
        }
        return value;
    }

    private String stripTokens(String expr) {
        if (expr.startsWith("${") && expr.indexOf("}") == expr.length() - 1) {
            expr = expr.substring(2, expr.length() - 1);
        }
        return expr;
    }

    public File alignToBaseDirectory(File file) {
        File basedir = this.context.getProject().getFile().getParentFile();
        return new File(this.pathTranslator.alignToBaseDirectory(file.getPath(), basedir));
    }
}

