/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExclusionSetFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.monitor.logging.DefaultLog;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginParameterException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptorBuilder;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.apache.maven.project.path.PathTranslator;
import org.codehaus.plexus.ArtifactEnabledContainer;
import org.codehaus.plexus.ArtifactEnabledContainerException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryEvent;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryListener;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class DefaultPluginManager
extends AbstractLogEnabled
implements PluginManager,
ComponentDiscoveryListener,
Initializable,
Contextualizable {
    protected Map pluginDescriptors;
    protected Map pluginDescriptorsByPrefix;
    protected PlexusContainer container;
    protected PluginDescriptorBuilder pluginDescriptorBuilder;
    protected ArtifactFilter artifactFilter;
    protected PathTranslator pathTranslator;
    private ArtifactFactory artifactFactory;
    private Set pluginsInProcess = new HashSet();
    private Log mojoLogger;
    static /* synthetic */ Class class$java$lang$Object;

    public DefaultPluginManager() {
        this.pluginDescriptors = new HashMap();
        this.pluginDescriptorsByPrefix = new HashMap();
        this.pluginDescriptorBuilder = new PluginDescriptorBuilder();
    }

    public void componentDiscovered(ComponentDiscoveryEvent event) {
        ComponentSetDescriptor componentSetDescriptor = event.getComponentSetDescriptor();
        if (componentSetDescriptor instanceof PluginDescriptor) {
            PluginDescriptor pluginDescriptor = (PluginDescriptor)componentSetDescriptor;
            if (pluginDescriptor.getVersion() == null) {
                throw new NullPointerException("Version was null - check your plugin '" + pluginDescriptor.getId() + "' was built with Maven 2.0 Alpha 2");
            }
            String key = pluginDescriptor.getGroupId() + ":" + pluginDescriptor.getArtifactId();
            if (!this.pluginsInProcess.contains(key)) {
                this.pluginsInProcess.add(key);
                this.pluginDescriptors.put(key, pluginDescriptor);
                if (!this.pluginDescriptorsByPrefix.containsKey(pluginDescriptor.getGoalPrefix())) {
                    this.pluginDescriptorsByPrefix.put(pluginDescriptor.getGoalPrefix(), pluginDescriptor);
                }
            }
        }
    }

    private PluginDescriptor getPluginDescriptor(String groupId, String artifactId, String version) {
        String key = groupId + ":" + artifactId;
        return (PluginDescriptor)this.pluginDescriptors.get(key);
    }

    private PluginDescriptor getPluginDescriptor(String prefix) {
        return (PluginDescriptor)this.pluginDescriptorsByPrefix.get(prefix);
    }

    private boolean isPluginInstalled(String groupId, String artifactId, String version) {
        String key = groupId + ":" + artifactId;
        return this.pluginDescriptors.containsKey(key);
    }

    private boolean isPluginInstalled(String prefix) {
        return this.pluginDescriptorsByPrefix.containsKey(prefix);
    }

    public PluginDescriptor verifyPlugin(String prefix) {
        if (!this.isPluginInstalled(prefix)) {
            // empty if block
        }
        return this.getPluginDescriptor(prefix);
    }

    public PluginDescriptor verifyPlugin(String groupId, String artifactId, String version, MavenSession session) throws ArtifactResolutionException, PluginManagerException {
        if (version == null) {
            Plugin plugin;
            MavenProject project = session.getProject();
            Plugin pluginConfig = null;
            Iterator it = project.getBuildPlugins().iterator();
            while (it.hasNext()) {
                plugin = (Plugin)it.next();
                if (!groupId.equals(plugin.getGroupId()) || !artifactId.equals(plugin.getArtifactId())) continue;
                pluginConfig = plugin;
                break;
            }
            if (project.getReports() != null) {
                it = project.getReports().getPlugins().iterator();
                while (it.hasNext()) {
                    plugin = (Plugin)it.next();
                    if (!groupId.equals(plugin.getGroupId()) || !artifactId.equals(plugin.getArtifactId())) continue;
                    pluginConfig = plugin;
                    break;
                }
            }
            if (pluginConfig != null) {
                version = StringUtils.isEmpty((String)pluginConfig.getVersion()) ? "RELEASE" : pluginConfig.getVersion();
            }
        }
        if (!this.isPluginInstalled(groupId, artifactId, version)) {
            try {
                Artifact pluginArtifact = this.artifactFactory.createArtifact(groupId, artifactId, version, null, MojoDescriptor.MAVEN_PLUGIN, null);
                this.addPlugin(pluginArtifact, session);
                version = pluginArtifact.getBaseVersion();
            }
            catch (ArtifactEnabledContainerException e) {
                throw new PluginManagerException("Error occurred in the artifact container attempting to download plugin " + groupId + ":" + artifactId, (Exception)((Object)e));
            }
            catch (ArtifactResolutionException e) {
                if (groupId.equals(e.getGroupId()) && artifactId.equals(e.getArtifactId()) && version.equals(e.getVersion()) && "maven-plugin".equals(e.getType())) {
                    throw new PluginNotFoundException(e);
                }
                throw e;
            }
            catch (ComponentLookupException e) {
                throw new PluginManagerException("Internal configuration error while retrieving " + groupId + ":" + artifactId, (Exception)((Object)e));
            }
        }
        return this.getPluginDescriptor(groupId, artifactId, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPlugin(Artifact pluginArtifact, MavenSession session) throws ArtifactEnabledContainerException, ArtifactResolutionException, ComponentLookupException {
        ArtifactResolver artifactResolver = null;
        MavenProjectBuilder mavenProjectBuilder = null;
        try {
            artifactResolver = (ArtifactResolver)this.container.lookup(ArtifactResolver.ROLE);
            mavenProjectBuilder = (MavenProjectBuilder)this.container.lookup(MavenProjectBuilder.ROLE);
            MavenMetadataSource metadataSource = new MavenMetadataSource(artifactResolver, mavenProjectBuilder);
            ((ArtifactEnabledContainer)this.container).addComponent(pluginArtifact, artifactResolver, session.getPluginRepositories(), session.getLocalRepository(), (ArtifactMetadataSource)metadataSource, this.artifactFilter);
            if (artifactResolver != null) {
                this.releaseComponent(artifactResolver);
            }
            if (mavenProjectBuilder != null) {
                this.releaseComponent(mavenProjectBuilder);
            }
        }
        catch (Throwable throwable) {
            if (artifactResolver != null) {
                this.releaseComponent(artifactResolver);
            }
            if (mavenProjectBuilder != null) {
                this.releaseComponent(mavenProjectBuilder);
            }
            throw throwable;
        }
    }

    private void releaseComponent(Object component) {
        try {
            this.container.release(component);
        }
        catch (ComponentLifecycleException e) {
            this.getLogger().error("Error releasing component - ignoring", (Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeMojo(MavenSession session, MojoDescriptor mojoDescriptor) throws ArtifactResolutionException, PluginManagerException, MojoExecutionException {
        if (mojoDescriptor.isDependencyResolutionRequired() != null) {
            ArtifactResolver artifactResolver = null;
            MavenProjectBuilder mavenProjectBuilder = null;
            try {
                artifactResolver = (ArtifactResolver)this.container.lookup(ArtifactResolver.ROLE);
                mavenProjectBuilder = (MavenProjectBuilder)this.container.lookup(MavenProjectBuilder.ROLE);
                this.resolveTransitiveDependencies(session, artifactResolver, mavenProjectBuilder, mojoDescriptor.isDependencyResolutionRequired());
                this.downloadDependencies(session, artifactResolver);
                if (artifactResolver != null) {
                    this.releaseComponent(artifactResolver);
                }
                if (mavenProjectBuilder != null) {
                    this.releaseComponent(mavenProjectBuilder);
                }
            }
            catch (ComponentLookupException e) {
                try {
                    throw new PluginManagerException("Internal configuration error in plugin manager", (Exception)((Object)e));
                }
                catch (Throwable throwable) {
                    if (artifactResolver != null) {
                        this.releaseComponent(artifactResolver);
                    }
                    if (mavenProjectBuilder == null) throw throwable;
                    this.releaseComponent(mavenProjectBuilder);
                    throw throwable;
                }
            }
        }
        Mojo plugin = null;
        String goalName = mojoDescriptor.getFullGoalName();
        try {
            plugin = (Mojo)this.container.lookup(Mojo.ROLE, mojoDescriptor.getRoleHint());
            plugin.setLog(this.mojoLogger);
            String goalId = mojoDescriptor.getGoal();
            PluginDescriptor pluginDescriptor = mojoDescriptor.getPluginDescriptor();
            Xpp3Dom dom = session.getProject().getGoalConfiguration(pluginDescriptor.getGroupId(), pluginDescriptor.getArtifactId(), goalId);
            XmlPlexusConfiguration pomConfiguration = dom == null ? new XmlPlexusConfiguration("configuration") : new XmlPlexusConfiguration(dom);
            PluginParameterExpressionEvaluator expressionEvaluator = new PluginParameterExpressionEvaluator(session, this.pathTranslator, this.getLogger());
            PlexusConfiguration mergedConfiguration = this.mergeConfiguration((PlexusConfiguration)pomConfiguration, mojoDescriptor.getMojoConfiguration());
            try {
                this.getPluginConfigurationFromExpressions(plugin, mojoDescriptor, mergedConfiguration, expressionEvaluator);
                this.populatePluginFields(plugin, mojoDescriptor, mergedConfiguration, expressionEvaluator);
            }
            catch (ExpressionEvaluationException e) {
                throw new MojoExecutionException("Unable to configure plugin", (Exception)((Object)e));
            }
            String event = "mojo-execute";
            EventDispatcher dispatcher = session.getEventDispatcher();
            dispatcher.dispatchStart(event, goalName);
            try {
                plugin.execute();
                dispatcher.dispatchEnd(event, goalName);
            }
            catch (MojoExecutionException e) {
                session.getEventDispatcher().dispatchError(event, goalName, (Throwable)e);
                throw e;
            }
            this.releaseComponent(plugin);
            return;
        }
        catch (PluginConfigurationException e) {
            try {
                String msg = "Error configuring plugin for execution of '" + goalName + "'.";
                throw new MojoExecutionException(msg, (Exception)e);
                catch (ComponentLookupException e2) {
                    throw new MojoExecutionException("Error looking up plugin: ", (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                this.releaseComponent(plugin);
                throw throwable;
            }
        }
    }

    private void validatePomConfiguration(MojoDescriptor goal, PlexusConfiguration pomConfiguration) throws PluginConfigurationException {
        List parameters = goal.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            Parameter parameter = (Parameter)parameters.get(i);
            boolean editable = parameter.isEditable();
            String key = parameter.getName();
            String lookupKey = parameter.getAlias();
            if (StringUtils.isEmpty((String)lookupKey)) {
                lookupKey = key;
            }
            if (editable || pomConfiguration.getChild(lookupKey, false) == null && pomConfiguration.getChild(key, false) == null) continue;
            StringBuffer errorMessage = new StringBuffer().append("ERROR: Cannot override read-only parameter: ").append(key);
            if (!lookupKey.equals(key)) {
                errorMessage.append(" (with alias: ").append(lookupKey).append(")");
            }
            errorMessage.append(" in goal: ").append(goal.getFullGoalName());
            throw new PluginConfigurationException(errorMessage.toString());
        }
    }

    private PlexusConfiguration mergeConfiguration(PlexusConfiguration dominant, PlexusConfiguration configuration) {
        PlexusConfiguration[] children = configuration.getChildren();
        for (int i = 0; i < children.length; ++i) {
            PlexusConfiguration child = children[i];
            XmlPlexusConfiguration childDom = (XmlPlexusConfiguration)dominant.getChild(child.getName(), false);
            if (childDom != null) {
                this.mergeConfiguration((PlexusConfiguration)childDom, child);
                continue;
            }
            dominant.addChild(DefaultPluginManager.copyConfiguration(child));
        }
        return dominant;
    }

    public static PlexusConfiguration copyConfiguration(PlexusConfiguration src) {
        XmlPlexusConfiguration dom = new XmlPlexusConfiguration(src.getName());
        dom.setValue(src.getValue(null));
        String[] attributeNames = src.getAttributeNames();
        for (int i = 0; i < attributeNames.length; ++i) {
            String attributeName = attributeNames[i];
            dom.setAttribute(attributeName, src.getAttribute(attributeName, null));
        }
        PlexusConfiguration[] children = src.getChildren();
        for (int i = 0; i < children.length; ++i) {
            dom.addChild(DefaultPluginManager.copyConfiguration(children[i]));
        }
        return dom;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void populatePluginFields(Mojo plugin, MojoDescriptor mojoDescriptor, PlexusConfiguration configuration, ExpressionEvaluator expressionEvaluator) throws PluginConfigurationException {
        ComponentConfigurator configurator = null;
        try {
            String configuratorId = mojoDescriptor.getComponentConfigurator();
            configurator = StringUtils.isNotEmpty((String)configuratorId) ? (ComponentConfigurator)this.container.lookup(ComponentConfigurator.ROLE, configuratorId) : (ComponentConfigurator)this.container.lookup(ComponentConfigurator.ROLE);
            configurator.configureComponent((Object)plugin, configuration, expressionEvaluator);
            if (configurator == null) return;
        }
        catch (ComponentConfigurationException e) {
            try {
                throw new PluginConfigurationException("Unable to parse the created DOM for plugin configuration", e);
                catch (ComponentLookupException e2) {
                    throw new PluginConfigurationException("Unable to retrieve component configurator for plugin configuration", e2);
                }
            }
            catch (Throwable throwable) {
                if (configurator == null) throw throwable;
                try {
                    this.container.release(configurator);
                    throw throwable;
                }
                catch (ComponentLifecycleException e3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            this.container.release((Object)configurator);
            return;
        }
        catch (ComponentLifecycleException e) {
            return;
        }
    }

    private Field findPluginField(Class clazz, String key) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(key);
        }
        catch (NoSuchFieldException e) {
            Class superclass = clazz.getSuperclass();
            if (superclass != (class$java$lang$Object == null ? (class$java$lang$Object = DefaultPluginManager.class$("java.lang.Object")) : class$java$lang$Object)) {
                return this.findPluginField(superclass, key);
            }
            throw e;
        }
    }

    private void getPluginConfigurationFromExpressions(Mojo plugin, MojoDescriptor goal, PlexusConfiguration mergedConfiguration, ExpressionEvaluator expressionEvaluator) throws ExpressionEvaluationException, PluginConfigurationException {
        List parameters = goal.getParameters();
        ArrayList<Parameter> invalidParameters = new ArrayList<Parameter>();
        for (int i = 0; i < parameters.size(); ++i) {
            PlexusConfiguration goalConfiguration;
            String expression;
            Parameter parameter = (Parameter)parameters.get(i);
            boolean editable = parameter.isEditable();
            String key = parameter.getName();
            String lookupKey = parameter.getAlias();
            if (StringUtils.isEmpty((String)lookupKey)) {
                lookupKey = key;
            }
            boolean foundInConfiguration = false;
            if (mergedConfiguration.getChild(lookupKey, false) != null) {
                expression = mergedConfiguration.getChild(lookupKey, false).getValue(null);
                foundInConfiguration = true;
            } else if (mergedConfiguration.getChild(key, false) != null) {
                expression = mergedConfiguration.getChild(key, false).getValue(null);
                foundInConfiguration = true;
            } else {
                expression = parameter.getExpression();
            }
            if (foundInConfiguration && expression != null && parameter.getDeprecated() != null && !expression.equals((goalConfiguration = goal.getMojoConfiguration()).getChild(lookupKey, false).getValue(null)) && !expression.equals(goalConfiguration.getChild(key, false).getValue(null))) {
                StringBuffer message = new StringBuffer().append("DEPRECATED: ").append(key);
                if (!lookupKey.equals(key)) {
                    message.append(" (aliased to ").append(lookupKey).append(")");
                }
                message.append(" is deprecated.\n\t").append(parameter.getDeprecated());
                this.getLogger().warn(message.toString());
            }
            Object value = expressionEvaluator.evaluate(expression);
            this.getLogger().debug("Evaluated mojo parameter expression: '" + expression + "' to: " + value + " for parameter: '" + key + "'");
            if (value == null && !"map-oriented".equals(goal.getComponentConfigurator())) {
                Object defaultValue;
                try {
                    Field pluginField = this.findPluginField(plugin.getClass(), parameter.getName());
                    boolean accessible = pluginField.isAccessible();
                    if (!accessible) {
                        ((AccessibleObject)pluginField).setAccessible(true);
                    }
                    defaultValue = pluginField.get(plugin);
                    if (!accessible) {
                        ((AccessibleObject)pluginField).setAccessible(false);
                    }
                }
                catch (IllegalAccessException e) {
                    String message = "Error finding field for parameter '" + parameter.getName() + "'";
                    throw new PluginConfigurationException(message, e);
                }
                catch (NoSuchFieldException e) {
                    String message = "Error finding field for parameter '" + parameter.getName() + "'";
                    throw new PluginConfigurationException(message, e);
                }
                if (defaultValue != null) {
                    value = defaultValue;
                }
            }
            if (value != null || !parameter.isRequired()) continue;
            invalidParameters.add(parameter);
        }
        if (!invalidParameters.isEmpty()) {
            throw new PluginParameterException(goal, invalidParameters);
        }
    }

    public static String createPluginParameterRequiredMessage(MojoDescriptor mojo, Parameter parameter, String expression) {
        StringBuffer message = new StringBuffer();
        message.append("The '" + parameter.getName());
        message.append("' parameter is required for the execution of the ");
        message.append(mojo.getFullGoalName());
        message.append(" mojo and cannot be null.");
        if (expression != null) {
            message.append(" The retrieval expression was: ").append(expression);
        }
        return message.toString();
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
        LoggerManager manager = null;
        try {
            manager = (LoggerManager)this.container.lookup(LoggerManager.ROLE);
            this.mojoLogger = new DefaultLog(manager.getLoggerForComponent(Mojo.ROLE));
        }
        catch (ComponentLookupException e) {
            throw new ContextException("Error locating a logger manager", (Throwable)e);
        }
        finally {
            if (manager != null) {
                try {
                    this.container.release((Object)manager);
                }
                catch (ComponentLifecycleException e) {
                    this.getLogger().error("Error releasing the logger manager - ignoring", (Throwable)e);
                }
            }
        }
    }

    public void initialize() {
        this.artifactFilter = new ExclusionSetFilter(new String[]{"maven-core", "maven-artifact", "maven-model", "maven-settings", "maven-monitor", "maven-plugin-api", "maven-plugin-descriptor", "plexus-container-default", "maven-project", "plexus-container-artifact", "maven-reporting-api", "doxia-core", "wagon-provider-api", "classworlds", "maven-plugin", "plexus-marmalade-factory", "maven-script-marmalade", "marmalade-core"});
    }

    private void resolveTransitiveDependencies(MavenSession context, ArtifactResolver artifactResolver, MavenProjectBuilder mavenProjectBuilder, String scope) throws ArtifactResolutionException {
        MavenProject project = context.getProject();
        MavenMetadataSource sourceReader = new MavenMetadataSource(artifactResolver, mavenProjectBuilder);
        ScopeArtifactFilter filter = new ScopeArtifactFilter(scope);
        boolean systemOnline = !context.getSettings().getActiveProfile().isOffline();
        ArtifactResolutionResult result = artifactResolver.resolveTransitively(project.getArtifacts(), context.getRemoteRepositories(), context.getLocalRepository(), (ArtifactMetadataSource)sourceReader, (ArtifactFilter)filter);
        project.addArtifacts(result.getArtifacts().values(), this.artifactFactory);
    }

    private void downloadDependencies(MavenSession context, ArtifactResolver artifactResolver) throws ArtifactResolutionException {
        Iterator it = context.getProject().getArtifacts().iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            artifactResolver.resolve(artifact, context.getRemoteRepositories(), context.getLocalRepository());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

