/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.execution.MavenExecutionResponse;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.lifecycle.Phase;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.injection.ModelDefaultsInjector;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class DefaultLifecycleExecutor
extends AbstractLogEnabled
implements LifecycleExecutor {
    private ModelDefaultsInjector modelDefaultsInjector;
    private PluginManager pluginManager;
    private ArtifactHandlerManager artifactHandlerManager;
    private List phases;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenExecutionResponse execute(List tasks, MavenSession session) throws LifecycleExecutionException {
        MavenExecutionResponse response = new MavenExecutionResponse();
        response.setStart(new Date());
        try {
            this.processGoals(session, tasks);
        }
        catch (MojoExecutionException e) {
            response.setException(e);
        }
        catch (ArtifactHandlerNotFoundException e) {
            response.setException(e);
        }
        catch (ArtifactResolutionException e) {
            response.setException(e);
        }
        finally {
            response.setFinish(new Date());
        }
        return response;
    }

    private void processGoals(MavenSession session, List tasks) throws ArtifactHandlerNotFoundException, LifecycleExecutionException, PluginNotFoundException, MojoExecutionException, ArtifactResolutionException {
        HashMap<String, Phase> phaseMap = new HashMap<String, Phase>();
        Iterator i = this.phases.iterator();
        while (i.hasNext()) {
            Phase p = (Phase)i.next();
            phaseMap.put(p.getId(), new Phase(p));
        }
        MavenProject project = session.getProject();
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(project.getPackaging());
        if (artifactHandler != null) {
            if (artifactHandler.packageGoal() != null) {
                this.configureMojo(artifactHandler.packageGoal(), session, phaseMap);
            }
            if (artifactHandler.additionalPlugin() != null) {
                String additionalPluginGroupId = PluginDescriptor.getDefaultPluginGroupId();
                String additionalPluginArtifactId = PluginDescriptor.getDefaultPluginArtifactId((String)artifactHandler.additionalPlugin());
                this.injectHandlerPluginConfiguration(project, additionalPluginGroupId, additionalPluginArtifactId, null);
            }
        }
        this.processPluginConfiguration(project, session, phaseMap);
        Iterator i2 = tasks.iterator();
        while (i2.hasNext()) {
            String task = (String)i2.next();
            List goals = this.processGoalChain(task, session, phaseMap);
            Iterator j = goals.iterator();
            while (j.hasNext()) {
                MojoDescriptor mojo = (MojoDescriptor)j.next();
                if (mojo.getExecutePhase() != null) {
                    this.execute(Collections.singletonList(mojo.getExecutePhase()), session);
                }
                try {
                    this.pluginManager.executeMojo(session, mojo);
                }
                catch (PluginManagerException e) {
                    throw new LifecycleExecutionException("Internal error in the plugin manager", e);
                }
            }
        }
    }

    private void injectHandlerPluginConfiguration(MavenProject project, String groupId, String artifactId, String version) {
        String key = Plugin.constructKey((String)groupId, (String)artifactId);
        Plugin plugin = (Plugin)project.getBuild().getPluginsAsMap().get(key);
        if (plugin == null) {
            Plugin def;
            plugin = new Plugin();
            plugin.setGroupId(groupId);
            plugin.setArtifactId(artifactId);
            plugin.setVersion(version);
            PluginManagement pluginManagement = project.getPluginManagement();
            if (pluginManagement != null && (def = (Plugin)pluginManagement.getPluginsAsMap().get(key)) != null) {
                this.modelDefaultsInjector.mergePluginWithDefaults(plugin, def);
            }
            project.addPlugin(plugin);
        }
    }

    private void processPluginConfiguration(MavenProject project, MavenSession mavenSession, Map phaseMap) throws LifecycleExecutionException, ArtifactResolutionException {
        Iterator i = project.getBuildPlugins().iterator();
        while (i.hasNext()) {
            Plugin plugin = (Plugin)i.next();
            this.processPluginPhases(plugin, mavenSession, phaseMap);
        }
    }

    private void processPluginPhases(Plugin plugin, MavenSession session, Map phaseMap) throws LifecycleExecutionException, ArtifactResolutionException {
        PluginDescriptor pluginDescriptor;
        String groupId = plugin.getGroupId();
        String artifactId = plugin.getArtifactId();
        String version = plugin.getVersion();
        try {
            pluginDescriptor = this.pluginManager.verifyPlugin(groupId, artifactId, version, session);
        }
        catch (PluginManagerException e) {
            throw new LifecycleExecutionException("Internal error in the plugin manager", e);
        }
        Iterator j = pluginDescriptor.getMojos().iterator();
        while (j.hasNext()) {
            MojoDescriptor mojoDescriptor = (MojoDescriptor)j.next();
            if (mojoDescriptor.getGoal() == null) {
                throw new LifecycleExecutionException("The plugin " + artifactId + " was built with an older version of Maven");
            }
            if (!plugin.getGoals().isEmpty() && !plugin.getGoalsAsMap().containsKey(mojoDescriptor.getGoal())) continue;
            this.configureMojoPhaseBinding(mojoDescriptor, phaseMap, session.getSettings());
        }
    }

    private void configureMojoPhaseBinding(MojoDescriptor mojoDescriptor, Map phaseMap, Settings settings) throws LifecycleExecutionException {
        if (settings.getActiveProfile().isOffline() && mojoDescriptor.isOnlineRequired()) {
            String goal = mojoDescriptor.getGoal();
            this.getLogger().warn(goal + " requires online mode, but maven is currently offline. Disabling " + goal + ".");
        } else if (mojoDescriptor.getPhase() != null) {
            Phase phase = (Phase)phaseMap.get(mojoDescriptor.getPhase());
            if (phase == null) {
                String message = "Required phase '" + mojoDescriptor.getPhase() + "' not found";
                throw new LifecycleExecutionException(message);
            }
            phase.getGoals().add(mojoDescriptor.getId());
        }
    }

    private List processGoalChain(String task, MavenSession session, Map phaseMap) throws LifecycleExecutionException, ArtifactResolutionException {
        ArrayList<MojoDescriptor> goals = new ArrayList<MojoDescriptor>();
        if (phaseMap.containsKey(task)) {
            int index = this.phases.indexOf(phaseMap.get(task));
            for (int j = 0; j <= index; ++j) {
                Phase p = (Phase)this.phases.get(j);
                if ((p = (Phase)phaseMap.get(p.getId())).getGoals() == null) continue;
                Iterator k = p.getGoals().iterator();
                while (k.hasNext()) {
                    String goal = (String)k.next();
                    goals.add(this.configureMojo(goal, session, phaseMap));
                }
            }
        } else {
            goals.add(this.configureMojo(task, session, phaseMap));
        }
        return goals;
    }

    private MojoDescriptor configureMojo(String task, MavenSession session, Map phaseMap) throws LifecycleExecutionException, ArtifactResolutionException {
        MojoDescriptor mojoDescriptor = this.getMojoDescriptor(task, session);
        this.configureMojoPhaseBinding(mojoDescriptor, phaseMap, session.getSettings());
        return mojoDescriptor;
    }

    private MojoDescriptor getMojoDescriptor(String task, MavenSession session) throws ArtifactResolutionException, LifecycleExecutionException {
        String groupId = null;
        String artifactId = null;
        String version = null;
        String goal = null;
        PluginDescriptor pluginDescriptor = null;
        StringTokenizer tok = new StringTokenizer(task, ":");
        int numTokens = tok.countTokens();
        if (numTokens == 2) {
            String prefix = tok.nextToken();
            goal = tok.nextToken();
            pluginDescriptor = this.pluginManager.verifyPlugin(prefix);
            if (pluginDescriptor == null) {
                groupId = PluginDescriptor.getDefaultPluginGroupId();
                artifactId = PluginDescriptor.getDefaultPluginArtifactId((String)prefix);
            }
        } else if (numTokens == 4) {
            groupId = tok.nextToken();
            artifactId = tok.nextToken();
            version = tok.nextToken();
            goal = tok.nextToken();
        } else {
            String message = "Invalid task '" + task + "': you must specify a valid lifecycle phase, or" + " a goal in the format plugin:goal or pluginGroupId:pluginArtifactId:pluginVersion:goal";
            throw new LifecycleExecutionException(message);
        }
        if (pluginDescriptor == null) {
            try {
                this.injectHandlerPluginConfiguration(session.getProject(), groupId, artifactId, version);
                pluginDescriptor = this.pluginManager.verifyPlugin(groupId, artifactId, version, session);
            }
            catch (PluginManagerException e) {
                throw new LifecycleExecutionException("Internal error in the plugin manager", e);
            }
        } else {
            this.injectHandlerPluginConfiguration(session.getProject(), pluginDescriptor.getGroupId(), pluginDescriptor.getArtifactId(), pluginDescriptor.getVersion());
        }
        MojoDescriptor mojoDescriptor = null;
        Iterator i = pluginDescriptor.getMojos().iterator();
        while (i.hasNext() && mojoDescriptor == null) {
            MojoDescriptor desc = (MojoDescriptor)i.next();
            if (!desc.getGoal().equals(goal)) continue;
            mojoDescriptor = desc;
        }
        if (mojoDescriptor == null) {
            throw new LifecycleExecutionException("Required goal not found: " + task);
        }
        return mojoDescriptor;
    }

    public List getPhases() {
        return this.phases;
    }
}

