/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.execution;

import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;

public class MavenSession {
    private PlexusContainer container;
    private MavenProject project;
    private ArtifactRepository localRepository;
    private List goals;
    private EventDispatcher eventDispatcher;
    private final Settings settings;

    public MavenSession(MavenProject project, PlexusContainer container, Settings settings, ArtifactRepository localRepository, EventDispatcher eventDispatcher, List goals) {
        this.project = project;
        this.container = container;
        this.settings = settings;
        this.localRepository = localRepository;
        this.eventDispatcher = eventDispatcher;
        this.goals = goals;
    }

    private void initializeContainerContext() {
        Context context = this.container.getContext();
        context.put((Object)"project", (Object)this.project);
        context.put((Object)"settings", (Object)this.settings);
        context.put((Object)"basedir", (Object)this.project.getBasedir().getAbsolutePath());
        context.put((Object)"localRepository", (Object)this.localRepository);
        context.put((Object)"maven.final.name", (Object)this.project.getBuild().getFinalName());
    }

    public PlexusContainer getContainer() {
        return this.container;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public List getRemoteRepositories() {
        return this.project.getRemoteArtifactRepositories();
    }

    public List getGoals() {
        return this.goals;
    }

    public Object lookup(String role) throws ComponentLookupException {
        return this.container.lookup(role);
    }

    public Object lookup(String role, String roleHint) throws ComponentLookupException {
        return this.container.lookup(role, roleHint);
    }

    public List lookupList(String role) throws ComponentLookupException {
        return this.container.lookupList(role);
    }

    public Map lookupMap(String role) throws ComponentLookupException {
        return this.container.lookupMap(role);
    }

    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public List getPluginRepositories() {
        return this.project.getPluginArtifactRepositories();
    }
}

