/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.maven.Maven;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.cli.ConsoleDownloadMonitor;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResponse;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.monitor.event.DefaultEventDispatcher;
import org.apache.maven.monitor.event.DefaultEventMonitor;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.monitor.event.EventMonitor;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.reactor.ReactorException;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.events.TransferListener;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.embed.ArtifactEnabledEmbedder;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MavenCli {
    public static final String POMv4 = "pom.xml";
    public static File userDir = new File(System.getProperty("user.dir"));
    static /* synthetic */ Class class$org$apache$maven$cli$MavenCli;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int main(String[] args, ClassWorld classWorld) {
        Settings settings;
        boolean showErrors;
        CommandLine commandLine;
        CLIManager cliManager = new CLIManager();
        try {
            commandLine = cliManager.parse(args);
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line options: " + e.getMessage());
            cliManager.displayHelp();
            return 1;
        }
        if (System.getProperty("java.class.version", "44.0").compareTo("48.0") < 0) {
            System.err.println("Sorry, but JDK 1.4 or above is required to execute Maven");
            System.err.println("You appear to be using Java version: " + System.getProperty("java.version", "<unknown>"));
            return 1;
        }
        MavenCli.initializeSystemProperties(commandLine);
        boolean debug = commandLine.hasOption('X');
        boolean bl = showErrors = debug || commandLine.hasOption('e');
        if (showErrors) {
            System.out.println("+ Error stacktraces are turned on.");
        }
        if (commandLine.hasOption('h')) {
            cliManager.displayHelp();
            return 0;
        }
        if (commandLine.hasOption('v')) {
            MavenCli.showVersion();
            return 0;
        }
        DefaultEventDispatcher eventDispatcher = new DefaultEventDispatcher();
        ArtifactEnabledEmbedder embedder = new ArtifactEnabledEmbedder();
        try {
            embedder.start(classWorld);
        }
        catch (PlexusContainerException e) {
            MavenCli.showFatalError("Unable to start the embedded plexus container", (Exception)((Object)e), showErrors);
            return 1;
        }
        try {
            MavenSettingsBuilder settingsBuilder = (MavenSettingsBuilder)embedder.lookup(MavenSettingsBuilder.ROLE);
            settings = settingsBuilder.buildSettings();
        }
        catch (IOException e) {
            MavenCli.showFatalError("Unable to read settings.xml", e, showErrors);
            return 1;
        }
        catch (XmlPullParserException e) {
            MavenCli.showFatalError("Unable to read settings.xml", (Exception)((Object)e), showErrors);
            return 1;
        }
        catch (ComponentLookupException e) {
            MavenCli.showFatalError("Unable to read settings.xml", (Exception)((Object)e), showErrors);
            return 1;
        }
        List projectFiles = null;
        try {
            projectFiles = MavenCli.getProjectFiles(commandLine);
        }
        catch (IOException e) {
            MavenCli.showFatalError("Error locating project files for reactor execution", e, showErrors);
            return 1;
        }
        Maven maven = null;
        MavenExecutionRequest request = null;
        LoggerManager manager = null;
        try {
            manager = (LoggerManager)embedder.lookup(LoggerManager.ROLE);
            if (debug) {
                manager.setThreshold(0);
            }
            request = MavenCli.createRequest(projectFiles, embedder, commandLine, settings, (EventDispatcher)eventDispatcher, manager);
            maven = MavenCli.createMavenInstance(embedder);
        }
        catch (ComponentLookupException e) {
            MavenCli.showFatalError("Unable to configure the Maven application", (Exception)((Object)e), showErrors);
            int n = 1;
            return n;
        }
        finally {
            if (manager != null) {
                try {
                    embedder.release((Object)manager);
                }
                catch (ComponentLifecycleException e) {
                    MavenCli.showFatalError("Error releasing logging manager", (Exception)((Object)e), showErrors);
                    return 1;
                }
            }
        }
        if (request.getGoals().isEmpty()) {
            System.err.println("You must specify at least one goal. Try 'install'");
            cliManager.displayHelp();
            return 1;
        }
        MavenExecutionResponse response = null;
        try {
            response = maven.execute(request);
        }
        catch (ReactorException e) {
            MavenCli.showFatalError("Error executing Maven for a project", e, showErrors);
            return 1;
        }
        if (response != null && response.isExecutionFailure()) {
            return 1;
        }
        return 0;
    }

    private static void showFatalError(String message, Exception e, boolean show) {
        System.err.println("FATAL ERROR: " + message);
        if (show) {
            System.err.println("Error stacktrace:");
            e.printStackTrace();
        } else {
            System.err.println("For more information, run with the -e flag");
        }
    }

    private static MavenExecutionRequest createRequest(List files, ArtifactEnabledEmbedder embedder, CommandLine commandLine, Settings settings, EventDispatcher eventDispatcher, LoggerManager manager) throws ComponentLookupException {
        DefaultMavenExecutionRequest request = null;
        ArtifactRepository localRepository = MavenCli.createLocalRepository(embedder, settings, commandLine);
        request = new DefaultMavenExecutionRequest(localRepository, settings, eventDispatcher, commandLine.getArgList(), files, userDir.getPath());
        Logger logger = manager.getLoggerForComponent(Mojo.ROLE);
        if (logger != null) {
            request.addEventMonitor((EventMonitor)new DefaultEventMonitor(logger));
        }
        if (commandLine.hasOption('N')) {
            request.setRecursive(false);
        }
        return request;
    }

    private static List getProjectFiles(CommandLine commandLine) throws IOException {
        List files = Collections.EMPTY_LIST;
        if (commandLine.hasOption('r')) {
            String includes = System.getProperty("maven.reactor.includes", "**/pom.xml");
            String excludes = System.getProperty("maven.reactor.excludes", POMv4);
            files = FileUtils.getFiles((File)userDir, (String)includes, (String)excludes);
            Collections.sort(files);
        } else {
            File projectFile = new File(userDir, POMv4);
            if (projectFile.exists()) {
                files = Collections.singletonList(projectFile);
            }
        }
        return files;
    }

    private static Maven createMavenInstance(ArtifactEnabledEmbedder embedder) throws ComponentLookupException {
        WagonManager wagonManager = (WagonManager)embedder.lookup(WagonManager.ROLE);
        wagonManager.setDownloadMonitor((TransferListener)new ConsoleDownloadMonitor());
        return (Maven)embedder.lookup(Maven.ROLE);
    }

    private static ArtifactRepository createLocalRepository(ArtifactEnabledEmbedder embedder, Settings settings, CommandLine commandLine) throws ComponentLookupException {
        ArtifactRepositoryLayout repositoryLayout = (ArtifactRepositoryLayout)embedder.lookup(ArtifactRepositoryLayout.ROLE, "default");
        ArtifactRepositoryFactory artifactRepositoryFactory = (ArtifactRepositoryFactory)embedder.lookup(ArtifactRepositoryFactory.ROLE);
        String url = "file://" + settings.getActiveProfile().getLocalRepository();
        ArtifactRepository localRepository = new ArtifactRepository("local", url, repositoryLayout);
        boolean snapshotPolicySet = false;
        if (commandLine.hasOption('o')) {
            settings.getActiveProfile().setOffline(true);
            artifactRepositoryFactory.setGlobalSnapshotPolicy("never");
            snapshotPolicySet = true;
        }
        if (!snapshotPolicySet && commandLine.hasOption('U')) {
            artifactRepositoryFactory.setGlobalSnapshotPolicy("always");
        }
        return localRepository;
    }

    private static void showVersion() {
        String version = "unknown";
        try {
            Enumeration<URL> e = (class$org$apache$maven$cli$MavenCli == null ? (class$org$apache$maven$cli$MavenCli = MavenCli.class$("org.apache.maven.cli.MavenCli")) : class$org$apache$maven$cli$MavenCli).getClassLoader().getResources("/META-INF/maven/pom.xml");
            while (e.hasMoreElements()) {
                URL resource = e.nextElement();
                if (resource.getPath().indexOf("maven-core") < 0) continue;
                MavenXpp3Reader reader = new MavenXpp3Reader();
                Model model = reader.read((Reader)new InputStreamReader(resource.openStream()));
                version = model.getVersion();
                break;
            }
            System.out.println("Maven version: " + version);
        }
        catch (IOException e) {
            System.err.println("Unable determine version from JAR file: " + e.getMessage());
        }
        catch (XmlPullParserException e) {
            System.err.println("Unable to parse POM in JAR file: " + e.getMessage());
        }
    }

    private static void initializeSystemProperties(CommandLine commandLine) {
        if (commandLine.hasOption('D')) {
            String[] defStrs = commandLine.getOptionValues('D');
            for (int i = 0; i < defStrs.length; ++i) {
                MavenCli.setCliProperty(defStrs[i]);
            }
        }
    }

    private static void setCliProperty(String property) {
        String name = null;
        String value = null;
        int i = property.indexOf("=");
        if (i <= 0) {
            name = property.trim();
            value = "true";
        } else {
            name = property.substring(0, i).trim();
            value = property.substring(i + 1).trim();
        }
        System.setProperty(name, value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class CLIManager {
        public static final char SET_SYSTEM_PROPERTY = 'D';
        public static final char OFFLINE = 'o';
        public static final char REACTOR = 'r';
        public static final char DEBUG = 'X';
        public static final char ERRORS = 'e';
        public static final char HELP = 'h';
        public static final char VERSION = 'v';
        private Options options = new Options();
        public static final char NON_RECURSIVE = 'N';
        public static final char UPDATE_SNAPSHOTS = 'U';

        public CLIManager() {
            OptionBuilder.withLongOpt((String)"define");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"Define a system property");
            this.options.addOption(OptionBuilder.create((char)'D'));
            OptionBuilder.withLongOpt((String)"offline");
            OptionBuilder.withDescription((String)"Work offline");
            this.options.addOption(OptionBuilder.create((char)'o'));
            OptionBuilder.withLongOpt((String)"help");
            OptionBuilder.withDescription((String)"Display help information");
            this.options.addOption(OptionBuilder.create((char)'h'));
            OptionBuilder.withLongOpt((String)"version");
            OptionBuilder.withDescription((String)"Display version information");
            this.options.addOption(OptionBuilder.create((char)'v'));
            OptionBuilder.withLongOpt((String)"debug");
            OptionBuilder.withDescription((String)"Produce execution debug output");
            this.options.addOption(OptionBuilder.create((char)'X'));
            OptionBuilder.withLongOpt((String)"errors");
            OptionBuilder.withDescription((String)"Produce execution error messages");
            this.options.addOption(OptionBuilder.create((char)'e'));
            OptionBuilder.withLongOpt((String)"reactor");
            OptionBuilder.withDescription((String)"Execute goals for project found in the reactor");
            this.options.addOption(OptionBuilder.create((char)'r'));
            OptionBuilder.withLongOpt((String)"non-recursive");
            OptionBuilder.withDescription((String)"Do not recurse into sub-projects");
            this.options.addOption(OptionBuilder.create((char)'N'));
            OptionBuilder.withLongOpt((String)"update-snapshots");
            OptionBuilder.withDescription((String)"Update all snapshots regardless of repository policies");
            this.options.addOption(OptionBuilder.create((char)'U'));
        }

        public CommandLine parse(String[] args) throws ParseException {
            PosixParser parser = new PosixParser();
            return parser.parse(this.options, args);
        }

        public void displayHelp() {
            System.out.println();
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("maven [options] [goal [goal2 [goal3] ...]]", "\nOptions:", this.options, "\n");
        }
    }
}

