/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.Maven;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResponse;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectSorter;
import org.apache.maven.reactor.ReactorException;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.usability.ErrorDiagnoser;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.dag.CycleDetectedException;

public class DefaultMaven
extends AbstractLogEnabled
implements Maven,
Contextualizable {
    private I18N i18n;
    protected MavenProjectBuilder projectBuilder;
    protected LifecycleExecutor lifecycleExecutor;
    protected PlexusContainer container;
    protected Map errorDiagnosers;

    public MavenExecutionResponse execute(MavenExecutionRequest request) throws ReactorException {
        List projects;
        if (request.getSettings().getActiveProfile().isOffline()) {
            this.getLogger().info("Maven is running in offline mode.");
        }
        try {
            this.resolveParameters(request.getSettings());
        }
        catch (ComponentLookupException e) {
            throw new ReactorException("Unable to configure Maven for execution", e);
        }
        EventDispatcher dispatcher = request.getEventDispatcher();
        String event = "reactor-execute";
        dispatcher.dispatchStart(event, request.getBaseDirectory());
        try {
            projects = this.collectProjects(request.getFiles(), request.getLocalRepository(), request.isRecursive());
            projects = ProjectSorter.getSortedProjects((List)projects);
            if (projects.isEmpty()) {
                projects.add(this.projectBuilder.buildStandaloneSuperProject(request.getLocalRepository()));
            }
        }
        catch (IOException e) {
            throw new ReactorException("Error processing projects for the reactor: ", e);
        }
        catch (CycleDetectedException e) {
            throw new ReactorException("Error processing projects for the reactor: ", e);
        }
        catch (ArtifactResolutionException e) {
            dispatcher.dispatchError(event, request.getBaseDirectory(), (Throwable)e);
            MavenExecutionResponse response = new MavenExecutionResponse();
            response.setStart(new Date());
            response.setFinish(new Date());
            response.setException(e);
            this.logFailure(response, e, null);
            return response;
        }
        catch (ProjectBuildingException e) {
            dispatcher.dispatchError(event, request.getBaseDirectory(), (Throwable)e);
            MavenExecutionResponse response = new MavenExecutionResponse();
            response.setStart(new Date());
            response.setFinish(new Date());
            response.setException(e);
            this.logFailure(response, e, null);
            return response;
        }
        try {
            Iterator iterator = projects.iterator();
            while (iterator.hasNext()) {
                MavenProject project = (MavenProject)iterator.next();
                this.line();
                this.getLogger().info("Building " + project.getName());
                this.line();
                try {
                    MavenExecutionResponse response = this.processProject(request, project, dispatcher);
                    if (!response.isExecutionFailure()) continue;
                    dispatcher.dispatchError(event, request.getBaseDirectory(), response.getException());
                    return response;
                }
                catch (LifecycleExecutionException e) {
                    throw new ReactorException("Error executing project within the reactor", e);
                }
            }
            dispatcher.dispatchEnd(event, request.getBaseDirectory());
            return null;
        }
        catch (ReactorException e) {
            dispatcher.dispatchError(event, request.getBaseDirectory(), (Throwable)e);
            throw e;
        }
    }

    private List collectProjects(List files, ArtifactRepository localRepository, boolean recursive) throws ProjectBuildingException, ReactorException, IOException, ArtifactResolutionException {
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>(files.size());
        Iterator iterator = files.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            MavenProject project = this.getProject(file, localRepository);
            if (project.getModules() != null && !project.getModules().isEmpty() && recursive) {
                project.setPackaging("pom");
                File basedir = file.getParentFile();
                ArrayList<File> moduleFiles = new ArrayList<File>(project.getModules().size());
                Iterator i = project.getModules().iterator();
                while (i.hasNext()) {
                    String name = (String)i.next();
                    if (name.indexOf("..") >= 0) {
                        String message = "Illegal module name: " + name + " (cannot contain path characters)";
                        throw new ReactorException(message);
                    }
                    moduleFiles.add(new File(basedir, name + "/pom.xml"));
                }
                List collectedProjects = this.collectProjects(moduleFiles, localRepository, recursive);
                projects.addAll(collectedProjects);
                project.setCollectedProjects(collectedProjects);
            }
            projects.add(project);
        }
        return projects;
    }

    private MavenExecutionResponse processProject(MavenExecutionRequest request, MavenProject project, EventDispatcher dispatcher) throws LifecycleExecutionException {
        List goals = request.getGoals();
        MavenSession session = this.createSession(request, project);
        String event = "project-execute";
        dispatcher.dispatchStart(event, project.getId());
        MavenExecutionResponse response = null;
        try {
            response = this.lifecycleExecutor.execute(goals, session);
            dispatcher.dispatchEnd(event, project.getId());
        }
        catch (LifecycleExecutionException e) {
            dispatcher.dispatchError(event, project.getId(), (Throwable)e);
            throw e;
        }
        if (response.isExecutionFailure()) {
            Throwable exception = response.getException();
            if (exception instanceof MojoExecutionException) {
                if (exception.getCause() == null) {
                    MojoExecutionException e = (MojoExecutionException)exception;
                    this.logFailure(response, e, e.getLongMessage());
                } else {
                    this.logError(response);
                }
            } else if (exception instanceof ArtifactResolutionException) {
                this.logFailure(response, exception, null);
            } else {
                this.logError(response);
            }
        } else {
            this.logSuccess(response);
        }
        return response;
    }

    public MavenProject getProject(File pom, ArtifactRepository localRepository) throws ProjectBuildingException, ArtifactResolutionException {
        if (pom.exists() && pom.length() == 0L) {
            throw new ProjectBuildingException(this.i18n.format("empty.descriptor.error", (Object)pom));
        }
        return this.projectBuilder.build(pom, localRepository);
    }

    protected MavenSession createSession(MavenExecutionRequest request, MavenProject project) {
        return new MavenSession(project, this.container, request.getSettings(), request.getLocalRepository(), request.getEventDispatcher(), request.getGoals());
    }

    private void resolveParameters(Settings settings) throws ComponentLookupException {
        WagonManager wagonManager = (WagonManager)this.container.lookup(WagonManager.ROLE);
        Proxy proxy = settings.getActiveProxy();
        if (proxy != null) {
            wagonManager.addProxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), proxy.getUsername(), proxy.getPassword(), proxy.getNonProxyHosts());
        }
        Iterator i = settings.getServers().iterator();
        while (i.hasNext()) {
            Server server = (Server)i.next();
            wagonManager.addAuthenticationInfo(server.getId(), server.getUsername(), server.getPassword(), server.getPrivateKey(), server.getPassphrase());
        }
        i = settings.getMirrors().iterator();
        while (i.hasNext()) {
            Mirror mirror = (Mirror)i.next();
            wagonManager.addMirror(mirror.getId(), mirror.getMirrorOf(), mirror.getUrl());
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    protected void logError(MavenExecutionResponse r) {
        this.line();
        this.getLogger().error("BUILD ERROR");
        this.line();
        this.getLogger().error("Cause: ", r.getException());
        this.line();
        this.stats(r.getStart(), r.getFinish());
        this.line();
    }

    protected void logFailure(MavenExecutionResponse r, Throwable e, String longMessage) {
        this.line();
        this.getLogger().info("BUILD FAILURE");
        this.line();
        String message = null;
        if (this.errorDiagnosers != null) {
            Iterator it = this.errorDiagnosers.values().iterator();
            while (it.hasNext()) {
                ErrorDiagnoser diagnoser = (ErrorDiagnoser)it.next();
                if (!diagnoser.canDiagnose(e)) continue;
                message = diagnoser.diagnose(e);
            }
        }
        if (message == null) {
            message = "Reason: " + e.getMessage();
        }
        this.getLogger().info(message);
        this.line();
        if (longMessage != null) {
            this.getLogger().info(longMessage);
            this.line();
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Trace", e);
            this.line();
        }
        this.stats(r.getStart(), r.getFinish());
        this.line();
    }

    protected void logSuccess(MavenExecutionResponse r) {
        this.line();
        this.getLogger().info("BUILD SUCCESSFUL");
        this.line();
        this.stats(r.getStart(), r.getFinish());
        this.line();
    }

    protected void stats(Date start, Date finish) {
        long time = finish.getTime() - start.getTime();
        this.getLogger().info("Total time: " + DefaultMaven.formatTime(time));
        this.getLogger().info("Finished at: " + finish);
        long mb = 0x100000L;
        System.gc();
        Runtime r = Runtime.getRuntime();
        this.getLogger().info("Final Memory: " + (r.totalMemory() - r.freeMemory()) / 0x100000L + "M/" + r.totalMemory() / 0x100000L + "M");
    }

    protected void line() {
        this.getLogger().info("----------------------------------------------------------------------------");
    }

    protected static String formatTime(long ms) {
        long secs = ms / 1000L;
        long min = secs / 60L;
        secs %= 60L;
        String msg = "";
        if (min > 1L) {
            msg = min + " minutes ";
        } else if (min == 1L) {
            msg = "1 minute ";
        }
        msg = secs > 1L ? msg + secs + " seconds" : (secs == 1L ? msg + "1 second" : msg + "< 1 second");
        return msg;
    }
}

