/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.metadata.ResolutionGroup;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.CyclicDependencyException;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.artifact.resolver.ResolutionNode;
import org.apache.maven.artifact.resolver.TransitiveArtifactResolutionException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.artifact.versioning.VersionRange;

public class DefaultArtifactCollector
implements ArtifactCollector {
    public ArtifactResolutionResult collect(Set artifacts, Artifact originatingArtifact, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, List listeners) throws ArtifactResolutionException {
        return this.collect(artifacts, originatingArtifact, Collections.EMPTY_MAP, localRepository, remoteRepositories, source, filter, listeners);
    }

    public ArtifactResolutionResult collect(Set artifacts, Artifact originatingArtifact, Map managedVersions, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, List listeners) throws ArtifactResolutionException {
        HashMap resolvedArtifacts = new HashMap();
        ResolutionNode root = new ResolutionNode(originatingArtifact, remoteRepositories);
        try {
            root.addDependencies(artifacts, remoteRepositories, filter);
            this.recurse(root, resolvedArtifacts, managedVersions, localRepository, remoteRepositories, source, filter, listeners);
            HashSet<ResolutionNode> set = new HashSet<ResolutionNode>();
            Iterator i = resolvedArtifacts.values().iterator();
            while (i.hasNext()) {
                List nodes = (List)i.next();
                Iterator j = nodes.iterator();
                while (j.hasNext()) {
                    ResolutionNode node = (ResolutionNode)j.next();
                    if (node.equals(root) || !node.isActive()) continue;
                    Artifact artifact = node.getArtifact();
                    if (node.getArtifact().isOptional()) continue;
                    artifact.setDependencyTrail(node.getDependencyTrail());
                    set.add(node);
                }
            }
            ArtifactResolutionResult result = new ArtifactResolutionResult();
            result.setArtifactResolutionNodes(set);
            return result;
        }
        catch (OverConstrainedVersionException e) {
            throw new ArtifactResolutionException("Unable to mediate dependency", e);
        }
    }

    private void recurse(ResolutionNode node, Map resolvedArtifacts, Map managedVersions, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter, List listeners) throws CyclicDependencyException, TransitiveArtifactResolutionException, OverConstrainedVersionException {
        Iterator i;
        ArrayList<ResolutionNode> previousNodes;
        this.fireEvent(1, listeners, node);
        Object key = node.getKey();
        if (managedVersions.containsKey(key)) {
            Artifact artifact = (Artifact)managedVersions.get(key);
            this.fireEvent(7, listeners, node, artifact);
            if (artifact.getVersion() != null) {
                node.getArtifact().setVersion(artifact.getVersion());
            }
            if (artifact.getScope() != null) {
                node.getArtifact().setScope(artifact.getScope());
            }
        }
        if ((previousNodes = (ArrayList<ResolutionNode>)resolvedArtifacts.get(key)) != null) {
            i = previousNodes.iterator();
            while (i.hasNext()) {
                ResolutionNode previous = (ResolutionNode)i.next();
                if (!previous.isActive()) continue;
                VersionRange previousRange = previous.getArtifact().getVersionRange();
                VersionRange currentRange = node.getArtifact().getVersionRange();
                if (previousRange == null) {
                    node.getArtifact().setVersion(previous.getArtifact().getVersion());
                } else if (currentRange == null) {
                    previous.getArtifact().setVersion(node.getArtifact().getVersion());
                } else {
                    previous.getArtifact().setVersionRange(previousRange.restrict(currentRange));
                    node.getArtifact().setVersionRange(currentRange.restrict(previousRange));
                }
                if (previous.getDepth() <= node.getDepth()) {
                    this.checkScopeUpdate(node, previous, listeners);
                } else {
                    this.checkScopeUpdate(previous, node, listeners);
                }
                if (previous.getDepth() <= node.getDepth()) {
                    this.fireEvent(5, listeners, node, previous.getArtifact());
                    node.disable();
                    continue;
                }
                this.fireEvent(5, listeners, previous, node.getArtifact());
                previous.disable();
            }
        } else {
            previousNodes = new ArrayList<ResolutionNode>();
            resolvedArtifacts.put(key, previousNodes);
        }
        previousNodes.add(node);
        this.fireEvent(4, listeners, node);
        if (node.isActive()) {
            this.fireEvent(2, listeners, node);
            i = node.getChildrenIterator();
            while (i.hasNext()) {
                ResolutionNode child = (ResolutionNode)i.next();
                if (child.isResolved() || child.getArtifact().isOptional()) continue;
                Artifact artifact = child.getArtifact();
                try {
                    if (artifact.getVersion() == null) {
                        ArtifactVersion version;
                        VersionRange versionRange = artifact.getVersionRange();
                        if (!versionRange.isSelectedVersionKnown()) {
                            List versions = artifact.getAvailableVersions();
                            if (versions == null) {
                                versions = source.retrieveAvailableVersions(artifact, localRepository, remoteRepositories);
                                artifact.setAvailableVersions(versions);
                            }
                            if ((version = versionRange.matchVersion(versions)) == null) {
                                if (versions.isEmpty()) {
                                    throw new OverConstrainedVersionException("No versions are present in the repository for the artifact with a range " + versionRange);
                                }
                                throw new OverConstrainedVersionException("Couldn't find a version in " + versions + " to match range " + versionRange);
                            }
                        } else {
                            version = versionRange.getSelectedVersion();
                        }
                        artifact.selectVersion(version.toString());
                        this.fireEvent(10, listeners, child);
                    }
                    ResolutionGroup rGroup = source.retrieve(artifact, localRepository, remoteRepositories);
                    child.addDependencies(rGroup.getArtifacts(), rGroup.getResolutionRepositories(), filter);
                }
                catch (CyclicDependencyException e) {
                    this.fireEvent(8, listeners, new ResolutionNode(e.getArtifact(), null, child));
                }
                catch (ArtifactMetadataRetrievalException e) {
                    artifact.setDependencyTrail(node.getDependencyTrail());
                    throw new TransitiveArtifactResolutionException(e.getMessage(), artifact, remoteRepositories, e);
                }
                this.recurse(child, resolvedArtifacts, managedVersions, localRepository, remoteRepositories, source, filter, listeners);
            }
            this.fireEvent(3, listeners, node);
        }
    }

    private void checkScopeUpdate(ResolutionNode node, ResolutionNode previous, List listeners) {
        boolean updateScope = false;
        Artifact newArtifact = node.getArtifact();
        Artifact previousArtifact = previous.getArtifact();
        if ("runtime".equals(newArtifact.getScope()) && ("test".equals(previousArtifact.getScope()) || "provided".equals(previousArtifact.getScope()))) {
            updateScope = true;
        }
        if ("compile".equals(newArtifact.getScope()) && !"compile".equals(previousArtifact.getScope())) {
            updateScope = true;
        }
        if (updateScope) {
            int event = previous.getDepth() < 2 ? 9 : 6;
            this.fireEvent(event, listeners, previous, newArtifact);
            previousArtifact.setScope(newArtifact.getScope());
        }
    }

    private void fireEvent(int event, List listeners, ResolutionNode node) {
        this.fireEvent(event, listeners, node, null);
    }

    private void fireEvent(int event, List listeners, ResolutionNode node, Artifact replacement) {
        Iterator i = listeners.iterator();
        block12: while (i.hasNext()) {
            ResolutionListener listener = (ResolutionListener)i.next();
            switch (event) {
                case 1: {
                    listener.testArtifact(node.getArtifact());
                    continue block12;
                }
                case 2: {
                    listener.startProcessChildren(node.getArtifact());
                    continue block12;
                }
                case 3: {
                    listener.endProcessChildren(node.getArtifact());
                    continue block12;
                }
                case 4: {
                    listener.includeArtifact(node.getArtifact());
                    continue block12;
                }
                case 5: {
                    listener.omitForNearer(node.getArtifact(), replacement);
                    continue block12;
                }
                case 8: {
                    listener.omitForCycle(node.getArtifact());
                    continue block12;
                }
                case 6: {
                    listener.updateScope(node.getArtifact(), replacement.getScope());
                    continue block12;
                }
                case 9: {
                    listener.updateScopeCurrentPom(node.getArtifact(), replacement.getScope());
                    continue block12;
                }
                case 7: {
                    listener.manageArtifact(node.getArtifact(), replacement);
                    continue block12;
                }
                case 10: {
                    listener.selectVersionFromRange(node.getArtifact());
                    continue block12;
                }
            }
            throw new IllegalStateException("Unknown event: " + event);
        }
    }
}

