/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;

public class ArtifactResolutionException
extends Exception {
    private String groupId;
    private String artifactId;
    private String version;
    private String type;
    private String downloadUrl;
    private List remoteRepositories;
    private final String originalMessage;
    private final String path;
    private static final String LS = System.getProperty("line.separator");

    public ArtifactResolutionException(String message, String groupId, String artifactId, String version, String type, List remoteRepositories, String downloadUrl, List path, Throwable t) {
        super(ArtifactResolutionException.constructMessage(message, groupId, artifactId, version, type, remoteRepositories, downloadUrl, path), t);
        this.originalMessage = message;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.type = type;
        this.version = version;
        this.remoteRepositories = remoteRepositories;
        this.downloadUrl = downloadUrl;
        this.path = ArtifactResolutionException.constructArtifactPath(path);
    }

    public ArtifactResolutionException(String message, String groupId, String artifactId, String version, String type, List remoteRepositories, String downloadUrl, Throwable t) {
        this(message, groupId, artifactId, version, type, remoteRepositories, downloadUrl, null, t);
    }

    public ArtifactResolutionException(String message, String groupId, String artifactId, String version, String type, List remoteRepositories, String downloadUrl, List path) {
        super(ArtifactResolutionException.constructMessage(message, groupId, artifactId, version, type, remoteRepositories, downloadUrl, path));
        this.originalMessage = message;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.type = type;
        this.version = version;
        this.remoteRepositories = remoteRepositories;
        this.downloadUrl = downloadUrl;
        this.path = ArtifactResolutionException.constructArtifactPath(path);
    }

    public String getOriginalMessage() {
        return this.originalMessage;
    }

    private static String constructArtifactPath(List path) {
        StringBuffer sb = new StringBuffer();
        if (path != null) {
            sb.append(LS);
            sb.append("Path to dependency: ");
            sb.append(LS);
            int num = 1;
            Iterator i = path.iterator();
            while (i.hasNext()) {
                sb.append("\t");
                sb.append(num++);
                sb.append(") ");
                sb.append(i.next());
                sb.append(LS);
            }
        }
        return sb.toString();
    }

    private static String constructMessage(String message, String groupId, String artifactId, String version, String type, List remoteRepositories, String downloadUrl, List path) {
        StringBuffer sb = new StringBuffer();
        sb.append(message);
        sb.append(LS);
        sb.append("  " + groupId + ":" + artifactId + ":" + version + ":" + type);
        sb.append(LS);
        if (remoteRepositories != null && !remoteRepositories.isEmpty()) {
            sb.append(LS);
            sb.append("from the specified remote repositories:");
            sb.append(LS + "  ");
            Iterator i = remoteRepositories.iterator();
            while (i.hasNext()) {
                ArtifactRepository remoteRepository = (ArtifactRepository)i.next();
                sb.append(remoteRepository.getId());
                sb.append(" (");
                sb.append(remoteRepository.getUrl());
                sb.append(")");
                if (!i.hasNext()) continue;
                sb.append(",\n  ");
            }
        }
        sb.append(ArtifactResolutionException.constructArtifactPath(path));
        sb.append(LS);
        if (downloadUrl != null && !type.equals("pom")) {
            sb.append(LS);
            sb.append(LS);
            sb.append("Try downloading the file manually from");
            sb.append(LS);
            sb.append("  " + downloadUrl);
            sb.append(LS);
            sb.append("and install it using the command: ");
            sb.append(LS);
            sb.append("  m2 install:install-file -DgroupId=");
            sb.append(groupId);
            sb.append(" -DartifactId=");
            sb.append(artifactId);
            sb.append(" -Dversion=");
            sb.append(version);
            sb.append(" -Dpackaging=");
            sb.append(type);
            sb.append(" -Dfile=/path/to/file");
        }
        return sb.toString();
    }

    public ArtifactResolutionException(String message, Artifact artifact, List remoteRepositories, Throwable t) {
        this(message, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), remoteRepositories, artifact.getDownloadUrl(), artifact.getDependencyTrail(), t);
    }

    public ArtifactResolutionException(String message, Artifact artifact, List remoteRepositories) {
        this(message, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), remoteRepositories, artifact.getDownloadUrl(), artifact.getDependencyTrail());
    }

    public ArtifactResolutionException(String message, Artifact artifact) {
        this(message, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), null, artifact.getDownloadUrl(), artifact.getDependencyTrail());
    }

    public ArtifactResolutionException(String message, Throwable cause) {
        super(message, cause);
        this.originalMessage = message;
        this.path = "";
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public List getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public String getArtifactPath() {
        return this.path;
    }
}

