/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.transform;

import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ReleaseArtifactMetadata;
import org.apache.maven.artifact.metadata.VersionArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactPathFormatException;
import org.apache.maven.artifact.transform.AbstractVersionTransformation;
import org.apache.maven.wagon.ResourceDoesNotExistException;

public class ReleaseArtifactTransformation
extends AbstractVersionTransformation {
    public static final String RELEASE_VERSION = "RELEASE";

    private static boolean isRelease(Artifact artifact) {
        return artifact.getVersion().equals(RELEASE_VERSION);
    }

    public void transformForResolve(Artifact artifact, List remoteRepositories, ArtifactRepository localRepository) throws ArtifactMetadataRetrievalException {
        String version;
        if (ReleaseArtifactTransformation.isRelease(artifact) && !(version = this.resolveVersion(artifact, localRepository, remoteRepositories)).equals(artifact.getVersion())) {
            artifact.setBaseVersion(version);
            artifact.updateVersion(version, localRepository);
        }
    }

    public void transformForInstall(Artifact artifact, ArtifactRepository localRepository) throws ArtifactMetadataRetrievalException {
        ReleaseArtifactMetadata metadata = new ReleaseArtifactMetadata(artifact);
        metadata.setVersion(artifact.getVersion());
        artifact.addMetadata(metadata);
    }

    public void transformForDeployment(Artifact artifact, ArtifactRepository remoteRepository) throws ArtifactMetadataRetrievalException {
        ReleaseArtifactMetadata metadata = new ReleaseArtifactMetadata(artifact);
        metadata.setVersion(artifact.getVersion());
        artifact.addMetadata(metadata);
    }

    protected VersionArtifactMetadata retrieveFromRemoteRepository(Artifact artifact, ArtifactRepository remoteRepository, VersionArtifactMetadata localMetadata) throws ArtifactMetadataRetrievalException {
        ReleaseArtifactMetadata metadata;
        block2: {
            metadata = new ReleaseArtifactMetadata(artifact);
            try {
                metadata.retrieveFromRemoteRepository(remoteRepository, this.wagonManager);
            }
            catch (ResourceDoesNotExistException e) {
                if (localMetadata.constructVersion() != null) break block2;
                throw new ArtifactMetadataRetrievalException("Unable to find release for artifact " + artifact, e);
            }
        }
        return metadata;
    }

    protected VersionArtifactMetadata readFromLocalRepository(Artifact artifact, ArtifactRepository localRepository) throws IOException, ArtifactPathFormatException {
        ReleaseArtifactMetadata metadata = new ReleaseArtifactMetadata(artifact);
        metadata.readFromLocalRepository(localRepository);
        return metadata;
    }
}

