/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.transform;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.VersionArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactPathFormatException;
import org.apache.maven.artifact.transform.ArtifactTransformation;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public abstract class AbstractVersionTransformation
extends AbstractLogEnabled
implements ArtifactTransformation {
    protected WagonManager wagonManager;
    private static Set resolvedArtifactCache = new HashSet();

    protected String resolveVersion(Artifact artifact, ArtifactRepository localRepository, List remoteRepositories) throws ArtifactMetadataRetrievalException {
        VersionArtifactMetadata localMetadata;
        try {
            localMetadata = this.readFromLocalRepository(artifact, localRepository);
        }
        catch (ArtifactPathFormatException e) {
            throw new ArtifactMetadataRetrievalException("Error reading local metadata", e);
        }
        catch (IOException e) {
            throw new ArtifactMetadataRetrievalException("Error reading local metadata", e);
        }
        boolean alreadyResolved = this.alreadyResolved(artifact);
        if (!alreadyResolved) {
            boolean checkedUpdates = false;
            Iterator i = remoteRepositories.iterator();
            while (i.hasNext()) {
                ArtifactRepository remoteRepository = (ArtifactRepository)((Object)i.next());
                String snapshotPolicy = remoteRepository.getSnapshotPolicy();
                boolean checkForUpdates = false;
                if ("always".equals(snapshotPolicy)) {
                    checkForUpdates = true;
                } else if ("daily".equals(snapshotPolicy)) {
                    if (!localMetadata.checkedSinceDate(this.getMidnightBoundary())) {
                        checkForUpdates = true;
                    }
                } else if (snapshotPolicy.startsWith("interval")) {
                    String s = snapshotPolicy.substring("interval".length() + 1);
                    int minutes = Integer.valueOf(s);
                    Calendar cal = Calendar.getInstance();
                    cal.add(12, -minutes);
                    if (!localMetadata.checkedSinceDate(cal.getTime())) {
                        checkForUpdates = true;
                    }
                }
                if (!checkForUpdates) continue;
                this.getLogger().info(artifact.getArtifactId() + ": checking for updates from " + remoteRepository.getId());
                VersionArtifactMetadata remoteMetadata = this.retrieveFromRemoteRepository(artifact, remoteRepository, localMetadata);
                int difference = remoteMetadata.compareTo(localMetadata);
                if (difference > 0) {
                    artifact.setRepository(remoteRepository);
                    localMetadata = remoteMetadata;
                }
                checkedUpdates = true;
            }
            if (checkedUpdates) {
                localMetadata.storeInLocalRepository(localRepository);
            }
            resolvedArtifactCache.add(AbstractVersionTransformation.getCacheKey(artifact));
        }
        String version = localMetadata.constructVersion();
        if (!artifact.getFile().exists() || localMetadata.newerThanFile(artifact.getFile())) {
            if (this.getLogger().isInfoEnabled() && !alreadyResolved && !version.equals(artifact.getBaseVersion())) {
                String message = artifact.getArtifactId() + ": resolved to version " + version;
                message = artifact.getRepository() != null ? message + " from repository " + artifact.getRepository().getId() : message + " from local repository";
                this.getLogger().info(message);
            }
            return version;
        }
        if (this.getLogger().isInfoEnabled() && !alreadyResolved) {
            this.getLogger().info(artifact.getArtifactId() + ": using locally installed snapshot");
        }
        return artifact.getVersion();
    }

    protected abstract VersionArtifactMetadata retrieveFromRemoteRepository(Artifact var1, ArtifactRepository var2, VersionArtifactMetadata var3) throws ArtifactMetadataRetrievalException;

    protected abstract VersionArtifactMetadata readFromLocalRepository(Artifact var1, ArtifactRepository var2) throws IOException, ArtifactPathFormatException;

    private Date getMidnightBoundary() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private boolean alreadyResolved(Artifact artifact) {
        return resolvedArtifactCache.contains(AbstractVersionTransformation.getCacheKey(artifact));
    }

    private static String getCacheKey(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getBaseVersion();
    }

    public abstract /* synthetic */ void transformForDeployment(Artifact var1, ArtifactRepository var2) throws ArtifactMetadataRetrievalException;

    public abstract /* synthetic */ void transformForInstall(Artifact var1, ArtifactRepository var2) throws ArtifactMetadataRetrievalException;

    public abstract /* synthetic */ void transformForResolve(Artifact var1, List var2, ArtifactRepository var3) throws ArtifactMetadataRetrievalException;
}

