/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver.filter;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;

public class ScopeArtifactFilter
implements ArtifactFilter {
    private final boolean compileScope;
    private final boolean runtimeScope;
    private final boolean testScope;

    public ScopeArtifactFilter(String scope) {
        if ("compile".equals(scope)) {
            this.compileScope = true;
            this.runtimeScope = false;
            this.testScope = false;
        } else if ("runtime".equals(scope)) {
            this.compileScope = true;
            this.runtimeScope = true;
            this.testScope = false;
        } else if ("test".equals(scope)) {
            this.compileScope = true;
            this.runtimeScope = true;
            this.testScope = true;
        } else {
            this.compileScope = false;
            this.runtimeScope = false;
            this.testScope = false;
        }
    }

    public boolean include(Artifact artifact) {
        if ("compile".equals(artifact.getScope())) {
            return this.compileScope;
        }
        if ("runtime".equals(artifact.getScope())) {
            return this.runtimeScope;
        }
        if ("test".equals(artifact.getScope())) {
            return this.testScope;
        }
        return false;
    }
}

