/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactPathFormatException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.TransitiveArtifactResolutionException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.transform.ArtifactTransformation;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;

public class DefaultArtifactResolver
extends AbstractLogEnabled
implements ArtifactResolver {
    private WagonManager wagonManager;
    private ArtifactHandlerManager artifactHandlerManager;
    private List artifactTransformations;
    private ArtifactFactory artifactFactory;

    public void resolve(Artifact artifact, List remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException {
        String localPath;
        Logger logger = this.getLogger();
        logger.debug("Resolving: " + artifact.getId() + " from:\n" + "{localRepository: " + (Object)((Object)localRepository) + "}\n" + "{remoteRepositories: " + remoteRepositories + "}");
        try {
            localPath = localRepository.pathOf(artifact);
        }
        catch (ArtifactPathFormatException e) {
            throw new ArtifactResolutionException(e.getMessage(), e);
        }
        artifact.setFile(new File(localRepository.getBasedir(), localPath));
        Iterator i = this.artifactTransformations.iterator();
        while (i.hasNext()) {
            ArtifactTransformation transform = (ArtifactTransformation)i.next();
            try {
                transform.transformForResolve(artifact, remoteRepositories, localRepository);
            }
            catch (ArtifactMetadataRetrievalException e) {
                throw new ArtifactResolutionException(e.getMessage(), artifact, remoteRepositories, e);
            }
        }
        File destination = artifact.getFile();
        if (!destination.exists()) {
            try {
                if (artifact.getRepository() != null) {
                    this.wagonManager.getArtifact(artifact, artifact.getRepository(), destination);
                } else {
                    this.wagonManager.getArtifact(artifact, remoteRepositories, destination);
                }
                Iterator i2 = artifact.getMetadataList().iterator();
                while (i2.hasNext()) {
                    ArtifactMetadata metadata = (ArtifactMetadata)i2.next();
                    metadata.storeInLocalRepository(localRepository);
                }
            }
            catch (ResourceDoesNotExistException e) {
                throw new ArtifactResolutionException(e.getMessage(), artifact, remoteRepositories, e);
            }
            catch (TransferFailedException e) {
                throw new ArtifactResolutionException(e.getMessage(), artifact, remoteRepositories, e);
            }
            catch (ArtifactMetadataRetrievalException e) {
                throw new ArtifactResolutionException(e.getMessage(), artifact, remoteRepositories, e);
            }
        }
    }

    public ArtifactResolutionResult resolveTransitively(Set artifacts, List remoteRepositories, ArtifactRepository localRepository, ArtifactMetadataSource source, ArtifactFilter filter) throws ArtifactResolutionException {
        ArtifactResolutionResult artifactResolutionResult = this.collect(artifacts, localRepository, remoteRepositories, source, filter);
        Iterator i = artifactResolutionResult.getArtifacts().values().iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            this.resolve(artifact, remoteRepositories, localRepository);
        }
        return artifactResolutionResult;
    }

    public ArtifactResolutionResult resolveTransitively(Set artifacts, List remoteRepositories, ArtifactRepository localRepository, ArtifactMetadataSource source) throws ArtifactResolutionException {
        return this.resolveTransitively(artifacts, remoteRepositories, localRepository, source, null);
    }

    public ArtifactResolutionResult resolveTransitively(Artifact artifact, List remoteRepositories, ArtifactRepository localRepository, ArtifactMetadataSource source) throws ArtifactResolutionException {
        return this.resolveTransitively(Collections.singleton(artifact), remoteRepositories, localRepository, source);
    }

    private ArtifactResolutionResult collect(Set artifacts, ArtifactRepository localRepository, List remoteRepositories, ArtifactMetadataSource source, ArtifactFilter filter) throws ArtifactResolutionException {
        ArtifactResolutionResult result = new ArtifactResolutionResult();
        HashMap<String, Artifact> resolvedArtifacts = new HashMap<String, Artifact>();
        LinkedList<Set> queue = new LinkedList<Set>();
        queue.add(artifacts);
        while (!queue.isEmpty()) {
            Set currentArtifacts = (Set)queue.remove(0);
            Iterator i = currentArtifacts.iterator();
            while (i.hasNext()) {
                Artifact newArtifact = (Artifact)i.next();
                String id = newArtifact.getConflictId();
                if (resolvedArtifacts.containsKey(id)) {
                    String knownVersion;
                    Artifact knownArtifact = (Artifact)resolvedArtifacts.get(id);
                    String newVersion = newArtifact.getVersion();
                    if (!newVersion.equals(knownVersion = knownArtifact.getVersion())) {
                        this.addConflict(result, knownArtifact, newArtifact);
                    }
                    boolean updateScope = false;
                    if ("runtime".equals(newArtifact.getScope()) && "test".equals(knownArtifact.getScope())) {
                        updateScope = true;
                    }
                    if ("compile".equals(newArtifact.getScope()) && !"compile".equals(knownArtifact.getScope())) {
                        updateScope = true;
                    }
                    if (!updateScope) continue;
                    Artifact artifact = this.artifactFactory.createArtifact(knownArtifact.getGroupId(), knownArtifact.getArtifactId(), knownVersion, newArtifact.getScope(), knownArtifact.getType());
                    resolvedArtifacts.put(artifact.getConflictId(), artifact);
                    continue;
                }
                if (filter != null && !filter.include(newArtifact)) continue;
                resolvedArtifacts.put(id, newArtifact);
                Set referencedDependencies = null;
                try {
                    referencedDependencies = source.retrieve(newArtifact, localRepository, remoteRepositories);
                }
                catch (ArtifactMetadataRetrievalException e) {
                    throw new TransitiveArtifactResolutionException(e.getMessage(), newArtifact, remoteRepositories, e);
                }
                queue.add(referencedDependencies);
            }
        }
        Map artifactResult = result.getArtifacts();
        Iterator it = resolvedArtifacts.values().iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            artifactResult.put(artifact.getId(), artifact);
        }
        return result;
    }

    private void addConflict(ArtifactResolutionResult result, Artifact knownArtifact, Artifact newArtifact) {
        LinkedList<Artifact> conflicts = (LinkedList<Artifact>)result.getConflicts().get(newArtifact.getConflictId());
        if (conflicts == null) {
            conflicts = new LinkedList<Artifact>();
            conflicts.add(knownArtifact);
            result.getConflicts().put(newArtifact.getConflictId(), conflicts);
        }
        conflicts.add(newArtifact);
    }
}

