/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;

public class ArtifactResolutionException
extends Exception {
    private String groupId;
    private String artifactId;
    private String version;
    private String type;
    private String downloadUrl;
    private List remoteRepositories;
    private static final String LS = System.getProperty("line.separator");

    public ArtifactResolutionException(String message, String groupId, String artifactId, String version, String type, List remoteRepositories, String downloadUrl, Throwable t) {
        super(ArtifactResolutionException.constructMessage(message, groupId, artifactId, version, type, remoteRepositories, downloadUrl), t);
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.type = type;
        this.version = version;
        this.remoteRepositories = remoteRepositories;
        this.downloadUrl = downloadUrl;
    }

    private static String constructMessage(String message, String groupId, String artifactId, String version, String type, List remoteRepositories, String downloadUrl) {
        StringBuffer sb = new StringBuffer();
        sb.append(message);
        sb.append(LS);
        sb.append("  " + groupId + ":" + artifactId + ":" + version + ":" + type);
        sb.append(LS);
        sb.append(LS);
        sb.append("from the specified remote repositories:");
        sb.append(LS + "  ");
        Iterator i = remoteRepositories.iterator();
        while (i.hasNext()) {
            ArtifactRepository remoteRepository = (ArtifactRepository)((Object)i.next());
            sb.append(remoteRepository.getUrl());
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        if (downloadUrl != null && !type.equals("pom")) {
            sb.append(LS);
            sb.append(LS);
            sb.append("Try downloading the file manually from");
            sb.append(LS);
            sb.append("  " + downloadUrl);
            sb.append(LS);
            sb.append("and install it using the command: ");
            sb.append(LS);
            sb.append("  m2 install:install-file -DgroupId=");
            sb.append(groupId);
            sb.append(" -DartifactId=");
            sb.append(artifactId);
            sb.append(" -Dversion=");
            sb.append(version);
            sb.append(" -Dpackaging=");
            sb.append(type);
            sb.append(" -Dfile=/path/to/file");
        }
        return sb.toString();
    }

    public ArtifactResolutionException(String message, Artifact artifact, List remoteRepositories, Throwable t) {
        this(message, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), remoteRepositories, artifact.getDownloadUrl(), t);
    }

    public ArtifactResolutionException(String message, Throwable cause) {
        super(message, cause);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public List getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }
}

