/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository.layout;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerNotFoundException;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.layout.ArtifactPathFormatException;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;

public class LegacyRepositoryLayout
implements ArtifactRepositoryLayout {
    private ArtifactHandlerManager artifactHandlerManager;

    public String pathOf(Artifact artifact) throws ArtifactPathFormatException {
        ArtifactHandler artifactHandler = null;
        try {
            artifactHandler = this.artifactHandlerManager.getArtifactHandler(artifact.getType());
        }
        catch (ArtifactHandlerNotFoundException e) {
            throw new ArtifactPathFormatException("Cannot find ArtifactHandler for artifact: '" + artifact.getId() + "'.", e);
        }
        StringBuffer path = new StringBuffer();
        path.append(artifact.getGroupId()).append('/');
        path.append(artifactHandler.directory()).append('/');
        path.append(artifact.getArtifactId()).append('-').append(artifact.getVersion());
        if (artifact.hasClassifier()) {
            path.append('-').append(artifact.getClassifier());
        }
        if (artifactHandler.extension() != null && artifactHandler.extension().length() > 0) {
            path.append('.').append(artifactHandler.extension());
        }
        return path.toString();
    }

    public String pathOfMetadata(ArtifactMetadata metadata) throws ArtifactPathFormatException {
        StringBuffer path = new StringBuffer();
        path.append(metadata.getGroupId()).append("/poms/");
        path.append(metadata.getFilename());
        return path.toString();
    }
}

