/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.layout.ArtifactPathFormatException;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.wagon.repository.Repository;

public class ArtifactRepository
extends Repository {
    private final String snapshotPolicy;
    private final ArtifactRepositoryLayout layout;
    public static final String SNAPSHOT_POLICY_NEVER = "never";
    public static final String SNAPSHOT_POLICY_ALWAYS = "always";
    public static final String SNAPSHOT_POLICY_DAILY = "daily";
    public static final String SNAPSHOT_POLICY_INTERVAL = "interval";

    public ArtifactRepository(String id, String url, ArtifactRepositoryLayout layout) {
        this(id, url, layout, SNAPSHOT_POLICY_NEVER);
    }

    public ArtifactRepository(String id, String url, ArtifactRepositoryLayout layout, String snapshotPolicy) {
        super(id, url);
        this.layout = layout;
        this.snapshotPolicy = snapshotPolicy;
    }

    public String pathOf(Artifact artifact) throws ArtifactPathFormatException {
        return this.layout.pathOf(artifact);
    }

    public String pathOfMetadata(ArtifactMetadata artifactMetadata) throws ArtifactPathFormatException {
        return this.layout.pathOfMetadata(artifactMetadata);
    }

    public String getSnapshotPolicy() {
        return this.snapshotPolicy;
    }

    public ArtifactRepository createMirror(Repository mirror) {
        return new ArtifactRepository(mirror.getId(), mirror.getUrl(), this.layout, this.snapshotPolicy);
    }
}

