/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.metadata;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.AbstractArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.VersionArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactPathFormatException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractVersionArtifactMetadata
extends AbstractArtifactMetadata
implements VersionArtifactMetadata {
    protected static final String SNAPSHOT_VERSION_FILE = "version.txt";
    protected long lastModified = 0L;

    public AbstractVersionArtifactMetadata(Artifact artifact, String filename) {
        super(artifact, filename);
    }

    protected File getLocalRepositoryLocation(ArtifactRepository localRepository) throws ArtifactPathFormatException {
        return new File(localRepository.getBasedir(), localRepository.pathOfMetadata(this));
    }

    private void readFromFile(File file) throws IOException {
        this.setContent(FileUtils.fileRead((File)file));
        this.lastModified = file.lastModified();
    }

    protected abstract void setContent(String var1);

    public boolean checkedSinceDate(Date date) {
        return !date.after(new Date(this.lastModified));
    }

    public boolean exists() {
        return this.lastModified > 0L;
    }

    public void readFromLocalRepository(ArtifactRepository localRepository) throws ArtifactPathFormatException, IOException {
        File f = this.getLocalRepositoryLocation(localRepository);
        if (f.exists()) {
            this.readFromFile(f);
        }
    }

    public void retrieveFromRemoteRepository(ArtifactRepository remoteRepository, WagonManager wagonManager) throws ArtifactMetadataRetrievalException, ResourceDoesNotExistException {
        try {
            File destination = File.createTempFile("maven-artifact", null);
            destination.deleteOnExit();
            wagonManager.getArtifactMetadata(this, remoteRepository, destination);
            this.readFromFile(destination);
        }
        catch (TransferFailedException e) {
            throw new ArtifactMetadataRetrievalException("Unable to retrieve metadata", e);
        }
        catch (IOException e) {
            throw new ArtifactMetadataRetrievalException("Unable to retrieve metadata", e);
        }
    }

    public void storeInLocalRepository(ArtifactRepository localRepository) throws ArtifactMetadataRetrievalException {
        try {
            String path = this.getLocalRepositoryLocation(localRepository).getPath();
            File file = new File(path);
            file.getParentFile().mkdirs();
            FileUtils.fileWrite((String)path, (String)this.constructVersion());
            this.lastModified = file.lastModified();
        }
        catch (IOException e) {
            throw new ArtifactMetadataRetrievalException("Unable to retrieve metadata", e);
        }
        catch (ArtifactPathFormatException e) {
            throw new ArtifactMetadataRetrievalException("Unable to retrieve metadata", e);
        }
    }

    public abstract /* synthetic */ String constructVersion();

    public abstract /* synthetic */ boolean newerThanFile(File var1);

    public abstract /* synthetic */ int compareTo(Object var1);
}

