/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.manager;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ChecksumFailedException;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactPathFormatException;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.ChecksumObserver;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.FileUtils;

public class DefaultWagonManager
extends AbstractLogEnabled
implements WagonManager,
Contextualizable {
    private PlexusContainer container;
    private Map proxies = new HashMap();
    private Map authenticationInfoMap = new HashMap();
    private Map mirrors = new HashMap();
    private TransferListener downloadMonitor;
    private ArtifactHandlerManager artifactHandlerManager;

    public Wagon getWagon(String protocol) throws UnsupportedProtocolException {
        Wagon wagon;
        try {
            wagon = (Wagon)this.container.lookup(Wagon.ROLE, protocol);
        }
        catch (ComponentLookupException e) {
            throw new UnsupportedProtocolException("Cannot find wagon which supports the requested protocol: " + protocol, (Throwable)e);
        }
        return wagon;
    }

    public void putArtifact(File source, Artifact artifact, ArtifactRepository repository) throws TransferFailedException {
        try {
            this.putRemoteFile(repository, source, repository.pathOf(artifact), this.downloadMonitor);
        }
        catch (ArtifactPathFormatException e) {
            throw new TransferFailedException("Path of artifact could not be determined: ", (Throwable)e);
        }
    }

    public void putArtifactMetadata(File source, ArtifactMetadata artifactMetadata, ArtifactRepository repository) throws TransferFailedException {
        try {
            this.getLogger().info("Uploading " + artifactMetadata);
            this.putRemoteFile(repository, source, repository.pathOfMetadata(artifactMetadata), null);
        }
        catch (ArtifactPathFormatException e) {
            throw new TransferFailedException("Path of artifact could not be determined: ", (Throwable)e);
        }
    }

    private void putRemoteFile(ArtifactRepository repository, File source, String remotePath, TransferListener downloadMonitor) throws TransferFailedException {
        String protocol = repository.getProtocol();
        Wagon wagon = null;
        try {
            wagon = this.getWagon(protocol);
        }
        catch (UnsupportedProtocolException e) {
            throw new TransferFailedException("Unsupported Protocol: ", (Throwable)e);
        }
        if (downloadMonitor != null) {
            wagon.addTransferListener(downloadMonitor);
        }
        HashMap<String, ChecksumObserver> checksums = new HashMap<String, ChecksumObserver>();
        try {
            ChecksumObserver checksumObserver = new ChecksumObserver("MD5");
            wagon.addTransferListener((TransferListener)checksumObserver);
            checksums.put("md5", checksumObserver);
            checksumObserver = new ChecksumObserver("SHA-1");
            wagon.addTransferListener((TransferListener)checksumObserver);
            checksums.put("sha1", checksumObserver);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TransferFailedException("Unable to add checksum methods", (Throwable)e);
        }
        try {
            wagon.connect((Repository)repository, this.getAuthenticationInfo(repository.getId()), this.getProxy(protocol));
            wagon.put(source, remotePath);
            wagon.removeTransferListener(downloadMonitor);
            Iterator i = checksums.keySet().iterator();
            while (i.hasNext()) {
                String extension = (String)i.next();
                ChecksumObserver observer = (ChecksumObserver)checksums.get(extension);
                File temp = File.createTempFile("maven-artifact", null);
                temp.deleteOnExit();
                FileUtils.fileWrite((String)temp.getAbsolutePath(), (String)observer.getActualChecksum());
                wagon.put(temp, remotePath + "." + extension);
            }
        }
        catch (ConnectionException e) {
            throw new TransferFailedException("Connection failed: ", (Throwable)e);
        }
        catch (AuthenticationException e) {
            throw new TransferFailedException("Authentication failed: ", (Throwable)e);
        }
        catch (AuthorizationException e) {
            throw new TransferFailedException("Authorization failed: ", (Throwable)e);
        }
        catch (ResourceDoesNotExistException e) {
            throw new TransferFailedException("Resource to deploy not found: ", (Throwable)e);
        }
        catch (IOException e) {
            throw new TransferFailedException("Error creating temporary file for deployment: ", (Throwable)e);
        }
        finally {
            this.disconnectWagon(wagon);
            this.releaseWagon(wagon);
        }
    }

    public void getArtifact(Artifact artifact, List remoteRepositories, File destination) throws TransferFailedException, ResourceDoesNotExistException {
        boolean successful = false;
        Iterator iter = remoteRepositories.iterator();
        while (iter.hasNext() && !successful) {
            ArtifactRepository repository = (ArtifactRepository)((Object)iter.next());
            try {
                this.getArtifact(artifact, repository, destination);
                successful = true;
            }
            catch (ResourceDoesNotExistException e) {
                this.getLogger().warn("Unable to get resource from repository " + repository.getUrl());
            }
        }
        if (!successful) {
            throw new ResourceDoesNotExistException("Unable to download the artifact from any repository");
        }
    }

    public void getArtifact(Artifact artifact, ArtifactRepository repository, File destination) throws TransferFailedException, ResourceDoesNotExistException {
        String remotePath = null;
        try {
            remotePath = repository.pathOf(artifact);
        }
        catch (ArtifactPathFormatException e) {
            throw new TransferFailedException("Failed to determine path for artifact", (Throwable)e);
        }
        this.getRemoteFile(repository, destination, remotePath, this.downloadMonitor);
    }

    public void getArtifactMetadata(ArtifactMetadata metadata, ArtifactRepository remoteRepository, File destination) throws TransferFailedException, ResourceDoesNotExistException {
        String remotePath;
        try {
            remotePath = remoteRepository.pathOfMetadata(metadata);
        }
        catch (ArtifactPathFormatException e) {
            throw new TransferFailedException("Failed to determine path for artifact", (Throwable)e);
        }
        this.getLogger().info("Retrieving " + metadata);
        this.getRemoteFile(remoteRepository, destination, remotePath, null);
    }

    private void getRemoteFile(ArtifactRepository repository, File destination, String remotePath, TransferListener downloadMonitor) throws TransferFailedException, ResourceDoesNotExistException, ChecksumFailedException {
        ChecksumObserver checksumObserver;
        Wagon wagon;
        String protocol = repository.getProtocol();
        try {
            wagon = this.getWagon(protocol);
        }
        catch (UnsupportedProtocolException e) {
            throw new TransferFailedException("Unsupported Protocol: ", (Throwable)e);
        }
        if (downloadMonitor != null) {
            wagon.addTransferListener(downloadMonitor);
        }
        if (!destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
        try {
            checksumObserver = new ChecksumObserver("MD5");
            wagon.addTransferListener((TransferListener)checksumObserver);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TransferFailedException("Unable to add checksum methods", (Throwable)e);
        }
        File temp = new File(destination + ".tmp");
        temp.deleteOnExit();
        try {
            Repository mirror = this.getMirror(repository.getId());
            if (mirror != null) {
                repository = repository.createMirror(mirror);
            }
            wagon.connect((Repository)repository, this.getAuthenticationInfo(repository.getId()), this.getProxy(protocol));
            wagon.get(remotePath, temp);
            try {
                String actualChecksum = checksumObserver.getActualChecksum();
                File checksumFile = new File(destination + ".md5");
                wagon.get(remotePath + ".md5", checksumFile);
                String expectedChecksum = FileUtils.fileRead((File)checksumFile);
                if (!expectedChecksum.equals(actualChecksum)) {
                    this.getLogger().warn("*** CHECKSUM MISMATCH - currently disabled fail due to bad repository checksums ***");
                }
            }
            catch (ResourceDoesNotExistException e) {
                this.getLogger().warn("No checksum exists - assuming a valid download");
            }
            catch (IOException e) {
                this.getLogger().error("Unable to read checksum - assuming a valid download", (Throwable)e);
            }
        }
        catch (ConnectionException e) {
            throw new TransferFailedException("Connection failed: ", (Throwable)e);
        }
        catch (AuthenticationException e) {
            throw new TransferFailedException("Authentication failed: ", (Throwable)e);
        }
        catch (AuthorizationException e) {
            throw new TransferFailedException("Authorization failed: ", (Throwable)e);
        }
        finally {
            this.disconnectWagon(wagon);
            this.releaseWagon(wagon);
        }
        if (!temp.exists()) {
            throw new ResourceDoesNotExistException("Downloaded file does not exist: " + temp);
        }
        if (!temp.renameTo(destination)) {
            try {
                FileUtils.copyFile((File)temp, (File)destination);
                temp.delete();
            }
            catch (IOException e) {
                throw new TransferFailedException("Error copying temporary file to the final destination: ", (Throwable)e);
            }
        }
    }

    private void disconnectWagon(Wagon wagon) {
        try {
            wagon.disconnect();
        }
        catch (ConnectionException e) {
            this.getLogger().error("Problem disconnecting from wagon - ignoring: " + e.getMessage());
        }
    }

    private void releaseWagon(Wagon wagon) {
        try {
            this.container.release((Object)wagon);
        }
        catch (ComponentLifecycleException e) {
            this.getLogger().error("Problem releasing wagon - ignoring: " + e.getMessage());
        }
    }

    public ProxyInfo getProxy(String protocol) {
        return (ProxyInfo)this.proxies.get(protocol);
    }

    public AuthenticationInfo getAuthenticationInfo(String id) {
        return (AuthenticationInfo)this.authenticationInfoMap.get(id);
    }

    public Repository getMirror(String mirrorOf) {
        return (Repository)this.mirrors.get(mirrorOf);
    }

    public void addProxy(String protocol, String host, int port, String username, String password, String nonProxyHosts) {
        ProxyInfo proxyInfo = new ProxyInfo();
        proxyInfo.setHost(host);
        proxyInfo.setType(protocol);
        proxyInfo.setPort(port);
        proxyInfo.setNonProxyHosts(nonProxyHosts);
        proxyInfo.setUserName(username);
        proxyInfo.setPassword(password);
        this.proxies.put(protocol, proxyInfo);
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    public void setDownloadMonitor(TransferListener downloadMonitor) {
        this.downloadMonitor = downloadMonitor;
    }

    public void addAuthenticationInfo(String repositoryId, String username, String password, String privateKey, String passphrase) {
        AuthenticationInfo authInfo = new AuthenticationInfo();
        authInfo.setUserName(username);
        authInfo.setPassword(password);
        authInfo.setPrivateKey(privateKey);
        authInfo.setPassphrase(passphrase);
        this.authenticationInfoMap.put(repositoryId, authInfo);
    }

    public void addMirror(String id, String mirrorOf, String url) {
        Repository mirror = new Repository(id, url);
        this.mirrors.put(mirrorOf, mirror);
    }
}

