/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.installer;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerNotFoundException;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactPathFormatException;
import org.apache.maven.artifact.transform.ArtifactTransformation;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;

public class DefaultArtifactInstaller
extends AbstractLogEnabled
implements ArtifactInstaller {
    private ArtifactHandlerManager artifactHandlerManager;
    private List artifactTransformations;

    public void install(String basedir, String finalName, Artifact artifact, ArtifactRepository localRepository) throws ArtifactInstallationException {
        File source = null;
        try {
            String extension = this.artifactHandlerManager.getArtifactHandler(artifact.getType()).extension();
            source = new File(basedir, finalName + "." + extension);
        }
        catch (ArtifactHandlerNotFoundException e) {
            throw new ArtifactInstallationException("Error installing artifact: ", e);
        }
        this.install(source, artifact, localRepository);
    }

    public void install(File source, Artifact artifact, ArtifactRepository localRepository) throws ArtifactInstallationException {
        try {
            Iterator i = this.artifactTransformations.iterator();
            while (i.hasNext()) {
                ArtifactTransformation transform = (ArtifactTransformation)i.next();
                transform.transformForInstall(artifact, localRepository);
            }
            String localPath = localRepository.pathOf(artifact);
            File destination = new File(localRepository.getBasedir(), localPath);
            if (!destination.getParentFile().exists()) {
                destination.getParentFile().mkdirs();
            }
            this.getLogger().info("Installing " + source.getPath() + " to " + destination);
            FileUtils.copyFile((File)source, (File)destination);
            Iterator i2 = artifact.getMetadataList().iterator();
            while (i2.hasNext()) {
                ArtifactMetadata metadata = (ArtifactMetadata)i2.next();
                metadata.storeInLocalRepository(localRepository);
            }
        }
        catch (IOException e) {
            throw new ArtifactInstallationException("Error installing artifact: ", e);
        }
        catch (ArtifactPathFormatException e) {
            throw new ArtifactInstallationException("Error installing artifact: ", e);
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new ArtifactInstallationException("Error installing artifact: ", e);
        }
    }
}

