/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactPathFormatException;
import org.codehaus.plexus.util.StringUtils;

public class DefaultArtifact
implements Artifact {
    private final String groupId;
    private final String artifactId;
    private String version;
    private String baseVersion;
    private final String type;
    private final String classifier;
    private final String scope;
    private List metadataList;
    private File file;
    private ArtifactRepository repository;
    private String downloadUrl;

    public DefaultArtifact(String groupId, String artifactId, String version, String scope, String type, String classifier) {
        if (type == null) {
            throw new NullPointerException("Artifact type cannot be null.");
        }
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
        this.scope = scope;
        this.classifier = classifier;
    }

    public DefaultArtifact(String groupId, String artifactId, String version, String scope, String type) {
        this(groupId, artifactId, version, scope, type, null);
    }

    public DefaultArtifact(String groupId, String artifactId, String version, String type) {
        this(groupId, artifactId, version, null, type, null);
    }

    public String getClassifier() {
        return this.classifier;
    }

    public boolean hasClassifier() {
        return StringUtils.isNotEmpty((String)this.classifier);
    }

    public String getScope() {
        return this.scope;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public ArtifactRepository getRepository() {
        return this.repository;
    }

    public void setRepository(ArtifactRepository repository) {
        this.repository = repository;
    }

    public String getId() {
        return this.getConflictId() + (this.hasClassifier() ? ":" + this.getClassifier() : "") + ":" + this.getBaseVersion();
    }

    public String getConflictId() {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getType();
    }

    public void addMetadata(ArtifactMetadata metadata) {
        if (this.metadataList == null) {
            this.metadataList = new ArrayList();
        }
        this.metadataList.add(metadata);
    }

    public List getMetadataList() {
        return this.metadataList == null ? Collections.EMPTY_LIST : this.metadataList;
    }

    public String toString() {
        return this.getId();
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.groupId.hashCode();
        result = 37 * result + this.artifactId.hashCode();
        result = 37 * result + this.type.hashCode();
        result = 37 * result + this.version.hashCode();
        result = 37 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Artifact)) {
            return false;
        }
        Artifact a = (Artifact)o;
        if (!a.getGroupId().equals(this.groupId)) {
            return false;
        }
        if (!a.getArtifactId().equals(this.artifactId)) {
            return false;
        }
        if (!a.getVersion().equals(this.version)) {
            return false;
        }
        if (!a.getType().equals(this.type)) {
            return false;
        }
        return !(this.classifier == null ? a.getClassifier() != null : !a.getClassifier().equals(this.classifier));
    }

    public String getBaseVersion() {
        if (this.baseVersion == null) {
            this.baseVersion = this.version;
            if (this.version == null) {
                throw new NullPointerException("version was null for " + this.groupId + ":" + this.artifactId);
            }
        }
        return this.baseVersion;
    }

    public void setBaseVersion(String baseVersion) {
        this.baseVersion = baseVersion;
    }

    public int compareTo(Object o) {
        Artifact a = (Artifact)o;
        int result = this.groupId.compareTo(a.getGroupId());
        if (result == 0 && (result = this.artifactId.compareTo(a.getArtifactId())) == 0 && (result = this.type.compareTo(a.getType())) == 0) {
            if (this.classifier == null) {
                if (a.getClassifier() != null) {
                    result = 1;
                }
            } else {
                result = a.getClassifier() != null ? this.classifier.compareTo(a.getClassifier()) : -1;
            }
            if (result == 0) {
                result = this.version.compareTo(a.getVersion());
            }
        }
        return result;
    }

    public void updateVersion(String version, ArtifactRepository localRepository) throws ArtifactMetadataRetrievalException {
        this.setVersion(version);
        try {
            this.setFile(new File(localRepository.getBasedir(), localRepository.pathOf(this)));
        }
        catch (ArtifactPathFormatException e) {
            throw new ArtifactMetadataRetrievalException("Error reading local metadata", e);
        }
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }
}

