/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.test;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactPathFormatException;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Reader;
import org.codehaus.plexus.PlexusTestCase;

public abstract class ArtifactTestCase
extends PlexusTestCase {
    private ArtifactRepository localRepository;

    protected File getLocalArtifactPath(Artifact artifact) throws ArtifactPathFormatException {
        return new File(this.localRepository.getBasedir(), this.localRepository.pathOf(artifact));
    }

    protected void setUp() throws Exception {
        super.setUp();
        File settingsFile = new File(System.getProperty("user.home"), ".m2/settings.xml");
        String localRepo = null;
        if (settingsFile.exists()) {
            Settings settings = new SettingsXpp3Reader().read((Reader)new FileReader(settingsFile));
            Profile profile = (Profile)settings.getProfiles().get(0);
            localRepo = profile.getLocalRepository();
        } else {
            localRepo = System.getProperty("user.home") + "/.m2/repository";
        }
        ArtifactRepositoryLayout repositoryLayout = (ArtifactRepositoryLayout)this.container.lookup(ArtifactRepositoryLayout.ROLE, "default");
        this.localRepository = new ArtifactRepository("local", "file://" + localRepo, repositoryLayout);
    }
}

