/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiver;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.archiver.ManifestConfiguration;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.IOUtil;

public class MavenArchiver {
    private JarArchiver archiver;
    private File archiveFile;

    public Manifest getManifest(MavenProject project, ManifestConfiguration config) throws ManifestException, DependencyResolutionRequiredException {
        Manifest m = new Manifest();
        Manifest.Attribute buildAttr = new Manifest.Attribute("Built-By", System.getProperty("user.name"));
        m.addConfiguredAttribute(buildAttr);
        Manifest.Attribute createdAttr = new Manifest.Attribute("Created-By", "Apache Maven");
        m.addConfiguredAttribute(createdAttr);
        Artifact projectArtifact = project.getArtifact();
        if (config.getPackageName() != null) {
            Manifest.Attribute packageAttr = new Manifest.Attribute("Package", config.getPackageName());
            m.addConfiguredAttribute(packageAttr);
        }
        Manifest.Attribute buildJdkAttr = new Manifest.Attribute("Build-Jdk", System.getProperty("java.version"));
        m.addConfiguredAttribute(buildJdkAttr);
        if (config.isAddClasspath()) {
            StringBuffer classpath = new StringBuffer();
            List artifacts = project.getRuntimeClasspathElements();
            String classpathPrefix = config.getClasspathPrefix();
            Iterator iter = artifacts.iterator();
            while (iter.hasNext()) {
                File f = new File((String)iter.next());
                if (!f.isFile()) continue;
                if (classpath.length() > 0) {
                    classpath.append(" ");
                }
                classpath.append(classpathPrefix);
                classpath.append(f.getName());
            }
            if (classpath.length() > 0) {
                Manifest.Attribute classpathAttr = new Manifest.Attribute("Class-Path", classpath.toString());
                m.addConfiguredAttribute(classpathAttr);
            }
        }
        Manifest.Attribute extensionNameAttr = new Manifest.Attribute("Extension-Name", project.getArtifactId());
        m.addConfiguredAttribute(extensionNameAttr);
        if (project.getDescription() != null) {
            Manifest.Attribute specificationTitleAttr = new Manifest.Attribute("Specification-Title", project.getDescription());
            m.addConfiguredAttribute(specificationTitleAttr);
        }
        if (project.getOrganization() != null) {
            Manifest.Attribute specificationVendor = new Manifest.Attribute("Specification-Vendor", project.getOrganization().getName());
            m.addConfiguredAttribute(specificationVendor);
            Manifest.Attribute implementationVendorAttr = new Manifest.Attribute("Implementation-Vendor", project.getOrganization().getName());
            m.addConfiguredAttribute(implementationVendorAttr);
        }
        Manifest.Attribute implementationTitleAttr = new Manifest.Attribute("Implementation-Title", project.getArtifactId());
        m.addConfiguredAttribute(implementationTitleAttr);
        Manifest.Attribute implementationVersionAttr = new Manifest.Attribute("Implementation-Version", project.getVersion());
        m.addConfiguredAttribute(implementationVersionAttr);
        String mainClass = config.getMainClass();
        if (mainClass != null && !"".equals(mainClass)) {
            Manifest.Attribute mainClassAttr = new Manifest.Attribute("Main-Class", mainClass);
            m.addConfiguredAttribute(mainClassAttr);
        }
        if (config.isAddExtensions()) {
            Artifact artifact;
            StringBuffer extensionsList = new StringBuffer();
            Set artifacts = project.getArtifacts();
            Iterator iter = artifacts.iterator();
            while (iter.hasNext()) {
                artifact = (Artifact)iter.next();
                if (!"jar".equals(artifact.getType())) continue;
                if (extensionsList.length() > 0) {
                    extensionsList.append(" ");
                }
                extensionsList.append(artifact.getArtifactId());
            }
            if (extensionsList.length() > 0) {
                Manifest.Attribute extensionsListAttr = new Manifest.Attribute("Extension-List", extensionsList.toString());
                m.addConfiguredAttribute(extensionsListAttr);
            }
            iter = artifacts.iterator();
            while (iter.hasNext()) {
                artifact = (Artifact)iter.next();
                if (!"jar".equals(artifact.getType())) continue;
                Manifest.Attribute archExtNameAttr = new Manifest.Attribute(artifact.getArtifactId() + "-Extension-Name", artifact.getArtifactId());
                m.addConfiguredAttribute(archExtNameAttr);
                String name = artifact.getArtifactId() + "-Implementation-Version";
                Manifest.Attribute archImplVersionAttr = new Manifest.Attribute(name, artifact.getVersion());
                m.addConfiguredAttribute(archImplVersionAttr);
                if (artifact.getRepository() == null) continue;
                name = artifact.getArtifactId() + "-Implementation-URL";
                String url = artifact.getRepository().getUrl() + "/" + artifact.toString();
                Manifest.Attribute archImplUrlAttr = new Manifest.Attribute(name, url);
                m.addConfiguredAttribute(archImplUrlAttr);
            }
        }
        return m;
    }

    public JarArchiver getArchiver() {
        return this.archiver;
    }

    public void setArchiver(JarArchiver archiver) {
        this.archiver = archiver;
    }

    public void setOutputFile(File outputFile) {
        this.archiveFile = outputFile;
    }

    public void createArchive(MavenProject project, MavenArchiveConfiguration archiveConfiguration) throws ArchiverException, ManifestException, IOException, DependencyResolutionRequiredException {
        MavenProject workingProject = new MavenProject(project);
        if (workingProject.getArtifact().isSnapshot()) {
            workingProject.setVersion(workingProject.getArtifact().getVersion());
        }
        String groupId = workingProject.getGroupId();
        String artifactId = workingProject.getArtifactId();
        File exportReadyPom = this.writeExportReadyPom(workingProject);
        this.archiver.addFile(exportReadyPom, "META-INF/maven/" + groupId + "/" + artifactId + "/pom.xml");
        Properties p = new Properties();
        p.setProperty("groupId", workingProject.getGroupId());
        p.setProperty("artifactId", workingProject.getArtifactId());
        p.setProperty("version", workingProject.getVersion());
        File pomPropertiesFile = new File(workingProject.getFile().getParentFile(), "pom.properties");
        FileOutputStream os = new FileOutputStream(pomPropertiesFile);
        p.store(os, "Generated by Maven");
        ((OutputStream)os).close();
        this.archiver.addFile(pomPropertiesFile, "META-INF/maven/" + groupId + "/" + artifactId + "/pom.properties");
        File manifestFile = archiveConfiguration.getManifestFile();
        if (manifestFile != null) {
            this.archiver.setManifest(manifestFile);
        }
        Manifest manifest = this.getManifest(workingProject, archiveConfiguration.getManifest());
        if (!archiveConfiguration.isManifestEntriesEmpty()) {
            Map entries = archiveConfiguration.getManifestEntries();
            Set keys = entries.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String value = (String)entries.get(key);
                Manifest.Attribute attr = new Manifest.Attribute(key, value);
                manifest.addConfiguredAttribute(attr);
            }
        }
        this.archiver.addConfiguredManifest(manifest);
        this.archiver.setCompress(archiveConfiguration.isCompress());
        this.archiver.setIndex(archiveConfiguration.isIndex());
        this.archiver.setDestFile(this.archiveFile);
        this.archiver.createArchive();
        pomPropertiesFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File writeExportReadyPom(MavenProject project) throws IOException {
        String buildDirectory = project.getBuild().getDirectory();
        File buildDirectoryFile = new File(buildDirectory);
        buildDirectoryFile.mkdirs();
        File fullPom = new File(buildDirectoryFile, "exported-pom.xml");
        FileWriter fWriter = null;
        try {
            fWriter = new FileWriter(fullPom);
            project.writeModel((Writer)fWriter);
        }
        catch (Throwable throwable) {
            IOUtil.close(fWriter);
            throw throwable;
        }
        IOUtil.close((Writer)fWriter);
        return fullPom;
    }
}

