/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiver;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.archiver.ManifestConfiguration;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;

public class MavenArchiver {
    private JarArchiver archiver = new JarArchiver();
    private File archiveFile;

    public Manifest getManifest(MavenProject project, ManifestConfiguration config) throws ManifestException, DependencyResolutionRequiredException {
        Manifest m = new Manifest();
        Manifest.Attribute buildAttr = new Manifest.Attribute("Built-By", System.getProperty("user.name"));
        m.addConfiguredAttribute(buildAttr);
        Manifest.Attribute createdAttr = new Manifest.Attribute("Created-By", "Apache Maven");
        m.addConfiguredAttribute(createdAttr);
        if (config.getPackageName() != null) {
            Manifest.Attribute packageAttr = new Manifest.Attribute("Package", config.getPackageName());
            m.addConfiguredAttribute(packageAttr);
        }
        Manifest.Attribute buildJdkAttr = new Manifest.Attribute("Build-Jdk", System.getProperty("java.version"));
        m.addConfiguredAttribute(buildJdkAttr);
        if (config.isAddClasspath()) {
            StringBuffer classpath = new StringBuffer();
            List artifacts = project.getRuntimeClasspathElements();
            Iterator iter = artifacts.iterator();
            while (iter.hasNext()) {
                File f = new File((String)iter.next());
                if (!f.isFile()) continue;
                if (classpath.length() > 0) {
                    classpath.append(" ");
                }
                classpath.append(f.getName());
            }
            if (classpath.length() > 0) {
                Manifest.Attribute classpathAttr = new Manifest.Attribute("Class-Path", classpath.toString());
                m.addConfiguredAttribute(classpathAttr);
            }
        }
        Manifest.Attribute extensionNameAttr = new Manifest.Attribute("Extension-Name", project.getArtifactId());
        m.addConfiguredAttribute(extensionNameAttr);
        if (project.getDescription() != null) {
            Manifest.Attribute specificationTitleAttr = new Manifest.Attribute("Specification-Title", project.getDescription());
            m.addConfiguredAttribute(specificationTitleAttr);
        }
        if (project.getOrganization() != null) {
            Manifest.Attribute specificationVendor = new Manifest.Attribute("Specification-Vendor", project.getOrganization().getName());
            m.addConfiguredAttribute(specificationVendor);
            Manifest.Attribute implementationVendorAttr = new Manifest.Attribute("Implementation-Vendor", project.getOrganization().getName());
            m.addConfiguredAttribute(implementationVendorAttr);
        }
        Manifest.Attribute implementationTitleAttr = new Manifest.Attribute("Implementation-Title", project.getArtifactId());
        m.addConfiguredAttribute(implementationTitleAttr);
        Manifest.Attribute implementationVersionAttr = new Manifest.Attribute("Implementation-Version", project.getVersion());
        m.addConfiguredAttribute(implementationVersionAttr);
        String mainClass = config.getMainClass();
        if (mainClass != null && !"".equals(mainClass)) {
            Manifest.Attribute mainClassAttr = new Manifest.Attribute("Main-Class", mainClass);
            m.addConfiguredAttribute(mainClassAttr);
        }
        if (config.isAddExtensions()) {
            Artifact artifact;
            StringBuffer extensionsList = new StringBuffer();
            Set artifacts = project.getArtifacts();
            Iterator iter = artifacts.iterator();
            while (iter.hasNext()) {
                artifact = (Artifact)iter.next();
                if (!"jar".equals(artifact.getType())) continue;
                if (extensionsList.length() > 0) {
                    extensionsList.append(" ");
                }
                extensionsList.append(artifact.getArtifactId());
            }
            if (extensionsList.length() > 0) {
                Manifest.Attribute extensionsListAttr = new Manifest.Attribute("Extension-List", extensionsList.toString());
                m.addConfiguredAttribute(extensionsListAttr);
            }
            iter = artifacts.iterator();
            while (iter.hasNext()) {
                artifact = (Artifact)iter.next();
                if (!"jar".equals(artifact.getType())) continue;
                Manifest.Attribute archExtNameAttr = new Manifest.Attribute(artifact.getArtifactId() + "-Extension-Name", artifact.getArtifactId());
                m.addConfiguredAttribute(archExtNameAttr);
                String name = artifact.getArtifactId() + "-Implementation-Version";
                Manifest.Attribute archImplVersionAttr = new Manifest.Attribute(name, artifact.getVersion());
                m.addConfiguredAttribute(archImplVersionAttr);
                if (artifact.getRepository() == null) continue;
                name = artifact.getArtifactId() + "-Implementation-URL";
                String url = artifact.getRepository().getUrl() + "/" + artifact.toString();
                Manifest.Attribute archImplUrlAttr = new Manifest.Attribute(name, url);
                m.addConfiguredAttribute(archImplUrlAttr);
            }
        }
        return m;
    }

    public JarArchiver getArchiver() {
        return this.archiver;
    }

    public void setArchiver(JarArchiver archiver) {
        this.archiver = archiver;
    }

    public void setOutputFile(File outputFile) {
        this.archiveFile = outputFile;
    }

    public void createArchive(MavenProject project, MavenArchiveConfiguration archiveConfiguration) throws ArchiverException, ManifestException, IOException, DependencyResolutionRequiredException {
        this.archiver.addFile(project.getFile(), "META-INF/maven/pom.xml");
        String manifestFile = archiveConfiguration.getManifestFile();
        if (manifestFile != null && !"".equals(manifestFile)) {
            this.archiver.setManifest(new File(manifestFile));
        }
        Manifest manifest = this.getManifest(project, archiveConfiguration.getManifest());
        this.archiver.addConfiguredManifest(manifest);
        this.archiver.setCompress(archiveConfiguration.isCompress());
        this.archiver.setIndex(archiveConfiguration.isIndex());
        this.archiver.setDestFile(this.archiveFile);
        this.archiver.createArchive();
    }
}

