/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mae.depgraph.impl.collect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.maven.mae.depgraph.impl.collect.DepGraphCache;
import org.apache.maven.mae.depgraph.impl.collect.SlimDepGraph;
import org.apache.maven.mae.depgraph.impl.collect.SlimDependencyEdge;
import org.apache.maven.mae.depgraph.impl.collect.SlimDependencyNode;
import org.apache.maven.mae.project.session.ProjectToolsSession;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.aether.RepositoryException;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.RequestTrace;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.artifact.ArtifactType;
import org.sonatype.aether.artifact.ArtifactTypeRegistry;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.CollectResult;
import org.sonatype.aether.collection.DependencyCollectionContext;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.collection.DependencyGraphTransformationContext;
import org.sonatype.aether.collection.DependencyGraphTransformer;
import org.sonatype.aether.collection.DependencyManagement;
import org.sonatype.aether.collection.DependencyManager;
import org.sonatype.aether.collection.DependencySelector;
import org.sonatype.aether.collection.DependencyTraverser;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.impl.ArtifactDescriptorReader;
import org.sonatype.aether.impl.DependencyCollector;
import org.sonatype.aether.impl.RemoteRepositoryManager;
import org.sonatype.aether.impl.VersionRangeResolver;
import org.sonatype.aether.repository.ArtifactRepository;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactDescriptorException;
import org.sonatype.aether.resolution.ArtifactDescriptorRequest;
import org.sonatype.aether.resolution.ArtifactDescriptorResult;
import org.sonatype.aether.resolution.VersionRangeRequest;
import org.sonatype.aether.resolution.VersionRangeResolutionException;
import org.sonatype.aether.resolution.VersionRangeResult;
import org.sonatype.aether.spi.locator.Service;
import org.sonatype.aether.spi.locator.ServiceLocator;
import org.sonatype.aether.util.DefaultRepositorySystemSession;
import org.sonatype.aether.util.DefaultRequestTrace;
import org.sonatype.aether.util.artifact.ArtifacIdUtils;
import org.sonatype.aether.version.Version;

@Component(role=DependencyCollector.class, hint="bare-bones")
public class BareBonesDependencyCollector
implements DependencyCollector,
Service {
    public static final String HINT = "bare-bones";
    private static final Logger logger = Logger.getLogger(BareBonesDependencyCollector.class);
    @Requirement
    private RemoteRepositoryManager remoteRepositoryManager;
    @Requirement
    private ArtifactDescriptorReader descriptorReader;
    @Requirement
    private VersionRangeResolver versionRangeResolver;

    public BareBonesDependencyCollector() {
    }

    public BareBonesDependencyCollector(Logger logger, RemoteRepositoryManager remoteRepositoryManager, ArtifactDescriptorReader artifactDescriptorReader, VersionRangeResolver versionRangeResolver) {
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setArtifactDescriptorReader(artifactDescriptorReader);
        this.setVersionRangeResolver(versionRangeResolver);
    }

    public void initService(ServiceLocator locator) {
        this.setRemoteRepositoryManager((RemoteRepositoryManager)locator.getService(RemoteRepositoryManager.class));
        this.setArtifactDescriptorReader((ArtifactDescriptorReader)locator.getService(ArtifactDescriptorReader.class));
        this.setVersionRangeResolver((VersionRangeResolver)locator.getService(VersionRangeResolver.class));
    }

    public BareBonesDependencyCollector setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        if (remoteRepositoryManager == null) {
            throw new IllegalArgumentException("remote repository manager has not been specified");
        }
        this.remoteRepositoryManager = remoteRepositoryManager;
        return this;
    }

    public BareBonesDependencyCollector setArtifactDescriptorReader(ArtifactDescriptorReader artifactDescriptorReader) {
        if (artifactDescriptorReader == null) {
            throw new IllegalArgumentException("artifact descriptor reader has not been specified");
        }
        this.descriptorReader = artifactDescriptorReader;
        return this;
    }

    public BareBonesDependencyCollector setVersionRangeResolver(VersionRangeResolver versionRangeResolver) {
        if (versionRangeResolver == null) {
            throw new IllegalArgumentException("version range resolver has not been specified");
        }
        this.versionRangeResolver = versionRangeResolver;
        return this;
    }

    public CollectResult collectDependencies(RepositorySystemSession session, CollectRequest request) throws DependencyCollectionException {
        Object context;
        boolean traverse;
        DependencySelector depSelector;
        session = this.optimizeSession(session);
        RequestTrace trace = DefaultRequestTrace.newChild((RequestTrace)request.getTrace(), (Object)request);
        CollectResult result = new CollectResult(request);
        ProjectToolsSession toolsSession = (ProjectToolsSession)session.getData().get((Object)"dependency-resolver-session");
        DependencySelector dependencySelector = depSelector = toolsSession == null ? null : toolsSession.getDependencySelector();
        if (depSelector == null) {
            depSelector = session.getDependencySelector();
        }
        DependencyManager depManager = session.getDependencyManager();
        DependencyTraverser depTraverser = session.getDependencyTraverser();
        Dependency root = request.getRoot();
        List repositories = request.getRepositories();
        List<Dependency> dependencies = request.getDependencies();
        List<Dependency> managedDependencies = request.getManagedDependencies();
        SlimDepGraph graph = new SlimDepGraph(session);
        SlimDependencyEdge edge = null;
        if (root != null) {
            ArtifactDescriptorResult descriptorResult;
            VersionRangeResult rangeResult;
            try {
                VersionRangeRequest rangeRequest = new VersionRangeRequest(root.getArtifact(), request.getRepositories(), request.getRequestContext());
                rangeRequest.setTrace(trace);
                rangeResult = this.versionRangeResolver.resolveVersionRange(session, rangeRequest);
                if (rangeResult.getVersions().isEmpty()) {
                    throw new VersionRangeResolutionException(rangeResult, "No versions available for " + root.getArtifact() + " within specified range");
                }
            }
            catch (VersionRangeResolutionException e) {
                result.addException((Exception)((Object)e));
                throw new DependencyCollectionException(result);
            }
            Version version = (Version)rangeResult.getVersions().get(rangeResult.getVersions().size() - 1);
            root = root.setArtifact(root.getArtifact().setVersion(version.toString()));
            try {
                ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest();
                descriptorRequest.setArtifact(root.getArtifact());
                descriptorRequest.setRepositories(request.getRepositories());
                descriptorRequest.setRequestContext(request.getRequestContext());
                descriptorRequest.setTrace(trace);
                descriptorResult = this.isLackingDescriptor(root.getArtifact()) ? new ArtifactDescriptorResult(descriptorRequest) : this.descriptorReader.readArtifactDescriptor(session, descriptorRequest);
            }
            catch (ArtifactDescriptorException e) {
                result.addException((Exception)((Object)e));
                throw new DependencyCollectionException(result);
            }
            root = root.setArtifact(descriptorResult.getArtifact());
            repositories = this.remoteRepositoryManager.aggregateRepositories(session, repositories, descriptorResult.getRepositories(), true);
            dependencies = this.mergeDeps(dependencies, descriptorResult.getDependencies());
            managedDependencies = this.mergeDeps(managedDependencies, descriptorResult.getManagedDependencies());
            SlimDependencyNode node = new SlimDependencyNode(ArtifacIdUtils.toId((Artifact)descriptorResult.getArtifact()), graph);
            node.setAliases(descriptorResult.getAliases());
            node.setRepositories(request.getRepositories());
            edge = new SlimDependencyEdge(node, graph);
            edge.setDependency(root);
            edge.setRequestContext(request.getRequestContext());
            edge.setRelocations(descriptorResult.getRelocations());
            edge.setVersionConstraint(rangeResult.getVersionConstraint());
            edge.setVersion(version);
        } else {
            edge = new SlimDependencyEdge(new SlimDependencyNode(SlimDependencyNode.UNKNOWN_ROOT_ID, graph), graph);
        }
        result.setRoot((DependencyNode)edge);
        boolean bl = traverse = root == null || depTraverser.traverseDependency(root);
        if (traverse && !dependencies.isEmpty()) {
            LinkedList<SlimDependencyEdge> edges = new LinkedList<SlimDependencyEdge>();
            edges.addFirst(edge);
            context = new CollectionContext(session, root, managedDependencies);
            DepGraphCache pool = new DepGraphCache(session);
            this.process(session, toolsSession, trace, result, edges, dependencies, repositories, depSelector.deriveChildSelector((DependencyCollectionContext)context), depManager.deriveChildManager((DependencyCollectionContext)context), depTraverser.deriveChildTraverser((DependencyCollectionContext)context), pool, graph);
        }
        DependencyGraphTransformer transformer = session.getDependencyGraphTransformer();
        try {
            context = new GraphTransformationContext(session);
            result.setRoot(transformer.transformGraph((DependencyNode)edge, (DependencyGraphTransformationContext)context));
        }
        catch (RepositoryException e) {
            result.addException((Exception)((Object)e));
        }
        if (!result.getExceptions().isEmpty()) {
            throw new DependencyCollectionException(result);
        }
        return result;
    }

    private RepositorySystemSession optimizeSession(RepositorySystemSession session) {
        DefaultRepositorySystemSession optimized = new DefaultRepositorySystemSession(session);
        optimized.setArtifactTypeRegistry((ArtifactTypeRegistry)new TypeRegistry(session));
        return optimized;
    }

    private List<Dependency> mergeDeps(List<Dependency> dominant, List<Dependency> recessive) {
        List<Dependency> result;
        if (dominant == null || dominant.isEmpty()) {
            result = recessive;
        } else if (recessive == null || recessive.isEmpty()) {
            result = dominant;
        } else {
            result = new ArrayList<Dependency>(dominant.size() + recessive.size());
            HashSet<String> ids = new HashSet<String>();
            for (Dependency dependency : dominant) {
                ids.add(this.getId(dependency.getArtifact()));
                result.add(dependency);
            }
            for (Dependency dependency : recessive) {
                if (ids.contains(this.getId(dependency.getArtifact()))) continue;
                result.add(dependency);
            }
        }
        return result;
    }

    private String getId(Artifact a) {
        return a.getGroupId() + ':' + a.getArtifactId() + ':' + a.getClassifier() + ':' + a.getExtension();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean process(RepositorySystemSession session, ProjectToolsSession toolsSession, RequestTrace trace, CollectResult result, LinkedList<SlimDependencyEdge> edges, List<Dependency> dependencies, List<RemoteRepository> repositories, DependencySelector depSelector, DependencyManager depManager, DependencyTraverser depTraverser, DepGraphCache pool, SlimDepGraph graph) throws DependencyCollectionException {
        boolean cycle = false;
        DependencyFilter filter = toolsSession == null ? null : toolsSession.getDependencyFilter();
        Iterator<Dependency> i$ = dependencies.iterator();
        block4: while (i$.hasNext()) {
            Dependency dependency = i$.next();
            boolean disableVersionManagement = false;
            List relocations = Collections.emptyList();
            block5: while (true) {
                VersionRangeResult rangeResult;
                if (!depSelector.selectDependency(dependency)) {
                    logger.warn((Object)("SELECT - Excluding from dependency graph: " + dependency.getArtifact()));
                    continue block4;
                }
                DependencyManagement depMngt = depManager.manageDependency(dependency);
                String premanagedVersion = null;
                String premanagedScope = null;
                if (depMngt != null) {
                    Artifact artifact;
                    if (depMngt.getVersion() != null && !disableVersionManagement) {
                        artifact = dependency.getArtifact();
                        premanagedVersion = artifact.getVersion();
                        dependency = dependency.setArtifact(artifact.setVersion(depMngt.getVersion()));
                    }
                    if (depMngt.getProperties() != null) {
                        artifact = dependency.getArtifact();
                        dependency = dependency.setArtifact(artifact.setProperties(depMngt.getProperties()));
                    }
                    if (depMngt.getScope() != null) {
                        premanagedScope = dependency.getScope();
                        dependency = dependency.setScope(depMngt.getScope());
                    }
                    if (depMngt.getExclusions() != null) {
                        dependency = dependency.setExclusions(depMngt.getExclusions());
                    }
                }
                disableVersionManagement = false;
                boolean noDescriptor = this.isLackingDescriptor(dependency.getArtifact());
                boolean traverse = !noDescriptor && depTraverser.traverseDependency(dependency);
                try {
                    VersionRangeRequest rangeRequest = new VersionRangeRequest();
                    rangeRequest.setArtifact(dependency.getArtifact());
                    rangeRequest.setRepositories(repositories);
                    rangeRequest.setRequestContext(result.getRequest().getRequestContext());
                    rangeRequest.setTrace(trace);
                    Object key = pool.toKey(rangeRequest);
                    rangeResult = pool.getConstraint(key, rangeRequest);
                    if (rangeResult == null) {
                        rangeResult = this.versionRangeResolver.resolveVersionRange(session, rangeRequest);
                        pool.putConstraint(key, rangeResult);
                    }
                    if (rangeResult.getVersions().isEmpty()) {
                        throw new VersionRangeResolutionException(rangeResult, "No versions available for " + dependency.getArtifact() + " within specified range");
                    }
                }
                catch (VersionRangeResolutionException e) {
                    result.addException((Exception)((Object)e));
                    continue block4;
                }
                ArrayList versions = new ArrayList(rangeResult.getVersions());
                Collections.reverse(versions);
                Iterator i$2 = versions.iterator();
                while (true) {
                    ArtifactRepository repo;
                    boolean recurse;
                    ArtifactDescriptorResult descriptorResult;
                    Dependency d;
                    Artifact originalArtifact;
                    Version version;
                    block25: {
                        if (!i$2.hasNext()) continue block4;
                        version = (Version)i$2.next();
                        originalArtifact = dependency.getArtifact().setVersion(version.toString());
                        d = dependency.setArtifact(originalArtifact);
                        try {
                            ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest();
                            descriptorRequest.setArtifact(d.getArtifact());
                            descriptorRequest.setRepositories(repositories);
                            descriptorRequest.setRequestContext(result.getRequest().getRequestContext());
                            descriptorRequest.setTrace(trace);
                            if (noDescriptor) {
                                descriptorResult = new ArtifactDescriptorResult(descriptorRequest);
                                break block25;
                            }
                            Object key = pool.toKey(descriptorRequest);
                            descriptorResult = pool.getDescriptor(key, descriptorRequest);
                            if (descriptorResult != null) break block25;
                            descriptorResult = this.descriptorReader.readArtifactDescriptor(session, descriptorRequest);
                            pool.putDescriptor(key, descriptorResult);
                        }
                        catch (ArtifactDescriptorException e) {
                            result.addException((Exception)((Object)e));
                            continue;
                        }
                    }
                    d = d.setArtifact(descriptorResult.getArtifact());
                    if (this.findDuplicate(edges, d.getArtifact()) != null) {
                        cycle = true;
                        continue block4;
                    }
                    if (!descriptorResult.getRelocations().isEmpty()) {
                        relocations = descriptorResult.getRelocations();
                        disableVersionManagement = originalArtifact.getGroupId().equals(d.getArtifact().getGroupId()) && originalArtifact.getArtifactId().equals(d.getArtifact().getArtifactId());
                        dependency = d;
                        continue block5;
                    }
                    d = pool.intern(d.setArtifact(graph.intern(d.getArtifact())));
                    DependencySelector childSelector = null;
                    DependencyManager childManager = null;
                    DependencyTraverser childTraverser = null;
                    List childRepos = null;
                    String key = ArtifacIdUtils.toId((Artifact)d.getArtifact());
                    boolean bl = recurse = traverse && !descriptorResult.getDependencies().isEmpty();
                    if (recurse) {
                        CollectionContext context = new CollectionContext(session, d, descriptorResult.getManagedDependencies());
                        childSelector = depSelector.deriveChildSelector((DependencyCollectionContext)context);
                        childManager = depManager.deriveChildManager((DependencyCollectionContext)context);
                        childTraverser = depTraverser.deriveChildTraverser((DependencyCollectionContext)context);
                        childRepos = this.remoteRepositoryManager.aggregateRepositories(session, repositories, descriptorResult.getRepositories(), true);
                    }
                    List<Object> repos = (repo = rangeResult.getRepository(version)) instanceof RemoteRepository ? Collections.singletonList((RemoteRepository)repo) : (repo == null ? repositories : Collections.emptyList());
                    SlimDependencyNode child = graph.getNode(key);
                    if (child == null) {
                        child = new SlimDependencyNode(key, graph);
                        child.setAliases(descriptorResult.getAliases());
                        child.setRepositories(repos);
                    } else {
                        recurse = false;
                        if (repos.size() < child.getRepositories().size()) {
                            child.setRepositories(repos);
                        }
                    }
                    SlimDependencyNode node = (SlimDependencyNode)edges.getFirst().getTo();
                    SlimDependencyEdge edge = new SlimDependencyEdge(node, child, graph);
                    edge.setDependency(d);
                    edge.setScope(d.getScope());
                    edge.setPremanagedScope(premanagedScope);
                    edge.setPremanagedVersion(premanagedVersion);
                    edge.setRelocations(relocations);
                    edge.setVersionConstraint(rangeResult.getVersionConstraint());
                    edge.setVersion(version);
                    edge.setRequestContext(result.getRequest().getRequestContext());
                    ArrayList<SlimDependencyEdge> parents = new ArrayList<SlimDependencyEdge>();
                    parents.add(edges.getFirst());
                    if (filter != null && !filter.accept((DependencyNode)edge, parents)) {
                        logger.warn((Object)("FILTER - Excluding from dependency graph: " + edge.getDependency().getArtifact()));
                        graph.removeEdge(edge);
                        continue block4;
                    }
                    if (!recurse) continue;
                    edges.addFirst(edge);
                    if (this.process(session, toolsSession, trace, result, edges, descriptorResult.getDependencies(), childRepos, childSelector, childManager, childTraverser, pool, graph)) {
                        cycle = true;
                        continue block4;
                    }
                    edges.removeFirst();
                }
                break;
            }
            break;
        }
        return cycle;
    }

    private SlimDependencyEdge findDuplicate(List<SlimDependencyEdge> edges, Artifact artifact) {
        SlimDependencyEdge edge;
        Dependency dependency;
        Iterator<SlimDependencyEdge> i$ = edges.iterator();
        while (i$.hasNext() && (dependency = (edge = i$.next()).getDependency()) != null) {
            Artifact a = dependency.getArtifact();
            if (!a.getArtifactId().equals(artifact.getArtifactId()) || !a.getGroupId().equals(artifact.getGroupId()) || !a.getBaseVersion().equals(artifact.getBaseVersion()) || !a.getExtension().equals(artifact.getExtension()) || !a.getClassifier().equals(artifact.getClassifier())) continue;
            return edge;
        }
        return null;
    }

    private boolean isLackingDescriptor(Artifact artifact) {
        return artifact.getProperty("localPath", null) != null;
    }

    private static final class TypeRegistry
    implements ArtifactTypeRegistry {
        private final ArtifactTypeRegistry delegate;
        private final Map<String, ArtifactType> types = new HashMap<String, ArtifactType>();

        TypeRegistry(RepositorySystemSession session) {
            this.delegate = session.getArtifactTypeRegistry();
        }

        public ArtifactType get(String typeId) {
            ArtifactType type = this.types.get(typeId);
            if (type == null) {
                type = this.delegate.get(typeId);
                this.types.put(typeId, type);
            }
            return type;
        }
    }

    private static final class GraphTransformationContext
    implements DependencyGraphTransformationContext {
        private final RepositorySystemSession session;
        private final Map<Object, Object> ctx = new HashMap<Object, Object>();

        GraphTransformationContext(RepositorySystemSession session) {
            this.session = session;
        }

        public RepositorySystemSession getSession() {
            return this.session;
        }

        public Object get(Object key) {
            return this.ctx.get(key);
        }

        public Object put(Object key, Object value) {
            return this.ctx.put(key, value);
        }
    }

    private static final class CollectionContext
    implements DependencyCollectionContext {
        private final RepositorySystemSession session;
        private final Dependency dependency;
        private final List<Dependency> managedDependencies;

        CollectionContext(RepositorySystemSession session, Dependency dependency, List<Dependency> managedDependencies) {
            this.session = session;
            this.dependency = dependency;
            this.managedDependencies = managedDependencies;
        }

        public RepositorySystemSession getSession() {
            return this.session;
        }

        public Dependency getDependency() {
            return this.dependency;
        }

        public List<Dependency> getManagedDependencies() {
            return this.managedDependencies;
        }
    }
}

