/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mae.depgraph.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.mae.depgraph.DepGraphNode;
import org.apache.maven.mae.depgraph.DepGraphRootNode;
import org.apache.maven.mae.depgraph.DependencyGraph;
import org.apache.maven.mae.project.session.ProjectToolsSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.artifact.ArtifactTypeRegistry;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.CollectResult;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.graph.DependencyVisitor;
import org.sonatype.aether.graph.Exclusion;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.util.DefaultRepositorySystemSession;

@Component(role=DependencyGraphResolver.class)
public class DependencyGraphResolver {
    private static final Logger LOGGER = Logger.getLogger(DependencyGraphResolver.class);
    @Requirement
    private RepositorySystem repositorySystem;

    public DependencyGraph accumulateGraph(Collection<MavenProject> rootProjects, RepositorySystemSession rss, ProjectToolsSession session) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Preparing for dependency-graph accumulation...");
        }
        rss = this.prepareForGraphResolution(rss, session);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Accumulating dependency graph...");
        }
        return this.accumulate(session, rss, rootProjects, session.getRemoteRepositoriesArray());
    }

    public DependencyGraph resolveGraph(DependencyGraph depGraph, Collection<MavenProject> rootProjects, RepositorySystemSession rss, ProjectToolsSession session) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Resolving dependencies in graph...");
        }
        this.resolve(rss, rootProjects, depGraph, session);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Graph state contains: " + depGraph.size() + " nodes."));
        }
        return depGraph;
    }

    private RepositorySystemSession prepareForGraphResolution(RepositorySystemSession s, ProjectToolsSession session) {
        DefaultRepositorySystemSession result = new DefaultRepositorySystemSession(s);
        result.setDependencySelector(session.getDependencySelector());
        return result;
    }

    private void resolve(RepositorySystemSession session, Collection<MavenProject> rootProjects, DependencyGraph depGraph, ProjectToolsSession toolsSession) {
        HashSet<DependencyResolveWorker> workers = new HashSet<DependencyResolveWorker>();
        for (DepGraphNode node : depGraph) {
            if (node == null || node.hasErrors() || node.isPreResolved()) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Resolving: " + node.getLatestArtifact()));
            }
            workers.add(new DependencyResolveWorker(node, session, this.repositorySystem));
        }
        this.runResolve(workers, toolsSession);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Dependency-graph resolution complete.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runResolve(Set<DependencyResolveWorker> workers, ProjectToolsSession session) {
        ExecutorService executorService = Executors.newFixedThreadPool(session.getResolveThreads());
        CountDownLatch latch = new CountDownLatch(workers.size());
        for (DependencyResolveWorker worker : workers) {
            worker.setLatch(latch);
            executorService.execute(worker);
        }
        CountDownLatch i$ = latch;
        synchronized (i$) {
            long count = 0L;
            while ((count = latch.getCount()) > 0L) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(count + " resolution workers remaining. Waiting 3s..."));
                }
                try {
                    latch.await(3L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
        }
        boolean terminated = false;
        int count = 1;
        while (!terminated) {
            try {
                executorService.shutdown();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Attempt " + count + " to shutdown graph-resolver. Waiting 3s..."));
                }
                ++count;
                terminated = executorService.awaitTermination(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DependencyGraph accumulate(ProjectToolsSession session, RepositorySystemSession rss, Collection<MavenProject> projects, RemoteRepository ... remoteRepositories) {
        DependencyGraph depGraph;
        ArtifactTypeRegistry stereotypes = rss.getArtifactTypeRegistry();
        ProjectToolsSession projectToolsSession = session;
        synchronized (projectToolsSession) {
            depGraph = (DependencyGraph)session.getState(DependencyGraph.class);
            if (depGraph == null) {
                depGraph = new DependencyGraph();
            }
        }
        GraphAccumulator accumulator = new GraphAccumulator(depGraph, session.getDependencyFilter());
        for (MavenProject project : projects) {
            CollectResult result;
            DependencyManagement depMngt;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Collecting dependencies for: " + project));
            }
            CollectRequest request = new CollectRequest();
            request.setRequestContext("project");
            request.setRepositories(Arrays.asList(remoteRepositories));
            if (project.getDependencyArtifacts() == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Adding dependencies to collection request...");
                }
                for (Dependency dependency : project.getDependencies()) {
                    request.addDependency(RepositoryUtils.toDependency((Dependency)dependency, (ArtifactTypeRegistry)stereotypes));
                }
            } else {
                String key;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Mapping project dependencies by management key...");
                }
                HashMap<String, Dependency> dependencies = new HashMap<String, Dependency>();
                for (Dependency dependency : project.getDependencies()) {
                    key = dependency.getManagementKey();
                    dependencies.put(key, dependency);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Adding dependencies to collection request...");
                }
                Iterator i$ = project.getDependencyArtifacts().iterator();
                while (i$.hasNext()) {
                    org.apache.maven.artifact.Artifact artifact;
                    key = (artifact = (org.apache.maven.artifact.Artifact)i$.next()).getDependencyConflictId();
                    Dependency dependency = (Dependency)dependencies.get(key);
                    List exclusions = dependency != null ? dependency.getExclusions() : null;
                    org.sonatype.aether.graph.Dependency dep = RepositoryUtils.toDependency((org.apache.maven.artifact.Artifact)artifact, (Collection)exclusions);
                    if (!"system".equals(dep.getScope()) && dep.getArtifact().getFile() != null) {
                        Artifact art = dep.getArtifact();
                        art = art.setFile(null).setVersion(art.getBaseVersion());
                        dep = dep.setArtifact(art);
                    }
                    request.addDependency(dep);
                }
            }
            if ((depMngt = project.getDependencyManagement()) != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Adding managed dependencies to collection request...");
                }
                for (Dependency dependency : depMngt.getDependencies()) {
                    request.addManagedDependency(RepositoryUtils.toDependency((Dependency)dependency, (ArtifactTypeRegistry)stereotypes));
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Collecting dependencies...");
            }
            Object old = rss.getData().get((Object)"dependency-resolver-session");
            try {
                rss.getData().set((Object)"dependency-resolver-session", (Object)session);
                result = this.repositorySystem.collectDependencies(rss, request);
            }
            catch (DependencyCollectionException e) {
                result = e.getResult();
            }
            finally {
                rss.getData().set((Object)"dependency-resolver-session", old);
            }
            DependencyNode root = result.getRoot();
            DepGraphRootNode rootNode = depGraph.addRoot(root, project);
            accumulator.resetForNextRun(root, rootNode);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Adding collected dependencies to consolidated dependency graph...");
            }
            result.getRoot().accept((DependencyVisitor)accumulator);
        }
        return depGraph;
    }

    private static final class DependencyResolveWorker
    implements Runnable {
        private final DepGraphNode depState;
        private final RepositorySystemSession session;
        private final RepositorySystem repositorySystem;
        private ArtifactResult result;
        private CountDownLatch latch;

        DependencyResolveWorker(DepGraphNode depState, RepositorySystemSession session, RepositorySystem repositorySystem) {
            this.depState = depState;
            this.session = session;
            this.repositorySystem = repositorySystem;
        }

        void setLatch(CountDownLatch latch) {
            this.latch = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Artifact artifact = this.depState.getLatestArtifact();
            try {
                ArtifactRequest request = new ArtifactRequest(artifact, new ArrayList<RemoteRepository>(this.depState.getRemoteRepositories()), "project");
                this.result = new ArtifactResult(request);
                if (this.validateForResolution()) {
                    try {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Object)("RESOLVE: " + artifact));
                        }
                        this.result = this.repositorySystem.resolveArtifact(this.session, request);
                    }
                    catch (ArtifactResolutionException e) {
                        this.result.addException((Exception)((Object)e));
                    }
                }
            }
            finally {
                this.depState.merge(this.result);
                if (this.latch != null) {
                    this.latch.countDown();
                }
            }
        }

        private boolean validateForResolution() {
            boolean valid = true;
            if (this.session == null) {
                this.result.addException((Exception)new IllegalArgumentException("Cannot resolve dependency: " + this.depState.getLatestArtifact() + ", RepositorySystemSession has not been set!"));
                valid = false;
            }
            if (this.repositorySystem == null) {
                this.result.addException((Exception)new IllegalArgumentException("Cannot resolve dependency: " + this.depState.getLatestArtifact() + ", RepositorySystem has not been set!"));
                valid = false;
            }
            return valid;
        }
    }

    private static final class GraphAccumulator
    implements DependencyVisitor {
        private final LinkedList<DependencyNode> parents = new LinkedList();
        private final Set<Exclusion> exclusions = new HashSet<Exclusion>();
        private final Set<Exclusion> lastExclusions = new HashSet<Exclusion>();
        private final DependencyGraph depGraph;
        private DependencyNode root;
        private DepGraphRootNode rootNode;
        private final DependencyFilter filter;

        GraphAccumulator(DependencyGraph depGraph, DependencyFilter filter) {
            this.depGraph = depGraph;
            this.filter = filter;
        }

        void resetForNextRun(DependencyNode root, DepGraphRootNode rootNode) {
            this.parents.clear();
            this.root = root;
            this.rootNode = rootNode;
            this.exclusions.clear();
            this.lastExclusions.clear();
        }

        public boolean visitEnter(DependencyNode node) {
            if (this.filter != null && !this.filter.accept(node, this.parents)) {
                return false;
            }
            if (node == this.root) {
                this.parents.addFirst(this.root);
                return true;
            }
            if (node == null || node.getDependency() == null || node.getDependency().getArtifact() == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Invalid node: " + node));
                }
                return true;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("START: dependency-processing for: " + node));
            }
            boolean result = false;
            Artifact artifact = node.getDependency().getArtifact();
            if (!this.excluded(artifact)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Enabling resolution for: " + node));
                }
                DependencyNode parent = this.parents.getFirst();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Adding dependency from: " + parent + " to: " + node));
                }
                boolean bl = result = !this.depGraph.contains(node);
                if (parent == this.root) {
                    this.depGraph.addDependency(this.rootNode, node);
                } else {
                    this.depGraph.addDependency(parent, node);
                }
                if (node.getDependency().getExclusions() != null) {
                    for (Exclusion exclusion : node.getDependency().getExclusions()) {
                        if (!this.exclusions.add(exclusion)) continue;
                        this.lastExclusions.add(exclusion);
                    }
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Pushing node: " + node + " onto parents stack."));
                }
                this.parents.addFirst(node);
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < this.parents.size(); ++i) {
                    builder.append("  ");
                }
                builder.append(">>>");
                builder.append(node);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)builder.toString());
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("DISABLING resolution for: " + node));
            }
            if (node != null && !node.getRelocations().isEmpty() && LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("The artifact " + node.getRelocations().get(0) + " has been relocated to " + node.getDependency().getArtifact()));
            }
            return result;
        }

        private boolean excluded(Artifact artifact) {
            for (Exclusion exclusion : this.exclusions) {
                if (!this.match(exclusion.getGroupId(), artifact.getGroupId()) || !this.match(exclusion.getArtifactId(), artifact.getArtifactId()) || !this.match(exclusion.getExtension(), artifact.getExtension()) || !this.match(exclusion.getClassifier(), artifact.getClassifier())) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("EXCLUDED: " + artifact));
                }
                return true;
            }
            return false;
        }

        private boolean match(String excluded, String check) {
            return "*".equals(excluded) || excluded.equals(check);
        }

        public boolean visitLeave(DependencyNode node) {
            if (node == null || this.parents.isEmpty()) {
                return true;
            }
            if (node == this.parents.getFirst()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Removing exclusions from last node: " + node));
                }
                for (Exclusion exclusion : this.lastExclusions) {
                    this.exclusions.remove(exclusion);
                }
                this.lastExclusions.clear();
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < this.parents.size(); ++i) {
                    builder.append("  ");
                }
                builder.append("<<<");
                builder.append(node);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)builder.toString());
                }
                this.parents.removeFirst();
            } else {
                int idx = this.parents.indexOf(node);
                if (idx > -1) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("TRAVERSAL LEAK. Removing " + (idx + 1) + " unaccounted-for parents that have finished traversal."));
                    }
                    for (int i = 0; i <= idx; ++i) {
                        this.parents.removeFirst();
                    }
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("END: dependency-processing for: " + node));
            }
            return true;
        }
    }
}

