/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mae.depgraph.impl;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.maven.mae.MAEException;
import org.apache.maven.mae.depgraph.DepGraphLoader;
import org.apache.maven.mae.depgraph.DependencyGraph;
import org.apache.maven.mae.depgraph.impl.DependencyGraphResolver;
import org.apache.maven.mae.project.ProjectLoader;
import org.apache.maven.mae.project.session.ProjectToolsSession;
import org.apache.maven.mae.project.session.SessionInitializer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.aether.RepositorySystemSession;

@Component(role=DepGraphLoader.class)
public class DefaultDepGraphLoader
implements DepGraphLoader {
    private static final Logger LOGGER = Logger.getLogger(DefaultDepGraphLoader.class);
    @Requirement
    private DependencyGraphResolver dependencyGraphResolver;
    @Requirement
    private SessionInitializer sessionInitializer;
    @Requirement
    private ProjectLoader projectLoader;

    @Override
    public DependencyGraph loadProjectDependencyGraph(File rootPom, ProjectToolsSession session, boolean includeModuleProjects) throws MAEException {
        this.sessionInitializer.initializeSessionComponents(session);
        List projects = includeModuleProjects ? this.projectLoader.buildReactorProjectInstances(session, includeModuleProjects, new File[]{rootPom}) : Collections.singletonList(this.projectLoader.buildProjectInstance(rootPom, session));
        DependencyGraph depGraph = this.dependencyGraphResolver.accumulateGraph(projects, session.getRepositorySystemSession(), session);
        session.setState((Object)depGraph);
        return depGraph;
    }

    @Override
    public DependencyGraph resolveProjectDependencies(File rootPom, ProjectToolsSession session, boolean includeModuleProjects) throws MAEException {
        this.sessionInitializer.initializeSessionComponents(session);
        List projects = includeModuleProjects ? this.projectLoader.buildReactorProjectInstances(session, includeModuleProjects, new File[]{rootPom}) : Collections.singletonList(this.projectLoader.buildProjectInstance(rootPom, session));
        RepositorySystemSession rss = session.getRepositorySystemSession();
        DependencyGraph depGraph = this.dependencyGraphResolver.accumulateGraph(projects, rss, session);
        this.dependencyGraphResolver.resolveGraph(depGraph, projects, rss, session);
        session.setState((Object)depGraph);
        return depGraph;
    }
}

