/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mae.depgraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.mae.depgraph.DepGraphNode;
import org.apache.maven.mae.depgraph.DepGraphRootNode;
import org.apache.maven.mae.graph.DirectedGraph;
import org.apache.maven.mae.graph.DirectionalEdge;
import org.apache.maven.mae.graph.SimpleDirectedGraph;
import org.apache.maven.project.MavenProject;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.resolution.ArtifactResult;

public class DependencyGraph
implements Iterable<DepGraphNode> {
    private final Set<DepGraphRootNode> roots = new LinkedHashSet<DepGraphRootNode>();
    private final DepGraph graph = new DepGraph();

    public DepGraphRootNode addRoot(DependencyNode root) {
        return this.addRoot(root, null);
    }

    public DepGraphRootNode addRoot(DependencyNode root, MavenProject project) {
        DepGraphRootNode newRoot = new DepGraphRootNode(root, project);
        DepGraphRootNode rootNode = (DepGraphRootNode)this.findOrAdd(newRoot);
        if (rootNode != newRoot) {
            rootNode.merge(root);
        }
        this.roots.add(rootNode);
        return rootNode;
    }

    public DepGraphNode addNodeResult(Artifact artifact, ArtifactResult result) {
        DepGraphNode node = this.findOrAdd(new DepGraphNode(artifact, false));
        node.merge(result);
        return node;
    }

    private DepGraphNode findOrAdd(DepGraphNode node) {
        DepGraphNode result = this.find(node);
        if (result == null) {
            this.graph.addVertex(node);
            result = node;
        }
        return result;
    }

    private DepGraphNode find(DepGraphNode node) {
        ArrayList<? extends DepGraphNode> nodes = new ArrayList<DepGraphNode>(this.graph.vertices());
        int idx = nodes.indexOf(node);
        if (idx > -1) {
            return (DepGraphNode)nodes.get(idx);
        }
        return null;
    }

    public DepGraphNode[] addDependency(DepGraphNode parentNode, DependencyNode child) {
        DepGraphNode newChildNode = new DepGraphNode(child);
        DepGraphNode childNode = this.findOrAdd(newChildNode);
        if (childNode != newChildNode) {
            childNode.merge(child);
        }
        if (parentNode != null) {
            this.graph.connect(parentNode, childNode);
        }
        return new DepGraphNode[]{parentNode, childNode};
    }

    public DepGraphNode[] addDependency(DependencyNode parent, DependencyNode child) {
        DepGraphNode parentNode = null;
        if (parent != null) {
            parentNode = this.findOrAdd(new DepGraphNode(parent));
        }
        return this.addDependency(parentNode, child);
    }

    public DepGraphNode[] addDependency(Artifact parent, Artifact child, boolean parentPreResolved, boolean childPreResolved) {
        DepGraphNode from = this.findOrAdd(new DepGraphNode(parent, parentPreResolved));
        DepGraphNode newTo = new DepGraphNode(child, childPreResolved);
        DepGraphNode to = this.findOrAdd(newTo);
        if (to != newTo) {
            to.merge(child);
        }
        this.graph.connect(from, to);
        return new DepGraphNode[]{from, to};
    }

    public Set<DepGraphRootNode> getRoots() {
        return new LinkedHashSet<DepGraphRootNode>(this.roots);
    }

    @Override
    public Iterator<DepGraphNode> iterator() {
        return new LinkedHashSet<DepGraphNode>(this.graph.vertices()).iterator();
    }

    public int size() {
        return this.graph.vertices().size();
    }

    public DirectedGraph<DepGraphNode, DirectionalEdge<DepGraphNode>> getGraph() {
        return this.graph;
    }

    public boolean contains(DependencyNode dep) {
        return this.find(new DepGraphNode(dep)) != null;
    }

    public static DependencyGraph constructFromRoot(DependencyNode rootNode, MavenProject rootProject) {
        DependencyGraph graph = new DependencyGraph();
        graph.addRoot(rootNode, rootProject);
        DependencyGraph.constructChildren(graph, rootNode);
        return graph;
    }

    private static void constructChildren(DependencyGraph graph, DependencyNode node) {
        for (DependencyNode child : node.getChildren()) {
            graph.addDependency(node, child);
            DependencyGraph.constructChildren(graph, child);
        }
    }

    private static final class DepGraph
    extends SimpleDirectedGraph<DepGraphNode> {
        private DepGraph() {
        }

        public void addVertex(DepGraphNode node) {
            this.getNakedGraph().addVertex((Object)node);
        }

        public Collection<? extends DepGraphNode> vertices() {
            return this.getNakedGraph().getVertices();
        }
    }
}

