/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.doxia.book.BookDoxia;
import org.apache.maven.doxia.book.BookDoxiaException;
import org.apache.maven.doxia.book.InvalidBookDescriptorException;
import org.apache.maven.doxia.book.model.BookModel;
import org.apache.maven.doxia.book.services.validation.ValidationResult;
import org.apache.maven.doxia.plugin.Book;
import org.apache.maven.doxia.plugin.Format;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class DoxiaRenderBooksMojo
extends AbstractMojo {
    private List books;
    private File basedir;
    private File generatedDocs;
    private BookDoxia bookDoxia;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public void execute() throws MojoExecutionException, MojoFailureException {
        Iterator it = this.books.iterator();
        while (it.hasNext()) {
            BookModel bookModel;
            List files;
            Book book = (Book)it.next();
            if (StringUtils.isEmpty((String)book.getDescriptor())) {
                throw new MojoFailureException("Invalid configuration: The book is required to have a descriptor set.");
            }
            if (StringUtils.isEmpty((String)book.getDirectory())) {
                throw new MojoFailureException("Invalid configuration: The book is required to have a directory set.");
            }
            if (book.getFormats() == null || book.getFormats().size() == 0) {
                throw new MojoFailureException("Invalid configuration: The book is required to have at least one format set.");
            }
            File descriptor = new File(this.basedir, book.getDescriptor());
            String includes = "";
            if (book.getIncludes() != null) {
                Iterator j = book.getIncludes().iterator();
                while (j.hasNext()) {
                    String include = (String)j.next();
                    includes = includes + include + ",";
                }
            } else {
                includes = "**/*";
            }
            String excludes = "";
            if (book.getExcludes() != null) {
                Iterator j = book.getExcludes().iterator();
                while (j.hasNext()) {
                    String exclude = (String)j.next();
                    excludes = excludes + exclude + ",";
                }
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Locating files to include in the book:");
                this.getLog().debug((CharSequence)("Basedir: " + this.basedir));
                this.getLog().debug((CharSequence)("Includes: " + includes));
                this.getLog().debug((CharSequence)("Excludes: " + excludes));
            }
            try {
                files = FileUtils.getFiles((File)new File(this.basedir, book.getDirectory()), (String)includes, (String)excludes);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error while looking for input files. Basedir=" + this.basedir.getAbsolutePath() + ", " + "includes=" + includes + ", " + "excludes=" + excludes, (Exception)e);
            }
            try {
                bookModel = this.bookDoxia.loadBook(descriptor);
            }
            catch (InvalidBookDescriptorException e) {
                throw new MojoFailureException("Invalid book descriptor: " + LINE_SEPARATOR + this.formatResult(e.getValidationResult()));
            }
            catch (BookDoxiaException e) {
                throw new MojoExecutionException("Error while loading the book descriptor", (Exception)((Object)e));
            }
            Iterator j = book.getFormats().iterator();
            while (j.hasNext()) {
                Format format = (Format)j.next();
                File outputDirectory = new File(this.generatedDocs, format.getId());
                File directory = new File(outputDirectory, bookModel.getId());
                try {
                    this.bookDoxia.renderBook(bookModel, format.getId(), files, directory);
                }
                catch (BookDoxiaException e) {
                    throw new MojoExecutionException("Error while generating book in format '" + format.getId() + "'.", (Exception)((Object)e));
                }
            }
        }
    }

    private String formatResult(ValidationResult result) {
        String error;
        Iterator it;
        StringBuffer buffer = new StringBuffer();
        if (result.getErrors().size() > 0) {
            buffer.append("Validation errors:");
            it = result.getErrors().iterator();
            while (it.hasNext()) {
                error = (String)it.next();
                buffer.append(LINE_SEPARATOR).append(" ").append(error);
            }
        }
        if (result.getWarnings().size() > 0) {
            buffer.append("Validation warnings:");
            it = result.getWarnings().iterator();
            while (it.hasNext()) {
                error = (String)it.next();
                buffer.append(LINE_SEPARATOR).append(" ").append(error);
            }
        }
        return buffer.toString();
    }
}

