/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.docrenderer.pdf.fo;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.maven.doxia.docrenderer.DocumentRendererException;
import org.apache.maven.doxia.docrenderer.pdf.AbstractPdfRenderer;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.document.DocumentTOC;
import org.apache.maven.doxia.document.DocumentTOCItem;
import org.apache.maven.doxia.module.fo.FoAggregateSink;
import org.apache.maven.doxia.module.fo.FoSink;
import org.apache.maven.doxia.module.fo.FoSinkFactory;
import org.apache.maven.doxia.module.fo.FoUtils;
import org.apache.maven.doxia.module.site.SiteModule;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.xml.sax.SAXParseException;

public class FoPdfRenderer
extends AbstractPdfRenderer {
    public void generatePdf(File inputFile, File pdfFile) throws DocumentRendererException {
        this.generatePdf(inputFile, pdfFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Map filesToProcess, File outputDirectory, DocumentModel documentModel) throws DocumentRendererException, IOException {
        File pdfOutputFile;
        this.copyResources(outputDirectory);
        if (documentModel == null) {
            this.getLogger().debug("No document model, generating all documents individually.");
            this.renderIndividual(filesToProcess, outputDirectory);
            return;
        }
        String outputName = this.getOutputName(documentModel);
        File outputFOFile = new File(outputDirectory, outputName + ".fo");
        if (!outputFOFile.getParentFile().exists()) {
            outputFOFile.getParentFile().mkdirs();
        }
        if (!(pdfOutputFile = new File(outputDirectory, outputName + ".pdf")).getParentFile().exists()) {
            pdfOutputFile.getParentFile().mkdirs();
        }
        XmlStreamWriter writer = null;
        try {
            writer = WriterFactory.newXmlWriter((File)outputFOFile);
            FoAggregateSink sink = new FoAggregateSink((Writer)writer);
            File fOConfigFile = new File(outputDirectory, "pdf-config.xml");
            if (fOConfigFile.exists()) {
                sink.load(fOConfigFile);
                this.getLogger().debug("Loaded pdf config file: " + fOConfigFile.getAbsolutePath());
            }
            sink.setDocumentModel(documentModel);
            sink.beginDocument();
            sink.coverPage();
            sink.toc();
            if (documentModel.getToc() == null || documentModel.getToc().getItems() == null) {
                this.getLogger().info("No TOC is defined in the document descriptor. Merging all documents.");
                this.mergeAllSources(filesToProcess, sink);
            } else {
                this.getLogger().debug("Using TOC defined in the document descriptor.");
                this.mergeSourcesFromTOC(documentModel.getToc(), sink);
            }
            sink.endDocument();
        }
        finally {
            IOUtil.close((Writer)writer);
        }
        this.generatePdf(outputFOFile, pdfOutputFile, documentModel);
    }

    public void renderIndividual(Map filesToProcess, File outputDirectory) throws DocumentRendererException, IOException {
        Iterator j = filesToProcess.keySet().iterator();
        while (j.hasNext()) {
            File pdfOutputFile;
            File outputFOFile;
            String key = (String)j.next();
            SiteModule module = (SiteModule)filesToProcess.get(key);
            File fullDoc = new File(this.getBaseDir(), module.getSourceDirectory() + File.separator + key);
            String output = key;
            String lowerCaseExtension = module.getExtension().toLowerCase(Locale.ENGLISH);
            if (output.toLowerCase(Locale.ENGLISH).indexOf("." + lowerCaseExtension) != -1) {
                output = output.substring(0, output.toLowerCase(Locale.ENGLISH).indexOf("." + lowerCaseExtension));
            }
            if (!(outputFOFile = new File(outputDirectory, output + ".fo")).getParentFile().exists()) {
                outputFOFile.getParentFile().mkdirs();
            }
            if (!(pdfOutputFile = new File(outputDirectory, output + ".pdf")).getParentFile().exists()) {
                pdfOutputFile.getParentFile().mkdirs();
            }
            FoSink sink = (FoSink)new FoSinkFactory().createSink(outputFOFile.getParentFile(), outputFOFile.getName());
            sink.beginDocument();
            this.parse(fullDoc.getAbsolutePath(), module.getParserId(), (Sink)sink);
            sink.endDocument();
            this.generatePdf(outputFOFile, pdfOutputFile, null);
        }
    }

    private void mergeAllSources(Map filesToProcess, FoAggregateSink sink) throws DocumentRendererException, IOException {
        Iterator j = filesToProcess.keySet().iterator();
        while (j.hasNext()) {
            String key = (String)j.next();
            SiteModule module = (SiteModule)filesToProcess.get(key);
            sink.setDocumentName(key);
            File fullDoc = new File(this.getBaseDir(), module.getSourceDirectory() + File.separator + key);
            this.parse(fullDoc.getAbsolutePath(), module.getParserId(), (Sink)sink);
        }
    }

    private void mergeSourcesFromTOC(DocumentTOC toc, FoAggregateSink sink) throws IOException, DocumentRendererException {
        this.parseTocItems(toc.getItems(), sink);
    }

    private void parseTocItems(List items, FoAggregateSink sink) throws IOException, DocumentRendererException {
        Iterator k = items.iterator();
        while (k.hasNext()) {
            DocumentTOCItem tocItem = (DocumentTOCItem)k.next();
            if (tocItem.getRef() == null) {
                if (!this.getLogger().isInfoEnabled()) continue;
                this.getLogger().info("No ref defined for tocItem " + tocItem.getName());
                continue;
            }
            String href = StringUtils.replace((String)tocItem.getRef(), (String)"\\", (String)"/");
            if (href.lastIndexOf(".") != -1) {
                href = href.substring(0, href.lastIndexOf("."));
            }
            this.renderModules(href, sink, tocItem);
            if (tocItem.getItems() == null) continue;
            this.parseTocItems(tocItem.getItems(), sink);
        }
    }

    private void renderModules(String href, FoAggregateSink sink, DocumentTOCItem tocItem) throws DocumentRendererException, IOException {
        Iterator i = this.siteModuleManager.getSiteModules().iterator();
        while (i.hasNext()) {
            String doc;
            File source;
            SiteModule module = (SiteModule)i.next();
            File moduleBasedir = new File(this.getBaseDir(), module.getSourceDirectory());
            if (!moduleBasedir.exists() || !(source = new File(moduleBasedir, doc = href + "." + module.getExtension())).exists()) continue;
            sink.setDocumentName(doc);
            sink.setDocumentTitle(tocItem.getName());
            this.parse(source.getPath(), module.getParserId(), (Sink)sink);
        }
    }

    private void generatePdf(File inputFile, File pdfFile, DocumentModel documentModel) throws DocumentRendererException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Generating: " + pdfFile);
        }
        try {
            FoUtils.convertFO2PDF((File)inputFile, (File)pdfFile, null, (DocumentModel)documentModel);
        }
        catch (TransformerException e) {
            if (e.getCause() != null && e.getCause() instanceof SAXParseException) {
                SAXParseException sax = (SAXParseException)e.getCause();
                StringBuffer sb = new StringBuffer();
                sb.append("Error creating PDF from ").append(inputFile.getAbsolutePath()).append(":").append(sax.getLineNumber()).append(":").append(sax.getColumnNumber()).append("\n");
                sb.append(e.getMessage());
                throw new DocumentRendererException(sb.toString());
            }
            throw new DocumentRendererException("Error creating PDF from " + inputFile + ": " + e.getMessage());
        }
    }
}

