/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.management;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DatabaseFormat {
    CONTINUUM_103("1.1.1", "legacy-continuum-jdo"){

        public boolean isConvertibleFrom(DatabaseFormat sourceFormat) {
            return false;
        }
    }
    ,
    CONTINUUM_109("1.1.1", "legacy-continuum-jdo", "legacy-redback-jdo"){

        public boolean isConvertibleFrom(DatabaseFormat sourceFormat) {
            return false;
        }
    }
    ,
    CONTINUUM_11("1.1.6", "continuum-jdo", "redback-jdo"){

        public boolean isConvertibleFrom(DatabaseFormat sourceFormat) {
            return sourceFormat == CONTINUUM_103 || sourceFormat == CONTINUUM_109;
        }
    };

    private final String jpoxVersion;
    private final String continuumToolRoleHint;
    private final String redbackToolRoleHint;

    private DatabaseFormat(String jpoxVersion, String continuumToolRoleHint) {
        this.jpoxVersion = jpoxVersion;
        this.continuumToolRoleHint = continuumToolRoleHint;
        this.redbackToolRoleHint = null;
    }

    private DatabaseFormat(String jpoxVersion, String continuumToolRoleHint, String redbackToolRoleHint) {
        this.jpoxVersion = jpoxVersion;
        this.continuumToolRoleHint = continuumToolRoleHint;
        this.redbackToolRoleHint = redbackToolRoleHint;
    }

    public abstract boolean isConvertibleFrom(DatabaseFormat var1);

    public String getJpoxVersion() {
        return this.jpoxVersion;
    }

    public String getContinuumToolRoleHint() {
        return this.continuumToolRoleHint;
    }

    public String getRedbackToolRoleHint() {
        return this.redbackToolRoleHint;
    }
}

