/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.management;

import com.sampullara.cli.Args;
import com.sampullara.cli.Argument;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.continuum.management.DataManagementTool;
import org.apache.maven.continuum.management.DatabaseFactoryConfigurator;
import org.apache.maven.continuum.management.DatabaseFormat;
import org.apache.maven.continuum.management.DatabaseParams;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataManagementCli {
    private static final Logger LOGGER = Logger.getLogger(DataManagementCli.class);

    public static void main(String[] args) throws Exception {
        SupportedDatabase databaseType;
        OperationMode mode;
        DatabaseFormat databaseFormat;
        Commands command = new Commands();
        try {
            Args.parse((Object)command, (String[])args);
            if (command.help) {
                Args.usage((Object)command);
                return;
            }
            if (command.version) {
                System.out.print("continuum-data-management version " + DataManagementCli.getVersion());
                return;
            }
            databaseFormat = DatabaseFormat.valueOf(command.databaseFormat);
            mode = OperationMode.valueOf(command.mode);
            databaseType = SupportedDatabase.valueOf(command.databaseType);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            Args.usage((Object)command);
            return;
        }
        if (command.directory.exists() && !command.directory.isDirectory()) {
            System.err.println(command.directory + " already exists and is not a directory.");
            Args.usage((Object)command);
            return;
        }
        if (!command.overwrite && mode == OperationMode.EXPORT && command.directory.exists()) {
            System.err.println(command.directory + " already exists and will not be overwritten unless the -overwrite flag is used.");
            Args.usage((Object)command);
            return;
        }
        if (command.buildsJdbcUrl == null && command.usersJdbcUrl == null) {
            System.err.println("You must specify one of -buildsJdbcUrl and -usersJdbcUrl");
            Args.usage((Object)command);
            return;
        }
        if (command.usersJdbcUrl != null && databaseFormat == DatabaseFormat.CONTINUUM_103) {
            System.err.println("The -usersJdbcUrl option can not be used with Continuum 1.0.3 databases");
            Args.usage((Object)command);
            return;
        }
        BasicConfigurator.configure();
        if (command.debug) {
            Logger.getRootLogger().setLevel(Level.DEBUG);
            Logger.getLogger((String)"JPOX").setLevel(Level.DEBUG);
        } else {
            Logger.getRootLogger().setLevel(Level.INFO);
        }
        if (command.buildsJdbcUrl != null) {
            LOGGER.info((Object)"Processing Continuum database...");
            DataManagementCli.processDatabase(databaseType, databaseFormat, mode, command.buildsJdbcUrl, command.directory, databaseFormat.getContinuumToolRoleHint(), "data-management-jdo", "continuum");
        }
        if (command.usersJdbcUrl != null) {
            LOGGER.info((Object)"Processing Redback database...");
            DataManagementCli.processDatabase(databaseType, databaseFormat, mode, command.usersJdbcUrl, command.directory, databaseFormat.getRedbackToolRoleHint(), "data-management-redback-jdo", "redback");
        }
    }

    private static void processDatabase(SupportedDatabase databaseType, DatabaseFormat databaseFormat, OperationMode mode, String jdbcUrl, File directory, String toolRoleHint, String managementArtifactId, String configRoleHint) throws PlexusContainerException, ComponentLookupException, ArtifactNotFoundException, ArtifactResolutionException, IOException {
        String applicationVersion = DataManagementCli.getVersion();
        DatabaseParams params = new DatabaseParams(databaseType.defaultParams);
        params.setUrl(jdbcUrl);
        DefaultPlexusContainer container = new DefaultPlexusContainer();
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        artifacts.addAll(DataManagementCli.downloadArtifact((PlexusContainer)container, params.getGroupId(), params.getArtifactId(), params.getVersion()));
        artifacts.addAll(DataManagementCli.downloadArtifact((PlexusContainer)container, "org.apache.maven.continuum", managementArtifactId, applicationVersion));
        artifacts.addAll(DataManagementCli.downloadArtifact((PlexusContainer)container, "jpox", "jpox", databaseFormat.getJpoxVersion()));
        ArrayList<File> jars = new ArrayList<File>();
        ArrayList<String> exclusions = new ArrayList<String>();
        URLClassLoader cp = (URLClassLoader)DataManagementCli.class.getClassLoader();
        for (URL url : cp.getURLs()) {
            int idEndIdx;
            String id;
            String urlEF = url.toExternalForm();
            if (!(!urlEF.endsWith("target/classes/") || "data-management-api".equals(id = urlEF.substring(urlEF.lastIndexOf(47, (idEndIdx = urlEF.length() - 16) - 1) + 1, idEndIdx)) || "data-management-cli".equals(id) || "continuum-legacy".equals(id) || "continuum-model".equals(id) || "redback-legacy".equals(id))) {
                exclusions.add("org.apache.maven.continuum:" + id);
                jars.add(new File(url.getPath()));
            }
            if (!urlEF.contains("jpox-enhancer")) continue;
            jars.add(new File(url.getPath()));
        }
        ExcludesArtifactFilter filter = new ExcludesArtifactFilter(exclusions);
        for (Artifact a : artifacts) {
            if ("jpox".equals(a.getGroupId()) && "jpox".equals(a.getArtifactId())) {
                if (!a.getVersion().equals(databaseFormat.getJpoxVersion())) continue;
                jars.add(a.getFile());
                continue;
            }
            if (!filter.include(a)) continue;
            jars.add(a.getFile());
        }
        ClassRealm realm = container.createComponentRealm("app", jars);
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)realm);
        ClassRealm oldRealm = container.setLookupRealm(realm);
        DatabaseFactoryConfigurator configurator = (DatabaseFactoryConfigurator)container.lookup(DatabaseFactoryConfigurator.class.getName(), configRoleHint, realm);
        configurator.configure(params);
        DataManagementTool manager = (DataManagementTool)container.lookup(DataManagementTool.class.getName(), toolRoleHint, realm);
        if (mode == OperationMode.EXPORT) {
            manager.backupDatabase(directory);
        } else if (mode == OperationMode.IMPORT) {
            manager.eraseDatabase();
            manager.restoreDatabase(directory);
        }
        container.setLookupRealm(oldRealm);
        Thread.currentThread().setContextClassLoader(oldLoader);
    }

    private static Collection<Artifact> downloadArtifact(PlexusContainer container, String groupId, String artifactId, String version) throws ComponentLookupException, ArtifactNotFoundException, ArtifactResolutionException, IOException {
        ArtifactRepositoryFactory factory = (ArtifactRepositoryFactory)container.lookup(ArtifactRepositoryFactory.ROLE);
        DefaultRepositoryLayout layout = (DefaultRepositoryLayout)container.lookup(ArtifactRepositoryLayout.ROLE, "default");
        ArtifactRepository localRepository = factory.createArtifactRepository("local", DataManagementCli.getLocalRepositoryURL(container), (ArtifactRepositoryLayout)layout, null, null);
        ArrayList<ArtifactRepository> remoteRepositories = new ArrayList<ArtifactRepository>();
        remoteRepositories.add(factory.createArtifactRepository("central", "http://repo1.maven.org/maven2", (ArtifactRepositoryLayout)layout, null, null));
        ArtifactFactory artifactFactory = (ArtifactFactory)container.lookup(ArtifactFactory.ROLE);
        Artifact artifact = artifactFactory.createArtifact(groupId, artifactId, version, "runtime", "jar");
        Artifact dummyArtifact = artifactFactory.createProjectArtifact("dummy", "dummy", "1.0");
        if (artifact.isSnapshot()) {
            remoteRepositories.add(factory.createArtifactRepository("apache.snapshots", "http://people.apache.org/repo/m2-snapshot-repository", (ArtifactRepositoryLayout)layout, null, null));
        }
        ArtifactResolver resolver = (ArtifactResolver)container.lookup(ArtifactResolver.ROLE);
        ArrayList<String> exclusions = new ArrayList<String>();
        exclusions.add("org.apache.maven.continuum:data-management-api");
        exclusions.add("org.codehaus.plexus:plexus-component-api");
        exclusions.add("org.codehaus.plexus:plexus-container-default");
        exclusions.add("stax:stax-api");
        exclusions.add("log4j:log4j");
        ExcludesArtifactFilter filter = new ExcludesArtifactFilter(exclusions);
        ArtifactMetadataSource source = (ArtifactMetadataSource)container.lookup(ArtifactMetadataSource.ROLE, "maven");
        ArtifactResolutionResult result = resolver.resolveTransitively(Collections.singleton(artifact), dummyArtifact, localRepository, remoteRepositories, source, (ArtifactFilter)filter);
        return result.getArtifacts();
    }

    private static String getLocalRepositoryURL(PlexusContainer container) throws ComponentLookupException, IOException {
        File settingsFile = new File(System.getProperty("user.home"), "/.m2/settings.xml");
        if (!settingsFile.exists()) {
            return new File(System.getProperty("user.home"), "/.m2/repository").toURL().toString();
        }
        Settings settings = DataManagementCli.getSettings(container);
        return new File(settings.getLocalRepository()).toURL().toString();
    }

    private static Settings getSettings(PlexusContainer container) throws ComponentLookupException, IOException {
        MavenSettingsBuilder mavenSettingsBuilder = (MavenSettingsBuilder)container.lookup(MavenSettingsBuilder.class.getName());
        try {
            return mavenSettingsBuilder.buildSettings(false);
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
            throw new IOException("Can't read settings.xml. " + e.getMessage());
        }
    }

    private static String getVersion() throws IOException {
        Properties properties = new Properties();
        properties.load(DataManagementCli.class.getResourceAsStream("/META-INF/maven/org.apache.maven.continuum/data-management-api/pom.properties"));
        return properties.getProperty("version");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SupportedDatabase {
        DERBY_10_1(new DatabaseParams("org.apache.derby.jdbc.EmbeddedDriver", "org.apache.derby", "derby", "10.1.3.1", "sa", ""));

        private DatabaseParams defaultParams;

        private SupportedDatabase(DatabaseParams defaultParams) {
            this.defaultParams = defaultParams;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OperationMode {
        IMPORT,
        EXPORT;

    }

    private static class Commands {
        @Argument(description="Display help information", value="help", alias="h")
        private boolean help;
        @Argument(description="Display version information", value="version", alias="v")
        private boolean version;
        @Argument(description="The JDBC URL for the Continuum database that contains the data to convert, or to import the data into", value="buildsJdbcUrl")
        private String buildsJdbcUrl;
        @Argument(description="The JDBC URL for the Redback database that contains the data to convert, or to import the data into", value="usersJdbcUrl")
        private String usersJdbcUrl;
        @Argument(description="Format of the database. Valid values are CONTINUUM_103, CONTINUUM_109, CONTINUUM_11. Default is CONTINUUM_11.")
        private String databaseFormat = DatabaseFormat.CONTINUUM_11.toString();
        @Argument(description="The directory to export the data to, or import the data from. Default is 'backups' in the current working directory.", value="directory")
        private File directory = new File("backups");
        @Argument(description="Mode of operation. Valid values are IMPORT and EXPORT. Default is EXPORT.", value="mode")
        private String mode = OperationMode.EXPORT.toString();
        @Argument(description="Whether to overwrite the designated directory if it already exists in export mode. Default is false.", value="overwrite")
        private boolean overwrite;
        @Argument(description="The type of database to use. Currently supported values are DERBY_10_1. The default value is DERBY_10_1.", value="databaseType")
        private String databaseType = SupportedDatabase.DERBY_10_1.toString();
        @Argument(description="Turn on debugging information. Default is off.", value="debug")
        private boolean debug;

        private Commands() {
        }
    }
}

