/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.xmlrpc.server;

import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.xmlrpc.ContinuumService;
import org.apache.maven.continuum.xmlrpc.server.ContinuumXmlRpcComponent;
import org.apache.maven.continuum.xmlrpc.server.ContinuumXmlRpcConfig;
import org.codehaus.plexus.redback.authorization.AuthorizationException;
import org.codehaus.plexus.redback.system.SecuritySession;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractContinuumSecureService
implements ContinuumService,
ContinuumXmlRpcComponent {
    private SecuritySystem securitySystem;
    private ContinuumXmlRpcConfig config;

    public void setConfig(ContinuumXmlRpcConfig config) {
        this.config = config;
    }

    public SecuritySystem getSecuritySystem() {
        return this.securitySystem;
    }

    public SecuritySession getSecuritySession() {
        return this.config.getSecuritySession();
    }

    public boolean isAuthenticated() {
        return this.getSecuritySession() != null && this.getSecuritySession().isAuthenticated();
    }

    protected void checkAuthorization(String role) throws ContinuumException {
        this.checkAuthorization(role, null, false);
    }

    protected void checkAuthorization(String role, String resource) throws ContinuumException {
        this.checkAuthorization(role, resource, true);
    }

    protected boolean isAuthorized(String role, String resource) throws AuthorizationException {
        return this.isAuthorized(role, resource, true);
    }

    protected boolean isAuthorized(String role, String resource, boolean requiredResource) throws AuthorizationException {
        return !(resource != null && StringUtils.isNotEmpty((String)resource.trim()) ? !this.getSecuritySystem().isAuthorized(this.config.getSecuritySession(), (Object)role, (Object)resource) : requiredResource || !this.getSecuritySystem().isAuthorized(this.config.getSecuritySession(), (Object)role));
    }

    protected void checkAuthorization(String role, String resource, boolean requiredResource) throws ContinuumException {
        try {
            if (!this.isAuthorized(role, resource, requiredResource)) {
                throw new ContinuumException("You're not authorized to execute this action.");
            }
        }
        catch (AuthorizationException ae) {
            throw new ContinuumException("error authorizing request.");
        }
    }

    protected void checkViewProjectGroupAuthorization(String resource) throws ContinuumException {
        this.checkAuthorization("continuum-view-group", resource);
    }

    protected void checkAddProjectGroupAuthorization() throws ContinuumException {
        this.checkAuthorization("continuum-add-group");
    }

    protected void checkRemoveProjectGroupAuthorization(String resource) throws ContinuumException {
        this.checkAuthorization("continuum-remove-group", resource);
    }

    protected void checkBuildProjectGroupAuthorization(String resource) throws ContinuumException {
        this.checkAuthorization("continuum-build-group", resource);
    }

    protected void checkModifyProjectGroupAuthorization(String resource) throws ContinuumException {
        this.checkAuthorization("continuum-modify-group", resource);
    }

    protected void checkAddProjectToGroupAuthorization(String resource) throws ContinuumException {
        this.checkAuthorization("continuum-add-project-to-group", resource);
    }

    protected void checkRemoveProjectFromGroupAuthorization(String resource) throws ContinuumException {
        this.checkAuthorization("continuum-remove-project-from-group", resource);
    }

    protected void checkModifyProjectInGroupAuthorization(String resource) throws ContinuumException {
        this.checkAuthorization("continuum-modify-project-in-group", resource);
    }

    protected void checkBuildProjectInGroupAuthorization(String resource) throws ContinuumException {
        this.checkAuthorization("continuum-build-project-in-group", resource);
    }

    protected void checkAddGroupBuildDefinitionAuthorization(String resource) throws ContinuumException {
        this.checkAuthorization("continuum-add-group-build-definition", resource);
    }

    protected void checkRemoveGroupBuildDefinitionAuthorization(String resource) throws ContinuumException {
        this.checkAuthorization("continuum-remove-group-build-definition", resource);
    }

    protected void checkModifyGroupBuildDefinitionAuthorization(String resource) throws ContinuumException {
        this.checkAuthorization("continuum-modify-group-build-definition", resource);
    }

    protected void checkAddProjectBuildDefinitionAuthorization(String resource) throws ContinuumException {
        this.checkAuthorization("continuum-add-project-build-definition", resource);
    }

    protected void checkModifyProjectBuildDefinitionAuthorization(String resource) throws ContinuumException {
        this.checkAuthorization("continuum-modify-project-build-definition", resource);
    }

    protected void checkRemoveProjectBuildDefinitionAuthorization(String resource) throws ContinuumException {
        this.checkAuthorization("continuum-remove-project-build-definition", resource);
    }

    protected void checkAddProjectGroupNotifierAuthorization(String resource) throws ContinuumException {
        this.checkAuthorization("continuum-add-group-notifier", resource);
    }

    protected void checkRemoveProjectGroupNotifierAuthorization(String resource) throws ContinuumException {
        this.checkAuthorization("continuum-remove-group-notifier", resource);
    }

    protected void checkModifyProjectGroupNotifierAuthorization(String resource) throws ContinuumException {
        this.checkAuthorization("continuum-modify-group-notifier", resource);
    }

    protected void checkAddProjectNotifierAuthorization(String resource) throws ContinuumException {
        this.checkAuthorization("continuum-add-project-notifier", resource);
    }

    protected void checkRemoveProjectNotifierAuthorization(String resource) throws ContinuumException {
        this.checkAuthorization("continuum-remove-project-notifier", resource);
    }

    protected void checkModifyProjectNotifierAuthorization(String resource) throws ContinuumException {
        this.checkAuthorization("continuum-modify-project-notifier", resource);
    }

    protected void checkManageConfigurationAuthorization() throws ContinuumException, ContinuumException {
        if (!this.isAuthenticated()) {
            throw new ContinuumException("Authentication required.");
        }
        this.checkAuthorization("continuum-manage-configuration");
    }

    protected void checkManageSchedulesAuthorization() throws ContinuumException, ContinuumException {
        if (!this.isAuthenticated()) {
            throw new ContinuumException("Authentication required.");
        }
        this.checkAuthorization("continuum-manage-schedules");
    }
}

