/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.xmlrpc.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.continuum.Continuum;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.model.project.BuildDefinition;
import org.apache.maven.continuum.model.project.BuildResult;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectDeveloper;
import org.apache.maven.continuum.model.project.ProjectNotifier;
import org.apache.maven.continuum.model.scm.ChangeFile;
import org.apache.maven.continuum.model.scm.ChangeSet;
import org.apache.maven.continuum.model.scm.SuiteResult;
import org.apache.maven.continuum.model.system.Profile;
import org.apache.maven.continuum.project.builder.ContinuumProjectBuildingResult;
import org.apache.maven.continuum.xmlrpc.project.AddingResult;
import org.apache.maven.continuum.xmlrpc.project.BuildResultSummary;
import org.apache.maven.continuum.xmlrpc.project.ProjectDependency;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroup;
import org.apache.maven.continuum.xmlrpc.project.ProjectGroupSummary;
import org.apache.maven.continuum.xmlrpc.project.ProjectSummary;
import org.apache.maven.continuum.xmlrpc.project.Schedule;
import org.apache.maven.continuum.xmlrpc.scm.ScmResult;
import org.apache.maven.continuum.xmlrpc.server.AbstractContinuumSecureService;
import org.apache.maven.continuum.xmlrpc.system.Installation;
import org.apache.maven.continuum.xmlrpc.test.TestCaseFailure;
import org.apache.maven.continuum.xmlrpc.test.TestResult;
import org.codehaus.plexus.redback.authorization.AuthorizationException;
import org.codehaus.plexus.redback.role.RoleManager;
import org.codehaus.plexus.redback.role.RoleManagerException;
import org.codehaus.plexus.util.StringUtils;

public class ContinuumServiceImpl
extends AbstractContinuumSecureService {
    private Continuum continuum;
    private RoleManager roleManager;

    public boolean ping() throws ContinuumException {
        return true;
    }

    public List getProjects(int projectGroupId) throws ContinuumException {
        this.checkViewProjectGroupAuthorization(this.getProjectGroupName(projectGroupId));
        ArrayList<ProjectSummary> projectsList = new ArrayList<ProjectSummary>();
        Collection projects = this.continuum.getProjectsInGroup(projectGroupId);
        if (projects != null) {
            for (Project project : projects) {
                ProjectSummary ps = this.populateProjectSummary(project);
                projectsList.add(ps);
            }
        }
        return projectsList;
    }

    public ProjectSummary getProjectSummary(int projectId) throws ContinuumException {
        Project project = this.continuum.getProject(projectId);
        this.checkViewProjectGroupAuthorization(project.getProjectGroup().getName());
        return this.populateProjectSummary(project);
    }

    public org.apache.maven.continuum.xmlrpc.project.Project getProjectWithAllDetails(int projectId) throws ContinuumException {
        Project project = this.continuum.getProjectWithAllDetails(projectId);
        this.checkViewProjectGroupAuthorization(project.getProjectGroup().getName());
        return this.populateProject(project);
    }

    public int removeProject(int projectId) throws ContinuumException {
        ProjectSummary ps = this.getProjectSummary(projectId);
        this.checkRemoveProjectFromGroupAuthorization(ps.getProjectGroup().getName());
        this.continuum.removeProject(projectId);
        return 0;
    }

    public ProjectSummary updateProject(ProjectSummary project) throws ContinuumException {
        ProjectSummary ps = this.getProjectSummary(project.getId());
        this.checkRemoveProjectFromGroupAuthorization(ps.getProjectGroup().getName());
        Project p = this.continuum.getProject(project.getId());
        p.setName(project.getName());
        p.setVersion(project.getVersion());
        p.setScmUrl(project.getScmUrl());
        p.setScmUseCache(project.isScmUseCache());
        p.setScmUsername(project.getScmUsername());
        p.setScmPassword(project.getScmPassword());
        p.setScmTag(project.getScmTag());
        this.continuum.updateProject(p);
        return this.getProjectSummary(project.getId());
    }

    public List getAllProjectGroups() throws ContinuumException {
        Collection pgList = this.continuum.getAllProjectGroups();
        ArrayList<ProjectGroup> result = new ArrayList<ProjectGroup>();
        for (org.apache.maven.continuum.model.project.ProjectGroup projectGroup : pgList) {
            try {
                if (!this.isAuthorized("continuum-view-group", projectGroup.getName())) continue;
                result.add(this.populateProjectGroupWithProjects(projectGroup));
            }
            catch (AuthorizationException e) {
                throw new ContinuumException("error authorizing request.");
            }
        }
        return result;
    }

    public List getAllProjectGroupsWithProjects() throws ContinuumException {
        Collection pgList = this.continuum.getAllProjectGroupsWithProjects();
        ArrayList<ProjectGroup> result = new ArrayList<ProjectGroup>();
        for (org.apache.maven.continuum.model.project.ProjectGroup projectGroup : pgList) {
            try {
                if (!this.isAuthorized("continuum-view-group", projectGroup.getName())) continue;
                result.add(this.populateProjectGroupWithProjects(projectGroup));
            }
            catch (AuthorizationException e) {
                throw new ContinuumException("error authorizing request.");
            }
        }
        return result;
    }

    protected String getProjectGroupName(int projectGroupId) throws ContinuumException {
        ProjectGroupSummary pgs = this.getPGSummary(projectGroupId);
        return pgs.getName();
    }

    private ProjectGroupSummary getPGSummary(int projectGroupId) throws ContinuumException {
        org.apache.maven.continuum.model.project.ProjectGroup projectGroup = this.continuum.getProjectGroup(projectGroupId);
        return this.populateProjectGroupSummary(projectGroup);
    }

    public ProjectGroupSummary getProjectGroupSummary(int projectGroupId) throws ContinuumException {
        this.checkViewProjectGroupAuthorization(this.getProjectGroupName(projectGroupId));
        org.apache.maven.continuum.model.project.ProjectGroup projectGroup = this.continuum.getProjectGroup(projectGroupId);
        return this.populateProjectGroupSummary(projectGroup);
    }

    public ProjectGroup getProjectGroupWithProjects(int projectGroupId) throws ContinuumException {
        this.checkViewProjectGroupAuthorization(this.getProjectGroupName(projectGroupId));
        org.apache.maven.continuum.model.project.ProjectGroup projectGroup = this.continuum.getProjectGroupWithProjects(projectGroupId);
        return this.populateProjectGroupWithProjects(projectGroup);
    }

    public int removeProjectGroup(int projectGroupId) throws ContinuumException {
        this.checkRemoveProjectGroupAuthorization(this.getProjectGroupName(projectGroupId));
        this.continuum.removeProjectGroup(projectGroupId);
        return 0;
    }

    public ProjectGroupSummary updateProjectGroup(ProjectGroupSummary projectGroup) throws ContinuumException {
        if (projectGroup == null) {
            return null;
        }
        this.checkModifyProjectGroupAuthorization(this.getProjectGroupName(projectGroup.getId()));
        if (StringUtils.isEmpty((String)projectGroup.getName())) {
            throw new ContinuumException("project group name is required");
        }
        if (StringUtils.isEmpty((String)projectGroup.getName().trim())) {
            throw new ContinuumException("project group name can't be spaces");
        }
        org.apache.maven.continuum.model.project.ProjectGroup pg = this.continuum.getProjectGroupWithProjects(projectGroup.getId());
        if (!projectGroup.getName().equals(pg.getName())) {
            try {
                this.roleManager.updateRole("project-administrator", pg.getName(), projectGroup.getName());
                this.roleManager.updateRole("project-developer", pg.getName(), projectGroup.getName());
                this.roleManager.updateRole("project-user", pg.getName(), projectGroup.getName());
                pg.setName(projectGroup.getName());
            }
            catch (RoleManagerException e) {
                throw new ContinuumException("unable to rename the project group", (Throwable)e);
            }
        }
        pg.setDescription(projectGroup.getDescription());
        this.continuum.updateProjectGroup(pg);
        return this.getProjectGroupSummary(projectGroup.getId());
    }

    public List getBuildDefinitionsForProject(int projectId) throws ContinuumException {
        ProjectSummary ps = this.getProjectSummary(projectId);
        this.checkViewProjectGroupAuthorization(ps.getProjectGroup().getName());
        List bds = this.continuum.getBuildDefinitionsForProject(projectId);
        ArrayList<org.apache.maven.continuum.xmlrpc.project.BuildDefinition> result = new ArrayList<org.apache.maven.continuum.xmlrpc.project.BuildDefinition>();
        Iterator i = bds.iterator();
        while (i.hasNext()) {
            result.add(this.populateBuildDefinition((BuildDefinition)i.next()));
        }
        return result;
    }

    public List getBuildDefinitionsForProjectGroup(int projectGroupId) throws ContinuumException {
        this.checkViewProjectGroupAuthorization(this.getProjectGroupName(projectGroupId));
        List bds = this.continuum.getBuildDefinitionsForProjectGroup(projectGroupId);
        ArrayList<org.apache.maven.continuum.xmlrpc.project.BuildDefinition> result = new ArrayList<org.apache.maven.continuum.xmlrpc.project.BuildDefinition>();
        Iterator i = bds.iterator();
        while (i.hasNext()) {
            result.add(this.populateBuildDefinition((BuildDefinition)i.next()));
        }
        return result;
    }

    public org.apache.maven.continuum.xmlrpc.project.BuildDefinition updateBuildDefinitionForProject(int projectId, org.apache.maven.continuum.xmlrpc.project.BuildDefinition buildDef) throws ContinuumException {
        ProjectSummary ps = this.getProjectSummary(projectId);
        this.checkModifyProjectBuildDefinitionAuthorization(ps.getProjectGroup().getName());
        BuildDefinition bd = this.populateBuildDefinition(buildDef);
        bd = this.continuum.updateBuildDefinitionForProject(projectId, bd);
        return this.populateBuildDefinition(bd);
    }

    public org.apache.maven.continuum.xmlrpc.project.BuildDefinition updateBuildDefinitionForProjectGroup(int projectGroupId, org.apache.maven.continuum.xmlrpc.project.BuildDefinition buildDef) throws ContinuumException {
        this.checkModifyGroupBuildDefinitionAuthorization(this.getProjectGroupName(projectGroupId));
        BuildDefinition bd = this.populateBuildDefinition(buildDef);
        bd = this.continuum.updateBuildDefinitionForProjectGroup(projectGroupId, bd);
        return this.populateBuildDefinition(bd);
    }

    public org.apache.maven.continuum.xmlrpc.project.BuildDefinition addBuildDefinitionToProject(int projectId, org.apache.maven.continuum.xmlrpc.project.BuildDefinition buildDef) throws ContinuumException {
        this.checkAddProjectBuildDefinitionAuthorization(this.getProjectSummary(projectId).getProjectGroup().getName());
        if (buildDef.getSchedule() == null) {
            throw new ContinuumException("The schedule can't be null.");
        }
        BuildDefinition bd = this.populateBuildDefinition(buildDef);
        bd = this.continuum.addBuildDefinitionToProject(projectId, bd);
        return this.populateBuildDefinition(bd);
    }

    public org.apache.maven.continuum.xmlrpc.project.BuildDefinition addBuildDefinitionToProjectGroup(int projectGroupId, org.apache.maven.continuum.xmlrpc.project.BuildDefinition buildDef) throws ContinuumException {
        this.checkAddGroupBuildDefinitionAuthorization(this.getPGSummary(projectGroupId).getName());
        if (buildDef.getSchedule() == null) {
            throw new ContinuumException("The schedule can't be null.");
        }
        BuildDefinition bd = this.populateBuildDefinition(buildDef);
        bd = this.continuum.addBuildDefinitionToProjectGroup(projectGroupId, bd);
        return this.populateBuildDefinition(bd);
    }

    public int addProjectToBuildQueue(int projectId) throws ContinuumException {
        ProjectSummary ps = this.getProjectSummary(projectId);
        this.checkBuildProjectInGroupAuthorization(ps.getProjectGroup().getName());
        this.continuum.buildProject(projectId, 0);
        return 0;
    }

    public int addProjectToBuildQueue(int projectId, int buildDefinitionId) throws ContinuumException {
        ProjectSummary ps = this.getProjectSummary(projectId);
        this.checkBuildProjectInGroupAuthorization(ps.getProjectGroup().getName());
        this.continuum.buildProject(projectId, buildDefinitionId, 0);
        return 0;
    }

    public int buildProject(int projectId) throws ContinuumException {
        ProjectSummary ps = this.getProjectSummary(projectId);
        this.checkBuildProjectInGroupAuthorization(ps.getProjectGroup().getName());
        this.continuum.buildProject(projectId);
        return 0;
    }

    public int buildProject(int projectId, int buildDefintionId) throws ContinuumException {
        ProjectSummary ps = this.getProjectSummary(projectId);
        this.checkBuildProjectInGroupAuthorization(ps.getProjectGroup().getName());
        this.continuum.buildProject(projectId, buildDefintionId);
        return 0;
    }

    public org.apache.maven.continuum.xmlrpc.project.BuildResult getLatestBuildResult(int projectId) throws ContinuumException {
        ProjectSummary ps = this.getProjectSummary(projectId);
        this.checkViewProjectGroupAuthorization(ps.getProjectGroup().getName());
        BuildResult buildResult = this.continuum.getLatestBuildResultForProject(projectId);
        return this.getBuildResult(projectId, buildResult.getId());
    }

    public org.apache.maven.continuum.xmlrpc.project.BuildResult getBuildResult(int projectId, int buildId) throws ContinuumException {
        ProjectSummary ps = this.getProjectSummary(projectId);
        this.checkViewProjectGroupAuthorization(ps.getProjectGroup().getName());
        return this.populateBuildResult(this.continuum.getBuildResult(buildId));
    }

    public List getBuildResultsForProject(int projectId) throws ContinuumException {
        ProjectSummary ps = this.getProjectSummary(projectId);
        this.checkViewProjectGroupAuthorization(ps.getProjectGroup().getName());
        ArrayList<BuildResultSummary> result = new ArrayList<BuildResultSummary>();
        Collection buildResults = this.continuum.getBuildResultsForProject(projectId);
        if (buildResults != null) {
            for (BuildResult buildResult : buildResults) {
                BuildResultSummary br = this.populateBuildResultSummary(buildResult);
                result.add(br);
            }
        }
        return result;
    }

    public int removeBuildResult(org.apache.maven.continuum.xmlrpc.project.BuildResult br) throws ContinuumException {
        this.checkModifyProjectGroupAuthorization(this.getProjectSummary(br.getProject().getId()).getProjectGroup().getName());
        this.continuum.removeBuildResult(br.getId());
        return 0;
    }

    public String getBuildOutput(int projectId, int buildId) throws ContinuumException {
        ProjectSummary ps = this.getProjectSummary(projectId);
        this.checkViewProjectGroupAuthorization(ps.getProjectGroup().getName());
        return this.continuum.getBuildOutput(projectId, buildId);
    }

    public AddingResult addMavenTwoProject(String url) throws ContinuumException {
        this.checkAddProjectGroupAuthorization();
        ContinuumProjectBuildingResult result = this.continuum.addMavenTwoProject(url);
        return this.populateAddingResult(result);
    }

    public AddingResult addMavenTwoProject(String url, int projectGroupId) throws ContinuumException {
        this.checkAddProjectToGroupAuthorization(this.getProjectGroupName(projectGroupId));
        ContinuumProjectBuildingResult result = this.continuum.addMavenTwoProject(url, projectGroupId);
        return this.populateAddingResult(result);
    }

    public AddingResult addMavenOneProject(String url) throws ContinuumException {
        this.checkAddProjectGroupAuthorization();
        ContinuumProjectBuildingResult result = this.continuum.addMavenOneProject(url);
        return this.populateAddingResult(result);
    }

    public AddingResult addMavenOneProject(String url, int projectGroupId) throws ContinuumException {
        this.checkAddProjectToGroupAuthorization(this.getProjectGroupName(projectGroupId));
        ContinuumProjectBuildingResult result = this.continuum.addMavenOneProject(url, projectGroupId);
        return this.populateAddingResult(result);
    }

    public ProjectSummary addAntProject(ProjectSummary project) throws ContinuumException {
        this.checkAddProjectGroupAuthorization();
        int projectId = this.continuum.addProject(this.populateProject(project), "ant");
        return this.getProjectSummary(projectId);
    }

    public ProjectSummary addAntProject(ProjectSummary project, int projectGroupId) throws ContinuumException {
        this.checkAddProjectGroupAuthorization();
        int projectId = this.continuum.addProject(this.populateProject(project), "ant", projectGroupId);
        return this.getProjectSummary(projectId);
    }

    public ProjectSummary addShellProject(ProjectSummary project) throws ContinuumException {
        this.checkAddProjectGroupAuthorization();
        int projectId = this.continuum.addProject(this.populateProject(project), "shell");
        return this.getProjectSummary(projectId);
    }

    public ProjectSummary addShellProject(ProjectSummary project, int projectGroupId) throws ContinuumException {
        this.checkAddProjectGroupAuthorization();
        int projectId = this.continuum.addProject(this.populateProject(project), "shell", projectGroupId);
        return this.getProjectSummary(projectId);
    }

    public List getSchedules() throws ContinuumException {
        Collection schedules = this.continuum.getSchedules();
        ArrayList<Schedule> s = new ArrayList<Schedule>();
        Iterator i = schedules.iterator();
        while (i.hasNext()) {
            s.add(this.populateSchedule((org.apache.maven.continuum.model.project.Schedule)i.next()));
        }
        return s;
    }

    public Schedule getSchedule(int scheduleId) throws ContinuumException {
        return this.populateSchedule(this.continuum.getSchedule(scheduleId));
    }

    public Schedule updateSchedule(Schedule schedule) throws ContinuumException {
        this.checkManageSchedulesAuthorization();
        this.continuum.updateSchedule(this.populateSchedule(schedule));
        return this.populateSchedule(this.continuum.getScheduleByName(schedule.getName()));
    }

    public Schedule addSchedule(Schedule schedule) throws ContinuumException {
        this.checkManageSchedulesAuthorization();
        this.continuum.addSchedule(this.populateSchedule(schedule));
        return this.populateSchedule(this.continuum.getScheduleByName(schedule.getName()));
    }

    public List getProfiles() throws ContinuumException {
        List profiles = this.continuum.getProfileService().getAllProfiles();
        ArrayList<org.apache.maven.continuum.xmlrpc.system.Profile> p = new ArrayList<org.apache.maven.continuum.xmlrpc.system.Profile>();
        Iterator i = profiles.iterator();
        while (i.hasNext()) {
            p.add(this.populateProfile((Profile)i.next()));
        }
        return p;
    }

    public org.apache.maven.continuum.xmlrpc.system.Profile getProfile(int profileId) throws ContinuumException {
        return this.populateProfile(this.continuum.getProfileService().getProfile(profileId));
    }

    private ProjectSummary populateProjectSummary(Project project) {
        if (project == null) {
            return null;
        }
        org.apache.maven.continuum.xmlrpc.project.Project ps = new org.apache.maven.continuum.xmlrpc.project.Project();
        ps.setArtifactId(project.getArtifactId());
        ps.setBuildNumber(project.getBuildNumber());
        ps.setDescription(project.getDescription());
        ps.setExecutorId(project.getExecutorId());
        ps.setGroupId(project.getGroupId());
        ps.setId(project.getId());
        ps.setLatestBuildId(project.getLatestBuildId());
        ps.setName(project.getName());
        ps.setProjectGroup(this.populateProjectGroupSummary(project.getProjectGroup()));
        ps.setScmTag(project.getScmTag());
        ps.setScmUrl(project.getScmUrl());
        ps.setScmUseCache(project.isScmUseCache());
        ps.setScmUsername(project.getScmUsername());
        ps.setState(project.getState());
        ps.setUrl(project.getUrl());
        ps.setVersion(project.getVersion());
        ps.setWorkingDirectory(project.getWorkingDirectory());
        return ps;
    }

    private org.apache.maven.continuum.xmlrpc.project.Project populateProject(Project project) {
        if (project == null) {
            return null;
        }
        org.apache.maven.continuum.xmlrpc.project.Project p = (org.apache.maven.continuum.xmlrpc.project.Project)this.populateProjectSummary(project);
        p.setParent(this.populateProjectDependency(project.getParent()));
        if (project.getDependencies() != null) {
            ArrayList<ProjectDependency> deps = new ArrayList<ProjectDependency>();
            for (org.apache.maven.continuum.model.project.ProjectDependency d : project.getDependencies()) {
                deps.add(this.populateProjectDependency(d));
            }
            p.setDependencies(deps);
        }
        if (project.getDevelopers() != null) {
            for (ProjectDeveloper developer : project.getDevelopers()) {
                p.addDeveloper(this.populateProjectDeveloper(developer));
            }
        }
        if (project.getNotifiers() != null) {
            for (ProjectNotifier notifier : project.getNotifiers()) {
                p.addNotifier(this.populateProjectNotifier(notifier));
            }
        }
        return p;
    }

    private org.apache.maven.continuum.xmlrpc.project.ProjectDeveloper populateProjectDeveloper(ProjectDeveloper developer) {
        if (developer == null) {
            return null;
        }
        org.apache.maven.continuum.xmlrpc.project.ProjectDeveloper res = new org.apache.maven.continuum.xmlrpc.project.ProjectDeveloper();
        res.setContinuumId(developer.getContinuumId());
        res.setEmail(developer.getEmail());
        res.setName(developer.getName());
        res.setScmId(developer.getScmId());
        return res;
    }

    private org.apache.maven.continuum.xmlrpc.project.ProjectNotifier populateProjectNotifier(ProjectNotifier notifier) {
        if (notifier == null) {
            return null;
        }
        org.apache.maven.continuum.xmlrpc.project.ProjectNotifier res = new org.apache.maven.continuum.xmlrpc.project.ProjectNotifier();
        res.setEnabled(notifier.isEnabled());
        res.setFrom(notifier.getFrom());
        res.setId(notifier.getId());
        res.setRecipientType(notifier.getRecipientType());
        res.setSendOnError(notifier.isSendOnError());
        res.setSendOnFailure(notifier.isSendOnFailure());
        res.setSendOnSuccess(notifier.isSendOnSuccess());
        res.setSendOnWarning(notifier.isSendOnWarning());
        res.setType(notifier.getType());
        if (notifier.getConfiguration() != null) {
            HashMap conf = new HashMap();
            for (String key : notifier.getConfiguration().keySet()) {
                conf.put(key, notifier.getConfiguration().get(key));
            }
            res.setConfiguration(conf);
        }
        return res;
    }

    private Project populateProject(ProjectSummary projectSummary) {
        if (projectSummary == null) {
            return null;
        }
        Project project = new Project();
        project.setArtifactId(projectSummary.getArtifactId());
        project.setBuildNumber(projectSummary.getBuildNumber());
        project.setDescription(projectSummary.getDescription());
        project.setExecutorId(projectSummary.getExecutorId());
        project.setGroupId(projectSummary.getGroupId());
        project.setId(projectSummary.getId());
        project.setLatestBuildId(projectSummary.getLatestBuildId());
        project.setName(projectSummary.getName());
        project.setProjectGroup(this.populateProjectGroupSummary(projectSummary.getProjectGroup()));
        project.setScmTag(projectSummary.getScmTag());
        project.setScmUrl(projectSummary.getScmUrl());
        project.setScmUseCache(projectSummary.isScmUseCache());
        project.setScmUsername(projectSummary.getScmUsername());
        project.setState(projectSummary.getState());
        project.setUrl(projectSummary.getUrl());
        project.setVersion(projectSummary.getVersion());
        project.setWorkingDirectory(projectSummary.getWorkingDirectory());
        return project;
    }

    private ProjectDependency populateProjectDependency(org.apache.maven.continuum.model.project.ProjectDependency dependency) {
        if (dependency == null) {
            return null;
        }
        ProjectDependency dep = new ProjectDependency();
        dep.setArtifactId(dependency.getArtifactId());
        dep.setGroupId(dependency.getGroupId());
        dep.setVersion(dependency.getVersion());
        return dep;
    }

    private ProjectGroupSummary populateProjectGroupSummary(org.apache.maven.continuum.model.project.ProjectGroup group) {
        if (group == null) {
            return null;
        }
        ProjectGroup g = new ProjectGroup();
        g.setDescription(group.getDescription());
        g.setGroupId(group.getGroupId());
        g.setId(group.getId());
        g.setName(group.getName());
        return g;
    }

    private org.apache.maven.continuum.model.project.ProjectGroup populateProjectGroupSummary(ProjectGroupSummary group) {
        if (group == null) {
            return null;
        }
        org.apache.maven.continuum.model.project.ProjectGroup g = new org.apache.maven.continuum.model.project.ProjectGroup();
        g.setDescription(group.getDescription());
        g.setGroupId(group.getGroupId());
        g.setId(group.getId());
        g.setName(group.getName());
        return g;
    }

    private ProjectGroup populateProjectGroupWithProjects(org.apache.maven.continuum.model.project.ProjectGroup group) {
        if (group == null) {
            return null;
        }
        ProjectGroup g = (ProjectGroup)this.populateProjectGroupSummary(group);
        if (group.getProjects() != null) {
            ArrayList<ProjectSummary> projects = new ArrayList<ProjectSummary>();
            for (Project p : group.getProjects()) {
                ProjectSummary ps = this.populateProjectSummary(p);
                projects.add(ps);
            }
            g.setProjects(projects);
        }
        return g;
    }

    private BuildResultSummary populateBuildResultSummary(BuildResult buildResult) {
        if (buildResult == null) {
            return null;
        }
        org.apache.maven.continuum.xmlrpc.project.BuildResult br = new org.apache.maven.continuum.xmlrpc.project.BuildResult();
        br.setBuildNumber(buildResult.getBuildNumber());
        br.setEndTime(buildResult.getEndTime());
        br.setError(buildResult.getError());
        br.setExitCode(buildResult.getExitCode());
        br.setId(buildResult.getId());
        br.setStartTime(buildResult.getStartTime());
        br.setState(buildResult.getState());
        br.setSuccess(buildResult.isSuccess());
        br.setTrigger(buildResult.getTrigger());
        br.setProject(this.populateProjectSummary(buildResult.getProject()));
        return br;
    }

    private org.apache.maven.continuum.xmlrpc.project.BuildResult populateBuildResult(BuildResult buildResult) throws ContinuumException {
        if (buildResult == null) {
            return null;
        }
        org.apache.maven.continuum.xmlrpc.project.BuildResult br = (org.apache.maven.continuum.xmlrpc.project.BuildResult)this.populateBuildResultSummary(buildResult);
        List changeSet = this.continuum.getChangesSinceLastSuccess(br.getProject().getId(), br.getId());
        if (changeSet != null) {
            Iterator i = changeSet.iterator();
            while (i.hasNext()) {
                br.addChangesSinceLastSucces(this.populateChangeSet((ChangeSet)i.next()));
            }
        }
        br.setScmResult(this.populateScmResult(buildResult.getScmResult()));
        if (buildResult.getModifiedDependencies() != null) {
            for (org.apache.maven.continuum.model.project.ProjectDependency dependency : buildResult.getModifiedDependencies()) {
                ProjectDependency dep = this.populateProjectDependency(dependency);
                br.addModifiedDependency(dep);
            }
        }
        br.setTestResult(this.populateTestResult(buildResult.getTestResult()));
        return br;
    }

    private AddingResult populateAddingResult(ContinuumProjectBuildingResult result) {
        if (result == null) {
            return null;
        }
        AddingResult res = new AddingResult();
        if (result.hasErrors()) {
            for (String error : result.getErrors()) {
                res.addError(error);
            }
        }
        if (result.getProjects() != null) {
            for (Project project : result.getProjects()) {
                res.addProject(this.populateProjectSummary(project));
            }
        }
        if (result.getProjectGroups() != null) {
            for (org.apache.maven.continuum.model.project.ProjectGroup projectGroup : result.getProjectGroups()) {
                res.addProjectGroup(this.populateProjectGroupSummary(projectGroup));
            }
        }
        return res;
    }

    private ScmResult populateScmResult(org.apache.maven.continuum.model.scm.ScmResult scmResult) {
        if (scmResult == null) {
            return null;
        }
        ScmResult res = new ScmResult();
        if (scmResult.getChanges() != null) {
            for (ChangeSet changeSet : scmResult.getChanges()) {
                res.addChange(this.populateChangeSet(changeSet));
            }
        }
        res.setCommandLine(scmResult.getCommandLine());
        res.setCommandOutput(scmResult.getCommandOutput());
        res.setException(scmResult.getException());
        res.setProviderMessage(scmResult.getProviderMessage());
        res.setSuccess(scmResult.isSuccess());
        return res;
    }

    private org.apache.maven.continuum.xmlrpc.scm.ChangeSet populateChangeSet(ChangeSet changeSet) {
        if (changeSet == null) {
            return null;
        }
        org.apache.maven.continuum.xmlrpc.scm.ChangeSet res = new org.apache.maven.continuum.xmlrpc.scm.ChangeSet();
        res.setAuthor(changeSet.getAuthor());
        res.setComment(changeSet.getComment());
        res.setDate(changeSet.getDate());
        if (changeSet.getFiles() != null) {
            for (ChangeFile changeFile : changeSet.getFiles()) {
                res.addFile(this.populateChangeFile(changeFile));
            }
        }
        res.setId(changeSet.getId());
        return res;
    }

    private org.apache.maven.continuum.xmlrpc.scm.ChangeFile populateChangeFile(ChangeFile changeFile) {
        if (changeFile == null) {
            return null;
        }
        org.apache.maven.continuum.xmlrpc.scm.ChangeFile res = new org.apache.maven.continuum.xmlrpc.scm.ChangeFile();
        res.setName(changeFile.getName());
        res.setRevision(changeFile.getRevision());
        res.setStatus(changeFile.getStatus());
        return res;
    }

    private TestResult populateTestResult(org.apache.maven.continuum.model.scm.TestResult testResult) {
        if (testResult == null) {
            return null;
        }
        TestResult res = new TestResult();
        res.setFailureCount(testResult.getFailureCount());
        if (testResult.getSuiteResults() != null) {
            for (SuiteResult suiteResult : testResult.getSuiteResults()) {
                res.addSuiteResult(this.populateSuiteResult(suiteResult));
            }
        }
        res.setTestCount(testResult.getTestCount());
        res.setTotalTime(testResult.getTotalTime());
        return res;
    }

    private org.apache.maven.continuum.xmlrpc.test.SuiteResult populateSuiteResult(SuiteResult suiteresult) {
        if (suiteresult == null) {
            return null;
        }
        org.apache.maven.continuum.xmlrpc.test.SuiteResult res = new org.apache.maven.continuum.xmlrpc.test.SuiteResult();
        res.setFailureCount(suiteresult.getFailureCount());
        if (suiteresult.getFailures() != null) {
            for (org.apache.maven.continuum.model.scm.TestCaseFailure failure : suiteresult.getFailures()) {
                res.addFailure(this.populateTestCaseFailure(failure));
            }
        }
        res.setName(suiteresult.getName());
        res.setTestCount(suiteresult.getTestCount());
        res.setTotalTime(suiteresult.getTotalTime());
        return res;
    }

    private TestCaseFailure populateTestCaseFailure(org.apache.maven.continuum.model.scm.TestCaseFailure failure) {
        if (failure == null) {
            return null;
        }
        TestCaseFailure res = new TestCaseFailure();
        res.setException(failure.getException());
        res.setName(failure.getName());
        return res;
    }

    private org.apache.maven.continuum.xmlrpc.project.BuildDefinition populateBuildDefinition(BuildDefinition buildDef) {
        if (buildDef == null) {
            return null;
        }
        org.apache.maven.continuum.xmlrpc.project.BuildDefinition bd = new org.apache.maven.continuum.xmlrpc.project.BuildDefinition();
        bd.setArguments(buildDef.getArguments());
        bd.setBuildFile(buildDef.getBuildFile());
        bd.setBuildFresh(buildDef.isBuildFresh());
        bd.setDefaultForProject(buildDef.isDefaultForProject());
        bd.setGoals(buildDef.getGoals());
        bd.setProfile(this.populateProfile(buildDef.getProfile()));
        bd.setSchedule(this.populateSchedule(buildDef.getSchedule()));
        return bd;
    }

    private BuildDefinition populateBuildDefinition(org.apache.maven.continuum.xmlrpc.project.BuildDefinition buildDef) {
        if (buildDef == null) {
            return null;
        }
        BuildDefinition bd = new BuildDefinition();
        bd.setArguments(buildDef.getArguments());
        bd.setBuildFile(buildDef.getBuildFile());
        bd.setBuildFresh(buildDef.isBuildFresh());
        bd.setDefaultForProject(buildDef.isDefaultForProject());
        bd.setGoals(buildDef.getGoals());
        bd.setProfile(this.populateProfile(buildDef.getProfile()));
        bd.setSchedule(this.populateSchedule(buildDef.getSchedule()));
        return bd;
    }

    private org.apache.maven.continuum.model.project.Schedule populateSchedule(Schedule schedule) {
        if (schedule == null) {
            return null;
        }
        org.apache.maven.continuum.model.project.Schedule s = new org.apache.maven.continuum.model.project.Schedule();
        s.setActive(schedule.isActive());
        s.setCronExpression(schedule.getCronExpression());
        s.setDelay(schedule.getDelay());
        s.setDescription(schedule.getDescription());
        s.setId(schedule.getId());
        s.setMaxJobExecutionTime(schedule.getMaxJobExecutionTime());
        s.setName(schedule.getName());
        return s;
    }

    private Schedule populateSchedule(org.apache.maven.continuum.model.project.Schedule schedule) {
        if (schedule == null) {
            return null;
        }
        Schedule s = new Schedule();
        s.setActive(schedule.isActive());
        s.setCronExpression(schedule.getCronExpression());
        s.setDelay(schedule.getDelay());
        s.setDescription(schedule.getDescription());
        s.setId(schedule.getId());
        s.setMaxJobExecutionTime(schedule.getMaxJobExecutionTime());
        s.setName(schedule.getName());
        return s;
    }

    public Profile populateProfile(org.apache.maven.continuum.xmlrpc.system.Profile profile) {
        if (profile == null) {
            return null;
        }
        Profile p = new Profile();
        p.setActive(profile.isActive());
        p.setBuilder(this.populateInstallation(profile.getBuilder()));
        p.setBuildWithoutChanges(profile.isBuildWithoutChanges());
        p.setDescription(profile.getDescription());
        if (profile.getEnvironmentVariables() != null) {
            ArrayList<org.apache.maven.continuum.model.system.Installation> envs = new ArrayList<org.apache.maven.continuum.model.system.Installation>();
            Iterator i = profile.getEnvironmentVariables().iterator();
            while (i.hasNext()) {
                envs.add(this.populateInstallation((Installation)i.next()));
            }
            p.setEnvironmentVariables(envs);
        }
        p.setId(profile.getId());
        p.setJdk(this.populateInstallation(profile.getJdk()));
        p.setName(profile.getName());
        p.setScmMode(profile.getScmMode());
        return p;
    }

    public org.apache.maven.continuum.xmlrpc.system.Profile populateProfile(Profile profile) {
        if (profile == null) {
            return null;
        }
        org.apache.maven.continuum.xmlrpc.system.Profile p = new org.apache.maven.continuum.xmlrpc.system.Profile();
        p.setActive(profile.isActive());
        p.setBuilder(this.populateInstallation(profile.getBuilder()));
        p.setBuildWithoutChanges(profile.isBuildWithoutChanges());
        p.setDescription(profile.getDescription());
        if (profile.getEnvironmentVariables() != null) {
            ArrayList<Installation> envs = new ArrayList<Installation>();
            Iterator i = profile.getEnvironmentVariables().iterator();
            while (i.hasNext()) {
                envs.add(this.populateInstallation((org.apache.maven.continuum.model.system.Installation)i.next()));
            }
            p.setEnvironmentVariables(envs);
        }
        p.setId(profile.getId());
        p.setJdk(this.populateInstallation(profile.getJdk()));
        p.setName(profile.getName());
        p.setScmMode(profile.getScmMode());
        return p;
    }

    public org.apache.maven.continuum.model.system.Installation populateInstallation(Installation install) {
        if (install == null) {
            return null;
        }
        org.apache.maven.continuum.model.system.Installation inst = new org.apache.maven.continuum.model.system.Installation();
        inst.setName(install.getName());
        inst.setType(install.getType());
        inst.setVarName(install.getVarName());
        inst.setVarValue(install.getVarValue());
        return inst;
    }

    public Installation populateInstallation(org.apache.maven.continuum.model.system.Installation install) {
        if (install == null) {
            return null;
        }
        Installation inst = new Installation();
        inst.setName(install.getName());
        inst.setType(install.getType());
        inst.setVarName(install.getVarName());
        inst.setVarValue(install.getVarValue());
        return inst;
    }
}

