/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.tool;

import java.util.HashMap;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.maven.continuum.web.tool.FormToolException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.formica.Element;
import org.codehaus.plexus.formica.Form;
import org.codehaus.plexus.formica.FormManager;
import org.codehaus.plexus.formica.FormNotFoundException;
import org.codehaus.plexus.formica.web.ContentGenerator;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.summit.rundata.RunData;
import org.codehaus.plexus.util.StringUtils;

public class FormicaTool
extends AbstractLogEnabled
implements Contextualizable {
    private FormManager formManager;
    private PlexusContainer container;

    public Form getForm(String fid) throws FormToolException {
        try {
            return this.formManager.getForm(fid);
        }
        catch (FormNotFoundException e) {
            throw new FormToolException("Cannot find form with id = " + fid, e);
        }
    }

    public String getItem(Form form, Element element, String id) throws FormToolException {
        if (id == null) {
            return null;
        }
        return this.getItem(form, element, this.getItem(form, id));
    }

    public String getItem(Form form, Element element, Object item) throws FormToolException {
        try {
            String text;
            if (element.getContentGenerator() != null) {
                ContentGenerator cg = (ContentGenerator)this.container.lookup(ContentGenerator.ROLE, element.getContentGenerator());
                text = cg.generate(item);
            } else {
                Object value = Ognl.getValue((String)element.getExpression(), (Object)item);
                text = value.toString();
            }
            return text;
        }
        catch (ComponentLookupException e) {
            throw new FormToolException("Content generator with id = " + element.getContentGenerator() + " does not exist", e);
        }
        catch (OgnlException e) {
            throw new FormToolException("Error extracting value from " + item + " using the expression " + element.getExpression(), e);
        }
    }

    public String getElementData(Form form, Element element, Object item, RunData runData) throws FormToolException {
        Object data = runData.getParameters().getString(element.getId());
        if (data != null) {
            return data.toString();
        }
        if (item != null) {
            try {
                data = Ognl.getValue((String)element.getExpression(), (Object)item);
                if (data != null) {
                    return data.toString();
                }
            }
            catch (OgnlException e) {
                throw new FormToolException("Error evaluating expression: ", e);
            }
        }
        return "";
    }

    public Object getItem(Form form, String id) throws FormToolException {
        Object component;
        try {
            component = this.container.lookup(this.assertNotEmpty(form, form.getSourceRole(), "source role"));
        }
        catch (ComponentLookupException e) {
            throw new FormToolException("Cannot lookup source component.", e);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        String expr = this.assertNotEmpty(form, form.getLookupExpression(), "lookup expression");
        return this.getValue(expr, map, component);
    }

    private String assertNotEmpty(Form form, String value, String field) throws FormToolException {
        if (StringUtils.isEmpty((String)value)) {
            throw new FormToolException("Missing " + field + " from form '" + form.getId() + "'.");
        }
        return value;
    }

    private Object getValue(String expr, Map map, Object o) throws FormToolException {
        Object data;
        try {
            data = Ognl.getValue((String)expr, (Map)map, (Object)o);
        }
        catch (Throwable e) {
            this.getLogger().error("Error while evaluation OGNL expression '" + expr + "'.", e);
            throw new FormToolException("Error while evaluation OGNL expression '" + expr + "'.", e);
        }
        return data;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

