/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.continuum.model.system.ContinuumUser;
import org.apache.maven.continuum.store.ContinuumStore;
import org.apache.maven.continuum.web.model.SessionUser;
import org.codehaus.plexus.action.AbstractAction;
import org.codehaus.plexus.security.Authenticator;
import org.codehaus.plexus.security.exception.AuthenticationException;
import org.codehaus.plexus.security.exception.UnauthorizedException;
import org.codehaus.plexus.security.exception.UnknownEntityException;
import org.codehaus.plexus.security.summit.SecureRunData;
import org.codehaus.plexus.security.summit.User;
import org.codehaus.plexus.util.StringUtils;

public class Login
extends AbstractAction {
    private ContinuumStore store;
    private Authenticator authenticator;

    public void execute(Map map) throws Exception {
        SecureRunData data = (SecureRunData)map.get("data");
        String username = (String)map.get("login.username");
        this.getLogger().info("Trying to log in '" + username + "'.");
        String password = (String)map.get("login.password");
        if (StringUtils.isEmpty((String)username) || StringUtils.isEmpty((String)password)) {
            data.getViewContext().put("loginMessage", (Object)"Both username and password has to be supplied.");
            data.setTarget("Login.vm");
            return;
        }
        HashMap<String, String> tokens = new HashMap<String, String>();
        tokens.put("username", username);
        tokens.put("password", password);
        try {
            this.authenticator.authenticate(tokens);
        }
        catch (UnknownEntityException e) {
            data.getViewContext().put("loginMessage", (Object)("Unknown user '" + username + "'."));
            data.setTarget("Login.vm");
            return;
        }
        catch (AuthenticationException e) {
            data.getViewContext().put("loginMessage", (Object)("Could not authenticate: " + e.getMessage()));
            data.setTarget("Login.vm");
            return;
        }
        catch (UnauthorizedException e) {
            data.getViewContext().put("loginMessage", (Object)("User '" + username + "' is not authorized ."));
            data.setTarget("Login.vm");
            return;
        }
        ContinuumUser user = this.store.getUserByUsername(username);
        SessionUser usr = new SessionUser(user.getAccountId(), user.getUsername());
        usr.setFullName(user.getFullName());
        usr.setLoggedIn(true);
        data.setUser((User)usr);
        data.setTarget("Summary.vm");
    }
}

