/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import java.util.Collections;
import java.util.Map;
import org.apache.maven.continuum.configuration.ConfigurationService;
import org.apache.maven.continuum.model.system.ContinuumUser;
import org.apache.maven.continuum.model.system.UserGroup;
import org.apache.maven.continuum.store.ContinuumStore;
import org.codehaus.plexus.action.AbstractAction;
import org.codehaus.plexus.summit.rundata.RunData;
import org.codehaus.plexus.util.StringUtils;

public class InitializationChecker
extends AbstractAction {
    private ConfigurationService configuration;
    private ContinuumStore store;

    public void execute(Map map) throws Exception {
        boolean guestAccountEnabled;
        String companyUrl;
        String companyLogo;
        String baseUrl;
        ContinuumUser adminUser = new ContinuumUser();
        String username = this.getValue(map, "username");
        if (StringUtils.isEmpty((String)username)) {
            throw new Exception("You must set a username.");
        }
        adminUser.setUsername(username);
        String password = this.getValue(map, "password");
        if (StringUtils.isEmpty((String)password) || !password.equals(this.getValue(map, "password.two"))) {
            throw new Exception("Your password is incorrect.");
        }
        adminUser.setPassword(this.getValue(map, "password"));
        String fullName = this.getValue(map, "fullName");
        if (StringUtils.isEmpty((String)fullName)) {
            throw new Exception("You must set a full name.");
        }
        adminUser.setFullName(fullName);
        String email = this.getValue(map, "email");
        if (StringUtils.isEmpty((String)email)) {
            throw new Exception("You must set an email.");
        }
        adminUser.setEmail(email);
        adminUser.setGroup(this.store.getUserGroup("Continuum admin"));
        this.store.addUser(adminUser);
        String workingDirectory = this.getValue(map, "workingDirectory");
        if (StringUtils.isEmpty((String)workingDirectory)) {
            throw new Exception("You must set a working directory.");
        }
        this.configuration.setWorkingDirectory(this.configuration.getFile(workingDirectory));
        String buildOutputDirectory = this.getValue(map, "buildOutputDirectory");
        if (StringUtils.isEmpty((String)buildOutputDirectory)) {
            throw new Exception("You must set a build output directory.");
        }
        this.configuration.setBuildOutputDirectory(this.configuration.getFile(buildOutputDirectory));
        String deploymentRepositoryDirectory = this.getValue(map, "deploymentRepositoryDirectory");
        if (!StringUtils.isEmpty((String)deploymentRepositoryDirectory)) {
            this.configuration.setDeploymentRepositoryDirectory(this.configuration.getFile(deploymentRepositoryDirectory));
        }
        if (StringUtils.isEmpty((String)(baseUrl = this.getValue(map, "baseUrl")))) {
            throw new Exception("You must set a base Url.");
        }
        this.configuration.setUrl(baseUrl);
        String companyName = this.getValue(map, "companyName");
        if (!StringUtils.isEmpty((String)companyName)) {
            this.configuration.setCompanyName(companyName);
        }
        if (!StringUtils.isEmpty((String)(companyLogo = this.getValue(map, "companyLogo")))) {
            this.configuration.setCompanyLogo(companyLogo);
        }
        if (!StringUtils.isEmpty((String)(companyUrl = this.getValue(map, "companyUrl")))) {
            this.configuration.setCompanyUrl(companyUrl);
        }
        if (guestAccountEnabled = this.getBooleanValue(map, "guestAccountEnabled")) {
            this.configuration.setGuestAccountEnabled(guestAccountEnabled);
        } else {
            this.configuration.setGuestAccountEnabled(false);
            UserGroup guestGroup = this.store.getUserGroup("Continuum guest");
            guestGroup.setPermissions(Collections.EMPTY_LIST);
            this.store.updateUserGroup(guestGroup);
        }
        this.configuration.setInitialized(true);
        this.configuration.store();
        RunData data = (RunData)map.get("data");
        data.setTarget("ConfigureEnd.vm");
    }

    private String getValue(Map map, String param) {
        return (String)map.get(param);
    }

    private boolean getBooleanValue(Map map, String param) {
        return "on".equals((String)map.get(param));
    }
}

