/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.action;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ognl.Ognl;
import org.apache.maven.continuum.web.action.Call;
import org.codehaus.plexus.action.AbstractAction;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;

public class CallApplicationModel
extends AbstractAction
implements Initializable {
    private static String CID = "cid";
    private String applicationRole;
    private List calls;
    private Map callMap;

    public void execute(Map parameters) throws Exception {
        Object application = this.lookup(this.applicationRole);
        String cid = (String)parameters.get(CID);
        if (cid == null) {
            this.getLogger().error("We cannot call the application with a null CID!");
            return;
        }
        Call call = (Call)this.callMap.get(cid);
        if (call == null) {
            this.getLogger().error("There is no call with id = " + cid + "!");
            return;
        }
        String expression = call.getExpression();
        parameters.put("parameters", parameters);
        Ognl.getValue((String)expression, (Map)parameters, (Object)application);
    }

    public void initialize() {
        this.callMap = new HashMap();
        Iterator i = this.calls.iterator();
        while (i.hasNext()) {
            Call call = (Call)i.next();
            this.callMap.put(call.getCid(), call);
        }
    }
}

