/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import org.apache.maven.continuum.configuration.ConfigurationService;
import org.apache.maven.continuum.execution.ContinuumBuildExecutor;
import org.apache.maven.continuum.model.project.BuildDefinition;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.model.project.ProjectNotifier;
import org.apache.maven.continuum.model.scm.ScmResult;
import org.apache.maven.continuum.store.ContinuumObjectNotFoundException;
import org.apache.maven.continuum.store.ContinuumStore;
import org.apache.maven.continuum.store.ContinuumStoreException;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.plexus.jdo.DefaultConfigurableJdoFactory;
import org.codehaus.plexus.jdo.JdoFactory;
import org.jpox.SchemaTool;

public abstract class AbstractContinuumTest
extends PlexusTestCase {
    private ContinuumStore store;

    protected void setUp() throws Exception {
        super.setUp();
        this.getStore();
        AbstractContinuumTest.setUpConfigurationService((ConfigurationService)this.lookup(ConfigurationService.ROLE));
        Collection projectGroups = this.store.getAllProjectGroupsWithProjects();
        AbstractContinuumTest.assertEquals((int)0, (int)projectGroups.size());
        this.createDefaultProjectGroup();
        projectGroups = this.store.getAllProjectGroupsWithProjects();
        AbstractContinuumTest.assertEquals((int)1, (int)projectGroups.size());
    }

    protected void createDefaultProjectGroup() throws Exception {
        try {
            ProjectGroup group = this.getDefaultProjectGroup();
        }
        catch (ContinuumObjectNotFoundException e) {
            ProjectGroup group = new ProjectGroup();
            group.setName("Default Project Group");
            group.setGroupId("default");
            group.setDescription("Contains all projects that do not have a group of their own");
            group = this.store.addProjectGroup(group);
        }
    }

    public static void setUpConfigurationService(ConfigurationService configurationService) throws Exception {
        configurationService.load();
        configurationService.setBuildOutputDirectory(AbstractContinuumTest.getTestFile((String)"target/build-output"));
        configurationService.setWorkingDirectory(AbstractContinuumTest.getTestFile((String)"target/working-directory"));
        configurationService.store();
    }

    protected ProjectGroup getDefaultProjectGroup() throws ContinuumStoreException {
        return this.store.getProjectGroupByGroupIdWithProjects("default");
    }

    protected ContinuumStore getStore() throws Exception {
        if (this.store != null) {
            return this.store;
        }
        Object o = this.lookup(JdoFactory.ROLE, "continuum");
        AbstractContinuumTest.assertEquals((String)DefaultConfigurableJdoFactory.class.getName(), (String)o.getClass().getName());
        DefaultConfigurableJdoFactory jdoFactory = (DefaultConfigurableJdoFactory)o;
        jdoFactory.setPersistenceManagerFactoryClass("org.jpox.PersistenceManagerFactoryImpl");
        jdoFactory.setDriverName("org.hsqldb.jdbcDriver");
        jdoFactory.setUrl("jdbc:hsqldb:mem:" + ((Object)((Object)this)).getClass().getName() + "." + this.getName());
        jdoFactory.setUserName("sa");
        jdoFactory.setPassword("");
        jdoFactory.setProperty("org.jpox.transactionIsolation", "READ_UNCOMMITTED");
        jdoFactory.setProperty("org.jpox.poid.transactionIsolation", "READ_UNCOMMITTED");
        jdoFactory.setProperty("org.jpox.autoCreateTables", "true");
        Properties properties = jdoFactory.getProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            System.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        SchemaTool.createSchemaTables((URL[])new URL[]{((Object)((Object)this)).getClass().getResource("/META-INF/package.jdo")}, (URL[])new URL[0], null, (boolean)false, null);
        PersistenceManagerFactory pmf = jdoFactory.getPersistenceManagerFactory();
        AbstractContinuumTest.assertNotNull((Object)pmf);
        PersistenceManager pm = pmf.getPersistenceManager();
        pm.close();
        this.store = (ContinuumStore)this.lookup(ContinuumStore.ROLE, "jdo");
        return this.store;
    }

    protected ContinuumBuildExecutor getBuildExecutor(String id) throws Exception {
        ContinuumBuildExecutor buildExecutor = (ContinuumBuildExecutor)this.lookup(ContinuumBuildExecutor.ROLE, id);
        AbstractContinuumTest.assertNotNull((String)("Could not look up build executor '" + id + "'"), (Object)buildExecutor);
        return buildExecutor;
    }

    public static Project makeStubProject(String name) {
        return AbstractContinuumTest.makeProject(name, "foo@bar.com", "1.0");
    }

    public static Project makeProject(String name, String emailAddress, String version) {
        Project project = new Project();
        AbstractContinuumTest.makeProject(project, name, version);
        List notifiers = AbstractContinuumTest.createMailNotifierList(emailAddress);
        project.setNotifiers(notifiers);
        return project;
    }

    public static Project makeStubShellProject(String name, String script) {
        Project project = new Project();
        AbstractContinuumTest.makeProject(project, name, "1.0");
        project.setExecutorId("shell");
        BuildDefinition def = new BuildDefinition();
        def.setBuildFile(script);
        project.addBuildDefinition(def);
        return project;
    }

    public static Project makeProject(Project project, String name, String version) {
        project.setExecutorId("maven2");
        project.setName(name);
        project.setVersion(version);
        return project;
    }

    protected static List createMailNotifierList(String emailAddress) {
        if (emailAddress == null) {
            return null;
        }
        ProjectNotifier notifier = new ProjectNotifier();
        notifier.setType("mail");
        Properties props = new Properties();
        props.put("address", emailAddress);
        notifier.setConfiguration((Map)props);
        ArrayList<ProjectNotifier> notifiers = new ArrayList<ProjectNotifier>();
        notifiers.add(notifier);
        return notifiers;
    }

    public Project addProject(ContinuumStore store, Project project) throws Exception {
        ProjectGroup defaultProjectGroup = this.getDefaultProjectGroup();
        ScmResult scmResult = new ScmResult();
        scmResult.setSuccess(true);
        scmResult.setCommandOutput("commandOutput");
        scmResult.setProviderMessage("providerMessage");
        project.setCheckoutResult(scmResult);
        defaultProjectGroup.addProject(project);
        store.updateProjectGroup(defaultProjectGroup);
        project = store.getProject(project.getId());
        AbstractContinuumTest.assertNotNull((String)"project group == null", (Object)project.getProjectGroup());
        return project;
    }

    public Project addProject(ContinuumStore store, String name) throws Exception {
        return this.addProject(store, AbstractContinuumTest.makeStubProject(name));
    }

    public Project addProject(ContinuumStore store, String name, String nagEmailAddress, String version) throws Exception {
        return this.addProject(store, AbstractContinuumTest.makeProject(name, nagEmailAddress, version));
    }

    public static void setCheckoutDone(ContinuumStore store, Project project, ScmResult scmResult) throws ContinuumStoreException {
        project.setCheckoutResult(scmResult);
        store.updateProject(project);
    }

    public void assertProjectEquals(Project expected, Project actual) {
        this.assertProjectEquals(expected.getName(), expected.getNotifiers(), expected.getVersion(), actual);
    }

    public void assertProjectEquals(String name, String emailAddress, String version, Project actual) {
        this.assertProjectEquals(name, AbstractContinuumTest.createMailNotifierList(emailAddress), version, actual);
    }

    public void assertProjectEquals(String name, List notifiers, String version, Project actual) {
        AbstractContinuumTest.assertEquals((String)"project.name", (String)name, (String)actual.getName());
        if (notifiers != null) {
            AbstractContinuumTest.assertNotNull((String)"project.notifiers", (Object)actual.getNotifiers());
            AbstractContinuumTest.assertEquals((String)"project.notifiers.size", (int)notifiers.size(), (int)actual.getNotifiers().size());
            for (int i = 0; i < notifiers.size(); ++i) {
                ProjectNotifier notifier = (ProjectNotifier)notifiers.get(i);
                ProjectNotifier actualNotifier = (ProjectNotifier)actual.getNotifiers().get(i);
                AbstractContinuumTest.assertEquals((String)"project.notifiers.notifier.type", (String)notifier.getType(), (String)actualNotifier.getType());
                AbstractContinuumTest.assertEquals((String)"project.notifiers.notifier.configuration.address", notifier.getConfiguration().get("address"), actualNotifier.getConfiguration().get("address"));
            }
        }
        AbstractContinuumTest.assertEquals((String)"project.version", (String)version, (String)actual.getVersion());
    }

    public ProjectGroup createStubProjectGroup(String name, String description) {
        ProjectGroup projectGroup = new ProjectGroup();
        projectGroup.setName(name);
        projectGroup.setDescription(description);
        return projectGroup;
    }
}

