/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.store;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.jdo.JDODetachedFieldAccessException;
import org.apache.maven.continuum.model.project.BuildDefinition;
import org.apache.maven.continuum.model.project.BuildResult;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectDependency;
import org.apache.maven.continuum.model.project.ProjectDeveloper;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.model.project.ProjectNotifier;
import org.apache.maven.continuum.model.project.Schedule;
import org.apache.maven.continuum.model.system.Installation;
import org.apache.maven.continuum.model.system.Profile;
import org.apache.maven.continuum.store.AbstractContinuumStoreTestCase;
import org.apache.maven.continuum.store.ContinuumObjectNotFoundException;
import org.apache.maven.continuum.store.ContinuumStoreException;

public class ContinuumStoreTest
extends AbstractContinuumStoreTestCase {
    private static final int INVALID_ID = 15000;

    public void testAddProjectGroup() throws ContinuumStoreException {
        String name = "testAddProjectGroup";
        String description = "testAddProjectGroup description";
        String groupId = "org.apache.maven.continuum.test";
        ProjectGroup group = ContinuumStoreTest.createTestProjectGroup(name, description, groupId);
        ProjectGroup copy = ContinuumStoreTest.createTestProjectGroup(group);
        this.store.addProjectGroup(group);
        copy.setId(group.getId());
        ProjectGroup retrievedGroup = this.store.getProjectGroup(group.getId());
        ContinuumStoreTest.assertProjectGroupEquals(copy, retrievedGroup);
    }

    public void testGetProjectGroup() throws ContinuumStoreException {
        ProjectGroup retrievedGroup = this.store.getProjectGroupWithProjects(this.defaultProjectGroup.getId());
        ContinuumStoreTest.assertProjectGroupEquals(this.defaultProjectGroup, retrievedGroup);
        List projects = retrievedGroup.getProjects();
        ContinuumStoreTest.assertEquals((String)"Check number of projects", (int)2, (int)projects.size());
        ContinuumStoreTest.assertTrue((String)"Check existence of project 1", (boolean)projects.contains(this.testProject1));
        ContinuumStoreTest.assertTrue((String)"Check existence of project 2", (boolean)projects.contains(this.testProject2));
        ContinuumStoreTest.checkProjectGroupDefaultFetchGroup(retrievedGroup);
        Project project = (Project)projects.get(0);
        ContinuumStoreTest.checkProjectDefaultFetchGroup(project);
        ContinuumStoreTest.assertEquals((int)project.getProjectGroup().getId(), (int)retrievedGroup.getId());
        ContinuumStoreTest.assertProjectEquals(this.testProject1, project);
        project = (Project)projects.get(1);
        ContinuumStoreTest.checkProjectDefaultFetchGroup(project);
        ContinuumStoreTest.assertEquals((int)project.getProjectGroup().getId(), (int)retrievedGroup.getId());
        ContinuumStoreTest.assertProjectEquals(this.testProject2, project);
    }

    public void testGetInvalidProjectGroup() throws ContinuumStoreException {
        try {
            this.store.getProjectGroup(15000);
            ContinuumStoreTest.fail((String)"Should not find group with invalid ID");
        }
        catch (ContinuumObjectNotFoundException expected) {
            ContinuumStoreTest.assertTrue((boolean)true);
        }
    }

    public void testEditProjectGroup() throws ContinuumStoreException {
        ProjectGroup newGroup = this.store.getProjectGroup(this.testProjectGroup2.getId());
        newGroup.setName("testEditProjectGroup2");
        newGroup.setDescription("testEditProjectGroup updated description");
        newGroup.setGroupId("org.apache.maven.continuum.test.new");
        ProjectGroup copy = ContinuumStoreTest.createTestProjectGroup(newGroup);
        copy.setId(newGroup.getId());
        this.store.updateProjectGroup(newGroup);
        ProjectGroup retrievedGroup = this.store.getProjectGroup(this.testProjectGroup2.getId());
        ContinuumStoreTest.assertProjectGroupEquals(copy, retrievedGroup);
    }

    public void testUpdateUndetachedGroup() {
        ProjectGroup newGroup = new ProjectGroup();
        newGroup.setId(this.testProjectGroup2.getId());
        newGroup.setName("testUpdateUndetachedGroup2");
        newGroup.setDescription("testUpdateUndetachedGroup updated description");
        newGroup.setGroupId("org.apache.maven.continuum.test.new");
        try {
            this.store.updateProjectGroup(newGroup);
            ContinuumStoreTest.fail((String)"Should not have succeeded");
        }
        catch (ContinuumStoreException expected) {
            ContinuumStoreTest.assertTrue((boolean)true);
        }
    }

    public void testGetAllProjectGroups() {
        Collection groups = this.store.getAllProjectGroupsWithProjects();
        ContinuumStoreTest.assertEquals((String)"check size", (int)2, (int)groups.size());
        ContinuumStoreTest.assertTrue((boolean)groups.contains(this.defaultProjectGroup));
        ContinuumStoreTest.assertTrue((boolean)groups.contains(this.testProjectGroup2));
        for (ProjectGroup group : groups) {
            List projects = group.getProjects();
            if (group.getId() == this.testProjectGroup2.getId()) {
                ContinuumStoreTest.assertProjectGroupEquals(this.testProjectGroup2, group);
                ContinuumStoreTest.assertTrue((String)"check no projects", (boolean)projects.isEmpty());
                continue;
            }
            if (group.getId() != this.defaultProjectGroup.getId()) continue;
            ContinuumStoreTest.assertProjectGroupEquals(this.defaultProjectGroup, group);
            ContinuumStoreTest.assertEquals((String)"Check number of projects", (int)2, (int)projects.size());
            ContinuumStoreTest.assertTrue((String)"Check existence of project 1", (boolean)projects.contains(this.testProject1));
            ContinuumStoreTest.assertTrue((String)"Check existence of project 2", (boolean)projects.contains(this.testProject2));
            ContinuumStoreTest.checkProjectGroupDefaultFetchGroup(group);
            Project p = (Project)projects.get(0);
            ContinuumStoreTest.checkProjectDefaultFetchGroup(p);
            ContinuumStoreTest.assertSame((String)"Check project group reference matches", (Object)p.getProjectGroup(), (Object)group);
        }
    }

    public void testGetProject() throws ContinuumStoreException {
        Project retrievedProject = this.store.getProject(this.testProject1.getId());
        ContinuumStoreTest.assertProjectEquals(this.testProject1, retrievedProject);
        ContinuumStoreTest.checkProjectDefaultFetchGroup(retrievedProject);
    }

    public void testGetProjectWithDetails() throws ContinuumStoreException {
        Project retrievedProject = this.store.getProjectWithAllDetails(this.testProject1.getId());
        ContinuumStoreTest.assertProjectEquals(this.testProject1, retrievedProject);
        ContinuumStoreTest.checkProjectFetchGroup(retrievedProject, false, false, true, true);
        ContinuumStoreTest.assertBuildDefinitionsEqual(retrievedProject.getBuildDefinitions(), this.testProject1.getBuildDefinitions());
        ContinuumStoreTest.assertNotifiersEqual(this.testProject1.getNotifiers(), retrievedProject.getNotifiers());
        ContinuumStoreTest.assertDevelopersEqual(this.testProject1.getDevelopers(), retrievedProject.getDevelopers());
        ContinuumStoreTest.assertDependenciesEqual(this.testProject1.getDependencies(), retrievedProject.getDependencies());
    }

    public void testGetProjectWithCheckoutResult() throws ContinuumStoreException {
        Project retrievedProject = this.store.getProjectWithCheckoutResult(this.testProject1.getId());
        ContinuumStoreTest.assertProjectEquals(this.testProject1, retrievedProject);
        ContinuumStoreTest.assertScmResultEquals(this.testCheckoutResult1, retrievedProject.getCheckoutResult());
        ContinuumStoreTest.checkProjectFetchGroup(retrievedProject, true, false, false, false);
    }

    public void testGetInvalidProject() throws ContinuumStoreException {
        try {
            this.store.getProject(15000);
            ContinuumStoreTest.fail((String)"Should not find project with invalid ID");
        }
        catch (ContinuumObjectNotFoundException expected) {
            ContinuumStoreTest.assertTrue((boolean)true);
        }
    }

    public void testEditProject() throws ContinuumStoreException {
        Project newProject = this.store.getProject(this.testProject2.getId());
        newProject.setName("testEditProject2");
        newProject.setDescription("testEditProject updated description");
        newProject.setGroupId("org.apache.maven.continuum.test.new");
        Project copy = ContinuumStoreTest.createTestProject(newProject);
        copy.setId(newProject.getId());
        this.store.updateProject(newProject);
        Project retrievedProject = this.store.getProject(this.testProject2.getId());
        ContinuumStoreTest.assertProjectEquals(copy, retrievedProject);
    }

    public void testUpdateUndetachedProject() {
        Project newProject = new Project();
        newProject.setId(this.testProject2.getId());
        newProject.setName("testUpdateUndetached2");
        newProject.setDescription("testUpdateUndetached updated description");
        newProject.setGroupId("org.apache.maven.continuum.test.new");
        try {
            this.store.updateProject(newProject);
            ContinuumStoreTest.fail((String)"Should not have succeeded");
        }
        catch (ContinuumStoreException expected) {
            ContinuumStoreTest.assertTrue((boolean)true);
        }
    }

    public void testGetAllProjects() {
        List projects = this.store.getAllProjectsByName();
        ContinuumStoreTest.assertEquals((String)"check items", Arrays.asList(this.testProject1, this.testProject2), (Object)projects);
        Project project = (Project)projects.get(1);
        ContinuumStoreTest.assertProjectEquals(this.testProject2, project);
        ContinuumStoreTest.checkProjectDefaultFetchGroup(project);
        ContinuumStoreTest.assertNotNull((String)"Check project group reference matches", (Object)project.getProjectGroup());
    }

    public void testAddSchedule() {
        Schedule newSchedule = ContinuumStoreTest.createTestSchedule("testAddSchedule", "testAddSchedule desc", 10, "cron test", false);
        Schedule copy = ContinuumStoreTest.createTestSchedule(newSchedule);
        this.store.addSchedule(newSchedule);
        copy.setId(newSchedule.getId());
        List schedules = this.store.getAllSchedulesByName();
        Schedule retrievedSchedule = (Schedule)schedules.get(schedules.size() - 1);
        ContinuumStoreTest.assertScheduleEquals(copy, retrievedSchedule);
    }

    public void testEditSchedule() throws ContinuumStoreException {
        Schedule newSchedule = (Schedule)this.store.getAllSchedulesByName().get(0);
        newSchedule.setName("name1.1");
        newSchedule.setDescription("testEditSchedule updated description");
        Schedule copy = ContinuumStoreTest.createTestSchedule(newSchedule);
        copy.setId(newSchedule.getId());
        this.store.updateSchedule(newSchedule);
        Schedule retrievedSchedule = (Schedule)this.store.getAllSchedulesByName().get(0);
        ContinuumStoreTest.assertScheduleEquals(copy, retrievedSchedule);
    }

    public void testRemoveSchedule() {
        Schedule schedule = (Schedule)this.store.getAllSchedulesByName().get(2);
        this.store.removeSchedule(schedule);
        List schedules = this.store.getAllSchedulesByName();
        ContinuumStoreTest.assertEquals((String)"check size", (int)2, (int)schedules.size());
        ContinuumStoreTest.assertFalse((String)"check not there", (boolean)schedules.contains(schedule));
    }

    public void testGetAllSchedules() {
        List schedules = this.store.getAllSchedulesByName();
        ContinuumStoreTest.assertEquals((String)"check item count", (int)3, (int)schedules.size());
        Schedule schedule = (Schedule)schedules.get(0);
        ContinuumStoreTest.assertScheduleEquals(this.testSchedule1, schedule);
        schedule = (Schedule)schedules.get(1);
        ContinuumStoreTest.assertScheduleEquals(this.testSchedule2, schedule);
        schedule = (Schedule)schedules.get(2);
        ContinuumStoreTest.assertScheduleEquals(this.testSchedule3, schedule);
    }

    public void testAddProfile() throws Exception {
        List installations = this.store.getAllInstallations();
        Profile newProfile = ContinuumStoreTest.createTestProfile("testAddProfile", "testAddProfile desc", 5, false, false, (Installation)installations.get(1), (Installation)installations.get(2));
        Profile copy = ContinuumStoreTest.createTestProfile(newProfile);
        this.store.addProfile(newProfile);
        copy.setId(newProfile.getId());
        List profiles = this.store.getAllProfilesByName();
        Profile retrievedProfile = (Profile)profiles.get(profiles.size() - 1);
        ContinuumStoreTest.assertProfileEquals(copy, retrievedProfile);
        ContinuumStoreTest.assertInstallationEquals(this.testInstallationMaven20a3, retrievedProfile.getBuilder());
        ContinuumStoreTest.assertInstallationEquals(this.testInstallationJava14, retrievedProfile.getJdk());
    }

    public void testEditProfile() throws ContinuumStoreException {
        Profile newProfile = (Profile)this.store.getAllProfilesByName().get(0);
        newProfile.setName("name1.1");
        newProfile.setDescription("testEditProfile updated description");
        Profile copy = ContinuumStoreTest.createTestProfile(newProfile);
        copy.setId(newProfile.getId());
        this.store.updateProfile(newProfile);
        Profile retrievedProfile = (Profile)this.store.getAllProfilesByName().get(0);
        ContinuumStoreTest.assertProfileEquals(copy, retrievedProfile);
        ContinuumStoreTest.assertInstallationEquals(copy.getBuilder(), retrievedProfile.getBuilder());
        ContinuumStoreTest.assertInstallationEquals(copy.getJdk(), retrievedProfile.getJdk());
    }

    public void testRemoveProfile() {
        Profile profile = (Profile)this.store.getAllProfilesByName().get(2);
        this.store.removeProfile(profile);
        List profiles = this.store.getAllProfilesByName();
        ContinuumStoreTest.assertEquals((String)"check size", (int)2, (int)profiles.size());
        ContinuumStoreTest.assertFalse((String)"check not there", (boolean)profiles.contains(profile));
    }

    public void testGetAllProfiles() {
        List profiles = this.store.getAllProfilesByName();
        ContinuumStoreTest.assertEquals((String)"check item count", (int)3, (int)profiles.size());
        Profile profile = (Profile)profiles.get(0);
        ContinuumStoreTest.assertProfileEquals(this.testProfile1, profile);
        ContinuumStoreTest.assertInstallationEquals(this.testProfile1.getBuilder(), profile.getBuilder());
        ContinuumStoreTest.assertInstallationEquals(this.testProfile1.getJdk(), profile.getJdk());
        profile = (Profile)profiles.get(1);
        ContinuumStoreTest.assertProfileEquals(this.testProfile2, profile);
        ContinuumStoreTest.assertInstallationEquals(this.testProfile2.getBuilder(), profile.getBuilder());
        ContinuumStoreTest.assertInstallationEquals(this.testProfile2.getJdk(), profile.getJdk());
        profile = (Profile)profiles.get(2);
        ContinuumStoreTest.assertProfileEquals(this.testProfile3, profile);
        ContinuumStoreTest.assertInstallationEquals(this.testProfile3.getBuilder(), profile.getBuilder());
        ContinuumStoreTest.assertInstallationEquals(this.testProfile3.getJdk(), profile.getJdk());
    }

    public void testGetAllInstallations() throws Exception {
        List installations = this.store.getAllInstallations();
        ContinuumStoreTest.assertEquals((String)"check item count", (int)3, (int)installations.size());
        Installation installation = (Installation)installations.get(0);
        ContinuumStoreTest.assertInstallationEquals(this.testInstallationJava13, installation);
        installation = (Installation)installations.get(1);
        ContinuumStoreTest.assertInstallationEquals(this.testInstallationJava14, installation);
        installation = (Installation)installations.get(2);
        ContinuumStoreTest.assertInstallationEquals(this.testInstallationMaven20a3, installation);
    }

    public void testUpdateInstallation() throws Exception {
        String name = "installationTest";
        Installation testOne = ContinuumStoreTest.createTestInstallation(name, "jdk", "varName", "varValue");
        testOne = this.store.addInstallation(testOne);
        Installation fromStore = this.store.getInstallation(testOne.getInstallationId());
        ContinuumStoreTest.assertInstallationEquals(testOne, fromStore);
        fromStore.setVarName("JAVA_HOME");
        fromStore.setVarValue("/usr/local/jdk1.5.0_08");
        this.store.updateInstallation(fromStore);
        Installation updatedFromStore = this.store.getInstallation(testOne.getInstallationId());
        ContinuumStoreTest.assertInstallationEquals(fromStore, updatedFromStore);
    }

    public void testRemoveInstallation() throws Exception {
        String name = "installationTestRemove";
        Installation testOne = ContinuumStoreTest.createTestInstallation(name, "jdk", "varName", "varValue");
        testOne = this.store.addInstallation(testOne);
        this.store.removeInstallation(testOne);
        Installation fromStore = this.store.getInstallation(testOne.getInstallationId());
        ContinuumStoreTest.assertNull((Object)fromStore);
    }

    public void testRemoveLinkedInstallations() throws Exception {
        String nameFirstInst = "linkedFirstInstallationTestRemove";
        String nameSecondInst = "linkedSecondInstallationTestRemove";
        String nameFirstEnvVar = "firstEnvVar";
        String nameSecondEnvVar = "secondEnvVar";
        Installation testOne = ContinuumStoreTest.createTestInstallation(nameFirstInst, "jdk", "varName", "varValue");
        Installation testTwo = ContinuumStoreTest.createTestInstallation(nameSecondInst, "maven2", "varName", "varValue");
        Installation firstEnvVar = ContinuumStoreTest.createTestInstallation(nameFirstEnvVar, "maven2", "varName", "varValue");
        Installation secondEnvVar = ContinuumStoreTest.createTestInstallation(nameSecondEnvVar, "maven2", "varName", "varValue");
        testOne = this.store.addInstallation(testOne);
        testTwo = this.store.addInstallation(testTwo);
        firstEnvVar = this.store.addInstallation(firstEnvVar);
        secondEnvVar = this.store.addInstallation(secondEnvVar);
        ArrayList<Installation> envVars = new ArrayList<Installation>(2);
        envVars.add(firstEnvVar);
        envVars.add(secondEnvVar);
        Profile firstProfile = ContinuumStoreTest.createTestProfile("first", "", 1, true, true, testOne, testTwo, envVars);
        Profile secondProfile = ContinuumStoreTest.createTestProfile("first", "", 1, true, true, testOne, testTwo, envVars);
        firstProfile = this.store.addProfile(firstProfile);
        secondProfile = this.store.addProfile(secondProfile);
        Profile firstGetted = this.store.getProfile(firstProfile.getId());
        Profile secondGetted = this.store.getProfile(secondProfile.getId());
        ContinuumStoreTest.assertNotNull((Object)firstGetted);
        ContinuumStoreTest.assertNotNull((Object)firstGetted.getJdk());
        ContinuumStoreTest.assertEquals((String)nameFirstInst, (String)firstGetted.getJdk().getName());
        ContinuumStoreTest.assertNotNull((Object)secondGetted);
        ContinuumStoreTest.assertNotNull((Object)secondGetted.getJdk());
        ContinuumStoreTest.assertEquals((String)nameFirstInst, (String)secondGetted.getJdk().getName());
        ContinuumStoreTest.assertNotNull((Object)firstGetted.getBuilder());
        ContinuumStoreTest.assertEquals((String)nameSecondInst, (String)firstGetted.getBuilder().getName());
        ContinuumStoreTest.assertEquals((int)2, (int)firstGetted.getEnvironmentVariables().size());
        ContinuumStoreTest.assertNotNull((Object)secondGetted.getBuilder());
        ContinuumStoreTest.assertEquals((String)nameSecondInst, (String)secondGetted.getBuilder().getName());
        ContinuumStoreTest.assertEquals((int)2, (int)secondGetted.getEnvironmentVariables().size());
        this.store.removeInstallation(testOne);
        Installation fromStore = this.store.getInstallation(testOne.getInstallationId());
        ContinuumStoreTest.assertNull((Object)fromStore);
        firstGetted = this.store.getProfile(firstProfile.getId());
        secondGetted = this.store.getProfile(secondProfile.getId());
        ContinuumStoreTest.assertNotNull((Object)firstGetted);
        ContinuumStoreTest.assertNull((Object)firstGetted.getJdk());
        ContinuumStoreTest.assertNotNull((Object)firstGetted.getBuilder());
        ContinuumStoreTest.assertEquals((int)2, (int)firstGetted.getEnvironmentVariables().size());
        ContinuumStoreTest.assertNotNull((Object)secondGetted);
        ContinuumStoreTest.assertNull((Object)secondGetted.getJdk());
        ContinuumStoreTest.assertNotNull((Object)secondGetted.getBuilder());
        ContinuumStoreTest.assertEquals((int)2, (int)secondGetted.getEnvironmentVariables().size());
        this.store.removeInstallation(testTwo);
        firstGetted = this.store.getProfile(firstProfile.getId());
        secondGetted = this.store.getProfile(secondProfile.getId());
        ContinuumStoreTest.assertNotNull((Object)firstGetted);
        ContinuumStoreTest.assertNull((Object)firstGetted.getJdk());
        ContinuumStoreTest.assertNull((Object)firstGetted.getBuilder());
        ContinuumStoreTest.assertEquals((int)2, (int)firstGetted.getEnvironmentVariables().size());
        ContinuumStoreTest.assertNotNull((Object)secondGetted);
        ContinuumStoreTest.assertNull((Object)secondGetted.getJdk());
        ContinuumStoreTest.assertNull((Object)secondGetted.getBuilder());
        ContinuumStoreTest.assertEquals((int)2, (int)secondGetted.getEnvironmentVariables().size());
        this.store.removeInstallation(firstEnvVar);
        firstGetted = this.store.getProfile(firstProfile.getId());
        secondGetted = this.store.getProfile(secondProfile.getId());
        ContinuumStoreTest.assertNotNull((Object)firstGetted);
        ContinuumStoreTest.assertNull((Object)firstGetted.getJdk());
        ContinuumStoreTest.assertNull((Object)firstGetted.getBuilder());
        ContinuumStoreTest.assertEquals((int)1, (int)firstGetted.getEnvironmentVariables().size());
        Installation env = (Installation)firstGetted.getEnvironmentVariables().get(0);
        ContinuumStoreTest.assertEquals((String)nameSecondEnvVar, (String)env.getName());
        ContinuumStoreTest.assertNotNull((Object)secondGetted);
        ContinuumStoreTest.assertNull((Object)secondGetted.getJdk());
        ContinuumStoreTest.assertNull((Object)secondGetted.getBuilder());
        ContinuumStoreTest.assertEquals((int)1, (int)secondGetted.getEnvironmentVariables().size());
        env = (Installation)secondGetted.getEnvironmentVariables().get(0);
        ContinuumStoreTest.assertEquals((String)nameSecondEnvVar, (String)env.getName());
        this.store.removeInstallation(secondEnvVar);
        firstGetted = this.store.getProfile(firstProfile.getId());
        secondGetted = this.store.getProfile(secondProfile.getId());
        ContinuumStoreTest.assertNotNull((Object)firstGetted);
        ContinuumStoreTest.assertNull((Object)firstGetted.getJdk());
        ContinuumStoreTest.assertNull((Object)firstGetted.getBuilder());
        ContinuumStoreTest.assertEquals((int)0, (int)firstGetted.getEnvironmentVariables().size());
        ContinuumStoreTest.assertNotNull((Object)secondGetted);
        ContinuumStoreTest.assertNull((Object)secondGetted.getJdk());
        ContinuumStoreTest.assertNull((Object)secondGetted.getBuilder());
        ContinuumStoreTest.assertEquals((int)0, (int)secondGetted.getEnvironmentVariables().size());
    }

    public void testDeleteProject() throws ContinuumStoreException {
        Project project = this.store.getProjectWithBuilds(this.testProject1.getId());
        this.store.removeProject(project);
        ProjectGroup projectGroup = this.store.getProjectGroupWithProjects(this.defaultProjectGroup.getId());
        ContinuumStoreTest.assertEquals((String)"check size is now 1", (int)1, (int)projectGroup.getProjects().size());
        ContinuumStoreTest.assertProjectEquals(this.testProject2, (Project)projectGroup.getProjects().get(0));
        this.confirmProjectDeletion(this.testProject1);
    }

    public void testDeleteProjectGroup() throws ContinuumStoreException {
        this.store.removeProjectGroup(this.store.getProjectGroup(this.defaultProjectGroup.getId()));
        try {
            this.store.getProjectGroup(this.defaultProjectGroup.getId());
            ContinuumStoreTest.fail((String)"Project group was not deleted");
        }
        catch (ContinuumObjectNotFoundException expected) {
            ContinuumStoreTest.assertTrue((boolean)true);
        }
        this.confirmProjectDeletion(this.testProject1);
        this.confirmProjectDeletion(this.testProject2);
    }

    public void testDeleteBuildResult() throws ContinuumStoreException {
        Project project = this.store.getProjectWithBuilds(this.testProject1.getId());
        Iterator i = project.getBuildResults().iterator();
        while (i.hasNext()) {
            BuildResult result = (BuildResult)i.next();
            if (result.getId() != this.testBuildResult1.getId()) continue;
            i.remove();
        }
        this.store.updateProject(project);
        project = this.store.getProjectWithBuilds(this.testProject1.getId());
        ContinuumStoreTest.assertEquals((String)"check size is now 1", (int)1, (int)project.getBuildResults().size());
        ContinuumStoreTest.assertBuildResultEquals(this.testBuildResult2, (BuildResult)project.getBuildResults().get(0));
        List results = this.store.getAllBuildsForAProjectByDate(this.testProject1.getId());
        ContinuumStoreTest.assertEquals((String)"check item count", (int)1, (int)results.size());
        ContinuumStoreTest.assertBuildResultEquals(this.testBuildResult2, (BuildResult)results.get(0));
    }

    public void testGetInvalidBuildResult() throws ContinuumStoreException {
        try {
            this.store.getBuildResult(15000);
            ContinuumStoreTest.fail((String)"Should not find build result with invalid ID");
        }
        catch (ContinuumObjectNotFoundException expected) {
            ContinuumStoreTest.assertTrue((boolean)true);
        }
    }

    public void testGetAllBuildsForAProject() {
        List results = this.store.getAllBuildsForAProjectByDate(this.testProject1.getId());
        ContinuumStoreTest.assertEquals((String)"check item count", (int)2, (int)results.size());
        BuildResult buildResult = (BuildResult)results.get(0);
        ContinuumStoreTest.assertBuildResultEquals(this.testBuildResult2, buildResult);
        ContinuumStoreTest.assertProjectEquals(this.testProject1, buildResult.getProject());
        ContinuumStoreTest.checkBuildResultDefaultFetchGroup(buildResult);
        buildResult = (BuildResult)results.get(1);
        ContinuumStoreTest.assertBuildResultEquals(this.testBuildResult1, buildResult);
        ContinuumStoreTest.assertProjectEquals(this.testProject1, buildResult.getProject());
        ContinuumStoreTest.checkBuildResultDefaultFetchGroup(buildResult);
    }

    public void testGetBuildResult() throws ContinuumStoreException {
        BuildResult buildResult = this.store.getBuildResult(this.testBuildResult3.getId());
        ContinuumStoreTest.assertBuildResultEquals(this.testBuildResult3, buildResult);
        ContinuumStoreTest.assertScmResultEquals(this.testBuildResult3.getScmResult(), buildResult.getScmResult());
        ContinuumStoreTest.assertProjectEquals(this.testProject2, buildResult.getProject());
    }

    public void testGetProjectGroupWithDetails() throws ContinuumStoreException {
        ProjectGroup retrievedGroup = this.store.getProjectGroupWithBuildDetailsByProjectGroupId(this.defaultProjectGroup.getId());
        ContinuumStoreTest.assertProjectGroupEquals(this.defaultProjectGroup, retrievedGroup);
        ContinuumStoreTest.assertNotifiersEqual(this.defaultProjectGroup.getNotifiers(), retrievedGroup.getNotifiers());
        ContinuumStoreTest.assertBuildDefinitionsEqual(retrievedGroup.getBuildDefinitions(), this.defaultProjectGroup.getBuildDefinitions());
        List projects = retrievedGroup.getProjects();
        ContinuumStoreTest.assertEquals((String)"Check number of projects", (int)2, (int)projects.size());
        Project project = (Project)projects.get(0);
        ContinuumStoreTest.checkProjectFetchGroup(project, false, false, true, false);
        ContinuumStoreTest.assertEquals((int)project.getProjectGroup().getId(), (int)retrievedGroup.getId());
        ContinuumStoreTest.assertProjectEquals(this.testProject1, project);
        ContinuumStoreTest.assertNotifiersEqual(this.testProject1.getNotifiers(), project.getNotifiers());
        ContinuumStoreTest.assertBuildDefinitionsEqual(project.getBuildDefinitions(), this.testProject1.getBuildDefinitions());
        project = (Project)projects.get(1);
        ContinuumStoreTest.checkProjectFetchGroup(project, false, false, true, false);
        ContinuumStoreTest.assertEquals((int)project.getProjectGroup().getId(), (int)retrievedGroup.getId());
        ContinuumStoreTest.assertProjectEquals(this.testProject2, project);
        ContinuumStoreTest.assertNotifiersEqual(this.testProject2.getNotifiers(), project.getNotifiers());
        ContinuumStoreTest.assertBuildDefinitionsEqual(project.getBuildDefinitions(), this.testProject2.getBuildDefinitions());
    }

    public void testGetAllProjectsGroupWithDetails() {
        List projectGroups = this.store.getAllProjectGroupsWithBuildDetails();
        ProjectGroup group1 = (ProjectGroup)projectGroups.get(0);
        ContinuumStoreTest.assertProjectGroupEquals(this.defaultProjectGroup, group1);
        ContinuumStoreTest.assertNotifiersEqual(this.defaultProjectGroup.getNotifiers(), group1.getNotifiers());
        ContinuumStoreTest.assertBuildDefinitionsEqual(group1.getBuildDefinitions(), this.defaultProjectGroup.getBuildDefinitions());
        ProjectGroup group2 = (ProjectGroup)projectGroups.get(1);
        ContinuumStoreTest.assertProjectGroupEquals(this.testProjectGroup2, group2);
        ContinuumStoreTest.assertNotifiersEqual(this.testProjectGroup2.getNotifiers(), group2.getNotifiers());
        ContinuumStoreTest.assertBuildDefinitionsEqual(group2.getBuildDefinitions(), this.testProjectGroup2.getBuildDefinitions());
        List projects = group1.getProjects();
        ContinuumStoreTest.assertEquals((String)"Check number of projects", (int)2, (int)projects.size());
        Project project = (Project)projects.get(0);
        ContinuumStoreTest.checkProjectFetchGroup(project, false, false, true, false);
        ContinuumStoreTest.assertSame((String)"Check project group reference matches", (Object)project.getProjectGroup(), (Object)group1);
        ContinuumStoreTest.assertProjectEquals(this.testProject1, project);
        ContinuumStoreTest.assertNotifiersEqual(this.testProject1.getNotifiers(), project.getNotifiers());
        ContinuumStoreTest.assertBuildDefinitionsEqual(project.getBuildDefinitions(), this.testProject1.getBuildDefinitions());
        project = (Project)projects.get(1);
        ContinuumStoreTest.checkProjectFetchGroup(project, false, false, true, false);
        ContinuumStoreTest.assertSame((String)"Check project group reference matches", (Object)project.getProjectGroup(), (Object)group1);
        ContinuumStoreTest.assertProjectEquals(this.testProject2, project);
        ContinuumStoreTest.assertNotifiersEqual(this.testProject2.getNotifiers(), project.getNotifiers());
        ContinuumStoreTest.assertBuildDefinitionsEqual(project.getBuildDefinitions(), this.testProject2.getBuildDefinitions());
        projects = group2.getProjects();
        ContinuumStoreTest.assertEquals((String)"Check number of projects", (int)0, (int)projects.size());
    }

    public void testAddDeveloperToProject() throws ContinuumStoreException {
        Project project = this.store.getProjectWithAllDetails(this.testProject1.getId());
        ProjectDeveloper developer = ContinuumStoreTest.createTestDeveloper(11, "email TADTP", "name TADTP", "scmId TADTP");
        ProjectDeveloper copy = ContinuumStoreTest.createTestDeveloper(developer);
        project.addDeveloper(developer);
        this.store.updateProject(project);
        project = this.store.getProjectWithAllDetails(this.testProject1.getId());
        ContinuumStoreTest.assertEquals((String)"check # devs", (int)2, (int)project.getDevelopers().size());
        ContinuumStoreTest.assertDeveloperEquals(copy, (ProjectDeveloper)project.getDevelopers().get(1));
    }

    public void testEditDeveloper() throws ContinuumStoreException {
        Project project = this.store.getProjectWithAllDetails(this.testProject1.getId());
        ProjectDeveloper newDeveloper = (ProjectDeveloper)project.getDevelopers().get(0);
        newDeveloper.setName("name1.1");
        newDeveloper.setEmail("email1.1");
        ProjectDeveloper copy = ContinuumStoreTest.createTestDeveloper(newDeveloper);
        this.store.updateProject(project);
        project = this.store.getProjectWithAllDetails(this.testProject1.getId());
        ContinuumStoreTest.assertEquals((String)"check # devs", (int)1, (int)project.getDevelopers().size());
        ContinuumStoreTest.assertDeveloperEquals(copy, (ProjectDeveloper)project.getDevelopers().get(0));
    }

    public void testDeleteDeveloper() throws ContinuumStoreException {
        Project project = this.store.getProjectWithAllDetails(this.testProject1.getId());
        project.getDevelopers().remove(0);
        this.store.updateProject(project);
        project = this.store.getProjectWithAllDetails(this.testProject1.getId());
        ContinuumStoreTest.assertEquals((String)"check size is now 0", (int)0, (int)project.getDevelopers().size());
    }

    public void testAddDependencyToProject() throws ContinuumStoreException {
        Project project = this.store.getProjectWithAllDetails(this.testProject1.getId());
        ProjectDependency dependency = ContinuumStoreTest.createTestDependency("TADTP groupId", "TADTP artifactId", "TADTP version");
        ProjectDependency copy = ContinuumStoreTest.createTestDependency(dependency);
        project.addDependency(dependency);
        this.store.updateProject(project);
        project = this.store.getProjectWithAllDetails(this.testProject1.getId());
        ContinuumStoreTest.assertEquals((String)"check # deps", (int)3, (int)project.getDependencies().size());
        ContinuumStoreTest.assertDependencyEquals(copy, (ProjectDependency)project.getDependencies().get(2));
    }

    public void testEditDependency() throws ContinuumStoreException {
        Project project = this.store.getProjectWithAllDetails(this.testProject1.getId());
        ProjectDependency newDependency = (ProjectDependency)project.getDependencies().get(0);
        newDependency.setGroupId("groupId1.1");
        newDependency.setArtifactId("artifactId1.1");
        ProjectDependency copy = ContinuumStoreTest.createTestDependency(newDependency);
        this.store.updateProject(project);
        project = this.store.getProjectWithAllDetails(this.testProject1.getId());
        ContinuumStoreTest.assertEquals((String)"check # deps", (int)2, (int)project.getDependencies().size());
        ContinuumStoreTest.assertDependencyEquals(copy, (ProjectDependency)project.getDependencies().get(0));
    }

    public void testDeleteDependency() throws ContinuumStoreException {
        Project project = this.store.getProjectWithAllDetails(this.testProject1.getId());
        ProjectDependency dependency = (ProjectDependency)project.getDependencies().get(1);
        project.getDependencies().remove(0);
        this.store.updateProject(project);
        project = this.store.getProjectWithAllDetails(this.testProject1.getId());
        ContinuumStoreTest.assertEquals((String)"check size is now 1", (int)1, (int)project.getDependencies().size());
        ContinuumStoreTest.assertDependencyEquals(dependency, (ProjectDependency)project.getDependencies().get(0));
    }

    public void testAddNotifierToProject() throws ContinuumStoreException {
        Project project = this.store.getProjectWithAllDetails(this.testProject1.getId());
        ProjectNotifier notifier = ContinuumStoreTest.createTestNotifier(13, true, false, true, "TADNTP type");
        ProjectNotifier copy = ContinuumStoreTest.createTestNotifier(notifier);
        project.addNotifier(notifier);
        this.store.updateProject(project);
        project = this.store.getProjectWithAllDetails(this.testProject1.getId());
        ContinuumStoreTest.assertEquals((String)"check # notifiers", (int)2, (int)project.getNotifiers().size());
        ContinuumStoreTest.assertNotifierEquals(copy, (ProjectNotifier)project.getNotifiers().get(1));
    }

    public void testEditNotifier() throws ContinuumStoreException {
        Project project = this.store.getProjectWithAllDetails(this.testProject1.getId());
        ProjectNotifier newNotifier = (ProjectNotifier)project.getNotifiers().get(0);
        String type = "type11";
        newNotifier.setType(type);
        ProjectNotifier copy = ContinuumStoreTest.createTestNotifier(newNotifier);
        this.store.updateProject(project);
        project = this.store.getProjectWithAllDetails(this.testProject1.getId());
        ContinuumStoreTest.assertEquals((String)"check # notifiers", (int)1, (int)project.getNotifiers().size());
        ContinuumStoreTest.assertNotifierEquals(copy, (ProjectNotifier)project.getNotifiers().get(0));
    }

    public void testDeleteNotifier() throws ContinuumStoreException {
        Project project = this.store.getProjectWithAllDetails(this.testProject1.getId());
        project.getNotifiers().remove(0);
        this.store.updateProject(project);
        project = this.store.getProjectWithAllDetails(this.testProject1.getId());
        ContinuumStoreTest.assertEquals((String)"check size is now 0", (int)0, (int)project.getNotifiers().size());
    }

    public void testAddBuildDefinitionToProject() throws ContinuumStoreException {
        Project project = this.store.getProjectWithAllDetails(this.testProject1.getId());
        Profile profile = this.store.getProfile(this.testProfile1.getId());
        Schedule schedule = this.store.getSchedule(this.testSchedule1.getId());
        BuildDefinition buildDefinition = ContinuumStoreTest.createTestBuildDefinition("TABDTP arguments", "TABDTP buildFile", "TABDTP goals", profile, schedule, false, false);
        BuildDefinition copy = ContinuumStoreTest.createTestBuildDefinition(buildDefinition);
        project.addBuildDefinition(buildDefinition);
        this.store.updateProject(project);
        project = this.store.getProjectWithAllDetails(this.testProject1.getId());
        ContinuumStoreTest.assertEquals((String)"check # build defs", (int)3, (int)project.getBuildDefinitions().size());
        BuildDefinition retrievedBuildDefinition = (BuildDefinition)project.getBuildDefinitions().get(2);
        ContinuumStoreTest.assertBuildDefinitionEquals(copy, retrievedBuildDefinition);
        ContinuumStoreTest.assertScheduleEquals(this.testSchedule1, retrievedBuildDefinition.getSchedule());
        ContinuumStoreTest.assertProfileEquals(this.testProfile1, retrievedBuildDefinition.getProfile());
    }

    public void testEditBuildDefinition() throws ContinuumStoreException {
        Project project = this.store.getProjectWithAllDetails(this.testProject1.getId());
        BuildDefinition newBuildDefinition = (BuildDefinition)project.getBuildDefinitions().get(0);
        newBuildDefinition.setBuildFresh(true);
        new BuildDefinition().setDefaultForProject(true);
        String arguments = "arguments1.1";
        newBuildDefinition.setArguments(arguments);
        BuildDefinition copy = ContinuumStoreTest.createTestBuildDefinition(newBuildDefinition);
        this.store.storeBuildDefinition(newBuildDefinition);
        project = this.store.getProjectWithAllDetails(this.testProject1.getId());
        ContinuumStoreTest.assertEquals((String)"check # build defs", (int)2, (int)project.getBuildDefinitions().size());
        BuildDefinition retrievedBuildDefinition = (BuildDefinition)project.getBuildDefinitions().get(0);
        ContinuumStoreTest.assertBuildDefinitionEquals(copy, retrievedBuildDefinition);
        ContinuumStoreTest.assertScheduleEquals(this.testSchedule1, retrievedBuildDefinition.getSchedule());
        ContinuumStoreTest.assertProfileEquals(this.testProfile2, retrievedBuildDefinition.getProfile());
    }

    public void testDeleteBuildDefinition() throws ContinuumStoreException {
        Project project = this.store.getProjectWithAllDetails(this.testProject1.getId());
        BuildDefinition buildDefinition = (BuildDefinition)project.getBuildDefinitions().get(1);
        project.getBuildDefinitions().remove(0);
        this.store.updateProject(project);
        project = this.store.getProjectWithAllDetails(this.testProject1.getId());
        ContinuumStoreTest.assertEquals((String)"check size is now 1", (int)1, (int)project.getBuildDefinitions().size());
        BuildDefinition retrievedBuildDefinition = (BuildDefinition)project.getBuildDefinitions().get(0);
        ContinuumStoreTest.assertBuildDefinitionEquals(buildDefinition, retrievedBuildDefinition);
        ContinuumStoreTest.assertScheduleEquals(this.testSchedule2, retrievedBuildDefinition.getSchedule());
        ContinuumStoreTest.assertProfileEquals(this.testProfile2, retrievedBuildDefinition.getProfile());
    }

    public void testAddNotifierToProjectGroup() throws ContinuumStoreException {
        ProjectGroup projectGroup = this.store.getProjectGroupWithBuildDetailsByProjectGroupId(this.defaultProjectGroup.getId());
        ProjectNotifier notifier = ContinuumStoreTest.createTestNotifier(14, true, false, true, "TADNTPG type");
        ProjectNotifier copy = ContinuumStoreTest.createTestNotifier(notifier);
        projectGroup.addNotifier(notifier);
        this.store.updateProjectGroup(projectGroup);
        projectGroup = this.store.getProjectGroupWithBuildDetailsByProjectGroupId(this.defaultProjectGroup.getId());
        ContinuumStoreTest.assertEquals((String)"check # notifiers", (int)3, (int)projectGroup.getNotifiers().size());
        ContinuumStoreTest.assertNotifierEquals(copy, (ProjectNotifier)projectGroup.getNotifiers().get(2));
    }

    public void testEditGroupNotifier() throws ContinuumStoreException {
        ProjectGroup projectGroup = this.store.getProjectGroupWithBuildDetailsByProjectGroupId(this.defaultProjectGroup.getId());
        ProjectNotifier newNotifier = (ProjectNotifier)projectGroup.getNotifiers().get(0);
        String type = "type1";
        newNotifier.setType(type);
        ProjectNotifier copy = ContinuumStoreTest.createTestNotifier(newNotifier);
        this.store.updateProjectGroup(projectGroup);
        projectGroup = this.store.getProjectGroupWithBuildDetailsByProjectGroupId(this.defaultProjectGroup.getId());
        ContinuumStoreTest.assertEquals((String)"check # notifiers", (int)2, (int)projectGroup.getNotifiers().size());
        ContinuumStoreTest.assertNotifierEquals(copy, (ProjectNotifier)projectGroup.getNotifiers().get(0));
    }

    public void testDeleteGroupNotifier() throws ContinuumStoreException {
        ProjectGroup projectGroup = this.store.getProjectGroupWithBuildDetailsByProjectGroupId(this.defaultProjectGroup.getId());
        ProjectNotifier notifier = (ProjectNotifier)projectGroup.getNotifiers().get(1);
        projectGroup.getNotifiers().remove(0);
        this.store.updateProjectGroup(projectGroup);
        projectGroup = this.store.getProjectGroupWithBuildDetailsByProjectGroupId(this.defaultProjectGroup.getId());
        ContinuumStoreTest.assertEquals((String)"check size is now 1", (int)1, (int)projectGroup.getNotifiers().size());
        ContinuumStoreTest.assertNotifierEquals(notifier, (ProjectNotifier)projectGroup.getNotifiers().get(0));
    }

    public void testAddBuildDefinitionToProjectGroup() throws ContinuumStoreException {
        ProjectGroup projectGroup = this.store.getProjectGroupWithBuildDetailsByProjectGroupId(this.defaultProjectGroup.getId());
        Profile profile = this.store.getProfile(this.testProfile1.getId());
        Schedule schedule = this.store.getSchedule(this.testSchedule1.getId());
        BuildDefinition buildDefinition = ContinuumStoreTest.createTestBuildDefinition("TABDTPG arguments", "TABDTPG buildFile", "TABDTPG goals", profile, schedule, false, false);
        BuildDefinition copy = ContinuumStoreTest.createTestBuildDefinition(buildDefinition);
        projectGroup.addBuildDefinition(buildDefinition);
        this.store.updateProjectGroup(projectGroup);
        projectGroup = this.store.getProjectGroupWithBuildDetailsByProjectGroupId(this.defaultProjectGroup.getId());
        ContinuumStoreTest.assertEquals((String)"check # build defs", (int)2, (int)projectGroup.getBuildDefinitions().size());
        BuildDefinition retrievedBuildDefinition = (BuildDefinition)projectGroup.getBuildDefinitions().get(1);
        ContinuumStoreTest.assertBuildDefinitionEquals(copy, retrievedBuildDefinition);
        ContinuumStoreTest.assertScheduleEquals(this.testSchedule1, retrievedBuildDefinition.getSchedule());
        ContinuumStoreTest.assertProfileEquals(this.testProfile1, retrievedBuildDefinition.getProfile());
    }

    public void testEditGroupBuildDefinition() throws ContinuumStoreException {
        ProjectGroup projectGroup = this.store.getProjectGroupWithBuildDetailsByProjectGroupId(this.defaultProjectGroup.getId());
        BuildDefinition newBuildDefinition = (BuildDefinition)projectGroup.getBuildDefinitions().get(0);
        String arguments = "arguments1";
        newBuildDefinition.setArguments(arguments);
        BuildDefinition copy = ContinuumStoreTest.createTestBuildDefinition(newBuildDefinition);
        this.store.updateProjectGroup(projectGroup);
        projectGroup = this.store.getProjectGroupWithBuildDetailsByProjectGroupId(this.defaultProjectGroup.getId());
        ContinuumStoreTest.assertEquals((String)"check # build defs", (int)1, (int)projectGroup.getBuildDefinitions().size());
        BuildDefinition retrievedBuildDefinition = (BuildDefinition)projectGroup.getBuildDefinitions().get(0);
        ContinuumStoreTest.assertBuildDefinitionEquals(copy, retrievedBuildDefinition);
        ContinuumStoreTest.assertScheduleEquals(this.testSchedule2, retrievedBuildDefinition.getSchedule());
        ContinuumStoreTest.assertProfileEquals(this.testProfile1, retrievedBuildDefinition.getProfile());
    }

    public void testDeleteGroupBuildDefinition() throws ContinuumStoreException {
        ProjectGroup projectGroup = this.store.getProjectGroupWithBuildDetailsByProjectGroupId(this.defaultProjectGroup.getId());
        projectGroup.getBuildDefinitions().remove(0);
        this.store.updateProjectGroup(projectGroup);
        projectGroup = this.store.getProjectGroupWithBuildDetailsByProjectGroupId(this.defaultProjectGroup.getId());
        ContinuumStoreTest.assertEquals((String)"check size is now 0", (int)0, (int)projectGroup.getBuildDefinitions().size());
    }

    private void confirmProjectDeletion(Project project) throws ContinuumStoreException {
        try {
            this.store.getProject(project.getId());
            ContinuumStoreTest.fail((String)"Project should no longer exist");
        }
        catch (ContinuumObjectNotFoundException expected) {
            ContinuumStoreTest.assertTrue((boolean)true);
        }
    }

    private static void checkProjectGroupDefaultFetchGroup(ProjectGroup retrievedGroup) {
        try {
            retrievedGroup.getBuildDefinitions();
            ContinuumStoreTest.fail((String)"buildDefinitions should not be in the default fetch group");
        }
        catch (JDODetachedFieldAccessException expected) {
            ContinuumStoreTest.assertTrue((boolean)true);
        }
        try {
            retrievedGroup.getNotifiers();
            ContinuumStoreTest.fail((String)"notifiers should not be in the default fetch group");
        }
        catch (JDODetachedFieldAccessException expected) {
            ContinuumStoreTest.assertTrue((boolean)true);
        }
    }

    private static void checkProjectDefaultFetchGroup(Project project) {
        ContinuumStoreTest.checkProjectFetchGroup(project, false, false, false, false);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.createBuildDatabase();
    }

    private static void checkProjectFetchGroup(Project project, boolean checkoutFetchGroup, boolean buildResultsFetchGroup, boolean detailsFetchGroup, boolean fineDetailsFetchGroup) {
        if (!fineDetailsFetchGroup) {
            try {
                project.getDevelopers();
                ContinuumStoreTest.fail((String)"developers should not be in the default fetch group");
            }
            catch (JDODetachedFieldAccessException expected) {
                ContinuumStoreTest.assertTrue((boolean)true);
            }
            try {
                project.getDependencies();
                ContinuumStoreTest.fail((String)"dependencies should not be in the default fetch group");
            }
            catch (JDODetachedFieldAccessException expected) {
                ContinuumStoreTest.assertTrue((boolean)true);
            }
        }
        if (!detailsFetchGroup) {
            try {
                project.getNotifiers();
                ContinuumStoreTest.fail((String)"notifiers should not be in the default fetch group");
            }
            catch (JDODetachedFieldAccessException expected) {
                ContinuumStoreTest.assertTrue((boolean)true);
            }
            try {
                project.getBuildDefinitions();
                ContinuumStoreTest.fail((String)"buildDefinitions should not be in the default fetch group");
            }
            catch (JDODetachedFieldAccessException expected) {
                ContinuumStoreTest.assertTrue((boolean)true);
            }
        }
        if (!checkoutFetchGroup) {
            try {
                project.getCheckoutResult();
                ContinuumStoreTest.fail((String)"checkoutResult should not be in the fetch group");
            }
            catch (JDODetachedFieldAccessException expected) {
                ContinuumStoreTest.assertTrue((boolean)true);
            }
        }
        if (!buildResultsFetchGroup) {
            try {
                project.getBuildResults();
                ContinuumStoreTest.fail((String)"buildResults should not be in the default fetch group");
            }
            catch (JDODetachedFieldAccessException expected) {
                ContinuumStoreTest.assertTrue((boolean)true);
            }
        }
    }

    private static void checkBuildResultDefaultFetchGroup(BuildResult buildResult) {
        try {
            buildResult.getScmResult();
            ContinuumStoreTest.fail((String)"scmResult should not be in the default fetch group");
        }
        catch (JDODetachedFieldAccessException expected) {
            ContinuumStoreTest.assertTrue((boolean)true);
        }
    }
}

