/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.store;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jdo.Extent;
import javax.jdo.JDOHelper;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;
import org.apache.maven.continuum.model.project.BuildDefinition;
import org.apache.maven.continuum.model.project.BuildResult;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectDependency;
import org.apache.maven.continuum.model.project.ProjectDeveloper;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.model.project.ProjectNotifier;
import org.apache.maven.continuum.model.project.Schedule;
import org.apache.maven.continuum.model.scm.ChangeFile;
import org.apache.maven.continuum.model.scm.ChangeSet;
import org.apache.maven.continuum.model.scm.ScmResult;
import org.apache.maven.continuum.model.scm.SuiteResult;
import org.apache.maven.continuum.model.scm.TestCaseFailure;
import org.apache.maven.continuum.model.scm.TestResult;
import org.apache.maven.continuum.model.system.Installation;
import org.apache.maven.continuum.model.system.Profile;
import org.apache.maven.continuum.model.system.SystemConfiguration;
import org.apache.maven.continuum.store.AbstractContinuumStore;
import org.apache.maven.continuum.store.ContinuumObjectNotFoundException;
import org.apache.maven.continuum.store.ContinuumStore;
import org.apache.maven.continuum.store.ContinuumStoreException;
import org.codehaus.plexus.jdo.JdoFactory;
import org.codehaus.plexus.jdo.PlexusJdoUtils;
import org.codehaus.plexus.jdo.PlexusObjectNotFoundException;
import org.codehaus.plexus.jdo.PlexusStoreException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.StringUtils;

public class JdoContinuumStore
extends AbstractContinuumStore
implements ContinuumStore,
Initializable {
    private JdoFactory continuumJdoFactory;
    private PersistenceManagerFactory continuumPmf;
    private static final String PROJECT_WITH_BUILDS_FETCH_GROUP = "project-with-builds";
    private static final String PROJECT_WITH_CHECKOUT_RESULT_FETCH_GROUP = "project-with-checkout-result";
    private static final String BUILD_RESULT_WITH_DETAILS_FETCH_GROUP = "build-result-with-details";
    private static final String PROJECT_BUILD_DETAILS_FETCH_GROUP = "project-build-details";
    private static final String PROJECT_ALL_DETAILS_FETCH_GROUP = "project-all-details";
    private static final String PROJECT_DEPENDENCIES_FETCH_GROUP = "project-dependencies";
    private static final String PROJECTGROUP_PROJECTS_FETCH_GROUP = "projectgroup-projects";

    public void initialize() throws InitializationException {
        this.continuumPmf = this.continuumJdoFactory.getPersistenceManagerFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project getProjectByName(String name) throws ContinuumStoreException {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(Project.class, true);
            Query query = pm.newQuery(extent);
            query.declareImports("import java.lang.String");
            query.declareParameters("String name");
            query.setFilter("this.name == name");
            Collection result = (Collection)query.execute((Object)name);
            if (result.size() == 0) {
                tx.commit();
                Project project = null;
                return project;
            }
            Object object = pm.detachCopy(result.iterator().next());
            tx.commit();
            Project project = (Project)object;
            return project;
        }
        finally {
            this.rollback(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project getProject(String groupId, String artifactId, String version) throws ContinuumStoreException {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(Project.class, true);
            Query query = pm.newQuery(extent);
            query.declareImports("import java.lang.String");
            query.declareParameters("String groupId, String artifactId, String version");
            query.setFilter("this.groupId == groupId && this.artifactId == artifactId && this.version == version");
            Object[] params = new Object[]{groupId, artifactId, version};
            Collection result = (Collection)query.executeWithArray(params);
            if (result.size() == 0) {
                tx.commit();
                Project project = null;
                return project;
            }
            Object object = pm.detachCopy(result.iterator().next());
            tx.commit();
            Project project = (Project)object;
            return project;
        }
        finally {
            this.rollback(tx);
        }
    }

    public Map getAggregatedProjectIdsAndBuildDefinitionIdsBySchedule(int scheduleId) throws ContinuumStoreException {
        Map projectSource = this.getProjectIdsAndBuildDefinitionsIdsBySchedule(scheduleId);
        Map projectGroupSource = this.getProjectGroupIdsAndBuildDefinitionsIdsBySchedule(scheduleId);
        HashMap aggregate = new HashMap();
        if (projectSource != null) {
            aggregate.putAll(projectSource);
        }
        if (projectGroupSource != null) {
            for (Integer projectGroupId : projectGroupSource.keySet()) {
                List projectsInGroup = this.getProjectsInGroup(projectGroupId);
                Iterator j = projectsInGroup.iterator();
                while (j.hasNext()) {
                    Integer projectId = new Integer(((Project)j.next()).getId());
                    if (aggregate.keySet().contains(projectId)) continue;
                    aggregate.put(projectId, projectGroupSource.get(projectGroupId));
                }
            }
        }
        return aggregate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getProjectIdsAndBuildDefinitionsIdsBySchedule(int scheduleId) throws ContinuumStoreException {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(Project.class, true);
            Query query = pm.newQuery(extent);
            query.declareParameters("int scheduleId");
            query.declareImports("import org.apache.maven.continuum.model.project.BuildDefinition");
            query.declareVariables("BuildDefinition buildDef");
            query.setFilter("buildDefinitions.contains(buildDef) && buildDef.schedule.id == scheduleId");
            query.setResult("this.id, buildDef.id");
            List result = (List)query.execute((Object)new Integer(scheduleId));
            HashMap projects = new HashMap();
            if (result != null && !result.isEmpty()) {
                for (Object[] obj : result) {
                    List<Object> buildDefinitions;
                    if (projects.get(obj[0]) != null) {
                        buildDefinitions = (List)projects.get(obj[0]);
                    } else {
                        buildDefinitions = new ArrayList();
                        projects.put(obj[0], buildDefinitions);
                    }
                    buildDefinitions.add(obj[1]);
                }
                HashMap hashMap = projects;
                return hashMap;
            }
            if (!projects.isEmpty()) {
                HashMap hashMap = projects;
                return hashMap;
            }
        }
        finally {
            tx.commit();
            this.rollback(tx);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getProjectGroupIdsAndBuildDefinitionsIdsBySchedule(int scheduleId) throws ContinuumStoreException {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(ProjectGroup.class, true);
            Query query = pm.newQuery(extent);
            query.declareParameters("int scheduleId");
            query.declareImports("import org.apache.maven.continuum.model.project.BuildDefinition");
            query.declareVariables("BuildDefinition buildDef");
            query.setFilter("buildDefinitions.contains(buildDef) && buildDef.schedule.id == scheduleId");
            query.setResult("this.id, buildDef.id");
            List result = (List)query.execute((Object)new Integer(scheduleId));
            HashMap projectGroups = new HashMap();
            if (result != null && !result.isEmpty()) {
                for (Object[] obj : result) {
                    List<Object> buildDefinitions;
                    if (projectGroups.get(obj[0]) != null) {
                        buildDefinitions = (List)projectGroups.get(obj[0]);
                    } else {
                        buildDefinitions = new ArrayList();
                        projectGroups.put(obj[0], buildDefinitions);
                    }
                    buildDefinitions.add(obj[1]);
                }
                HashMap hashMap = projectGroups;
                return hashMap;
            }
        }
        finally {
            tx.commit();
            this.rollback(tx);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBuildResult(BuildResult build) throws ContinuumStoreException {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        Project project = build.getProject();
        try {
            tx.begin();
            if (!JDOHelper.isDetached((Object)build)) {
                throw new ContinuumStoreException("Not detached: " + build);
            }
            pm.makePersistent((Object)build);
            if (!JDOHelper.isDetached((Object)project)) {
                throw new ContinuumStoreException("Not detached: " + project);
            }
            project.setState(build.getState());
            pm.makePersistent((Object)project);
            tx.commit();
        }
        finally {
            this.rollback(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBuildResult(Project project, BuildResult build) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            pm.getFetchPlan().addGroup(PROJECT_WITH_BUILDS_FETCH_GROUP);
            Object objectId = pm.newObjectIdInstance(Project.class, (Object)new Integer(project.getId()));
            project = (Project)pm.getObjectById(objectId);
            build = (BuildResult)this.makePersistent(pm, build, false);
            project.setLatestBuildId(build.getId());
            project.setState(build.getState());
            project.addBuildResult(build);
            tx.commit();
        }
        finally {
            this.rollback(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildResult getLatestBuildResultForProject(int projectId) {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(BuildResult.class, true);
            Query query = pm.newQuery(extent);
            query.declareParameters("int projectId");
            query.setFilter("this.project.id == projectId && this.project.latestBuildId == this.id");
            List result = (List)query.execute((Object)new Integer(projectId));
            result = (List)pm.detachCopyAll((Collection)result);
            tx.commit();
            if (result != null && !result.isEmpty()) {
                BuildResult buildResult = (BuildResult)result.get(0);
                return buildResult;
            }
        }
        finally {
            this.rollback(tx);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildResult getLatestBuildResultForBuildDefinition(int projectId, int buildDefinitionId) {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(BuildResult.class, true);
            Query query = pm.newQuery(extent);
            query.declareParameters("int projectId, int buildDefinitionId");
            query.setFilter("this.project.id == projectId && this.buildDefinition.id == buildDefinitionId");
            query.setOrdering("id descending");
            Object[] params = new Object[]{new Integer(projectId), new Integer(buildDefinitionId)};
            List result = (List)query.executeWithArray(params);
            result = (List)pm.detachCopyAll((Collection)result);
            tx.commit();
            if (result != null && !result.isEmpty()) {
                BuildResult buildResult = (BuildResult)result.get(0);
                return buildResult;
            }
        }
        finally {
            this.rollback(tx);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getLatestBuildResultsByProjectGroupId(int projectGroupId) {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(BuildResult.class, true);
            Query query = pm.newQuery(extent);
            String filter = "this.project.latestBuildId == this.id";
            if (projectGroupId > 0) {
                query.declareParameters("int projectGroupId");
                filter = filter + " && this.project.projectGroup.id == projectGroupId";
            }
            query.setFilter(filter);
            List result = null;
            result = projectGroupId > 0 ? (List)query.execute((Object)new Integer(projectGroupId)) : (List)query.execute();
            result = (List)pm.detachCopyAll((Collection)result);
            tx.commit();
            if (result != null && !result.isEmpty()) {
                HashMap<Integer, BuildResult> builds = new HashMap<Integer, BuildResult>();
                for (BuildResult br : result) {
                    builds.put(new Integer(br.getProject().getId()), br);
                }
                HashMap<Integer, BuildResult> hashMap = builds;
                return hashMap;
            }
        }
        finally {
            this.rollback(tx);
        }
        return null;
    }

    public Map getLatestBuildResults() {
        return this.getLatestBuildResultsByProjectGroupId(-1);
    }

    public void removeBuildResult(BuildResult buildResult) {
        this.removeObject(buildResult);
    }

    public void removeNotifier(ProjectNotifier notifier) throws ContinuumStoreException {
        this.attachAndDelete(notifier);
    }

    public ProjectNotifier storeNotifier(ProjectNotifier notifier) throws ContinuumStoreException {
        this.updateObject(notifier);
        return notifier;
    }

    public BuildDefinition getDefaultBuildDefinition(int projectId) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        BuildDefinition bd = null;
        try {
            bd = this.getDefaultBuildDefinitionForProject(projectId);
        }
        catch (ContinuumObjectNotFoundException cne) {
            this.getLogger().debug("no default build definition on project, trying project group");
        }
        if (bd == null) {
            ProjectGroup projectGroup = this.getProjectGroupByProjectId(projectId);
            bd = this.getDefaultBuildDefinitionForProjectGroup(projectGroup.getId());
        }
        return bd;
    }

    public BuildDefinition getDefaultBuildDefinitionForProject(int projectId) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        Project project;
        try {
            project = this.getProjectWithBuildDetails(projectId);
        }
        catch (Exception e) {
            project = null;
        }
        if (project != null && project.getBuildDefinitions() != null) {
            for (BuildDefinition bd : project.getBuildDefinitions()) {
                if (!bd.isDefaultForProject()) continue;
                return bd;
            }
        }
        throw new ContinuumObjectNotFoundException("no default build definition declared for project " + projectId);
    }

    public BuildDefinition getDefaultBuildDefinitionForProjectGroup(int projectGroupId) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        ProjectGroup projectGroup = this.getProjectGroupWithBuildDetailsByProjectGroupId(projectGroupId);
        for (BuildDefinition bd : projectGroup.getBuildDefinitions()) {
            if (!bd.isDefaultForProject()) continue;
            return bd;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getDefaultBuildDefinitions() {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(Project.class, true);
            Query query = pm.newQuery(extent);
            query.declareImports("import org.apache.maven.continuum.model.project.BuildDefinition");
            query.setFilter("this.buildDefinitions.contains(buildDef) && buildDef.defaultForProject == true");
            query.declareVariables("BuildDefinition buildDef");
            query.setResult("this.id, buildDef.id");
            List result = (List)query.execute();
            HashMap<Integer, Integer> builds = new HashMap<Integer, Integer>();
            if (result != null && !result.isEmpty()) {
                for (Object[] obj : result) {
                    builds.put((Integer)obj[0], (Integer)obj[1]);
                }
                HashMap<Integer, Integer> hashMap = builds;
                return hashMap;
            }
        }
        finally {
            tx.commit();
            this.rollback(tx);
        }
        return null;
    }

    public BuildDefinition getBuildDefinition(int buildDefinitionId) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        return (BuildDefinition)this.getObjectById(BuildDefinition.class, buildDefinitionId);
    }

    public void removeBuildDefinition(BuildDefinition buildDefinition) throws ContinuumStoreException {
        this.attachAndDelete(buildDefinition);
    }

    public BuildDefinition storeBuildDefinition(BuildDefinition buildDefinition) throws ContinuumStoreException {
        this.updateObject(buildDefinition);
        return buildDefinition;
    }

    private Object makePersistent(PersistenceManager pm, Object object, boolean detach) {
        return PlexusJdoUtils.makePersistent((PersistenceManager)pm, (Object)object, (boolean)detach);
    }

    private Object getObjectFromQuery(Class clazz, String idField, String id, String fetchGroup) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        try {
            return PlexusJdoUtils.getObjectFromQuery((PersistenceManager)this.getPersistenceManager(), (Class)clazz, (String)idField, (String)id, (String)fetchGroup);
        }
        catch (PlexusObjectNotFoundException e) {
            throw new ContinuumObjectNotFoundException(e.getMessage());
        }
        catch (PlexusStoreException e) {
            throw new ContinuumStoreException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void attachAndDelete(Object object) {
        PlexusJdoUtils.attachAndDelete((PersistenceManager)this.getPersistenceManager(), (Object)object);
    }

    private void rollback(Transaction tx) {
        PlexusJdoUtils.rollbackIfActive((Transaction)tx);
    }

    public ProjectGroup getProjectGroup(int projectGroupId) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        return (ProjectGroup)this.getObjectById(ProjectGroup.class, projectGroupId);
    }

    private Object getObjectById(Class clazz, int id) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        return this.getObjectById(clazz, id, null);
    }

    private Object getObjectById(Class clazz, int id, String fetchGroup) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        try {
            return PlexusJdoUtils.getObjectById((PersistenceManager)this.getPersistenceManager(), (Class)clazz, (int)id, (String)fetchGroup);
        }
        catch (PlexusObjectNotFoundException e) {
            throw new ContinuumObjectNotFoundException(e.getMessage());
        }
        catch (PlexusStoreException e) {
            throw new ContinuumStoreException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public void updateProjectGroup(ProjectGroup group) throws ContinuumStoreException {
        this.updateObject(group);
    }

    private void updateObject(Object object) throws ContinuumStoreException {
        this.updateObject(this.getPersistenceManager(), object);
    }

    private void updateObject(PersistenceManager pmf, Object object) throws ContinuumStoreException {
        try {
            PlexusJdoUtils.updateObject((PersistenceManager)pmf, (Object)object);
        }
        catch (PlexusStoreException e) {
            throw new ContinuumStoreException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Collection getAllProjectGroupsWithProjects() {
        return this.getAllObjectsDetached(ProjectGroup.class, "name ascending", PROJECTGROUP_PROJECTS_FETCH_GROUP);
    }

    public Collection getAllProjectGroups() {
        return this.getAllObjectsDetached(ProjectGroup.class, "name ascending", null);
    }

    public List getAllProjectsByName() {
        return this.getAllObjectsDetached(Project.class, "name ascending", null);
    }

    public List getProjectsWithDependenciesByGroupId(int projectGroupId) {
        List allProjects = this.getAllObjectsDetached(Project.class, "name ascending", PROJECT_DEPENDENCIES_FETCH_GROUP);
        ArrayList<Project> groupProjects = new ArrayList<Project>();
        for (Project project : allProjects) {
            if (project.getProjectGroup().getId() != projectGroupId) continue;
            groupProjects.add(project);
        }
        return groupProjects;
    }

    public List getAllProjectsByNameWithDependencies() {
        return this.getAllObjectsDetached(Project.class, "name ascending", PROJECT_DEPENDENCIES_FETCH_GROUP);
    }

    public List getAllProjectsByNameWithBuildDetails() {
        return this.getAllObjectsDetached(Project.class, "name ascending", PROJECT_BUILD_DETAILS_FETCH_GROUP);
    }

    public List getAllSchedulesByName() {
        return this.getAllObjectsDetached(Schedule.class, "name ascending", null);
    }

    public Schedule addSchedule(Schedule schedule) {
        return (Schedule)this.addObject(schedule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schedule getScheduleByName(String name) throws ContinuumStoreException {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(Schedule.class, true);
            Query query = pm.newQuery(extent);
            query.declareImports("import java.lang.String");
            query.declareParameters("String name");
            query.setFilter("this.name == name");
            Collection result = (Collection)query.execute((Object)name);
            if (result.size() == 0) {
                tx.commit();
                Schedule schedule = null;
                return schedule;
            }
            Object object = pm.detachCopy(result.iterator().next());
            tx.commit();
            Schedule schedule = (Schedule)object;
            return schedule;
        }
        finally {
            this.rollback(tx);
        }
    }

    public Schedule storeSchedule(Schedule schedule) throws ContinuumStoreException {
        this.updateObject(schedule);
        return schedule;
    }

    public List getAllProfilesByName() {
        return this.getAllObjectsDetached(Profile.class, "name ascending", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profile getProfileByName(String profileName) throws ContinuumStoreException {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(Profile.class, true);
            Query query = pm.newQuery(extent);
            query.declareImports("import java.lang.String");
            query.declareParameters("String name");
            query.setFilter("this.name == name");
            Collection result = (Collection)query.execute((Object)profileName);
            if (result.size() == 0) {
                tx.commit();
                Profile profile = null;
                return profile;
            }
            Object object = pm.detachCopy(result.iterator().next());
            tx.commit();
            Profile profile = (Profile)object;
            return profile;
        }
        finally {
            this.rollback(tx);
        }
    }

    public Profile addProfile(Profile profile) {
        return (Profile)this.addObject(profile);
    }

    public Installation addInstallation(Installation installation) {
        return (Installation)this.addObject(installation);
    }

    public List getAllInstallations() {
        return this.getAllObjectsDetached(Installation.class, "name ascending", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstallation(Installation installation) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(Profile.class, true);
            Query query = pm.newQuery(extent);
            query.declareImports("import java.lang.String");
            query.declareParameters("String name");
            query.setFilter("this.jdk.name == name");
            Collection result = (Collection)query.execute((Object)installation.getName());
            if (result.size() != 0) {
                for (Profile profile : result) {
                    profile.setJdk(null);
                    pm.makePersistent((Object)profile);
                }
            }
            query = pm.newQuery(extent);
            query.declareImports("import java.lang.String");
            query.declareParameters("String name");
            query.setFilter("this.builder.name == name");
            result = (Collection)query.execute((Object)installation.getName());
            if (result.size() != 0) {
                for (Profile profile : result) {
                    profile.setBuilder(null);
                    pm.makePersistent((Object)profile);
                }
            }
            query = pm.newQuery(extent);
            query.declareImports("import java.lang.String");
            query.declareImports("import " + Installation.class.getName());
            query.declareParameters("Installation installation");
            query.setFilter("environmentVariables.contains(installation)");
            result = (Collection)query.execute((Object)installation);
            if (result.size() != 0) {
                for (Profile profile : result) {
                    ArrayList<Installation> newEnvironmentVariables = new ArrayList<Installation>();
                    for (Installation current : profile.getEnvironmentVariables()) {
                        if (StringUtils.equals((String)current.getName(), (String)installation.getName())) continue;
                        newEnvironmentVariables.add(current);
                    }
                    profile.setEnvironmentVariables(newEnvironmentVariables);
                    pm.makePersistent((Object)profile);
                }
            }
            pm.deletePersistent((Object)installation);
            tx.commit();
        }
        finally {
            this.rollback(tx);
        }
    }

    public void updateInstallation(Installation installation) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        this.updateObject(installation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Installation getInstallationByName(String name) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(Installation.class, true);
            Query query = pm.newQuery(extent);
            query.declareImports("import java.lang.String");
            query.declareParameters("String name");
            query.setFilter("this.name == name");
            Collection result = (Collection)query.execute((Object)name);
            if (result.size() == 0) {
                tx.commit();
                Installation installation = null;
                return installation;
            }
            Object object = pm.detachCopy(result.iterator().next());
            tx.commit();
            Installation installation = (Installation)object;
            return installation;
        }
        finally {
            this.rollback(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllBuildsForAProjectByDate(int projectId) {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Query query = pm.newQuery("SELECT FROM " + BuildResult.class.getName() + " WHERE project.id == projectId PARAMETERS int projectId ORDER BY endTime DESC");
            query.declareImports("import java.lang.Integer");
            query.declareParameters("Integer projectId");
            List result = (List)query.execute((Object)new Integer(projectId));
            result = (List)pm.detachCopyAll((Collection)result);
            tx.commit();
            List list = result;
            return list;
        }
        finally {
            this.rollback(tx);
        }
    }

    public Project getProject(int projectId) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        return (Project)this.getObjectById(Project.class, projectId);
    }

    public void updateProject(Project project) throws ContinuumStoreException {
        this.updateObject(project);
    }

    public void updateProfile(Profile profile) throws ContinuumStoreException {
        this.updateObject(profile);
    }

    public void updateSchedule(Schedule schedule) throws ContinuumStoreException {
        this.updateObject(schedule);
    }

    public Project getProjectWithBuilds(int projectId) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        return (Project)this.getObjectById(Project.class, projectId, PROJECT_WITH_BUILDS_FETCH_GROUP);
    }

    public void removeProfile(Profile profile) {
        this.removeObject(profile);
    }

    public void removeSchedule(Schedule schedule) {
        this.removeObject(schedule);
    }

    public Project getProjectWithCheckoutResult(int projectId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return (Project)this.getObjectById(Project.class, projectId, PROJECT_WITH_CHECKOUT_RESULT_FETCH_GROUP);
    }

    public BuildResult getBuildResult(int buildId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return (BuildResult)this.getObjectById(BuildResult.class, buildId, BUILD_RESULT_WITH_DETAILS_FETCH_GROUP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getBuildResultByBuildNumber(int projectId, int buildNumber) {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(BuildResult.class, true);
            Query query = pm.newQuery(extent);
            query.declareParameters("int projectId, int buildNumber");
            query.setFilter("this.project.id == projectId && this.buildNumber == buildNumber");
            List result = (List)query.execute((Object)new Integer(projectId), (Object)new Integer(buildNumber));
            result = (List)pm.detachCopyAll((Collection)result);
            tx.commit();
            List list = result;
            return list;
        }
        finally {
            this.rollback(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getBuildResultsForProject(int projectId, long fromDate) {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        pm.getFetchPlan().addGroup(BUILD_RESULT_WITH_DETAILS_FETCH_GROUP);
        try {
            tx.begin();
            Extent extent = pm.getExtent(BuildResult.class, true);
            Query query = pm.newQuery(extent);
            query.declareParameters("int projectId, long fromDate");
            query.setFilter("this.project.id == projectId && this.startTime > fromDate");
            List result = (List)query.execute((Object)new Integer(projectId), (Object)new Long(fromDate));
            result = (List)pm.detachCopyAll((Collection)result);
            tx.commit();
            List list = result;
            return list;
        }
        finally {
            this.rollback(tx);
        }
    }

    public List getBuildResultsInSuccessForProject(int projectId, long fromDate) {
        List buildResults = this.getBuildResultsForProject(projectId, fromDate);
        ArrayList<BuildResult> results = new ArrayList<BuildResult>();
        if (buildResults != null) {
            for (BuildResult res : buildResults) {
                if (res.getState() != 2) continue;
                results.add(res);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getBuildResultsInSuccessByProjectGroupId(int projectGroupId) {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(BuildResult.class, true);
            Query query = pm.newQuery(extent);
            String filter = "this.project.buildNumber == this.buildNumber";
            if (projectGroupId > 0) {
                query.declareParameters("int projectGroupId");
                filter = filter + " && this.project.projectGroup.id == projectGroupId";
            }
            query.setFilter(filter);
            List result = null;
            result = projectGroupId > 0 ? (List)query.execute((Object)new Integer(projectGroupId)) : (List)query.execute();
            result = (List)pm.detachCopyAll((Collection)result);
            tx.commit();
            if (result != null && !result.isEmpty()) {
                HashMap<Integer, BuildResult> builds = new HashMap<Integer, BuildResult>();
                for (BuildResult br : result) {
                    builds.put(new Integer(br.getProject().getId()), br);
                }
                HashMap<Integer, BuildResult> hashMap = builds;
                return hashMap;
            }
        }
        finally {
            this.rollback(tx);
        }
        return null;
    }

    public Map getBuildResultsInSuccess() {
        return this.getBuildResultsInSuccessByProjectGroupId(-1);
    }

    public void removeProject(Project project) {
        this.removeObject(project);
    }

    public void removeProjectGroup(ProjectGroup projectGroup) {
        ProjectGroup pg = null;
        try {
            pg = this.getProjectGroupWithProjects(projectGroup.getId());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (pg != null) {
            Iterator i = pg.getProjects().iterator();
            while (i.hasNext()) {
                this.removeProject((Project)i.next());
            }
            this.removeObject(pg);
        }
    }

    public List getProjectsInGroup(int projectGroupId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return this.getProjectGroupWithProjects(projectGroupId).getProjects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getProjectsInGroupWithDependencies(int projectGroupId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(Project.class, true);
            Query query = pm.newQuery(extent, "projectGroup.id == " + projectGroupId);
            query.setOrdering("name ascending");
            pm.getFetchPlan().addGroup(PROJECT_DEPENDENCIES_FETCH_GROUP);
            pm.getFetchPlan().addGroup(PROJECTGROUP_PROJECTS_FETCH_GROUP);
            List result = (List)query.execute();
            result = (List)pm.detachCopyAll((Collection)result);
            tx.commit();
            List list = result;
            return list;
        }
        finally {
            this.rollback(tx);
        }
    }

    public ProjectGroup getProjectGroupWithProjects(int projectGroupId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return (ProjectGroup)this.getObjectById(ProjectGroup.class, projectGroupId, PROJECTGROUP_PROJECTS_FETCH_GROUP);
    }

    public ProjectGroup getProjectGroupWithBuildDetailsByProjectGroupId(int projectGroupId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return (ProjectGroup)this.getObjectById(ProjectGroup.class, projectGroupId, PROJECT_BUILD_DETAILS_FETCH_GROUP);
    }

    public List getAllProjectGroupsWithBuildDetails() {
        return this.getAllObjectsDetached(ProjectGroup.class, "name ascending", PROJECT_BUILD_DETAILS_FETCH_GROUP);
    }

    public List getAllProjectsWithAllDetails() {
        return this.getAllObjectsDetached(Project.class, "name ascending", PROJECT_ALL_DETAILS_FETCH_GROUP);
    }

    public Project getProjectWithAllDetails(int projectId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return (Project)this.getObjectById(Project.class, projectId, PROJECT_ALL_DETAILS_FETCH_GROUP);
    }

    public Schedule getSchedule(int scheduleId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return (Schedule)this.getObjectById(Schedule.class, scheduleId);
    }

    public Profile getProfile(int profileId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return (Profile)this.getObjectById(Profile.class, profileId);
    }

    private void removeObject(Object o) {
        PlexusJdoUtils.removeObject((PersistenceManager)this.getPersistenceManager(), (Object)o);
    }

    private List getAllObjectsDetached(Class clazz) {
        return this.getAllObjectsDetached(clazz, null);
    }

    private List getAllObjectsDetached(Class clazz, String fetchGroup) {
        return this.getAllObjectsDetached(clazz, null, fetchGroup);
    }

    private List getAllObjectsDetached(Class clazz, String ordering, String fetchGroup) {
        return this.getAllObjectsDetached(this.getPersistenceManager(), clazz, ordering, fetchGroup);
    }

    private List getAllObjectsDetached(PersistenceManager pmf, Class clazz) {
        return this.getAllObjectsDetached(pmf, clazz, null);
    }

    private List getAllObjectsDetached(PersistenceManager pmf, Class clazz, String fetchGroup) {
        return this.getAllObjectsDetached(pmf, clazz, null, fetchGroup);
    }

    private List getAllObjectsDetached(PersistenceManager pmf, Class clazz, String ordering, String fetchGroup) {
        return PlexusJdoUtils.getAllObjectsDetached((PersistenceManager)pmf, (Class)clazz, (String)ordering, (String)fetchGroup);
    }

    public ProjectGroup addProjectGroup(ProjectGroup group) {
        return (ProjectGroup)this.addObject(group);
    }

    private Object addObject(Object object) {
        return this.addObject(this.getPersistenceManager(), object);
    }

    private Object addObject(PersistenceManager pmf, Object object) {
        return PlexusJdoUtils.addObject((PersistenceManager)pmf, (Object)object);
    }

    public ProjectGroup getProjectGroupByGroupId(String groupId) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        return (ProjectGroup)this.getObjectFromQuery(ProjectGroup.class, "groupId", groupId, null);
    }

    public ProjectGroup getProjectGroupByGroupIdWithBuildDetails(String groupId) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        return (ProjectGroup)this.getObjectFromQuery(ProjectGroup.class, "groupId", groupId, PROJECT_BUILD_DETAILS_FETCH_GROUP);
    }

    public ProjectGroup getProjectGroupByGroupIdWithProjects(String groupId) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        return (ProjectGroup)this.getObjectFromQuery(ProjectGroup.class, "groupId", groupId, PROJECTGROUP_PROJECTS_FETCH_GROUP);
    }

    public Project getProjectWithBuildDetails(int projectId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return (Project)this.getObjectById(Project.class, projectId, PROJECT_BUILD_DETAILS_FETCH_GROUP);
    }

    public ProjectGroup getProjectGroupByProjectId(int projectId) throws ContinuumObjectNotFoundException {
        try {
            return this.getProject(projectId).getProjectGroup();
        }
        catch (ContinuumStoreException e) {
            throw new ContinuumObjectNotFoundException("unable to find project group containing project with id: " + projectId);
        }
    }

    public SystemConfiguration addSystemConfiguration(SystemConfiguration systemConf) {
        return (SystemConfiguration)this.addObject(systemConf);
    }

    public void updateSystemConfiguration(SystemConfiguration systemConf) throws ContinuumStoreException {
        this.updateObject(systemConf);
    }

    public SystemConfiguration getSystemConfiguration() throws ContinuumStoreException {
        List systemConfs = this.getAllObjectsDetached(SystemConfiguration.class);
        if (systemConfs == null || systemConfs.isEmpty()) {
            return null;
        }
        if (systemConfs.size() > 1) {
            throw new ContinuumStoreException("Database is corrupted. There are more than one systemConfiguration object.");
        }
        return (SystemConfiguration)systemConfs.get(0);
    }

    private PersistenceManager getPersistenceManager() {
        return this.getPersistenceManager(this.continuumPmf);
    }

    private PersistenceManager getPersistenceManager(PersistenceManagerFactory pmf) {
        PersistenceManager pm = pmf.getPersistenceManager();
        pm.getFetchPlan().setMaxFetchDepth(-1);
        pm.getFetchPlan().setDetachmentOptions(1);
        return pm;
    }

    public void closeStore() {
        this.closePersistenceManagerFactory(this.continuumPmf, 1);
    }

    public Collection getAllProjectGroupsWithTheLot() {
        List<String> fetchGroups = Arrays.asList(PROJECT_WITH_BUILDS_FETCH_GROUP, PROJECTGROUP_PROJECTS_FETCH_GROUP, BUILD_RESULT_WITH_DETAILS_FETCH_GROUP, PROJECT_WITH_CHECKOUT_RESULT_FETCH_GROUP, PROJECT_ALL_DETAILS_FETCH_GROUP, PROJECT_BUILD_DETAILS_FETCH_GROUP);
        return PlexusJdoUtils.getAllObjectsDetached((PersistenceManager)this.getPersistenceManager(), ProjectGroup.class, (String)"name ascending", fetchGroups);
    }

    public void eraseDatabase() {
        PlexusJdoUtils.removeAll((PersistenceManager)this.getPersistenceManager(), ProjectGroup.class);
        PlexusJdoUtils.removeAll((PersistenceManager)this.getPersistenceManager(), Project.class);
        PlexusJdoUtils.removeAll((PersistenceManager)this.getPersistenceManager(), Schedule.class);
        PlexusJdoUtils.removeAll((PersistenceManager)this.getPersistenceManager(), Profile.class);
        PlexusJdoUtils.removeAll((PersistenceManager)this.getPersistenceManager(), Installation.class);
        PlexusJdoUtils.removeAll((PersistenceManager)this.getPersistenceManager(), ScmResult.class);
        PlexusJdoUtils.removeAll((PersistenceManager)this.getPersistenceManager(), BuildResult.class);
        PlexusJdoUtils.removeAll((PersistenceManager)this.getPersistenceManager(), TestResult.class);
        PlexusJdoUtils.removeAll((PersistenceManager)this.getPersistenceManager(), SuiteResult.class);
        PlexusJdoUtils.removeAll((PersistenceManager)this.getPersistenceManager(), TestCaseFailure.class);
        PlexusJdoUtils.removeAll((PersistenceManager)this.getPersistenceManager(), SystemConfiguration.class);
        PlexusJdoUtils.removeAll((PersistenceManager)this.getPersistenceManager(), ProjectNotifier.class);
        PlexusJdoUtils.removeAll((PersistenceManager)this.getPersistenceManager(), ProjectDeveloper.class);
        PlexusJdoUtils.removeAll((PersistenceManager)this.getPersistenceManager(), ProjectDependency.class);
        PlexusJdoUtils.removeAll((PersistenceManager)this.getPersistenceManager(), ChangeSet.class);
        PlexusJdoUtils.removeAll((PersistenceManager)this.getPersistenceManager(), ChangeFile.class);
        PlexusJdoUtils.removeAll((PersistenceManager)this.getPersistenceManager(), BuildDefinition.class);
    }

    private void closePersistenceManagerFactory(PersistenceManagerFactory pmf, int numTry) {
        if (pmf != null && !pmf.isClosed()) {
            try {
                pmf.close();
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (JDOUserException e) {
                if (numTry < 5) {
                    try {
                        Thread.currentThread().wait(1000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    this.closePersistenceManagerFactory(pmf, numTry + 1);
                }
                throw e;
            }
        }
    }
}

