/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.store;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.continuum.model.project.BuildDefinition;
import org.apache.maven.continuum.model.project.BuildResult;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectDependency;
import org.apache.maven.continuum.model.project.ProjectDeveloper;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.model.project.ProjectNotifier;
import org.apache.maven.continuum.model.project.Schedule;
import org.apache.maven.continuum.model.scm.ChangeFile;
import org.apache.maven.continuum.model.scm.ChangeSet;
import org.apache.maven.continuum.model.scm.ScmResult;
import org.apache.maven.continuum.model.system.Installation;
import org.apache.maven.continuum.model.system.Profile;
import org.apache.maven.continuum.model.system.SystemConfiguration;
import org.apache.maven.continuum.store.ContinuumStore;
import org.apache.maven.continuum.store.ContinuumStoreException;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.plexus.jdo.DefaultConfigurableJdoFactory;
import org.codehaus.plexus.jdo.JdoFactory;

public abstract class AbstractContinuumStoreTestCase
extends PlexusTestCase {
    protected ContinuumStore store;
    protected ProjectGroup defaultProjectGroup;
    protected ProjectGroup testProjectGroup2;
    protected Project testProject1;
    protected Project testProject2;
    protected Schedule testSchedule1;
    protected Schedule testSchedule2;
    protected Schedule testSchedule3;
    protected Profile testProfile1;
    protected Profile testProfile2;
    protected Profile testProfile3;
    protected Installation testInstallationJava13;
    protected Installation testInstallationJava14;
    protected Installation testInstallationMaven20a3;
    protected BuildResult testBuildResult1;
    protected BuildResult testBuildResult2;
    protected BuildResult testBuildResult3;
    protected ScmResult testCheckoutResult1;
    private ProjectNotifier testGroupNotifier1;
    private ProjectNotifier testGroupNotifier2;
    private ProjectNotifier testGroupNotifier3;
    private ProjectNotifier testNotifier1;
    private ProjectNotifier testNotifier2;
    private ProjectNotifier testNotifier3;
    private ProjectDeveloper testDeveloper1;
    private ProjectDeveloper testDeveloper2;
    private ProjectDeveloper testDeveloper3;
    private ProjectDependency testDependency1;
    private ProjectDependency testDependency2;
    private ProjectDependency testDependency3;
    private SystemConfiguration systemConfiguration;

    protected void setUp() throws Exception {
        super.setUp();
        this.store = this.createStore();
    }

    protected void createBuildDatabase() throws Exception {
        this.createBuildDatabase(true);
    }

    protected void createBuildDatabase(boolean addToStore) throws Exception {
        this.defaultProjectGroup = AbstractContinuumStoreTestCase.createTestProjectGroup("Default Group", "The Default Group", "org.apache.maven.test.default");
        this.testProjectGroup2 = AbstractContinuumStoreTestCase.createTestProjectGroup("test group 2", "test group 2 desc", "test group 2 groupId");
        this.testProject1 = AbstractContinuumStoreTestCase.createTestProject("artifactId1", 1, "description1", this.defaultProjectGroup.getGroupId(), "name1", "scmUrl1", 1, "url1", "version1", "workingDirectory1");
        this.testProject2 = AbstractContinuumStoreTestCase.createTestProject("artifactId2", 2, "description2", this.defaultProjectGroup.getGroupId(), "name2", "scmUrl2", 1, "url2", "version2", "workingDirectory2");
        this.testSchedule1 = AbstractContinuumStoreTestCase.createTestSchedule("name1", "description1", 1, "cronExpression1", true);
        this.testSchedule2 = AbstractContinuumStoreTestCase.createTestSchedule("name2", "description2", 2, "cronExpression2", true);
        this.testSchedule3 = AbstractContinuumStoreTestCase.createTestSchedule("name3", "description3", 3, "cronExpression3", true);
        this.testInstallationJava13 = AbstractContinuumStoreTestCase.createTestInstallation("JDK 1.3", "jdk", "JAVA_HOME", "/usr/local/java-1.3");
        this.testInstallationJava14 = AbstractContinuumStoreTestCase.createTestInstallation("JDK 1.4", "jdk", "JAVA_HOME", "/usr/local/java-1.4");
        this.testInstallationMaven20a3 = AbstractContinuumStoreTestCase.createTestInstallation("Maven 2.0 alpha 3", "maven2", "M2_HOME", "/usr/local/maven-2.0-alpha-3");
        this.testGroupNotifier1 = AbstractContinuumStoreTestCase.createTestNotifier(1, true, false, true, "type1");
        this.testGroupNotifier2 = AbstractContinuumStoreTestCase.createTestNotifier(2, false, true, false, "type2");
        this.testGroupNotifier3 = AbstractContinuumStoreTestCase.createTestNotifier(3, true, false, false, "type3");
        this.testNotifier1 = AbstractContinuumStoreTestCase.createTestNotifier(11, true, true, false, "type11");
        this.testNotifier2 = AbstractContinuumStoreTestCase.createTestNotifier(12, false, false, true, "type12");
        this.testNotifier3 = AbstractContinuumStoreTestCase.createTestNotifier(13, false, true, false, "type13");
        this.testDeveloper1 = AbstractContinuumStoreTestCase.createTestDeveloper(1, "email1", "name1", "scmId1");
        this.testDeveloper2 = AbstractContinuumStoreTestCase.createTestDeveloper(2, "email2", "name2", "scmId2");
        this.testDeveloper3 = AbstractContinuumStoreTestCase.createTestDeveloper(3, "email3", "name3", "scmId3");
        this.testDependency1 = AbstractContinuumStoreTestCase.createTestDependency("groupId1", "artifactId1", "version1");
        this.testDependency2 = AbstractContinuumStoreTestCase.createTestDependency("groupId2", "artifactId2", "version2");
        this.testDependency3 = AbstractContinuumStoreTestCase.createTestDependency("groupId3", "artifactId3", "version3");
        long baseTime = System.currentTimeMillis();
        this.testBuildResult1 = AbstractContinuumStoreTestCase.createTestBuildResult(1, true, 1, 1, "error1", 1, baseTime, baseTime + 1000L);
        BuildResult buildResult1 = AbstractContinuumStoreTestCase.createTestBuildResult(this.testBuildResult1);
        ScmResult scmResult = AbstractContinuumStoreTestCase.createTestScmResult("commandOutput1", "providerMessage1", true, "1");
        buildResult1.setScmResult(scmResult);
        ScmResult testBuildResult1ScmResult = AbstractContinuumStoreTestCase.createTestScmResult(scmResult, "1");
        this.testBuildResult1.setScmResult(testBuildResult1ScmResult);
        this.testCheckoutResult1 = AbstractContinuumStoreTestCase.createTestScmResult("commandOutputCO1", "providerMessageCO1", false, "CO1");
        ScmResult checkoutResult1 = AbstractContinuumStoreTestCase.createTestScmResult(this.testCheckoutResult1, "CO1");
        this.testProject1.setCheckoutResult(checkoutResult1);
        this.testProject1.addBuildResult(buildResult1);
        this.testBuildResult2 = AbstractContinuumStoreTestCase.createTestBuildResult(2, false, 2, 2, "error2", 2, baseTime + 2000L, baseTime + 3000L);
        BuildResult buildResult2 = AbstractContinuumStoreTestCase.createTestBuildResult(this.testBuildResult2);
        this.testProject1.addBuildResult(buildResult2);
        this.testBuildResult3 = AbstractContinuumStoreTestCase.createTestBuildResult(3, true, 3, 3, "error3", 3, baseTime + 4000L, baseTime + 5000L);
        BuildResult buildResult3 = AbstractContinuumStoreTestCase.createTestBuildResult(this.testBuildResult3);
        scmResult = AbstractContinuumStoreTestCase.createTestScmResult("commandOutput3", "providerMessage3", true, "3");
        buildResult3.setScmResult(scmResult);
        this.testBuildResult3.setScmResult(AbstractContinuumStoreTestCase.createTestScmResult(scmResult, "3"));
        this.testProject2.addBuildResult(buildResult3);
        Schedule schedule2 = AbstractContinuumStoreTestCase.createTestSchedule(this.testSchedule2);
        if (addToStore) {
            schedule2 = this.store.addSchedule(schedule2);
            this.testSchedule2.setId(schedule2.getId());
        } else {
            this.testSchedule2.setId(1);
        }
        Schedule schedule1 = AbstractContinuumStoreTestCase.createTestSchedule(this.testSchedule1);
        if (addToStore) {
            schedule1 = this.store.addSchedule(schedule1);
            this.testSchedule1.setId(schedule1.getId());
        } else {
            this.testSchedule1.setId(2);
        }
        Schedule schedule3 = AbstractContinuumStoreTestCase.createTestSchedule(this.testSchedule3);
        if (addToStore) {
            schedule3 = this.store.addSchedule(schedule3);
            this.testSchedule3.setId(schedule3.getId());
        } else {
            this.testSchedule3.setId(3);
        }
        Installation installationJava14 = AbstractContinuumStoreTestCase.createTestInstallation(this.testInstallationJava14);
        if (addToStore) {
            installationJava14 = this.store.addInstallation(installationJava14);
        }
        Installation installationMaven20a3 = AbstractContinuumStoreTestCase.createTestInstallation(this.testInstallationMaven20a3);
        if (addToStore) {
            installationMaven20a3 = this.store.addInstallation(installationMaven20a3);
        }
        Installation installationJava13 = AbstractContinuumStoreTestCase.createTestInstallation(this.testInstallationJava13);
        if (addToStore) {
            installationJava13 = this.store.addInstallation(installationJava13);
        }
        this.testProfile1 = AbstractContinuumStoreTestCase.createTestProfile("name1", "description1", 1, true, true, installationJava13, installationMaven20a3);
        this.testProfile2 = AbstractContinuumStoreTestCase.createTestProfile("name2", "description2", 2, false, true, installationJava14, installationMaven20a3);
        this.testProfile3 = AbstractContinuumStoreTestCase.createTestProfile("name3", "description3", 3, true, false, installationJava14, installationMaven20a3);
        Profile profile1 = AbstractContinuumStoreTestCase.createTestProfile(this.testProfile1);
        if (addToStore) {
            profile1 = this.store.addProfile(profile1);
        }
        this.testProfile1.setId(profile1.getId());
        Profile profile2 = AbstractContinuumStoreTestCase.createTestProfile(this.testProfile2);
        if (addToStore) {
            profile2 = this.store.addProfile(profile2);
        }
        this.testProfile2.setId(profile2.getId());
        Profile profile3 = AbstractContinuumStoreTestCase.createTestProfile(this.testProfile3);
        if (addToStore) {
            profile3 = this.store.addProfile(profile3);
        }
        this.testProfile3.setId(profile3.getId());
        BuildDefinition testGroupBuildDefinition1 = AbstractContinuumStoreTestCase.createTestBuildDefinition("arguments1", "buildFile1", "goals1", profile1, schedule2, false, false);
        BuildDefinition testGroupBuildDefinition2 = AbstractContinuumStoreTestCase.createTestBuildDefinition("arguments2", "buildFile2", "goals2", profile1, schedule1, false, false);
        BuildDefinition testGroupBuildDefinition3 = AbstractContinuumStoreTestCase.createTestBuildDefinition("arguments3", "buildFile3", "goals3", profile2, schedule1, false, false);
        BuildDefinition testGroupBuildDefinition4 = AbstractContinuumStoreTestCase.createTestBuildDefinition(null, null, "deploy", null, null, false, false);
        BuildDefinition testBuildDefinition1 = AbstractContinuumStoreTestCase.createTestBuildDefinition("arguments11", "buildFile11", "goals11", profile2, schedule1, false, false);
        BuildDefinition testBuildDefinition2 = AbstractContinuumStoreTestCase.createTestBuildDefinition("arguments12", "buildFile12", "goals12", profile2, schedule2, false, false);
        BuildDefinition testBuildDefinition3 = AbstractContinuumStoreTestCase.createTestBuildDefinition("arguments13", "buildFile13", "goals13", profile1, schedule2, false, false);
        BuildDefinition testBuildDefinition4 = AbstractContinuumStoreTestCase.createTestBuildDefinition(null, null, "deploy", null, null, false, false);
        ProjectGroup group = AbstractContinuumStoreTestCase.createTestProjectGroup(this.defaultProjectGroup);
        Project project1 = AbstractContinuumStoreTestCase.createTestProject(this.testProject1);
        project1.addBuildResult(buildResult1);
        project1.addBuildResult(buildResult2);
        project1.setCheckoutResult(checkoutResult1);
        ProjectNotifier notifier1 = AbstractContinuumStoreTestCase.createTestNotifier(this.testNotifier1);
        project1.addNotifier(notifier1);
        this.testProject1.addNotifier(this.testNotifier1);
        BuildDefinition buildDefinition1 = AbstractContinuumStoreTestCase.createTestBuildDefinition(testBuildDefinition1);
        project1.addBuildDefinition(buildDefinition1);
        this.testProject1.addBuildDefinition(testBuildDefinition1);
        BuildDefinition buildDefinition2 = AbstractContinuumStoreTestCase.createTestBuildDefinition(testBuildDefinition2);
        project1.addBuildDefinition(buildDefinition2);
        this.testProject1.addBuildDefinition(testBuildDefinition2);
        ProjectDeveloper projectDeveloper1 = AbstractContinuumStoreTestCase.createTestDeveloper(this.testDeveloper1);
        project1.addDeveloper(projectDeveloper1);
        this.testProject1.addDeveloper(this.testDeveloper1);
        ProjectDependency projectDependency1 = AbstractContinuumStoreTestCase.createTestDependency(this.testDependency1);
        project1.addDependency(projectDependency1);
        this.testProject1.addDependency(this.testDependency1);
        ProjectDependency projectDependency2 = AbstractContinuumStoreTestCase.createTestDependency(this.testDependency2);
        project1.addDependency(projectDependency2);
        this.testProject1.addDependency(this.testDependency2);
        group.addProject(project1);
        this.defaultProjectGroup.addProject(project1);
        Project project2 = AbstractContinuumStoreTestCase.createTestProject(this.testProject2);
        project2.addBuildResult(buildResult3);
        ProjectNotifier notifier2 = AbstractContinuumStoreTestCase.createTestNotifier(this.testNotifier2);
        project2.addNotifier(notifier2);
        this.testProject2.addNotifier(this.testNotifier2);
        ProjectNotifier notifier3 = AbstractContinuumStoreTestCase.createTestNotifier(this.testNotifier3);
        project2.addNotifier(notifier3);
        this.testProject2.addNotifier(this.testNotifier3);
        BuildDefinition buildDefinition3 = AbstractContinuumStoreTestCase.createTestBuildDefinition(testBuildDefinition3);
        project2.addBuildDefinition(buildDefinition3);
        this.testProject2.addBuildDefinition(testBuildDefinition3);
        BuildDefinition buildDefinition4 = AbstractContinuumStoreTestCase.createTestBuildDefinition(testBuildDefinition4);
        project2.addBuildDefinition(buildDefinition4);
        this.testProject2.addBuildDefinition(testBuildDefinition4);
        ProjectDeveloper projectDeveloper2 = AbstractContinuumStoreTestCase.createTestDeveloper(this.testDeveloper2);
        project2.addDeveloper(projectDeveloper2);
        this.testProject2.addDeveloper(this.testDeveloper2);
        ProjectDeveloper projectDeveloper3 = AbstractContinuumStoreTestCase.createTestDeveloper(this.testDeveloper3);
        project2.addDeveloper(projectDeveloper3);
        this.testProject2.addDeveloper(this.testDeveloper3);
        ProjectDependency projectDependency3 = AbstractContinuumStoreTestCase.createTestDependency(this.testDependency3);
        project2.addDependency(projectDependency3);
        this.testProject2.addDependency(this.testDependency3);
        group.addProject(project2);
        this.defaultProjectGroup.addProject(project2);
        ProjectNotifier groupNotifier1 = AbstractContinuumStoreTestCase.createTestNotifier(this.testGroupNotifier1);
        group.addNotifier(groupNotifier1);
        this.defaultProjectGroup.addNotifier(this.testGroupNotifier1);
        ProjectNotifier groupNotifier2 = AbstractContinuumStoreTestCase.createTestNotifier(this.testGroupNotifier2);
        group.addNotifier(groupNotifier2);
        this.defaultProjectGroup.addNotifier(this.testGroupNotifier2);
        BuildDefinition groupBuildDefinition1 = AbstractContinuumStoreTestCase.createTestBuildDefinition(testGroupBuildDefinition1);
        group.addBuildDefinition(groupBuildDefinition1);
        this.defaultProjectGroup.addBuildDefinition(testGroupBuildDefinition1);
        if (addToStore) {
            this.store.addProjectGroup(group);
            this.defaultProjectGroup.setId(group.getId());
            this.testProject1.setId(project1.getId());
            this.testProject2.setId(project2.getId());
            this.testBuildResult1.setId(buildResult1.getId());
            this.testBuildResult2.setId(buildResult2.getId());
            this.testBuildResult3.setId(buildResult3.getId());
        } else {
            this.defaultProjectGroup.setId(1);
            this.testProject1.setId(1);
            this.testProject2.setId(2);
        }
        group = AbstractContinuumStoreTestCase.createTestProjectGroup(this.testProjectGroup2);
        ProjectNotifier groupNotifier3 = AbstractContinuumStoreTestCase.createTestNotifier(this.testGroupNotifier3);
        group.addNotifier(groupNotifier3);
        this.testProjectGroup2.addNotifier(this.testGroupNotifier3);
        BuildDefinition groupBuildDefinition2 = AbstractContinuumStoreTestCase.createTestBuildDefinition(testGroupBuildDefinition2);
        group.addBuildDefinition(groupBuildDefinition2);
        this.testProjectGroup2.addBuildDefinition(testGroupBuildDefinition2);
        BuildDefinition groupBuildDefinition3 = AbstractContinuumStoreTestCase.createTestBuildDefinition(testGroupBuildDefinition3);
        group.addBuildDefinition(groupBuildDefinition3);
        this.testProjectGroup2.addBuildDefinition(testGroupBuildDefinition3);
        BuildDefinition groupBuildDefinition4 = AbstractContinuumStoreTestCase.createTestBuildDefinition(testGroupBuildDefinition4);
        group.addBuildDefinition(groupBuildDefinition4);
        this.testProjectGroup2.addBuildDefinition(testGroupBuildDefinition4);
        if (addToStore) {
            this.store.addProjectGroup(group);
            this.testProjectGroup2.setId(group.getId());
        } else {
            this.testProjectGroup2.setId(2);
        }
        this.systemConfiguration = new SystemConfiguration();
        this.systemConfiguration.setBaseUrl("baseUrl");
        this.systemConfiguration.setBuildOutputDirectory("buildOutputDirectory");
        this.systemConfiguration.setDefaultScheduleCronExpression("* * * * *");
        this.systemConfiguration.setDefaultScheduleDescription("Description");
        this.systemConfiguration.setDeploymentRepositoryDirectory("deployment");
        this.systemConfiguration.setGuestAccountEnabled(false);
        this.systemConfiguration.setInitialized(true);
        this.systemConfiguration.setWorkingDirectory("workingDirectory");
        if (addToStore) {
            this.systemConfiguration = this.store.addSystemConfiguration(this.systemConfiguration);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.store.eraseDatabase();
        this.store.closeStore();
    }

    protected void assertBuildDatabase() throws ContinuumStoreException {
        AbstractContinuumStoreTestCase.assertProjectGroupEquals(this.defaultProjectGroup, this.store.getProjectGroup(this.defaultProjectGroup.getId()));
        AbstractContinuumStoreTestCase.assertProjectGroupEquals(this.testProjectGroup2, this.store.getProjectGroup(this.testProjectGroup2.getId()));
        AbstractContinuumStoreTestCase.assertProjectEquals(this.testProject1, this.store.getProject(this.testProject1.getId()));
        AbstractContinuumStoreTestCase.assertProjectEquals(this.testProject2, this.store.getProject(this.testProject2.getId()));
        AbstractContinuumStoreTestCase.assertScheduleEquals(this.testSchedule1, this.store.getSchedule(this.testSchedule1.getId()));
        AbstractContinuumStoreTestCase.assertScheduleEquals(this.testSchedule2, this.store.getSchedule(this.testSchedule2.getId()));
        AbstractContinuumStoreTestCase.assertScheduleEquals(this.testSchedule3, this.store.getSchedule(this.testSchedule3.getId()));
        Iterator iterator = this.store.getAllInstallations().iterator();
        AbstractContinuumStoreTestCase.assertInstallationEquals(this.testInstallationJava13, (Installation)iterator.next());
        AbstractContinuumStoreTestCase.assertInstallationEquals(this.testInstallationJava14, (Installation)iterator.next());
        AbstractContinuumStoreTestCase.assertInstallationEquals(this.testInstallationMaven20a3, (Installation)iterator.next());
        this.assertSystemConfiguration(this.systemConfiguration, this.store.getSystemConfiguration());
    }

    private void assertSystemConfiguration(SystemConfiguration expected, SystemConfiguration actual) {
        AbstractContinuumStoreTestCase.assertNotSame((Object)expected, (Object)actual);
        AbstractContinuumStoreTestCase.assertEquals((String)expected.getBaseUrl(), (String)actual.getBaseUrl());
        AbstractContinuumStoreTestCase.assertEquals((String)expected.getBuildOutputDirectory(), (String)actual.getBuildOutputDirectory());
        AbstractContinuumStoreTestCase.assertEquals((String)expected.getDefaultScheduleCronExpression(), (String)actual.getDefaultScheduleCronExpression());
        AbstractContinuumStoreTestCase.assertEquals((String)expected.getDefaultScheduleDescription(), (String)actual.getDefaultScheduleDescription());
        AbstractContinuumStoreTestCase.assertEquals((String)expected.getDeploymentRepositoryDirectory(), (String)actual.getDeploymentRepositoryDirectory());
        AbstractContinuumStoreTestCase.assertEquals((boolean)expected.isGuestAccountEnabled(), (boolean)actual.isGuestAccountEnabled());
        AbstractContinuumStoreTestCase.assertEquals((boolean)expected.isInitialized(), (boolean)actual.isInitialized());
        AbstractContinuumStoreTestCase.assertEquals((String)expected.getWorkingDirectory(), (String)actual.getWorkingDirectory());
    }

    protected void assertEmpty() throws ContinuumStoreException {
        AbstractContinuumStoreTestCase.assertEquals((int)0, (int)this.store.getAllInstallations().size());
        AbstractContinuumStoreTestCase.assertEquals((int)0, (int)this.store.getAllProfilesByName().size());
        AbstractContinuumStoreTestCase.assertEquals((int)0, (int)this.store.getAllProjectGroups().size());
        AbstractContinuumStoreTestCase.assertEquals((int)0, (int)this.store.getAllProjectsByName().size());
        AbstractContinuumStoreTestCase.assertNull((Object)this.store.getSystemConfiguration());
    }

    protected static BuildDefinition createTestBuildDefinition(BuildDefinition buildDefinition) {
        return AbstractContinuumStoreTestCase.createTestBuildDefinition(buildDefinition.getArguments(), buildDefinition.getBuildFile(), buildDefinition.getGoals(), buildDefinition.getProfile(), buildDefinition.getSchedule(), buildDefinition.isDefaultForProject(), buildDefinition.isBuildFresh());
    }

    protected static BuildDefinition createTestBuildDefinition(String arguments, String buildFile, String goals, Profile profile, Schedule schedule, boolean defaultForProject, boolean buildFresh) {
        BuildDefinition definition = new BuildDefinition();
        definition.setArguments(arguments);
        definition.setBuildFile(buildFile);
        definition.setGoals(goals);
        definition.setProfile(profile);
        definition.setSchedule(schedule);
        definition.setDefaultForProject(defaultForProject);
        definition.setBuildFresh(buildFresh);
        return definition;
    }

    protected static ProjectNotifier createTestNotifier(ProjectNotifier notifier) {
        return AbstractContinuumStoreTestCase.createTestNotifier(notifier.getRecipientType(), notifier.isSendOnError(), notifier.isSendOnFailure(), notifier.isSendOnSuccess(), notifier.getType());
    }

    protected static ProjectNotifier createTestNotifier(int recipientType, boolean sendOnError, boolean sendOnFailure, boolean sendOnSuccess, String type) {
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("key1", "value1");
        configuration.put("key2", "value2");
        ProjectNotifier notifier = new ProjectNotifier();
        notifier.setConfiguration(configuration);
        notifier.setRecipientType(recipientType);
        notifier.setSendOnError(sendOnError);
        notifier.setSendOnFailure(sendOnFailure);
        notifier.setSendOnSuccess(sendOnSuccess);
        notifier.setType(type);
        return notifier;
    }

    private static ScmResult createTestScmResult(ScmResult scmResult, String base) {
        return AbstractContinuumStoreTestCase.createTestScmResult(scmResult.getCommandOutput(), scmResult.getProviderMessage(), scmResult.isSuccess(), base);
    }

    private static ScmResult createTestScmResult(String commandOutput, String providerMessage, boolean success, String base) {
        ScmResult scmResult = new ScmResult();
        scmResult.setCommandOutput(commandOutput);
        scmResult.setProviderMessage(providerMessage);
        scmResult.setSuccess(success);
        ArrayList<ChangeSet> changes = new ArrayList<ChangeSet>();
        changes.add(AbstractContinuumStoreTestCase.createTestChangeSet("author" + base + ".1", "comment" + base + ".1", base + ".1"));
        changes.add(AbstractContinuumStoreTestCase.createTestChangeSet("author" + base + ".2", "comment" + base + ".2", base + ".2"));
        scmResult.setChanges(changes);
        return scmResult;
    }

    private static ChangeSet createTestChangeSet(String author, String comment, String base) {
        ChangeSet changeSet = new ChangeSet();
        changeSet.setAuthor(author);
        changeSet.setComment(comment);
        changeSet.setDate(System.currentTimeMillis());
        ArrayList<ChangeFile> files = new ArrayList<ChangeFile>();
        files.add(AbstractContinuumStoreTestCase.createTestChangeFile("name" + base + ".1", "rev" + base + ".1"));
        files.add(AbstractContinuumStoreTestCase.createTestChangeFile("name" + base + ".2", "rev" + base + ".2"));
        files.add(AbstractContinuumStoreTestCase.createTestChangeFile("name" + base + ".3", "rev" + base + ".3"));
        changeSet.setFiles(files);
        return changeSet;
    }

    private static ChangeFile createTestChangeFile(String name, String revision) {
        ChangeFile changeFile = new ChangeFile();
        changeFile.setName(name);
        changeFile.setRevision(revision);
        return changeFile;
    }

    private static BuildResult createTestBuildResult(BuildResult buildResult) {
        return AbstractContinuumStoreTestCase.createTestBuildResult(buildResult.getTrigger(), buildResult.isSuccess(), buildResult.getState(), buildResult.getExitCode(), buildResult.getError(), buildResult.getBuildNumber(), buildResult.getStartTime(), buildResult.getEndTime());
    }

    private static BuildResult createTestBuildResult(int trigger, boolean success, int state, int exitCode, String error, int buildNumber, long startTime, long endTime) {
        BuildResult result = new BuildResult();
        result.setBuildNumber(buildNumber);
        result.setStartTime(startTime);
        result.setEndTime(endTime);
        result.setError(error);
        result.setExitCode(exitCode);
        result.setState(state);
        result.setSuccess(success);
        result.setTrigger(trigger);
        return result;
    }

    protected static Installation createTestInstallation(String name, String type, String varName, String varValue) {
        Installation installation = new Installation();
        installation.setName(name);
        installation.setVarName(varName);
        installation.setVarValue(varValue);
        return installation;
    }

    protected static Installation createTestInstallation(Installation installation) {
        return AbstractContinuumStoreTestCase.createTestInstallation(installation.getName(), installation.getType(), installation.getVarName(), installation.getVarValue());
    }

    protected static Schedule createTestSchedule(Schedule schedule) {
        return AbstractContinuumStoreTestCase.createTestSchedule(schedule.getName(), schedule.getDescription(), schedule.getDelay(), schedule.getCronExpression(), schedule.isActive());
    }

    protected static Schedule createTestSchedule(String name, String description, int delay, String cronExpression, boolean active) {
        Schedule schedule = new Schedule();
        schedule.setActive(active);
        schedule.setCronExpression(cronExpression);
        schedule.setDelay(delay);
        schedule.setDescription(description);
        schedule.setName(name);
        return schedule;
    }

    protected static Profile createTestProfile(Profile profile) {
        return AbstractContinuumStoreTestCase.createTestProfile(profile.getName(), profile.getDescription(), profile.getScmMode(), profile.isBuildWithoutChanges(), profile.isActive(), profile.getJdk(), profile.getBuilder());
    }

    protected static Profile createTestProfile(String name, String description, int scmMode, boolean buildWithoutChanges, boolean active, Installation jdk, Installation builder) {
        Profile profile = new Profile();
        profile.setActive(active);
        profile.setBuildWithoutChanges(buildWithoutChanges);
        profile.setScmMode(scmMode);
        profile.setDescription(description);
        profile.setName(name);
        profile.setBuilder(builder);
        profile.setJdk(jdk);
        return profile;
    }

    protected static Profile createTestProfile(String name, String description, int scmMode, boolean buildWithoutChanges, boolean active, Installation jdk, Installation builder, List envVars) {
        Profile profile = new Profile();
        profile.setActive(active);
        profile.setBuildWithoutChanges(buildWithoutChanges);
        profile.setScmMode(scmMode);
        profile.setDescription(description);
        profile.setName(name);
        profile.setBuilder(builder);
        profile.setJdk(jdk);
        profile.setEnvironmentVariables(envVars);
        return profile;
    }

    protected static ProjectGroup createTestProjectGroup(ProjectGroup group) {
        return AbstractContinuumStoreTestCase.createTestProjectGroup(group.getName(), group.getDescription(), group.getGroupId());
    }

    protected static ProjectGroup createTestProjectGroup(String name, String description, String groupId) {
        ProjectGroup group = new ProjectGroup();
        group.setName(name);
        group.setDescription(description);
        group.setGroupId(groupId);
        return group;
    }

    protected static Project createTestProject(Project project) {
        return AbstractContinuumStoreTestCase.createTestProject(project.getArtifactId(), project.getBuildNumber(), project.getDescription(), project.getGroupId(), project.getName(), project.getScmUrl(), project.getState(), project.getUrl(), project.getVersion(), project.getWorkingDirectory());
    }

    private static Project createTestProject(String artifactId, int buildNumber, String description, String groupId, String name, String scmUrl, int state, String url, String version, String workingDirectory) {
        Project project = new Project();
        project.setArtifactId(artifactId);
        project.setBuildNumber(buildNumber);
        project.setDescription(description);
        project.setGroupId(groupId);
        project.setName(name);
        project.setScmUrl(scmUrl);
        project.setState(state);
        project.setUrl(url);
        project.setVersion(version);
        project.setWorkingDirectory(workingDirectory);
        return project;
    }

    protected static void assertProjectEquals(Project expectedProject, Project project) {
        AbstractContinuumStoreTestCase.assertEquals((String)"compare projects", (Object)expectedProject, (Object)project);
        AbstractContinuumStoreTestCase.assertNotSame((Object)expectedProject, (Object)project);
        AbstractContinuumStoreTestCase.assertEquals((String)"compare expectedProject - name", (String)expectedProject.getName(), (String)project.getName());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare expectedProject - desc", (String)expectedProject.getDescription(), (String)project.getDescription());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare expectedProject - groupId", (String)expectedProject.getGroupId(), (String)project.getGroupId());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare expectedProject - artifactId", (String)expectedProject.getArtifactId(), (String)project.getArtifactId());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare expectedProject - buildNumber", (int)expectedProject.getBuildNumber(), (int)project.getBuildNumber());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare expectedProject - scmUrl", (String)expectedProject.getScmUrl(), (String)project.getScmUrl());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare expectedProject - state", (int)expectedProject.getState(), (int)project.getState());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare expectedProject - url", (String)expectedProject.getUrl(), (String)project.getUrl());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare expectedProject - version", (String)expectedProject.getVersion(), (String)project.getVersion());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare expectedProject - workingDirectory", (String)expectedProject.getWorkingDirectory(), (String)project.getWorkingDirectory());
    }

    protected static void assertProjectGroupEquals(ProjectGroup expectedGroup, ProjectGroup actualGroup) {
        AbstractContinuumStoreTestCase.assertEquals((String)"compare project groups", (Object)expectedGroup, (Object)actualGroup);
        AbstractContinuumStoreTestCase.assertNotSame((Object)expectedGroup, (Object)actualGroup);
        AbstractContinuumStoreTestCase.assertEquals((String)"compare project groups - name", (String)expectedGroup.getName(), (String)actualGroup.getName());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare project groups - desc", (String)expectedGroup.getDescription(), (String)actualGroup.getDescription());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare project groups - groupId", (String)expectedGroup.getGroupId(), (String)actualGroup.getGroupId());
    }

    protected static void assertScheduleEquals(Schedule expectedSchedule, Schedule actualSchedule) {
        AbstractContinuumStoreTestCase.assertEquals((Object)expectedSchedule, (Object)actualSchedule);
        if (expectedSchedule != null) {
            AbstractContinuumStoreTestCase.assertNotSame((Object)expectedSchedule, (Object)actualSchedule);
            AbstractContinuumStoreTestCase.assertEquals((String)"compare schedule - id", (int)expectedSchedule.getId(), (int)actualSchedule.getId());
            AbstractContinuumStoreTestCase.assertEquals((String)"compare schedule - name", (String)expectedSchedule.getName(), (String)actualSchedule.getName());
            AbstractContinuumStoreTestCase.assertEquals((String)"compare schedule - desc", (String)expectedSchedule.getDescription(), (String)actualSchedule.getDescription());
            AbstractContinuumStoreTestCase.assertEquals((String)"compare schedule - delay", (int)expectedSchedule.getDelay(), (int)actualSchedule.getDelay());
            AbstractContinuumStoreTestCase.assertEquals((String)"compare schedule - cron", (String)expectedSchedule.getCronExpression(), (String)actualSchedule.getCronExpression());
            AbstractContinuumStoreTestCase.assertEquals((String)"compare schedule - active", (boolean)expectedSchedule.isActive(), (boolean)actualSchedule.isActive());
        }
    }

    protected static void assertProfileEquals(Profile expectedProfile, Profile actualProfile) {
        AbstractContinuumStoreTestCase.assertEquals((Object)expectedProfile, (Object)actualProfile);
        if (expectedProfile != null) {
            AbstractContinuumStoreTestCase.assertNotSame((Object)expectedProfile, (Object)actualProfile);
            AbstractContinuumStoreTestCase.assertEquals((String)"compare profile - name", (String)expectedProfile.getName(), (String)actualProfile.getName());
            AbstractContinuumStoreTestCase.assertEquals((String)"compare profile - desc", (String)expectedProfile.getDescription(), (String)actualProfile.getDescription());
            AbstractContinuumStoreTestCase.assertEquals((String)"compare profile - scmMode", (int)expectedProfile.getScmMode(), (int)actualProfile.getScmMode());
            AbstractContinuumStoreTestCase.assertEquals((String)"compare profile - build w/o changes", (boolean)expectedProfile.isBuildWithoutChanges(), (boolean)actualProfile.isBuildWithoutChanges());
            AbstractContinuumStoreTestCase.assertEquals((String)"compare profile - active", (boolean)expectedProfile.isActive(), (boolean)actualProfile.isActive());
        }
    }

    protected static void assertInstallationEquals(Installation expected, Installation actual) {
        AbstractContinuumStoreTestCase.assertNotNull((Object)actual);
        AbstractContinuumStoreTestCase.assertEquals((String)"compare installation - name", (String)expected.getName(), (String)actual.getName());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare installation - varName", (String)expected.getVarName(), (String)actual.getVarName());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare installation - varValue", (String)expected.getVarValue(), (String)actual.getVarValue());
    }

    protected static void assertBuildResultEquals(BuildResult expected, BuildResult actual) {
        AbstractContinuumStoreTestCase.assertEquals((String)"compare build result - build #", (int)expected.getBuildNumber(), (int)actual.getBuildNumber());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare build result - end time", (long)expected.getEndTime(), (long)actual.getEndTime());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare build result - error", (String)expected.getError(), (String)actual.getError());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare build result - exit code", (int)expected.getExitCode(), (int)actual.getExitCode());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare build result - start time", (long)expected.getStartTime(), (long)actual.getStartTime());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare build result - state", (int)expected.getState(), (int)actual.getState());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare build result - trigger", (int)expected.getTrigger(), (int)actual.getTrigger());
    }

    protected static void assertScmResultEquals(ScmResult expected, ScmResult actual) {
        AbstractContinuumStoreTestCase.assertEquals((String)"compare SCM result - output", (String)expected.getCommandOutput(), (String)actual.getCommandOutput());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare SCM result - message", (String)expected.getProviderMessage(), (String)actual.getProviderMessage());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare SCM result - success", (boolean)expected.isSuccess(), (boolean)actual.isSuccess());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare SCM result - changes size", (int)actual.getChanges().size(), (int)expected.getChanges().size());
        for (int i = 0; i < actual.getChanges().size(); ++i) {
            AbstractContinuumStoreTestCase.assertChangeSetEquals((ChangeSet)expected.getChanges().get(i), (ChangeSet)actual.getChanges().get(i));
        }
    }

    private static void assertChangeSetEquals(ChangeSet expected, ChangeSet actual) {
        AbstractContinuumStoreTestCase.assertEquals((String)"compare change set result - author", (String)expected.getAuthor(), (String)actual.getAuthor());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare change set result - comment", (String)expected.getComment(), (String)actual.getComment());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare change set result - files size", (int)expected.getFiles().size(), (int)actual.getFiles().size());
        for (int i = 0; i < actual.getFiles().size(); ++i) {
            AbstractContinuumStoreTestCase.assertChangeFileEquals((ChangeFile)expected.getFiles().get(i), (ChangeFile)actual.getFiles().get(i));
        }
    }

    private static void assertChangeFileEquals(ChangeFile expected, ChangeFile actual) {
        AbstractContinuumStoreTestCase.assertEquals((String)"compare change file result - name", (String)expected.getName(), (String)actual.getName());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare change file result - revision", (String)expected.getRevision(), (String)actual.getRevision());
    }

    protected static void assertNotifiersEqual(List expected, List actual) {
        for (int i = 0; i < actual.size(); ++i) {
            AbstractContinuumStoreTestCase.assertNotifierEquals((ProjectNotifier)expected.get(i), (ProjectNotifier)actual.get(i));
        }
    }

    protected static void assertNotifierEquals(ProjectNotifier expected, ProjectNotifier actual) {
        AbstractContinuumStoreTestCase.assertEquals((String)"compare notifier - recipient type", (int)expected.getRecipientType(), (int)actual.getRecipientType());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare notifier - type", (String)expected.getType(), (String)actual.getType());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare notifier - configuration", (Object)expected.getConfiguration(), (Object)actual.getConfiguration());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare notifier - send on success", (boolean)expected.isSendOnSuccess(), (boolean)actual.isSendOnSuccess());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare notifier - send on failure", (boolean)expected.isSendOnFailure(), (boolean)actual.isSendOnFailure());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare notifier - send on error", (boolean)expected.isSendOnError(), (boolean)actual.isSendOnError());
    }

    protected static void assertBuildDefinitionsEqual(List expectedBuildDefinitions, List actualBuildDefinitions) {
        for (int i = 0; i < expectedBuildDefinitions.size(); ++i) {
            BuildDefinition expectedBuildDefinition = (BuildDefinition)expectedBuildDefinitions.get(i);
            BuildDefinition actualBuildDefinition = (BuildDefinition)actualBuildDefinitions.get(i);
            AbstractContinuumStoreTestCase.assertBuildDefinitionEquals(expectedBuildDefinition, actualBuildDefinition);
            AbstractContinuumStoreTestCase.assertScheduleEquals(expectedBuildDefinition.getSchedule(), actualBuildDefinition.getSchedule());
            AbstractContinuumStoreTestCase.assertProfileEquals(expectedBuildDefinition.getProfile(), actualBuildDefinition.getProfile());
        }
    }

    protected static void assertBuildDefinitionEquals(BuildDefinition expectedBuildDefinition, BuildDefinition actualBuildDefinition) {
        AbstractContinuumStoreTestCase.assertEquals((String)"compare build definition - arguments", (String)expectedBuildDefinition.getArguments(), (String)actualBuildDefinition.getArguments());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare build definition - build file", (String)expectedBuildDefinition.getBuildFile(), (String)actualBuildDefinition.getBuildFile());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare build definition - goals", (String)expectedBuildDefinition.getGoals(), (String)actualBuildDefinition.getGoals());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare build definition - build fresh", (boolean)expectedBuildDefinition.isBuildFresh(), (boolean)actualBuildDefinition.isBuildFresh());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare build definition - defaultForProject", (boolean)expectedBuildDefinition.isDefaultForProject(), (boolean)actualBuildDefinition.isDefaultForProject());
    }

    protected static void assertDevelopersEqual(List expectedDevelopers, List actualDevelopers) {
        for (int i = 0; i < actualDevelopers.size(); ++i) {
            AbstractContinuumStoreTestCase.assertDeveloperEquals((ProjectDeveloper)expectedDevelopers.get(i), (ProjectDeveloper)actualDevelopers.get(i));
        }
    }

    protected static void assertDeveloperEquals(ProjectDeveloper expectedDeveloper, ProjectDeveloper actualDeveloper) {
        AbstractContinuumStoreTestCase.assertEquals((String)"compare developer - name", (String)expectedDeveloper.getName(), (String)actualDeveloper.getName());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare developer - email", (String)expectedDeveloper.getEmail(), (String)actualDeveloper.getEmail());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare developer - scmId", (String)expectedDeveloper.getScmId(), (String)actualDeveloper.getScmId());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare developer - continuumId", (int)expectedDeveloper.getContinuumId(), (int)actualDeveloper.getContinuumId());
    }

    protected static void assertDependenciesEqual(List expectedDependencies, List actualDependencies) {
        for (int i = 0; i < actualDependencies.size(); ++i) {
            AbstractContinuumStoreTestCase.assertDependencyEquals((ProjectDependency)expectedDependencies.get(i), (ProjectDependency)actualDependencies.get(i));
        }
    }

    protected static void assertDependencyEquals(ProjectDependency expectedDependency, ProjectDependency actualDependency) {
        AbstractContinuumStoreTestCase.assertEquals((String)"compare dependency - groupId", (String)expectedDependency.getGroupId(), (String)actualDependency.getGroupId());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare dependency - artifactId", (String)expectedDependency.getArtifactId(), (String)actualDependency.getArtifactId());
        AbstractContinuumStoreTestCase.assertEquals((String)"compare dependency - version", (String)expectedDependency.getVersion(), (String)actualDependency.getVersion());
    }

    protected static ProjectDependency createTestDependency(ProjectDependency dependency) {
        return AbstractContinuumStoreTestCase.createTestDependency(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
    }

    protected static ProjectDeveloper createTestDeveloper(ProjectDeveloper developer) {
        return AbstractContinuumStoreTestCase.createTestDeveloper(developer.getContinuumId(), developer.getEmail(), developer.getName(), developer.getScmId());
    }

    protected static ProjectDependency createTestDependency(String groupId, String artifactId, String version) {
        ProjectDependency dependency = new ProjectDependency();
        dependency.setArtifactId(artifactId);
        dependency.setGroupId(groupId);
        dependency.setVersion(version);
        return dependency;
    }

    protected static ProjectDeveloper createTestDeveloper(int continuumId, String email, String name, String scmId) {
        ProjectDeveloper developer = new ProjectDeveloper();
        developer.setContinuumId(continuumId);
        developer.setEmail(email);
        developer.setName(name);
        developer.setScmId(scmId);
        return developer;
    }

    protected ContinuumStore createStore() throws Exception {
        DefaultConfigurableJdoFactory jdoFactory = (DefaultConfigurableJdoFactory)this.lookup(JdoFactory.ROLE, "continuum");
        jdoFactory.setUrl("jdbc:hsqldb:mem:" + this.getName());
        return (ContinuumStore)this.lookup(ContinuumStore.ROLE, "jdo");
    }
}

