/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jdo.Extent;
import javax.jdo.JDOHelper;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;
import org.apache.maven.continuum.model.project.BuildDefinition;
import org.apache.maven.continuum.model.project.BuildResult;
import org.apache.maven.continuum.model.project.Profile;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.model.project.ProjectNotifier;
import org.apache.maven.continuum.model.project.Schedule;
import org.apache.maven.continuum.model.system.ContinuumUser;
import org.apache.maven.continuum.model.system.Installation;
import org.apache.maven.continuum.model.system.Permission;
import org.apache.maven.continuum.model.system.SystemConfiguration;
import org.apache.maven.continuum.model.system.UserGroup;
import org.apache.maven.continuum.store.AbstractContinuumStore;
import org.apache.maven.continuum.store.ContinuumObjectNotFoundException;
import org.apache.maven.continuum.store.ContinuumStore;
import org.apache.maven.continuum.store.ContinuumStoreException;
import org.codehaus.plexus.jdo.JdoFactory;
import org.codehaus.plexus.jdo.PlexusJdoUtils;
import org.codehaus.plexus.jdo.PlexusObjectNotFoundException;
import org.codehaus.plexus.jdo.PlexusStoreException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;

public class JdoContinuumStore
extends AbstractContinuumStore
implements ContinuumStore,
Initializable {
    private JdoFactory jdoFactory;
    private PersistenceManagerFactory pmf;
    private static final String PROJECT_WITH_BUILDS_FETCH_GROUP = "project-with-builds";
    private static final String PROJECT_WITH_CHECKOUT_RESULT_FETCH_GROUP = "project-with-checkout-result";
    private static final String BUILD_RESULT_WITH_DETAILS_FETCH_GROUP = "build-result-with-details";
    private static final String PROJECT_BUILD_DETAILS_FETCH_GROUP = "project-build-details";
    private static final String PROJECT_ALL_DETAILS_FETCH_GROUP = "project-all-details";
    private static final String PROJECT_DEPENDENCIES_FETCH_GROUP = "project-dependencies";
    private static final String PROJECTGROUP_PROJECTS_FETCH_GROUP = "projectgroup-projects";
    private static final String DEFAULT_GROUP_ID = "default";
    static /* synthetic */ Class class$org$apache$maven$continuum$model$project$Project;
    static /* synthetic */ Class class$org$apache$maven$continuum$model$project$BuildResult;
    static /* synthetic */ Class class$org$apache$maven$continuum$model$project$BuildDefinition;
    static /* synthetic */ Class class$org$apache$maven$continuum$model$project$ProjectGroup;
    static /* synthetic */ Class class$org$apache$maven$continuum$model$project$Schedule;
    static /* synthetic */ Class class$org$apache$maven$continuum$model$project$Profile;
    static /* synthetic */ Class class$org$apache$maven$continuum$model$system$Installation;
    static /* synthetic */ Class class$org$apache$maven$continuum$model$system$SystemConfiguration;
    static /* synthetic */ Class class$org$apache$maven$continuum$model$system$ContinuumUser;
    static /* synthetic */ Class class$org$apache$maven$continuum$model$system$Permission;
    static /* synthetic */ Class class$org$apache$maven$continuum$model$system$UserGroup;

    public void initialize() throws InitializationException {
        this.pmf = this.jdoFactory.getPersistenceManagerFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project getProjectByName(String name) throws ContinuumStoreException {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(class$org$apache$maven$continuum$model$project$Project == null ? (class$org$apache$maven$continuum$model$project$Project = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Project")) : class$org$apache$maven$continuum$model$project$Project, true);
            Query query = pm.newQuery(extent);
            query.declareImports("import java.lang.String");
            query.declareParameters("String name");
            query.setFilter("this.name == name");
            Collection result = (Collection)query.execute((Object)name);
            if (result.size() == 0) {
                tx.commit();
                Project project = null;
                return project;
            }
            Object object = pm.detachCopy(result.iterator().next());
            tx.commit();
            Project project = (Project)object;
            return project;
        }
        finally {
            this.rollback(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getProjectIdsAndBuildDefinitionsIdsBySchedule(int scheduleId) throws ContinuumStoreException {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(class$org$apache$maven$continuum$model$project$Project == null ? (class$org$apache$maven$continuum$model$project$Project = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Project")) : class$org$apache$maven$continuum$model$project$Project, true);
            Query query = pm.newQuery(extent);
            query.declareParameters("int scheduleId");
            query.declareImports("import org.apache.maven.continuum.model.project.BuildDefinition");
            query.declareVariables("BuildDefinition buildDef");
            query.setFilter("buildDefinitions.contains(buildDef) && buildDef.schedule.id == scheduleId");
            query.setResult("this.id, buildDef.id");
            List result = (List)query.execute((Object)new Integer(scheduleId));
            HashMap projects = new HashMap();
            if (result != null && !result.isEmpty()) {
                Iterator i = result.iterator();
                while (i.hasNext()) {
                    Object[] obj = (Object[])i.next();
                    List<Object> buildDefinitions = projects.get(obj[0]) != null ? (List)projects.get(obj[0]) : new ArrayList<Object>();
                    buildDefinitions.add(obj[1]);
                    projects.put(obj[0], buildDefinitions);
                }
                HashMap hashMap = projects;
                return hashMap;
            }
        }
        finally {
            tx.commit();
            this.rollback(tx);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBuildResult(BuildResult build) throws ContinuumStoreException {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        Project project = build.getProject();
        try {
            tx.begin();
            if (!JDOHelper.isDetached((Object)build)) {
                throw new ContinuumStoreException("Not detached: " + build);
            }
            pm.makePersistent((Object)build);
            if (!JDOHelper.isDetached((Object)project)) {
                throw new ContinuumStoreException("Not detached: " + project);
            }
            project.setState(build.getState());
            pm.makePersistent((Object)project);
            tx.commit();
        }
        finally {
            this.rollback(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBuildResult(Project project, BuildResult build) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            pm.getFetchPlan().addGroup(PROJECT_WITH_BUILDS_FETCH_GROUP);
            Object objectId = pm.newObjectIdInstance(class$org$apache$maven$continuum$model$project$Project == null ? (class$org$apache$maven$continuum$model$project$Project = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Project")) : class$org$apache$maven$continuum$model$project$Project, (Object)new Integer(project.getId()));
            project = (Project)pm.getObjectById(objectId);
            build = (BuildResult)this.makePersistent(pm, build, false);
            project.setLatestBuildId(build.getId());
            project.setState(build.getState());
            project.addBuildResult(build);
            tx.commit();
        }
        finally {
            this.rollback(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildResult getLatestBuildResultForProject(int projectId) {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(class$org$apache$maven$continuum$model$project$BuildResult == null ? (class$org$apache$maven$continuum$model$project$BuildResult = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.BuildResult")) : class$org$apache$maven$continuum$model$project$BuildResult, true);
            Query query = pm.newQuery(extent);
            query.declareParameters("int projectId");
            query.setFilter("this.project.id == projectId && this.project.latestBuildId == this.id");
            List result = (List)query.execute((Object)new Integer(projectId));
            result = (List)pm.detachCopyAll((Collection)result);
            tx.commit();
            if (result != null && !result.isEmpty()) {
                BuildResult buildResult = (BuildResult)result.get(0);
                return buildResult;
            }
        }
        finally {
            this.rollback(tx);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getLatestBuildResults() {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(class$org$apache$maven$continuum$model$project$BuildResult == null ? (class$org$apache$maven$continuum$model$project$BuildResult = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.BuildResult")) : class$org$apache$maven$continuum$model$project$BuildResult, true);
            Query query = pm.newQuery(extent);
            query.setFilter("this.project.latestBuildId == this.id");
            List result = (List)query.execute();
            result = (List)pm.detachCopyAll((Collection)result);
            tx.commit();
            if (result != null && !result.isEmpty()) {
                HashMap<Integer, BuildResult> builds = new HashMap<Integer, BuildResult>();
                Iterator i = result.iterator();
                while (i.hasNext()) {
                    BuildResult br = (BuildResult)i.next();
                    builds.put(new Integer(br.getProject().getId()), br);
                }
                HashMap<Integer, BuildResult> hashMap = builds;
                return hashMap;
            }
        }
        finally {
            this.rollback(tx);
        }
        return null;
    }

    public void removeNotifier(ProjectNotifier notifier) throws ContinuumStoreException {
        this.attachAndDelete(notifier);
    }

    public ProjectNotifier storeNotifier(ProjectNotifier notifier) throws ContinuumStoreException {
        this.updateObject(notifier);
        return notifier;
    }

    public BuildDefinition getDefaultBuildDefinition(int projectId) {
        Project project;
        try {
            project = this.getProjectWithBuildDetails(projectId);
        }
        catch (Exception e) {
            project = null;
        }
        if (project != null && project.getBuildDefinitions() != null) {
            Iterator i = project.getBuildDefinitions().iterator();
            while (i.hasNext()) {
                BuildDefinition bd = (BuildDefinition)i.next();
                if (!bd.isDefaultForProject()) continue;
                return bd;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getDefaultBuildDefinitions() {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(class$org$apache$maven$continuum$model$project$Project == null ? (class$org$apache$maven$continuum$model$project$Project = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Project")) : class$org$apache$maven$continuum$model$project$Project, true);
            Query query = pm.newQuery(extent);
            query.declareImports("import org.apache.maven.continuum.model.project.BuildDefinition");
            query.setFilter("this.buildDefinitions.contains(buildDef) && buildDef.defaultForProject == true");
            query.declareVariables("BuildDefinition buildDef");
            query.setResult("this.id, buildDef.id");
            List result = (List)query.execute();
            HashMap<Integer, Integer> builds = new HashMap<Integer, Integer>();
            if (result != null && !result.isEmpty()) {
                Iterator i = result.iterator();
                while (i.hasNext()) {
                    Object[] obj = (Object[])i.next();
                    builds.put((Integer)obj[0], (Integer)obj[1]);
                }
                HashMap<Integer, Integer> hashMap = builds;
                return hashMap;
            }
        }
        finally {
            tx.commit();
            this.rollback(tx);
        }
        return null;
    }

    public BuildDefinition getBuildDefinition(int buildDefinitionId) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        return (BuildDefinition)this.getObjectById(class$org$apache$maven$continuum$model$project$BuildDefinition == null ? (class$org$apache$maven$continuum$model$project$BuildDefinition = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.BuildDefinition")) : class$org$apache$maven$continuum$model$project$BuildDefinition, buildDefinitionId);
    }

    public void removeBuildDefinition(BuildDefinition buildDefinition) throws ContinuumStoreException {
        this.attachAndDelete(buildDefinition);
    }

    public BuildDefinition storeBuildDefinition(BuildDefinition buildDefinition) throws ContinuumStoreException {
        this.updateObject(buildDefinition);
        return buildDefinition;
    }

    private Object makePersistent(PersistenceManager pm, Object object, boolean detach) {
        return PlexusJdoUtils.makePersistent((PersistenceManager)pm, (Object)object, (boolean)detach);
    }

    private Object getObjectFromQuery(Class clazz, String idField, String id, String fetchGroup) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        try {
            return PlexusJdoUtils.getObjectFromQuery((PersistenceManager)this.getPersistenceManager(), (Class)clazz, (String)idField, (String)id, (String)fetchGroup);
        }
        catch (PlexusObjectNotFoundException e) {
            throw new ContinuumObjectNotFoundException(e.getMessage());
        }
        catch (PlexusStoreException e) {
            throw new ContinuumStoreException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void attachAndDelete(Object object) {
        PlexusJdoUtils.attachAndDelete((PersistenceManager)this.getPersistenceManager(), (Object)object);
    }

    private void rollback(Transaction tx) {
        PlexusJdoUtils.rollbackIfActive((Transaction)tx);
    }

    public ProjectGroup getProjectGroup(int projectGroupId) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        return (ProjectGroup)this.getObjectById(class$org$apache$maven$continuum$model$project$ProjectGroup == null ? (class$org$apache$maven$continuum$model$project$ProjectGroup = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.ProjectGroup")) : class$org$apache$maven$continuum$model$project$ProjectGroup, projectGroupId);
    }

    private Object getObjectById(Class clazz, int id) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        return this.getObjectById(clazz, id, null);
    }

    private Object getObjectById(Class clazz, int id, String fetchGroup) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        try {
            return PlexusJdoUtils.getObjectById((PersistenceManager)this.getPersistenceManager(), (Class)clazz, (int)id, (String)fetchGroup);
        }
        catch (PlexusObjectNotFoundException e) {
            throw new ContinuumObjectNotFoundException(e.getMessage());
        }
        catch (PlexusStoreException e) {
            throw new ContinuumStoreException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public void updateProjectGroup(ProjectGroup group) throws ContinuumStoreException {
        this.updateObject(group);
    }

    private void updateObject(Object object) throws ContinuumStoreException {
        try {
            PlexusJdoUtils.updateObject((PersistenceManager)this.getPersistenceManager(), (Object)object);
        }
        catch (PlexusStoreException e) {
            throw new ContinuumStoreException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Collection getAllProjectGroupsWithProjects() {
        return this.getAllObjectsDetached(class$org$apache$maven$continuum$model$project$ProjectGroup == null ? (class$org$apache$maven$continuum$model$project$ProjectGroup = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.ProjectGroup")) : class$org$apache$maven$continuum$model$project$ProjectGroup, "name ascending", PROJECTGROUP_PROJECTS_FETCH_GROUP);
    }

    public List getAllProjectsByName() {
        return this.getAllObjectsDetached(class$org$apache$maven$continuum$model$project$Project == null ? (class$org$apache$maven$continuum$model$project$Project = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Project")) : class$org$apache$maven$continuum$model$project$Project, "name ascending", null);
    }

    public List getAllProjectsByNameWithDependencies() {
        return this.getAllObjectsDetached(class$org$apache$maven$continuum$model$project$Project == null ? (class$org$apache$maven$continuum$model$project$Project = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Project")) : class$org$apache$maven$continuum$model$project$Project, "name ascending", PROJECT_DEPENDENCIES_FETCH_GROUP);
    }

    public List getAllProjectsByNameWithBuildDetails() {
        return this.getAllObjectsDetached(class$org$apache$maven$continuum$model$project$Project == null ? (class$org$apache$maven$continuum$model$project$Project = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Project")) : class$org$apache$maven$continuum$model$project$Project, "name ascending", PROJECT_BUILD_DETAILS_FETCH_GROUP);
    }

    public List getAllSchedulesByName() {
        return this.getAllObjectsDetached(class$org$apache$maven$continuum$model$project$Schedule == null ? (class$org$apache$maven$continuum$model$project$Schedule = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Schedule")) : class$org$apache$maven$continuum$model$project$Schedule, "name ascending", null);
    }

    public Schedule addSchedule(Schedule schedule) {
        return (Schedule)this.addObject(schedule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schedule getScheduleByName(String name) throws ContinuumStoreException {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(class$org$apache$maven$continuum$model$project$Schedule == null ? (class$org$apache$maven$continuum$model$project$Schedule = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Schedule")) : class$org$apache$maven$continuum$model$project$Schedule, true);
            Query query = pm.newQuery(extent);
            query.declareImports("import java.lang.String");
            query.declareParameters("String name");
            query.setFilter("this.name == name");
            Collection result = (Collection)query.execute((Object)name);
            if (result.size() == 0) {
                tx.commit();
                Schedule schedule = null;
                return schedule;
            }
            Object object = pm.detachCopy(result.iterator().next());
            tx.commit();
            Schedule schedule = (Schedule)object;
            return schedule;
        }
        finally {
            this.rollback(tx);
        }
    }

    public Schedule storeSchedule(Schedule schedule) throws ContinuumStoreException {
        this.updateObject(schedule);
        return schedule;
    }

    public List getAllProfilesByName() {
        return this.getAllObjectsDetached(class$org$apache$maven$continuum$model$project$Profile == null ? (class$org$apache$maven$continuum$model$project$Profile = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Profile")) : class$org$apache$maven$continuum$model$project$Profile, "name ascending", null);
    }

    public Profile addProfile(Profile profile) {
        return (Profile)this.addObject(profile);
    }

    public Installation addInstallation(Installation installation) {
        return (Installation)this.addObject(installation);
    }

    public List getAllInstallations() {
        return this.getAllObjectsDetached(class$org$apache$maven$continuum$model$system$Installation == null ? (class$org$apache$maven$continuum$model$system$Installation = JdoContinuumStore.class$("org.apache.maven.continuum.model.system.Installation")) : class$org$apache$maven$continuum$model$system$Installation, "name ascending, version ascending", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllBuildsForAProjectByDate(int projectId) {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Query query = pm.newQuery("SELECT FROM " + (class$org$apache$maven$continuum$model$project$BuildResult == null ? (class$org$apache$maven$continuum$model$project$BuildResult = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.BuildResult")) : class$org$apache$maven$continuum$model$project$BuildResult).getName() + " WHERE project.id == projectId PARAMETERS int projectId ORDER BY endTime DESC");
            query.declareImports("import java.lang.Integer");
            query.declareParameters("Integer projectId");
            List result = (List)query.execute((Object)new Integer(projectId));
            result = (List)pm.detachCopyAll((Collection)result);
            tx.commit();
            List list = result;
            return list;
        }
        finally {
            this.rollback(tx);
        }
    }

    public Project getProject(int projectId) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        return (Project)this.getObjectById(class$org$apache$maven$continuum$model$project$Project == null ? (class$org$apache$maven$continuum$model$project$Project = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Project")) : class$org$apache$maven$continuum$model$project$Project, projectId);
    }

    public void updateProject(Project project) throws ContinuumStoreException {
        this.updateObject(project);
    }

    public void updateProfile(Profile profile) throws ContinuumStoreException {
        this.updateObject(profile);
    }

    public void updateSchedule(Schedule schedule) throws ContinuumStoreException {
        this.updateObject(schedule);
    }

    public Project getProjectWithBuilds(int projectId) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        return (Project)this.getObjectById(class$org$apache$maven$continuum$model$project$Project == null ? (class$org$apache$maven$continuum$model$project$Project = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Project")) : class$org$apache$maven$continuum$model$project$Project, projectId, PROJECT_WITH_BUILDS_FETCH_GROUP);
    }

    public void removeProfile(Profile profile) {
        this.removeObject(profile);
    }

    public void removeSchedule(Schedule schedule) {
        this.removeObject(schedule);
    }

    public Project getProjectWithCheckoutResult(int projectId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return (Project)this.getObjectById(class$org$apache$maven$continuum$model$project$Project == null ? (class$org$apache$maven$continuum$model$project$Project = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Project")) : class$org$apache$maven$continuum$model$project$Project, projectId, PROJECT_WITH_CHECKOUT_RESULT_FETCH_GROUP);
    }

    public BuildResult getBuildResult(int buildId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return (BuildResult)this.getObjectById(class$org$apache$maven$continuum$model$project$BuildResult == null ? (class$org$apache$maven$continuum$model$project$BuildResult = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.BuildResult")) : class$org$apache$maven$continuum$model$project$BuildResult, buildId, BUILD_RESULT_WITH_DETAILS_FETCH_GROUP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getBuildResultByBuildNumber(int projectId, int buildNumber) {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(class$org$apache$maven$continuum$model$project$BuildResult == null ? (class$org$apache$maven$continuum$model$project$BuildResult = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.BuildResult")) : class$org$apache$maven$continuum$model$project$BuildResult, true);
            Query query = pm.newQuery(extent);
            query.declareParameters("int projectId, int buildNumber");
            query.setFilter("this.project.id == projectId && this.buildNumber == buildNumber");
            List result = (List)query.execute((Object)new Integer(projectId), (Object)new Integer(buildNumber));
            result = (List)pm.detachCopyAll((Collection)result);
            tx.commit();
            List list = result;
            return list;
        }
        finally {
            this.rollback(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getBuildResultsForProject(int projectId, long fromDate) {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        pm.getFetchPlan().addGroup(BUILD_RESULT_WITH_DETAILS_FETCH_GROUP);
        try {
            tx.begin();
            Extent extent = pm.getExtent(class$org$apache$maven$continuum$model$project$BuildResult == null ? (class$org$apache$maven$continuum$model$project$BuildResult = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.BuildResult")) : class$org$apache$maven$continuum$model$project$BuildResult, true);
            Query query = pm.newQuery(extent);
            query.declareParameters("int projectId, long fromDate");
            query.setFilter("this.project.id == projectId && this.startTime > fromDate");
            List result = (List)query.execute((Object)new Integer(projectId), (Object)new Long(fromDate));
            result = (List)pm.detachCopyAll((Collection)result);
            tx.commit();
            List list = result;
            return list;
        }
        finally {
            this.rollback(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getBuildResultsInSuccess() {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(class$org$apache$maven$continuum$model$project$BuildResult == null ? (class$org$apache$maven$continuum$model$project$BuildResult = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.BuildResult")) : class$org$apache$maven$continuum$model$project$BuildResult, true);
            Query query = pm.newQuery(extent);
            query.setFilter("this.project.buildNumber == this.buildNumber");
            List result = (List)query.execute();
            result = (List)pm.detachCopyAll((Collection)result);
            tx.commit();
            if (result != null && !result.isEmpty()) {
                HashMap<Integer, BuildResult> builds = new HashMap<Integer, BuildResult>();
                Iterator i = result.iterator();
                while (i.hasNext()) {
                    BuildResult br = (BuildResult)i.next();
                    builds.put(new Integer(br.getProject().getId()), br);
                }
                HashMap<Integer, BuildResult> hashMap = builds;
                return hashMap;
            }
        }
        finally {
            this.rollback(tx);
        }
        return null;
    }

    public void removeProject(Project project) {
        this.removeObject(project);
    }

    public void removeProjectGroup(ProjectGroup projectGroup) {
        ProjectGroup pg = null;
        try {
            pg = this.getProjectGroupWithProjects(projectGroup.getId());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (pg != null) {
            Iterator i = pg.getProjects().iterator();
            while (i.hasNext()) {
                this.removeProject((Project)i.next());
            }
            this.removeObject(pg);
        }
    }

    public ProjectGroup getProjectGroupWithProjects(int projectGroupId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return (ProjectGroup)this.getObjectById(class$org$apache$maven$continuum$model$project$ProjectGroup == null ? (class$org$apache$maven$continuum$model$project$ProjectGroup = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.ProjectGroup")) : class$org$apache$maven$continuum$model$project$ProjectGroup, projectGroupId, PROJECTGROUP_PROJECTS_FETCH_GROUP);
    }

    public ProjectGroup getProjectGroupWithBuildDetails(int projectGroupId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return (ProjectGroup)this.getObjectById(class$org$apache$maven$continuum$model$project$ProjectGroup == null ? (class$org$apache$maven$continuum$model$project$ProjectGroup = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.ProjectGroup")) : class$org$apache$maven$continuum$model$project$ProjectGroup, projectGroupId, PROJECT_BUILD_DETAILS_FETCH_GROUP);
    }

    public List getAllProjectGroupsWithBuildDetails() {
        return this.getAllObjectsDetached(class$org$apache$maven$continuum$model$project$ProjectGroup == null ? (class$org$apache$maven$continuum$model$project$ProjectGroup = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.ProjectGroup")) : class$org$apache$maven$continuum$model$project$ProjectGroup, "name ascending", PROJECT_BUILD_DETAILS_FETCH_GROUP);
    }

    public List getAllProjectsWithAllDetails() {
        return this.getAllObjectsDetached(class$org$apache$maven$continuum$model$project$Project == null ? (class$org$apache$maven$continuum$model$project$Project = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Project")) : class$org$apache$maven$continuum$model$project$Project, "name ascending", PROJECT_ALL_DETAILS_FETCH_GROUP);
    }

    public Project getProjectWithAllDetails(int projectId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return (Project)this.getObjectById(class$org$apache$maven$continuum$model$project$Project == null ? (class$org$apache$maven$continuum$model$project$Project = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Project")) : class$org$apache$maven$continuum$model$project$Project, projectId, PROJECT_ALL_DETAILS_FETCH_GROUP);
    }

    public Schedule getSchedule(int scheduleId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return (Schedule)this.getObjectById(class$org$apache$maven$continuum$model$project$Schedule == null ? (class$org$apache$maven$continuum$model$project$Schedule = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Schedule")) : class$org$apache$maven$continuum$model$project$Schedule, scheduleId);
    }

    public Profile getProfile(int profileId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return (Profile)this.getObjectById(class$org$apache$maven$continuum$model$project$Profile == null ? (class$org$apache$maven$continuum$model$project$Profile = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Profile")) : class$org$apache$maven$continuum$model$project$Profile, profileId);
    }

    private void removeObject(Object o) {
        PlexusJdoUtils.removeObject((PersistenceManager)this.getPersistenceManager(), (Object)o);
    }

    private List getAllObjectsDetached(Class clazz) {
        return this.getAllObjectsDetached(clazz, null);
    }

    private List getAllObjectsDetached(Class clazz, String fetchGroup) {
        return this.getAllObjectsDetached(clazz, null, fetchGroup);
    }

    private List getAllObjectsDetached(Class clazz, String ordering, String fetchGroup) {
        return PlexusJdoUtils.getAllObjectsDetached((PersistenceManager)this.getPersistenceManager(), (Class)clazz, (String)ordering, (String)fetchGroup);
    }

    public ProjectGroup addProjectGroup(ProjectGroup group) {
        return (ProjectGroup)this.addObject(group);
    }

    private Object addObject(Object object) {
        return PlexusJdoUtils.addObject((PersistenceManager)this.getPersistenceManager(), (Object)object);
    }

    public ProjectGroup getProjectGroupByGroupId(String groupId) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        return (ProjectGroup)this.getObjectFromQuery(class$org$apache$maven$continuum$model$project$ProjectGroup == null ? (class$org$apache$maven$continuum$model$project$ProjectGroup = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.ProjectGroup")) : class$org$apache$maven$continuum$model$project$ProjectGroup, "groupId", groupId, null);
    }

    public ProjectGroup getProjectGroupByGroupIdWithProjects(String groupId) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        return (ProjectGroup)this.getObjectFromQuery(class$org$apache$maven$continuum$model$project$ProjectGroup == null ? (class$org$apache$maven$continuum$model$project$ProjectGroup = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.ProjectGroup")) : class$org$apache$maven$continuum$model$project$ProjectGroup, "groupId", groupId, PROJECTGROUP_PROJECTS_FETCH_GROUP);
    }

    public Project getProjectWithBuildDetails(int projectId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return (Project)this.getObjectById(class$org$apache$maven$continuum$model$project$Project == null ? (class$org$apache$maven$continuum$model$project$Project = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Project")) : class$org$apache$maven$continuum$model$project$Project, projectId, PROJECT_BUILD_DETAILS_FETCH_GROUP);
    }

    public ProjectGroup getDefaultProjectGroup() throws ContinuumStoreException {
        ProjectGroup group;
        try {
            group = (ProjectGroup)this.getObjectFromQuery(class$org$apache$maven$continuum$model$project$ProjectGroup == null ? (class$org$apache$maven$continuum$model$project$ProjectGroup = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.ProjectGroup")) : class$org$apache$maven$continuum$model$project$ProjectGroup, "groupId", DEFAULT_GROUP_ID, PROJECTGROUP_PROJECTS_FETCH_GROUP);
        }
        catch (ContinuumObjectNotFoundException e) {
            group = new ProjectGroup();
            group.setName("Default Project Group");
            group.setGroupId(DEFAULT_GROUP_ID);
            group.setDescription("Contains all projects that do not have a group of their own");
            group = this.addProjectGroup(group);
        }
        return group;
    }

    public SystemConfiguration addSystemConfiguration(SystemConfiguration systemConf) {
        return (SystemConfiguration)this.addObject(systemConf);
    }

    public void updateSystemConfiguration(SystemConfiguration systemConf) throws ContinuumStoreException {
        this.updateObject(systemConf);
    }

    public SystemConfiguration getSystemConfiguration() throws ContinuumStoreException {
        List systemConfs = this.getAllObjectsDetached(class$org$apache$maven$continuum$model$system$SystemConfiguration == null ? (class$org$apache$maven$continuum$model$system$SystemConfiguration = JdoContinuumStore.class$("org.apache.maven.continuum.model.system.SystemConfiguration")) : class$org$apache$maven$continuum$model$system$SystemConfiguration);
        if (systemConfs == null || systemConfs.isEmpty()) {
            return null;
        }
        if (systemConfs.size() > 1) {
            throw new ContinuumStoreException("Database is corrupted. There are more than one systemConfiguration object.");
        }
        return (SystemConfiguration)systemConfs.get(0);
    }

    public ContinuumUser addUser(ContinuumUser user) {
        return (ContinuumUser)this.addObject(user);
    }

    public void updateUser(ContinuumUser user) throws ContinuumStoreException {
        this.updateObject(user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContinuumUser getGuestUser() throws ContinuumStoreException {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(class$org$apache$maven$continuum$model$system$ContinuumUser == null ? (class$org$apache$maven$continuum$model$system$ContinuumUser = JdoContinuumStore.class$("org.apache.maven.continuum.model.system.ContinuumUser")) : class$org$apache$maven$continuum$model$system$ContinuumUser, true);
            Query query = pm.newQuery(extent);
            query.setFilter("this.guest == true");
            Collection result = (Collection)query.execute();
            if (result.size() == 0) {
                tx.commit();
                ContinuumUser continuumUser = null;
                return continuumUser;
            }
            Object object = pm.detachCopy(result.iterator().next());
            tx.commit();
            ContinuumUser continuumUser = (ContinuumUser)object;
            return continuumUser;
        }
        finally {
            this.rollback(tx);
        }
    }

    public List getUsers() throws ContinuumStoreException {
        return this.getAllObjectsDetached(class$org$apache$maven$continuum$model$system$ContinuumUser == null ? (class$org$apache$maven$continuum$model$system$ContinuumUser = JdoContinuumStore.class$("org.apache.maven.continuum.model.system.ContinuumUser")) : class$org$apache$maven$continuum$model$system$ContinuumUser);
    }

    public ContinuumUser getUser(int userId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return (ContinuumUser)this.getObjectById(class$org$apache$maven$continuum$model$system$ContinuumUser == null ? (class$org$apache$maven$continuum$model$system$ContinuumUser = JdoContinuumStore.class$("org.apache.maven.continuum.model.system.ContinuumUser")) : class$org$apache$maven$continuum$model$system$ContinuumUser, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContinuumUser getUserByUsername(String username) throws ContinuumStoreException {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(class$org$apache$maven$continuum$model$system$ContinuumUser == null ? (class$org$apache$maven$continuum$model$system$ContinuumUser = JdoContinuumStore.class$("org.apache.maven.continuum.model.system.ContinuumUser")) : class$org$apache$maven$continuum$model$system$ContinuumUser, true);
            Query query = pm.newQuery(extent);
            query.declareImports("import java.lang.String");
            query.declareParameters("String username");
            query.setFilter("this.username == username");
            Collection result = (Collection)query.execute((Object)username);
            if (result.size() == 0) {
                tx.commit();
                ContinuumUser continuumUser = null;
                return continuumUser;
            }
            Object object = pm.detachCopy(result.iterator().next());
            tx.commit();
            ContinuumUser continuumUser = (ContinuumUser)object;
            return continuumUser;
        }
        finally {
            this.rollback(tx);
        }
    }

    public void removeUser(ContinuumUser user) {
        this.removeObject(user);
    }

    public List getPermissions() throws ContinuumStoreException {
        return this.getAllObjectsDetached(class$org$apache$maven$continuum$model$system$Permission == null ? (class$org$apache$maven$continuum$model$system$Permission = JdoContinuumStore.class$("org.apache.maven.continuum.model.system.Permission")) : class$org$apache$maven$continuum$model$system$Permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Permission getPermission(String name) throws ContinuumStoreException {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(class$org$apache$maven$continuum$model$system$Permission == null ? (class$org$apache$maven$continuum$model$system$Permission = JdoContinuumStore.class$("org.apache.maven.continuum.model.system.Permission")) : class$org$apache$maven$continuum$model$system$Permission, true);
            Query query = pm.newQuery(extent);
            query.declareImports("import java.lang.String");
            query.declareParameters("String name");
            query.setFilter("this.name == name");
            Collection result = (Collection)query.execute((Object)name);
            if (result.size() == 0) {
                tx.commit();
                Permission permission = null;
                return permission;
            }
            Object object = pm.detachCopy(result.iterator().next());
            tx.commit();
            Permission permission = (Permission)object;
            return permission;
        }
        finally {
            this.rollback(tx);
        }
    }

    public Permission addPermission(Permission perm) {
        return (Permission)this.addObject(perm);
    }

    public UserGroup addUserGroup(UserGroup group) {
        return (UserGroup)this.addObject(group);
    }

    public void updateUserGroup(UserGroup group) throws ContinuumStoreException {
        this.updateObject(group);
    }

    public List getUserGroups() throws ContinuumStoreException {
        return this.getAllObjectsDetached(class$org$apache$maven$continuum$model$system$UserGroup == null ? (class$org$apache$maven$continuum$model$system$UserGroup = JdoContinuumStore.class$("org.apache.maven.continuum.model.system.UserGroup")) : class$org$apache$maven$continuum$model$system$UserGroup);
    }

    public UserGroup getUserGroup(int userGroupId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return (UserGroup)this.getObjectById(class$org$apache$maven$continuum$model$system$UserGroup == null ? (class$org$apache$maven$continuum$model$system$UserGroup = JdoContinuumStore.class$("org.apache.maven.continuum.model.system.UserGroup")) : class$org$apache$maven$continuum$model$system$UserGroup, userGroupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserGroup getUserGroup(String name) {
        PersistenceManager pm = this.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(class$org$apache$maven$continuum$model$system$UserGroup == null ? (class$org$apache$maven$continuum$model$system$UserGroup = JdoContinuumStore.class$("org.apache.maven.continuum.model.system.UserGroup")) : class$org$apache$maven$continuum$model$system$UserGroup, true);
            Query query = pm.newQuery(extent);
            query.declareImports("import java.lang.String");
            query.declareParameters("String name");
            query.setFilter("this.name == name");
            Collection result = (Collection)query.execute((Object)name);
            if (result.size() == 0) {
                tx.commit();
                UserGroup userGroup = null;
                return userGroup;
            }
            Object object = pm.detachCopy(result.iterator().next());
            tx.commit();
            UserGroup userGroup = (UserGroup)object;
            return userGroup;
        }
        finally {
            this.rollback(tx);
        }
    }

    private PersistenceManager getPersistenceManager() {
        PersistenceManager pm = this.pmf.getPersistenceManager();
        pm.getFetchPlan().setMaxFetchDepth(-1);
        return pm;
    }

    public void removeUserGroup(UserGroup group) {
        this.removeObject(group);
    }

    public void closeStore() {
        this.closePersistenceManagerFactory(1);
    }

    private void closePersistenceManagerFactory(int numTry) {
        if (this.pmf != null && !this.pmf.isClosed()) {
            try {
                this.pmf.close();
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (JDOUserException e) {
                if (numTry < 5) {
                    try {
                        Thread.currentThread().wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.closePersistenceManagerFactory(numTry + 1);
                }
                throw e;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

