/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.store;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.jdo.Extent;
import javax.jdo.JDOException;
import javax.jdo.JDOHelper;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.JDOUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;
import org.apache.maven.continuum.model.project.BuildDefinition;
import org.apache.maven.continuum.model.project.BuildResult;
import org.apache.maven.continuum.model.project.Profile;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.model.project.ProjectNotifier;
import org.apache.maven.continuum.model.project.Schedule;
import org.apache.maven.continuum.model.system.ContinuumUser;
import org.apache.maven.continuum.model.system.Installation;
import org.apache.maven.continuum.model.system.Permission;
import org.apache.maven.continuum.model.system.SystemConfiguration;
import org.apache.maven.continuum.model.system.UserGroup;
import org.apache.maven.continuum.store.AbstractContinuumStore;
import org.apache.maven.continuum.store.ContinuumObjectNotFoundException;
import org.apache.maven.continuum.store.ContinuumStore;
import org.apache.maven.continuum.store.ContinuumStoreException;
import org.codehaus.plexus.jdo.JdoFactory;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;

public class JdoContinuumStore
extends AbstractContinuumStore
implements ContinuumStore,
Initializable {
    private JdoFactory jdoFactory;
    private PersistenceManagerFactory pmf;
    private static final String PROJECT_WITH_BUILDS_FETCH_GROUP = "project-with-builds";
    private static final String PROJECT_WITH_CHECKOUT_RESULT_FETCH_GROUP = "project-with-checkout-result";
    private static final String BUILD_RESULT_WITH_DETAILS_FETCH_GROUP = "build-result-with-details";
    private static final String PROJECT_BUILD_DETAILS_FETCH_GROUP = "project-build-details";
    private static final String PROJECT_ALL_DETAILS_FETCH_GROUP = "project-all-details";
    private static final String DEFAULT_GROUP_ID = "default";
    static /* synthetic */ Class class$org$apache$maven$continuum$model$project$Project;
    static /* synthetic */ Class class$org$apache$maven$continuum$model$project$BuildResult;
    static /* synthetic */ Class class$org$apache$maven$continuum$model$project$ProjectGroup;
    static /* synthetic */ Class class$org$apache$maven$continuum$model$project$Schedule;
    static /* synthetic */ Class class$org$apache$maven$continuum$model$project$Profile;
    static /* synthetic */ Class class$org$apache$maven$continuum$model$system$Installation;
    static /* synthetic */ Class class$org$apache$maven$continuum$model$system$SystemConfiguration;
    static /* synthetic */ Class class$org$apache$maven$continuum$model$system$ContinuumUser;
    static /* synthetic */ Class class$org$apache$maven$continuum$model$system$Permission;
    static /* synthetic */ Class class$org$apache$maven$continuum$model$system$UserGroup;

    public void initialize() throws InitializationException {
        this.pmf = this.jdoFactory.getPersistenceManagerFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project getProjectByName(String name) throws ContinuumStoreException {
        PersistenceManager pm = this.pmf.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(class$org$apache$maven$continuum$model$project$Project == null ? (class$org$apache$maven$continuum$model$project$Project = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Project")) : class$org$apache$maven$continuum$model$project$Project, true);
            Query query = pm.newQuery(extent);
            query.declareImports("import java.lang.String");
            query.declareParameters("String name");
            query.setFilter("this.name == name");
            Collection result = (Collection)query.execute((Object)name);
            if (result.size() == 0) {
                tx.commit();
                Project project = null;
                return project;
            }
            Object object = pm.detachCopy(result.iterator().next());
            tx.commit();
            Project project = (Project)object;
            return project;
        }
        finally {
            this.rollback(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBuildResult(BuildResult build) throws ContinuumStoreException {
        PersistenceManager pm = this.pmf.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        Project project = build.getProject();
        try {
            tx.begin();
            if (!JDOHelper.isDetached((Object)build)) {
                throw new ContinuumStoreException("Not detached: " + build);
            }
            pm.attachCopy((Object)build, true);
            if (!JDOHelper.isDetached((Object)project)) {
                throw new ContinuumStoreException("Not detached: " + project);
            }
            project.setState(build.getState());
            pm.attachCopy((Object)project, true);
            tx.commit();
        }
        finally {
            this.rollback(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBuildResult(Project project, BuildResult build) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        PersistenceManager pm = this.pmf.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            pm.getFetchPlan().addGroup(PROJECT_WITH_BUILDS_FETCH_GROUP);
            Object objectId = pm.newObjectIdInstance(class$org$apache$maven$continuum$model$project$Project == null ? (class$org$apache$maven$continuum$model$project$Project = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Project")) : class$org$apache$maven$continuum$model$project$Project, (Object)new Integer(project.getId()));
            project = (Project)pm.getObjectById(objectId);
            build = (BuildResult)this.makePersistent(pm, build, false);
            project.setLatestBuildId(build.getId());
            project.setBuildNumber(project.getBuildNumber() + 1);
            project.setState(build.getState());
            project.addBuildResult(build);
            tx.commit();
        }
        finally {
            this.rollback(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildResult getLatestBuildResultForProject(int projectId) {
        PersistenceManager pm = this.pmf.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Object id = pm.newObjectIdInstance(class$org$apache$maven$continuum$model$project$Project == null ? (class$org$apache$maven$continuum$model$project$Project = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Project")) : class$org$apache$maven$continuum$model$project$Project, (Object)new Integer(projectId));
            Project project = (Project)pm.getObjectById(id);
            int buildId = project.getLatestBuildId();
            if (buildId > 0) {
                id = pm.newObjectIdInstance(class$org$apache$maven$continuum$model$project$BuildResult == null ? (class$org$apache$maven$continuum$model$project$BuildResult = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.BuildResult")) : class$org$apache$maven$continuum$model$project$BuildResult, (Object)new Integer(buildId));
                Object object = pm.getObjectById(id);
                BuildResult build = (BuildResult)pm.detachCopy(object);
                tx.commit();
                BuildResult buildResult = build;
                return buildResult;
            }
        }
        finally {
            this.rollback(tx);
        }
        return null;
    }

    public void removeNotifier(ProjectNotifier notifier) throws ContinuumStoreException {
        this.attachAndDelete(notifier);
    }

    public ProjectNotifier storeNotifier(ProjectNotifier notifier) throws ContinuumStoreException {
        this.updateObject(notifier);
        return notifier;
    }

    public void removeBuildDefinition(BuildDefinition buildDefinition) throws ContinuumStoreException {
        this.attachAndDelete(buildDefinition);
    }

    public BuildDefinition storeBuildDefinition(BuildDefinition buildDefinition) throws ContinuumStoreException {
        this.updateObject(buildDefinition);
        return buildDefinition;
    }

    private Object makePersistent(PersistenceManager pm, Object object, boolean detach) {
        pm.makePersistent(object);
        Object id = pm.getObjectId(object);
        Object persistentObject = pm.getObjectById(id);
        if (detach) {
            persistentObject = pm.detachCopy(persistentObject);
        }
        return persistentObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getObjectFromQuery(Class clazz, String idField, String id, String fetchGroup) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        PersistenceManager pm = this.pmf.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(clazz, true);
            Query query = pm.newQuery(extent);
            query.declareImports("import java.lang.String");
            query.declareParameters("String " + idField);
            query.setFilter("this." + idField + " == " + idField);
            Collection result = (Collection)query.execute((Object)id);
            if (result.size() == 0) {
                throw new ContinuumObjectNotFoundException(clazz.getName(), id);
            }
            if (result.size() > 1) {
                throw new ContinuumStoreException("A query for object of type " + clazz.getName() + " on the " + "field '" + idField + "' returned more than one object.");
            }
            pm.getFetchPlan().addGroup(fetchGroup);
            Object object = pm.detachCopy(result.iterator().next());
            tx.commit();
            Object object2 = object;
            return object2;
        }
        finally {
            this.rollback(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachAndDelete(Object object) {
        PersistenceManager pm = this.pmf.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            pm.attachCopy(object, true);
            pm.deletePersistent(object);
            tx.commit();
        }
        finally {
            this.rollback(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollback(Transaction tx) {
        PersistenceManager pm = tx.getPersistenceManager();
        try {
            if (tx.isActive()) {
                tx.rollback();
            }
        }
        finally {
            this.closePersistenceManager(pm);
        }
    }

    private void closePersistenceManager(PersistenceManager pm) {
        try {
            pm.close();
        }
        catch (JDOUserException e) {
            this.getLogger().warn("Error while closing the persistence manager.", (Throwable)e);
        }
    }

    public ProjectGroup getProjectGroup(int projectGroupId) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        return (ProjectGroup)this.getObjectById(class$org$apache$maven$continuum$model$project$ProjectGroup == null ? (class$org$apache$maven$continuum$model$project$ProjectGroup = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.ProjectGroup")) : class$org$apache$maven$continuum$model$project$ProjectGroup, projectGroupId);
    }

    private Object getObjectById(Class clazz, int id) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        return this.getObjectById(clazz, id, null);
    }

    private Object getObjectById(Class clazz, int id, String fetchGroup) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        PersistenceManager pm = this.pmf.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            if (fetchGroup != null) {
                pm.getFetchPlan().addGroup(fetchGroup);
            }
            Object objectId = pm.newObjectIdInstance(clazz, (Object)new Integer(id));
            Object object = pm.getObjectById(objectId);
            object = pm.detachCopy(object);
            tx.commit();
            Object object2 = object;
            return object2;
        }
        catch (JDOObjectNotFoundException e) {
            throw new ContinuumObjectNotFoundException(clazz.getName(), Integer.toString(id));
        }
        catch (JDOException e) {
            throw new ContinuumStoreException("Error handling JDO", (Exception)((Object)e));
        }
        finally {
            this.rollback(tx);
        }
    }

    public void updateProjectGroup(ProjectGroup group) throws ContinuumStoreException {
        this.updateObject(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateObject(Object object) throws ContinuumStoreException {
        PersistenceManager pm = this.pmf.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            if (!JDOHelper.isDetached((Object)object)) {
                throw new ContinuumStoreException("Not detached: " + object);
            }
            pm.attachCopy(object, true);
            tx.commit();
        }
        finally {
            this.rollback(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllProjectGroupsWithProjects() {
        PersistenceManager pm = this.pmf.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(class$org$apache$maven$continuum$model$project$ProjectGroup == null ? (class$org$apache$maven$continuum$model$project$ProjectGroup = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.ProjectGroup")) : class$org$apache$maven$continuum$model$project$ProjectGroup, true);
            Query query = pm.newQuery(extent);
            query.setOrdering("name ascending");
            Collection result = (Collection)query.execute();
            result = pm.detachCopyAll(result);
            tx.commit();
            Collection collection = result;
            return collection;
        }
        finally {
            this.rollback(tx);
        }
    }

    public List getAllProjectsByName() {
        return this.getAllObjectsDetached(class$org$apache$maven$continuum$model$project$Project == null ? (class$org$apache$maven$continuum$model$project$Project = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Project")) : class$org$apache$maven$continuum$model$project$Project, "name ascending", null);
    }

    public List getAllSchedulesByName() {
        return this.getAllObjectsDetached(class$org$apache$maven$continuum$model$project$Schedule == null ? (class$org$apache$maven$continuum$model$project$Schedule = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Schedule")) : class$org$apache$maven$continuum$model$project$Schedule, "name ascending", null);
    }

    public Schedule addSchedule(Schedule schedule) {
        return (Schedule)this.addObject(schedule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schedule getScheduleByName(String name) throws ContinuumStoreException {
        PersistenceManager pm = this.pmf.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(class$org$apache$maven$continuum$model$project$Schedule == null ? (class$org$apache$maven$continuum$model$project$Schedule = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Schedule")) : class$org$apache$maven$continuum$model$project$Schedule, true);
            Query query = pm.newQuery(extent);
            query.declareImports("import java.lang.String");
            query.declareParameters("String name");
            query.setFilter("this.name == name");
            Collection result = (Collection)query.execute((Object)name);
            if (result.size() == 0) {
                tx.commit();
                Schedule schedule = null;
                return schedule;
            }
            Object object = pm.detachCopy(result.iterator().next());
            tx.commit();
            Schedule schedule = (Schedule)object;
            return schedule;
        }
        finally {
            this.rollback(tx);
        }
    }

    public Schedule storeSchedule(Schedule schedule) throws ContinuumStoreException {
        this.updateObject(schedule);
        return schedule;
    }

    public List getAllProfilesByName() {
        return this.getAllObjectsDetached(class$org$apache$maven$continuum$model$project$Profile == null ? (class$org$apache$maven$continuum$model$project$Profile = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Profile")) : class$org$apache$maven$continuum$model$project$Profile, "name ascending", null);
    }

    public Profile addProfile(Profile profile) {
        return (Profile)this.addObject(profile);
    }

    public Installation addInstallation(Installation installation) {
        return (Installation)this.addObject(installation);
    }

    public List getAllInstallations() {
        return this.getAllObjectsDetached(class$org$apache$maven$continuum$model$system$Installation == null ? (class$org$apache$maven$continuum$model$system$Installation = JdoContinuumStore.class$("org.apache.maven.continuum.model.system.Installation")) : class$org$apache$maven$continuum$model$system$Installation, "name ascending, version ascending", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllBuildsForAProjectByDate(int projectId) {
        PersistenceManager pm = this.pmf.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Query q = pm.newQuery("SELECT FROM " + (class$org$apache$maven$continuum$model$project$BuildResult == null ? (class$org$apache$maven$continuum$model$project$BuildResult = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.BuildResult")) : class$org$apache$maven$continuum$model$project$BuildResult).getName() + " WHERE project.id == :projectId PARAMETERS int projectId ORDER BY endTime DESC");
            List result = (List)q.execute((Object)new Integer(projectId));
            result = (List)pm.detachCopyAll((Collection)result);
            tx.commit();
            List list = result;
            return list;
        }
        finally {
            this.rollback(tx);
        }
    }

    public Project getProject(int projectId) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        return (Project)this.getObjectById(class$org$apache$maven$continuum$model$project$Project == null ? (class$org$apache$maven$continuum$model$project$Project = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Project")) : class$org$apache$maven$continuum$model$project$Project, projectId);
    }

    public void updateProject(Project project) throws ContinuumStoreException {
        this.updateObject(project);
    }

    public void updateProfile(Profile profile) throws ContinuumStoreException {
        this.updateObject(profile);
    }

    public void updateSchedule(Schedule schedule) throws ContinuumStoreException {
        this.updateObject(schedule);
    }

    public Project getProjectWithBuilds(int projectId) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        return (Project)this.getObjectById(class$org$apache$maven$continuum$model$project$Project == null ? (class$org$apache$maven$continuum$model$project$Project = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Project")) : class$org$apache$maven$continuum$model$project$Project, projectId, PROJECT_WITH_BUILDS_FETCH_GROUP);
    }

    public void removeProfile(Profile profile) {
        this.removeObject(profile);
    }

    public void removeSchedule(Schedule schedule) {
        this.removeObject(schedule);
    }

    public Project getProjectWithCheckoutResult(int projectId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return (Project)this.getObjectById(class$org$apache$maven$continuum$model$project$Project == null ? (class$org$apache$maven$continuum$model$project$Project = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Project")) : class$org$apache$maven$continuum$model$project$Project, projectId, PROJECT_WITH_CHECKOUT_RESULT_FETCH_GROUP);
    }

    public BuildResult getBuildResult(int buildId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return (BuildResult)this.getObjectById(class$org$apache$maven$continuum$model$project$BuildResult == null ? (class$org$apache$maven$continuum$model$project$BuildResult = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.BuildResult")) : class$org$apache$maven$continuum$model$project$BuildResult, buildId, BUILD_RESULT_WITH_DETAILS_FETCH_GROUP);
    }

    public void removeProject(Project project) {
        this.removeObject(project);
    }

    public void removeProjectGroup(ProjectGroup projectGroup) {
        Iterator i = projectGroup.getProjects().iterator();
        while (i.hasNext()) {
            this.removeProject((Project)i.next());
        }
        this.removeObject(projectGroup);
    }

    public ProjectGroup getProjectGroupWithBuildDetails(int projectGroupId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return (ProjectGroup)this.getObjectById(class$org$apache$maven$continuum$model$project$ProjectGroup == null ? (class$org$apache$maven$continuum$model$project$ProjectGroup = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.ProjectGroup")) : class$org$apache$maven$continuum$model$project$ProjectGroup, projectGroupId, PROJECT_BUILD_DETAILS_FETCH_GROUP);
    }

    public List getAllProjectGroupsWithBuildDetails() {
        return this.getAllObjectsDetached(class$org$apache$maven$continuum$model$project$ProjectGroup == null ? (class$org$apache$maven$continuum$model$project$ProjectGroup = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.ProjectGroup")) : class$org$apache$maven$continuum$model$project$ProjectGroup, "name ascending", PROJECT_BUILD_DETAILS_FETCH_GROUP);
    }

    public Project getProjectWithAllDetails(int projectId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return (Project)this.getObjectById(class$org$apache$maven$continuum$model$project$Project == null ? (class$org$apache$maven$continuum$model$project$Project = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Project")) : class$org$apache$maven$continuum$model$project$Project, projectId, PROJECT_ALL_DETAILS_FETCH_GROUP);
    }

    public Schedule getSchedule(int scheduleId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return (Schedule)this.getObjectById(class$org$apache$maven$continuum$model$project$Schedule == null ? (class$org$apache$maven$continuum$model$project$Schedule = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Schedule")) : class$org$apache$maven$continuum$model$project$Schedule, scheduleId);
    }

    public Profile getProfile(int profileId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return (Profile)this.getObjectById(class$org$apache$maven$continuum$model$project$Profile == null ? (class$org$apache$maven$continuum$model$project$Profile = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Profile")) : class$org$apache$maven$continuum$model$project$Profile, profileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeObject(Object o) {
        PersistenceManager pm = this.pmf.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            o = pm.getObjectById(pm.getObjectId(o));
            pm.deletePersistent(o);
            tx.commit();
        }
        finally {
            this.rollback(tx);
        }
    }

    private List getAllObjectsDetached(Class clazz) {
        return this.getAllObjectsDetached(clazz, null, null);
    }

    private List getAllObjectsDetached(Class clazz, String fetchGroup) {
        return this.getAllObjectsDetached(clazz, null, fetchGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getAllObjectsDetached(Class clazz, String ordering, String fetchGroup) {
        PersistenceManager pm = this.pmf.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(clazz, true);
            Query query = pm.newQuery(extent);
            if (ordering != null) {
                query.setOrdering(ordering);
            }
            if (fetchGroup != null) {
                pm.getFetchPlan().addGroup(fetchGroup);
            }
            List result = (List)query.execute();
            result = (List)pm.detachCopyAll((Collection)result);
            tx.commit();
            List list = result;
            return list;
        }
        finally {
            this.rollback(tx);
        }
    }

    public ProjectGroup addProjectGroup(ProjectGroup group) {
        return (ProjectGroup)this.addObject(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object addObject(Object object) {
        PersistenceManager pm = this.pmf.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            pm.makePersistent(object);
            object = pm.detachCopy(object);
            tx.commit();
            Object object2 = object;
            return object2;
        }
        finally {
            this.rollback(tx);
        }
    }

    public ProjectGroup getProjectGroupByGroupId(String groupId) throws ContinuumStoreException, ContinuumObjectNotFoundException {
        return (ProjectGroup)this.getObjectFromQuery(class$org$apache$maven$continuum$model$project$ProjectGroup == null ? (class$org$apache$maven$continuum$model$project$ProjectGroup = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.ProjectGroup")) : class$org$apache$maven$continuum$model$project$ProjectGroup, "groupId", groupId, null);
    }

    public Project getProjectWithBuildDetails(int projectId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return (Project)this.getObjectById(class$org$apache$maven$continuum$model$project$Project == null ? (class$org$apache$maven$continuum$model$project$Project = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.Project")) : class$org$apache$maven$continuum$model$project$Project, projectId, PROJECT_BUILD_DETAILS_FETCH_GROUP);
    }

    public ProjectGroup getDefaultProjectGroup() throws ContinuumStoreException {
        ProjectGroup group;
        try {
            group = (ProjectGroup)this.getObjectFromQuery(class$org$apache$maven$continuum$model$project$ProjectGroup == null ? (class$org$apache$maven$continuum$model$project$ProjectGroup = JdoContinuumStore.class$("org.apache.maven.continuum.model.project.ProjectGroup")) : class$org$apache$maven$continuum$model$project$ProjectGroup, "groupId", DEFAULT_GROUP_ID, null);
        }
        catch (ContinuumObjectNotFoundException e) {
            group = new ProjectGroup();
            group.setName("Default Project Group");
            group.setGroupId(DEFAULT_GROUP_ID);
            group.setDescription("Contains all projects that do not have a group of their own");
            group = this.addProjectGroup(group);
        }
        return group;
    }

    public SystemConfiguration addSystemConfiguration(SystemConfiguration systemConf) {
        return (SystemConfiguration)this.addObject(systemConf);
    }

    public void updateSystemConfiguration(SystemConfiguration systemConf) throws ContinuumStoreException {
        this.updateObject(systemConf);
    }

    public SystemConfiguration getSystemConfiguration() throws ContinuumStoreException {
        List systemConfs = this.getAllObjectsDetached(class$org$apache$maven$continuum$model$system$SystemConfiguration == null ? (class$org$apache$maven$continuum$model$system$SystemConfiguration = JdoContinuumStore.class$("org.apache.maven.continuum.model.system.SystemConfiguration")) : class$org$apache$maven$continuum$model$system$SystemConfiguration);
        if (systemConfs == null || systemConfs.isEmpty()) {
            return null;
        }
        if (systemConfs.size() > 1) {
            throw new ContinuumStoreException("Database is corrupted. There are more than one systemConfiguration object.");
        }
        return (SystemConfiguration)systemConfs.get(0);
    }

    public ContinuumUser addUser(ContinuumUser user) {
        return (ContinuumUser)this.addObject(user);
    }

    public void updateUser(ContinuumUser user) throws ContinuumStoreException {
        this.updateObject(user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContinuumUser getGuestUser() throws ContinuumStoreException {
        PersistenceManager pm = this.pmf.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(class$org$apache$maven$continuum$model$system$ContinuumUser == null ? (class$org$apache$maven$continuum$model$system$ContinuumUser = JdoContinuumStore.class$("org.apache.maven.continuum.model.system.ContinuumUser")) : class$org$apache$maven$continuum$model$system$ContinuumUser, true);
            Query query = pm.newQuery(extent);
            query.setFilter("this.guest == true");
            Collection result = (Collection)query.execute();
            if (result.size() == 0) {
                tx.commit();
                ContinuumUser continuumUser = null;
                return continuumUser;
            }
            Object object = pm.detachCopy(result.iterator().next());
            tx.commit();
            ContinuumUser continuumUser = (ContinuumUser)object;
            return continuumUser;
        }
        finally {
            this.rollback(tx);
        }
    }

    public List getUsers() throws ContinuumStoreException {
        return this.getAllObjectsDetached(class$org$apache$maven$continuum$model$system$ContinuumUser == null ? (class$org$apache$maven$continuum$model$system$ContinuumUser = JdoContinuumStore.class$("org.apache.maven.continuum.model.system.ContinuumUser")) : class$org$apache$maven$continuum$model$system$ContinuumUser);
    }

    public ContinuumUser getUser(int userId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return (ContinuumUser)this.getObjectById(class$org$apache$maven$continuum$model$system$ContinuumUser == null ? (class$org$apache$maven$continuum$model$system$ContinuumUser = JdoContinuumStore.class$("org.apache.maven.continuum.model.system.ContinuumUser")) : class$org$apache$maven$continuum$model$system$ContinuumUser, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContinuumUser getUserByUsername(String username) throws ContinuumStoreException {
        PersistenceManager pm = this.pmf.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(class$org$apache$maven$continuum$model$system$ContinuumUser == null ? (class$org$apache$maven$continuum$model$system$ContinuumUser = JdoContinuumStore.class$("org.apache.maven.continuum.model.system.ContinuumUser")) : class$org$apache$maven$continuum$model$system$ContinuumUser, true);
            Query query = pm.newQuery(extent);
            query.declareImports("import java.lang.String");
            query.declareParameters("String username");
            query.setFilter("this.username == username");
            Collection result = (Collection)query.execute((Object)username);
            if (result.size() == 0) {
                tx.commit();
                ContinuumUser continuumUser = null;
                return continuumUser;
            }
            Object object = pm.detachCopy(result.iterator().next());
            tx.commit();
            ContinuumUser continuumUser = (ContinuumUser)object;
            return continuumUser;
        }
        finally {
            this.rollback(tx);
        }
    }

    public void removeUser(ContinuumUser user) {
        this.removeObject(user);
    }

    public List getPermissions() throws ContinuumStoreException {
        return this.getAllObjectsDetached(class$org$apache$maven$continuum$model$system$Permission == null ? (class$org$apache$maven$continuum$model$system$Permission = JdoContinuumStore.class$("org.apache.maven.continuum.model.system.Permission")) : class$org$apache$maven$continuum$model$system$Permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Permission getPermission(String name) throws ContinuumStoreException {
        PersistenceManager pm = this.pmf.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(class$org$apache$maven$continuum$model$system$Permission == null ? (class$org$apache$maven$continuum$model$system$Permission = JdoContinuumStore.class$("org.apache.maven.continuum.model.system.Permission")) : class$org$apache$maven$continuum$model$system$Permission, true);
            Query query = pm.newQuery(extent);
            query.declareImports("import java.lang.String");
            query.declareParameters("String name");
            query.setFilter("this.name == name");
            Collection result = (Collection)query.execute((Object)name);
            if (result.size() == 0) {
                tx.commit();
                Permission permission = null;
                return permission;
            }
            Object object = pm.detachCopy(result.iterator().next());
            tx.commit();
            Permission permission = (Permission)object;
            return permission;
        }
        finally {
            this.rollback(tx);
        }
    }

    public Permission addPermission(Permission perm) {
        return (Permission)this.addObject(perm);
    }

    public UserGroup addUserGroup(UserGroup group) {
        return (UserGroup)this.addObject(group);
    }

    public void updateUserGroup(UserGroup group) throws ContinuumStoreException {
        this.updateObject(group);
    }

    public List getUserGroups() throws ContinuumStoreException {
        return this.getAllObjectsDetached(class$org$apache$maven$continuum$model$system$UserGroup == null ? (class$org$apache$maven$continuum$model$system$UserGroup = JdoContinuumStore.class$("org.apache.maven.continuum.model.system.UserGroup")) : class$org$apache$maven$continuum$model$system$UserGroup);
    }

    public UserGroup getUserGroup(int userGroupId) throws ContinuumObjectNotFoundException, ContinuumStoreException {
        return (UserGroup)this.getObjectById(class$org$apache$maven$continuum$model$system$UserGroup == null ? (class$org$apache$maven$continuum$model$system$UserGroup = JdoContinuumStore.class$("org.apache.maven.continuum.model.system.UserGroup")) : class$org$apache$maven$continuum$model$system$UserGroup, userGroupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserGroup getUserGroup(String name) {
        PersistenceManager pm = this.pmf.getPersistenceManager();
        Transaction tx = pm.currentTransaction();
        try {
            tx.begin();
            Extent extent = pm.getExtent(class$org$apache$maven$continuum$model$system$UserGroup == null ? (class$org$apache$maven$continuum$model$system$UserGroup = JdoContinuumStore.class$("org.apache.maven.continuum.model.system.UserGroup")) : class$org$apache$maven$continuum$model$system$UserGroup, true);
            Query query = pm.newQuery(extent);
            query.declareImports("import java.lang.String");
            query.declareParameters("String name");
            query.setFilter("this.name == name");
            Collection result = (Collection)query.execute((Object)name);
            if (result.size() == 0) {
                tx.commit();
                UserGroup userGroup = null;
                return userGroup;
            }
            Object object = pm.detachCopy(result.iterator().next());
            tx.commit();
            UserGroup userGroup = (UserGroup)object;
            return userGroup;
        }
        finally {
            this.rollback(tx);
        }
    }

    public void removeUserGroup(UserGroup group) {
        this.removeObject(group);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

