/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.notification.msn;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.configuration.ConfigurationService;
import org.apache.maven.continuum.model.project.BuildResult;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectNotifier;
import org.apache.maven.continuum.notification.AbstractContinuumNotifier;
import org.apache.maven.continuum.store.ContinuumStore;
import org.apache.maven.continuum.store.ContinuumStoreException;
import org.codehaus.plexus.msn.MsnClient;
import org.codehaus.plexus.msn.MsnException;
import org.codehaus.plexus.notification.NotificationException;

public class MsnContinuumNotifier
extends AbstractContinuumNotifier {
    private MsnClient msnClient;
    private ConfigurationService configurationService;
    private ContinuumStore store;
    private String fromAddress;
    private String fromPassword;

    public void sendNotification(String source, Set recipients, Map configuration, Map context) throws NotificationException {
        Project project = (Project)context.get("project");
        ProjectNotifier projectNotifier = (ProjectNotifier)context.get("projectNotifier");
        BuildResult build = (BuildResult)context.get("build");
        if (build == null) {
            return;
        }
        if (recipients.size() == 0) {
            this.getLogger().info("No MSN recipients for '" + project.getName() + "'.");
            return;
        }
        if (source.equals("BuildComplete")) {
            this.buildComplete(project, projectNotifier, build, recipients, configuration);
        }
    }

    private String generateMessage(Project project, BuildResult build) throws ContinuumException {
        String message;
        int state = project.getState();
        if (build != null) {
            state = build.getState();
        }
        if (state == 2) {
            message = "BUILD SUCCESSFUL: " + project.getName();
        } else if (state == 3) {
            message = "BUILD FAILURE: " + project.getName();
        } else if (state == 4) {
            message = "BUILD ERROR: " + project.getName();
        } else {
            this.getLogger().warn("Unknown build state " + state + " for project " + project.getId());
            message = "ERROR: Unknown build state " + state + " for " + project.getName() + " project";
        }
        return message + " " + this.getReportUrl(project, build, this.configurationService);
    }

    private void buildComplete(Project project, ProjectNotifier projectNotifier, BuildResult build, Set recipients, Map configuration) throws NotificationException {
        String message;
        BuildResult previousBuild = this.getPreviousBuild(project, build);
        if (!this.shouldNotify(build, previousBuild, projectNotifier)) {
            return;
        }
        try {
            message = this.generateMessage(project, build);
        }
        catch (ContinuumException e) {
            throw new NotificationException("Can't generate the message.", (Throwable)e);
        }
        this.msnClient.setLogin(this.getUsername(configuration));
        this.msnClient.setPassword(this.getPassword(configuration));
        try {
            this.msnClient.login();
            for (String recipient : recipients) {
                this.msnClient.sendMessage(recipient, message);
            }
        }
        catch (MsnException e) {
            throw new NotificationException("Exception while sending message.", (Throwable)e);
        }
        finally {
            try {
                this.msnClient.logout();
            }
            catch (MsnException e) {}
        }
    }

    private BuildResult getPreviousBuild(Project project, BuildResult currentBuild) throws NotificationException {
        try {
            if (project.getId() > 0) {
                project = this.store.getProjectWithBuilds(project.getId());
            }
        }
        catch (ContinuumStoreException e) {
            throw new NotificationException("Unable to obtain project builds", (Throwable)e);
        }
        List builds = project.getBuildResults();
        if (builds.size() < 2) {
            return null;
        }
        BuildResult build = (BuildResult)builds.get(builds.size() - 1);
        if (currentBuild != null && build.getId() != currentBuild.getId()) {
            throw new NotificationException("INTERNAL ERROR: The current build wasn't the first in the build list. Current build: '" + currentBuild.getId() + "', " + "first build: '" + build.getId() + "'.");
        }
        return (BuildResult)builds.get(builds.size() - 2);
    }

    public void sendNotification(String arg0, Set arg1, Properties arg2) throws NotificationException {
        throw new NotificationException("Not implemented.");
    }

    private String getUsername(Map configuration) {
        if (configuration.containsKey("login")) {
            return (String)configuration.get("login");
        }
        return this.fromAddress;
    }

    private String getPassword(Map configuration) {
        if (configuration.containsKey("password")) {
            return (String)configuration.get("password");
        }
        return this.fromPassword;
    }
}

