/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.notification.msn;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.configuration.ConfigurationService;
import org.apache.maven.continuum.model.project.BuildResult;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.notification.AbstractContinuumNotifier;
import org.codehaus.plexus.msn.MsnClient;
import org.codehaus.plexus.msn.MsnException;
import org.codehaus.plexus.notification.NotificationException;

public class MsnContinuumNotifier
extends AbstractContinuumNotifier {
    private MsnClient msnClient;
    private ConfigurationService configurationService;
    private String fromAddress;
    private String fromPassword;

    public void sendNotification(String source, Set recipients, Map configuration, Map context) throws NotificationException {
        Project project = (Project)context.get("project");
        BuildResult build = (BuildResult)context.get("build");
        if (recipients.size() == 0) {
            this.getLogger().info("No MSN recipients for '" + project.getName() + "'.");
            return;
        }
        if (source.equals("BuildComplete")) {
            this.sendMessage(project, build, recipients, configuration);
        }
    }

    private String generateMessage(Project project, BuildResult build) throws ContinuumException {
        String message;
        int state = build.getState();
        if (state == 2) {
            message = "BUILD SUCCESSFUL: " + project.getName();
        } else if (state == 3) {
            message = "BUILD FAILURE: " + project.getName();
        } else if (state == 4) {
            message = "BUILD ERROR: " + project.getName();
        } else {
            this.getLogger().warn("Unknown build state " + build.getState() + " for project " + project.getId());
            message = "ERROR: Unknown build state " + build.getState();
        }
        return message + " " + this.getReportUrl(project, build, this.configurationService);
    }

    private void sendMessage(Project project, BuildResult build, Set recipients, Map configuration) throws NotificationException {
        String message;
        try {
            message = this.generateMessage(project, build);
        }
        catch (ContinuumException e) {
            throw new NotificationException("Can't generate the message.", (Throwable)e);
        }
        this.msnClient.setLogin(this.getUsername(configuration));
        this.msnClient.setPassword(this.getPassword(configuration));
        try {
            this.msnClient.login();
            Iterator i = recipients.iterator();
            while (i.hasNext()) {
                String recipient = (String)i.next();
                this.msnClient.sendMessage(recipient, message);
            }
        }
        catch (MsnException e) {
            throw new NotificationException("Exception while sending message.", (Throwable)e);
        }
        finally {
            try {
                this.msnClient.logout();
            }
            catch (MsnException e) {}
        }
    }

    public void sendNotification(String arg0, Set arg1, Properties arg2) throws NotificationException {
        throw new NotificationException("Not implemented.");
    }

    private String getUsername(Map configuration) {
        if (configuration.containsKey("login")) {
            return (String)configuration.get("login");
        }
        return this.fromAddress;
    }

    private String getPassword(Map configuration) {
        if (configuration.containsKey("password")) {
            return (String)configuration.get("password");
        }
        return this.fromPassword;
    }
}

