/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.model.project.io.stax;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.jdo.spi.PersistenceCapable;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.maven.continuum.model.project.BuildDefinition;
import org.apache.maven.continuum.model.project.BuildDefinitionTemplate;
import org.apache.maven.continuum.model.project.BuildResult;
import org.apache.maven.continuum.model.project.ContinuumDatabase;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectDependency;
import org.apache.maven.continuum.model.project.ProjectDeveloper;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.model.project.ProjectNotifier;
import org.apache.maven.continuum.model.project.Schedule;
import org.apache.maven.continuum.model.scm.ChangeFile;
import org.apache.maven.continuum.model.scm.ChangeSet;
import org.apache.maven.continuum.model.scm.ScmResult;
import org.apache.maven.continuum.model.scm.SuiteResult;
import org.apache.maven.continuum.model.scm.TestCaseFailure;
import org.apache.maven.continuum.model.scm.TestResult;
import org.apache.maven.continuum.model.system.Installation;
import org.apache.maven.continuum.model.system.NotificationAddress;
import org.apache.maven.continuum.model.system.Profile;
import org.apache.maven.continuum.model.system.SystemConfiguration;
import org.apache.maven.continuum.project.ContinuumProjectState;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class ContinuumStaxReader {
    private Map projectGroupInstances;
    private Map projectInstances;
    private Map projectGroupReferences;
    private Map projectReferences;
    private Map buildDefinitionReferences;
    private Map buildDefinitionInstances;
    private Map scheduleReferences;
    private Map profileReferences;
    private Map scheduleInstances;
    private Map profileInstances;
    private Map installationReferences;
    private Map installationInstances;

    public Xpp3Dom buildDom(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        ArrayList<Xpp3Dom> elements = new ArrayList<Xpp3Dom>();
        ArrayList<StringBuffer> values = new ArrayList<StringBuffer>();
        int eventType = xmlStreamReader.getEventType();
        while (xmlStreamReader.hasNext()) {
            if (eventType == 1) {
                String rawName = xmlStreamReader.getLocalName();
                Xpp3Dom childConfiguration = new Xpp3Dom(rawName);
                int depth = elements.size();
                if (depth > 0) {
                    Xpp3Dom parent = (Xpp3Dom)elements.get(depth - 1);
                    parent.addChild(childConfiguration);
                }
                elements.add(childConfiguration);
                if (xmlStreamReader.isEndElement()) {
                    values.add(null);
                } else {
                    values.add(new StringBuffer());
                }
                int attributesSize = xmlStreamReader.getAttributeCount();
                for (int i = 0; i < attributesSize; ++i) {
                    String name = xmlStreamReader.getAttributeLocalName(i);
                    String value = xmlStreamReader.getAttributeValue(i);
                    childConfiguration.setAttribute(name, value);
                }
            } else if (eventType == 4) {
                int depth = values.size() - 1;
                StringBuffer valueBuffer = (StringBuffer)values.get(depth);
                String text = xmlStreamReader.getText();
                text = text.trim();
                valueBuffer.append(text);
            } else if (eventType == 2) {
                int depth = elements.size() - 1;
                Xpp3Dom finishedConfiguration = (Xpp3Dom)elements.remove(depth);
                Object accumulatedValue = values.remove(depth);
                if (finishedConfiguration.getChildCount() == 0) {
                    if (accumulatedValue == null) {
                        finishedConfiguration.setValue(null);
                    } else {
                        finishedConfiguration.setValue(accumulatedValue.toString());
                    }
                }
                if (depth == 0) {
                    return finishedConfiguration;
                }
            }
            eventType = xmlStreamReader.next();
        }
        throw new IllegalStateException("End of document found before returning to 0 depth");
    }

    public boolean getBooleanValue(String s, String attribute, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            return Boolean.valueOf(s);
        }
        return false;
    }

    public char getCharacterValue(String s, String attribute, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    public Date getDateValue(String s, String attribute, String dateFormat, XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (s != null) {
            if (dateFormat == null) {
                return new Date(Long.valueOf(s));
            }
            SimpleDateFormat dateParser = new SimpleDateFormat(dateFormat, Locale.US);
            try {
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XMLStreamException(e.getMessage());
            }
        }
        return null;
    }

    public double getDoubleValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0.0;
    }

    public float getFloatValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0.0f;
    }

    public int getIntegerValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be an integer but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0;
    }

    public long getLongValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a long integer but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0L;
    }

    public String getRequiredAttributeValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        if (s == null && strict) {
            throw new XMLStreamException("Missing required value for attribute '" + attribute + "'", xmlStreamReader.getLocation());
        }
        return s;
    }

    public short getShortValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict) throws XMLStreamException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException e) {
                    if (!strict) break block3;
                    throw new XMLStreamException("Unable to parse element '" + attribute + "', must be a short integer but was '" + s + "'", xmlStreamReader.getLocation());
                }
            }
        }
        return 0;
    }

    public String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private BuildDefinition parseBuildDefinition(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        String v;
        BuildDefinition buildDefinition = new BuildDefinition();
        buildDefinition.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        if (this.buildDefinitionInstances == null) {
            this.buildDefinitionInstances = new HashMap();
        }
        if ((v = xmlStreamReader.getAttributeValue(null, "modello.id")) != null) {
            this.buildDefinitionInstances.put(v, buildDefinition);
        }
        while (xmlStreamReader.nextTag() == 1) {
            HashMap<String, String> refs;
            String value;
            if (xmlStreamReader.getLocalName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("id");
                buildDefinition.setId(this.getIntegerValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "id", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("defaultForProject")) {
                if (parsed.contains("defaultForProject")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("defaultForProject");
                buildDefinition.setDefaultForProject(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "defaultForProject", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("goals")) {
                if (parsed.contains("goals")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("goals");
                buildDefinition.setGoals(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("arguments")) {
                if (parsed.contains("arguments")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("arguments");
                buildDefinition.setArguments(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("buildFile")) {
                if (parsed.contains("buildFile")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("buildFile");
                buildDefinition.setBuildFile(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("buildFresh")) {
                if (parsed.contains("buildFresh")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("buildFresh");
                buildDefinition.setBuildFresh(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "buildFresh", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("description")) {
                if (parsed.contains("description")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("description");
                buildDefinition.setDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("type")) {
                if (parsed.contains("type")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("type");
                buildDefinition.setType(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("schedule")) {
                if (parsed.contains("schedule")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("schedule");
                value = xmlStreamReader.getAttributeValue(null, "id");
                if (value != null) {
                    if (this.scheduleReferences == null) {
                        this.scheduleReferences = new HashMap();
                    }
                    if ((refs = (HashMap<String, String>)this.scheduleReferences.get(buildDefinition)) == null) {
                        refs = new HashMap<String, String>();
                        this.scheduleReferences.put(buildDefinition, refs);
                    }
                    refs.put("schedule", value);
                }
                while (xmlStreamReader.getEventType() != 2) {
                    xmlStreamReader.next();
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("profile")) {
                if (parsed.contains("profile")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("profile");
                value = xmlStreamReader.getAttributeValue(null, "id");
                if (value != null) {
                    if (this.profileReferences == null) {
                        this.profileReferences = new HashMap();
                    }
                    if ((refs = (Map)this.profileReferences.get(buildDefinition)) == null) {
                        refs = new HashMap();
                        this.profileReferences.put(buildDefinition, refs);
                    }
                    refs.put("profile", value);
                }
                while (xmlStreamReader.getEventType() != 2) {
                    xmlStreamReader.next();
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("alwaysBuild")) {
                if (parsed.contains("alwaysBuild")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("alwaysBuild");
                buildDefinition.setAlwaysBuild(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "alwaysBuild", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("template")) {
                if (parsed.contains("template")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("template");
                buildDefinition.setTemplate(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "template", xmlStreamReader));
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        this.buildDefinitionInstances.put(String.valueOf(buildDefinition.getId()), buildDefinition);
        return buildDefinition;
    }

    private BuildDefinitionTemplate parseBuildDefinitionTemplate(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        BuildDefinitionTemplate buildDefinitionTemplate = new BuildDefinitionTemplate();
        buildDefinitionTemplate.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("id");
                buildDefinitionTemplate.setId(this.getIntegerValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "id", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("name");
                buildDefinitionTemplate.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("continuumDefault")) {
                if (parsed.contains("continuumDefault")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("continuumDefault");
                buildDefinitionTemplate.setContinuumDefault(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "continuumDefault", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("type")) {
                if (parsed.contains("type")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("type");
                buildDefinitionTemplate.setType(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("buildDefinitions")) {
                if (parsed.contains("buildDefinitions")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("buildDefinitions");
                ArrayList buildDefinitions = new ArrayList();
                buildDefinitionTemplate.setBuildDefinitions(buildDefinitions);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("buildDefinition")) {
                        buildDefinitionTemplate.addBuildDefinition(this.parseBuildDefinition("buildDefinition", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return buildDefinitionTemplate;
    }

    private BuildResult parseBuildResult(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        BuildResult buildResult = new BuildResult();
        buildResult.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            HashMap<String, String> refs;
            String value;
            if (xmlStreamReader.getLocalName().equals("project")) {
                if (parsed.contains("project")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("project");
                value = xmlStreamReader.getAttributeValue(null, "id");
                if (value != null) {
                    if (this.projectReferences == null) {
                        this.projectReferences = new HashMap();
                    }
                    if ((refs = (HashMap<String, String>)this.projectReferences.get(buildResult)) == null) {
                        refs = new HashMap<String, String>();
                        this.projectReferences.put(buildResult, refs);
                    }
                    refs.put("project", value);
                }
                while (xmlStreamReader.getEventType() != 2) {
                    xmlStreamReader.next();
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("buildDefinition")) {
                if (parsed.contains("buildDefinition")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("buildDefinition");
                value = xmlStreamReader.getAttributeValue(null, "id");
                if (value != null) {
                    if (this.buildDefinitionReferences == null) {
                        this.buildDefinitionReferences = new HashMap();
                    }
                    if ((refs = (Map)this.buildDefinitionReferences.get(buildResult)) == null) {
                        refs = new HashMap();
                        this.buildDefinitionReferences.put(buildResult, refs);
                    }
                    refs.put("buildDefinition", value);
                }
                while (xmlStreamReader.getEventType() != 2) {
                    xmlStreamReader.next();
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("id");
                buildResult.setId(this.getIntegerValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "id", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("buildNumber")) {
                if (parsed.contains("buildNumber")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("buildNumber");
                buildResult.setBuildNumber(this.getIntegerValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "buildNumber", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("state")) {
                if (parsed.contains("state")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("state");
                buildResult.setState(this.getIntegerValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "state", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("trigger")) {
                if (parsed.contains("trigger")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("trigger");
                buildResult.setTrigger(this.getIntegerValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "trigger", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("startTime")) {
                if (parsed.contains("startTime")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("startTime");
                buildResult.setStartTime(this.getLongValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "startTime", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("endTime")) {
                if (parsed.contains("endTime")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("endTime");
                buildResult.setEndTime(this.getLongValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "endTime", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("error")) {
                if (parsed.contains("error")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("error");
                buildResult.setError(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("success")) {
                if (parsed.contains("success")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("success");
                buildResult.setSuccess(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "success", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("exitCode")) {
                if (parsed.contains("exitCode")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("exitCode");
                buildResult.setExitCode(this.getIntegerValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "exitCode", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("scmResult")) {
                if (parsed.contains("scmResult")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("scmResult");
                buildResult.setScmResult(this.parseScmResult("scmResult", xmlStreamReader, strict, encoding));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("testResult")) {
                if (parsed.contains("testResult")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("testResult");
                buildResult.setTestResult(this.parseTestResult("testResult", xmlStreamReader, strict, encoding));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("modifiedDependencies")) {
                if (parsed.contains("modifiedDependencies")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("modifiedDependencies");
                ArrayList modifiedDependencies = new ArrayList();
                buildResult.setModifiedDependencies(modifiedDependencies);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("modifiedDependency")) {
                        buildResult.addModifiedDependency(this.parseProjectDependency("modifiedDependency", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return buildResult;
    }

    private ChangeFile parseChangeFile(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        ChangeFile changeFile = new ChangeFile();
        changeFile.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("name");
                changeFile.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("revision")) {
                if (parsed.contains("revision")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("revision");
                changeFile.setRevision(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("status")) {
                if (parsed.contains("status")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("status");
                changeFile.setStatus(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return changeFile;
    }

    private ChangeSet parseChangeSet(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        ChangeSet changeSet = new ChangeSet();
        changeSet.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("id");
                changeSet.setId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("author")) {
                if (parsed.contains("author")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("author");
                changeSet.setAuthor(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("comment")) {
                if (parsed.contains("comment")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("comment");
                changeSet.setComment(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("date")) {
                if (parsed.contains("date")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("date");
                changeSet.setDate(this.getLongValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "date", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("files")) {
                if (parsed.contains("files")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("files");
                ArrayList files = new ArrayList();
                changeSet.setFiles(files);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("file")) {
                        changeSet.addFile(this.parseChangeFile("file", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return changeSet;
    }

    private ContinuumDatabase parseContinuumDatabase(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        ContinuumDatabase continuumDatabase = new ContinuumDatabase();
        continuumDatabase.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        boolean foundRoot = false;
        while (xmlStreamReader.hasNext()) {
            int eventType = xmlStreamReader.next();
            if (eventType != 1) continue;
            if (xmlStreamReader.getLocalName().equals(tagName)) {
                foundRoot = true;
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("projectGroups")) {
                if (parsed.contains("projectGroups")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("projectGroups");
                ArrayList projectGroups = new ArrayList();
                continuumDatabase.setProjectGroups(projectGroups);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("projectGroup")) {
                        continuumDatabase.addProjectGroup(this.parseProjectGroup("projectGroup", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("systemConfiguration")) {
                if (parsed.contains("systemConfiguration")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("systemConfiguration");
                continuumDatabase.setSystemConfiguration(this.parseSystemConfiguration("systemConfiguration", xmlStreamReader, strict, encoding));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("installations")) {
                if (parsed.contains("installations")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("installations");
                ArrayList installations = new ArrayList();
                continuumDatabase.setInstallations(installations);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("installation")) {
                        continuumDatabase.addInstallation(this.parseInstallation("installation", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("schedules")) {
                if (parsed.contains("schedules")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("schedules");
                ArrayList schedules = new ArrayList();
                continuumDatabase.setSchedules(schedules);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("schedule")) {
                        continuumDatabase.addSchedule(this.parseSchedule("schedule", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("profiles")) {
                if (parsed.contains("profiles")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("profiles");
                ArrayList profiles = new ArrayList();
                continuumDatabase.setProfiles(profiles);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("profile")) {
                        continuumDatabase.addProfile(this.parseProfile("profile", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!foundRoot || !strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return continuumDatabase;
    }

    private ContinuumProjectState parseContinuumProjectState(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        ContinuumProjectState continuumProjectState = new ContinuumProjectState();
        continuumProjectState.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("name");
                continuumProjectState.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return continuumProjectState;
    }

    private Installation parseInstallation(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        String v;
        Installation installation = new Installation();
        installation.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        if (this.installationInstances == null) {
            this.installationInstances = new HashMap();
        }
        if ((v = xmlStreamReader.getAttributeValue(null, "modello.id")) != null) {
            this.installationInstances.put(v, installation);
        }
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("type")) {
                if (parsed.contains("type")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("type");
                installation.setType(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("varValue")) {
                if (parsed.contains("varValue")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("varValue");
                installation.setVarValue(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("varName")) {
                if (parsed.contains("varName")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("varName");
                installation.setVarName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("name");
                installation.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("installationId")) {
                if (parsed.contains("installationId")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("installationId");
                installation.setInstallationId(this.getIntegerValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "installationId", xmlStreamReader, strict));
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        this.installationInstances.put(String.valueOf(installation.getInstallationId()), installation);
        return installation;
    }

    private NotificationAddress parseNotificationAddress(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        NotificationAddress notificationAddress = new NotificationAddress();
        notificationAddress.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("type")) {
                if (parsed.contains("type")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("type");
                notificationAddress.setType(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("address")) {
                if (parsed.contains("address")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("address");
                notificationAddress.setAddress(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("configuration")) {
                if (parsed.contains("configuration")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("configuration");
                while (xmlStreamReader.nextTag() == 1) {
                    String key = xmlStreamReader.getLocalName();
                    String value = xmlStreamReader.getElementText().trim();
                    notificationAddress.addConfiguration(key, value);
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return notificationAddress;
    }

    private Profile parseProfile(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        String v;
        Profile profile = new Profile();
        profile.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        if (this.profileInstances == null) {
            this.profileInstances = new HashMap();
        }
        if ((v = xmlStreamReader.getAttributeValue(null, "modello.id")) != null) {
            this.profileInstances.put(v, profile);
        }
        while (xmlStreamReader.nextTag() == 1) {
            HashMap<String, String> refs;
            String value;
            if (xmlStreamReader.getLocalName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("id");
                profile.setId(this.getIntegerValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "id", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("active")) {
                if (parsed.contains("active")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("active");
                profile.setActive(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "active", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("name");
                profile.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("description")) {
                if (parsed.contains("description")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("description");
                profile.setDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("scmMode")) {
                if (parsed.contains("scmMode")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("scmMode");
                profile.setScmMode(this.getIntegerValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "scmMode", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("buildWithoutChanges")) {
                if (parsed.contains("buildWithoutChanges")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("buildWithoutChanges");
                profile.setBuildWithoutChanges(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "buildWithoutChanges", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("jdk")) {
                if (parsed.contains("jdk")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("jdk");
                value = xmlStreamReader.getAttributeValue(null, "installationId");
                if (value != null) {
                    if (this.installationReferences == null) {
                        this.installationReferences = new HashMap();
                    }
                    if ((refs = (HashMap<String, String>)this.installationReferences.get(profile)) == null) {
                        refs = new HashMap<String, String>();
                        this.installationReferences.put(profile, refs);
                    }
                    refs.put("jdk", value);
                }
                while (xmlStreamReader.getEventType() != 2) {
                    xmlStreamReader.next();
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("builder")) {
                if (parsed.contains("builder")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("builder");
                value = xmlStreamReader.getAttributeValue(null, "installationId");
                if (value != null) {
                    if (this.installationReferences == null) {
                        this.installationReferences = new HashMap();
                    }
                    if ((refs = (Map)this.installationReferences.get(profile)) == null) {
                        refs = new HashMap();
                        this.installationReferences.put(profile, refs);
                    }
                    refs.put("builder", value);
                }
                while (xmlStreamReader.getEventType() != 2) {
                    xmlStreamReader.next();
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("environmentVariables")) {
                if (parsed.contains("environmentVariables")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("environmentVariables");
                ArrayList environmentVariables = new ArrayList();
                profile.setEnvironmentVariables(environmentVariables);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("environmentVariable")) {
                        String value2 = xmlStreamReader.getAttributeValue(null, "installationId");
                        if (value2 != null) {
                            HashMap<String, String> refs2;
                            if (this.installationReferences == null) {
                                this.installationReferences = new HashMap();
                            }
                            if ((refs2 = (HashMap<String, String>)this.installationReferences.get(profile)) == null) {
                                refs2 = new HashMap<String, String>();
                                this.installationReferences.put(profile, refs2);
                            }
                            refs2.put("environmentVariables." + environmentVariables.size(), value2);
                        }
                        profile.addEnvironmentVariable(this.parseInstallation("environmentVariable", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        this.profileInstances.put(String.valueOf(profile.getId()), profile);
        return profile;
    }

    private Project parseProject(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        String v;
        Project project = new Project();
        project.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        if (this.projectInstances == null) {
            this.projectInstances = new HashMap();
        }
        if ((v = xmlStreamReader.getAttributeValue(null, "modello.id")) != null) {
            this.projectInstances.put(v, project);
        }
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("id");
                project.setId(this.getIntegerValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "id", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("groupId")) {
                if (parsed.contains("groupId")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("groupId");
                project.setGroupId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("artifactId")) {
                if (parsed.contains("artifactId")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("artifactId");
                project.setArtifactId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("executorId")) {
                if (parsed.contains("executorId")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("executorId");
                project.setExecutorId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("name");
                project.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("description")) {
                if (parsed.contains("description")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("description");
                project.setDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("url")) {
                if (parsed.contains("url")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("url");
                project.setUrl(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("scmUrl")) {
                if (parsed.contains("scmUrl")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("scmUrl");
                project.setScmUrl(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("scmTag")) {
                if (parsed.contains("scmTag")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("scmTag");
                project.setScmTag(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("scmUsername")) {
                if (parsed.contains("scmUsername")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("scmUsername");
                project.setScmUsername(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("scmPassword")) {
                if (parsed.contains("scmPassword")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("scmPassword");
                project.setScmPassword(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("scmUseCache")) {
                if (parsed.contains("scmUseCache")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("scmUseCache");
                project.setScmUseCache(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "scmUseCache", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("version")) {
                if (parsed.contains("version")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("version");
                project.setVersion(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("state")) {
                if (parsed.contains("state")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("state");
                project.setState(this.getIntegerValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "state", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("oldState")) {
                if (parsed.contains("oldState")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("oldState");
                project.setOldState(this.getIntegerValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "oldState", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("latestBuildId")) {
                if (parsed.contains("latestBuildId")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("latestBuildId");
                project.setLatestBuildId(this.getIntegerValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "latestBuildId", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("buildNumber")) {
                if (parsed.contains("buildNumber")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("buildNumber");
                project.setBuildNumber(this.getIntegerValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "buildNumber", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("workingDirectory")) {
                if (parsed.contains("workingDirectory")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("workingDirectory");
                project.setWorkingDirectory(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("buildResults")) {
                if (parsed.contains("buildResults")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("buildResults");
                ArrayList buildResults = new ArrayList();
                project.setBuildResults(buildResults);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("buildResult")) {
                        project.addBuildResult(this.parseBuildResult("buildResult", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("checkoutResult")) {
                if (parsed.contains("checkoutResult")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("checkoutResult");
                project.setCheckoutResult(this.parseScmResult("checkoutResult", xmlStreamReader, strict, encoding));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("developers")) {
                if (parsed.contains("developers")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("developers");
                ArrayList developers = new ArrayList();
                project.setDevelopers(developers);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("developer")) {
                        project.addDeveloper(this.parseProjectDeveloper("developer", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("parent")) {
                if (parsed.contains("parent")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("parent");
                project.setParent(this.parseProjectDependency("parent", xmlStreamReader, strict, encoding));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("dependencies")) {
                if (parsed.contains("dependencies")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("dependencies");
                ArrayList dependencies = new ArrayList();
                project.setDependencies(dependencies);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("dependency")) {
                        project.addDependency(this.parseProjectDependency("dependency", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("projectGroup")) {
                if (parsed.contains("projectGroup")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("projectGroup");
                String value = xmlStreamReader.getAttributeValue(null, "id");
                if (value != null) {
                    HashMap<String, String> refs;
                    if (this.projectGroupReferences == null) {
                        this.projectGroupReferences = new HashMap();
                    }
                    if ((refs = (HashMap<String, String>)this.projectGroupReferences.get(project)) == null) {
                        refs = new HashMap<String, String>();
                        this.projectGroupReferences.put(project, refs);
                    }
                    refs.put("projectGroup", value);
                }
                while (xmlStreamReader.getEventType() != 2) {
                    xmlStreamReader.next();
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("notifiers")) {
                if (parsed.contains("notifiers")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("notifiers");
                ArrayList notifiers = new ArrayList();
                project.setNotifiers(notifiers);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("notifier")) {
                        project.addNotifier(this.parseProjectNotifier("notifier", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("buildDefinitions")) {
                if (parsed.contains("buildDefinitions")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("buildDefinitions");
                ArrayList buildDefinitions = new ArrayList();
                project.setBuildDefinitions(buildDefinitions);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("buildDefinition")) {
                        project.addBuildDefinition(this.parseBuildDefinition("buildDefinition", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        this.projectInstances.put(String.valueOf(project.getId()), project);
        return project;
    }

    private ProjectDependency parseProjectDependency(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        ProjectDependency projectDependency = new ProjectDependency();
        projectDependency.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("groupId")) {
                if (parsed.contains("groupId")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("groupId");
                projectDependency.setGroupId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("artifactId")) {
                if (parsed.contains("artifactId")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("artifactId");
                projectDependency.setArtifactId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("version")) {
                if (parsed.contains("version")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("version");
                projectDependency.setVersion(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return projectDependency;
    }

    private ProjectDeveloper parseProjectDeveloper(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        ProjectDeveloper projectDeveloper = new ProjectDeveloper();
        projectDeveloper.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("scmId")) {
                if (parsed.contains("scmId")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("scmId");
                projectDeveloper.setScmId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("name");
                projectDeveloper.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("email")) {
                if (parsed.contains("email")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("email");
                projectDeveloper.setEmail(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("continuumId")) {
                if (parsed.contains("continuumId")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("continuumId");
                projectDeveloper.setContinuumId(this.getIntegerValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "continuumId", xmlStreamReader, strict));
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return projectDeveloper;
    }

    private ProjectGroup parseProjectGroup(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        String v;
        ProjectGroup projectGroup = new ProjectGroup();
        projectGroup.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        if (this.projectGroupInstances == null) {
            this.projectGroupInstances = new HashMap();
        }
        if ((v = xmlStreamReader.getAttributeValue(null, "modello.id")) != null) {
            this.projectGroupInstances.put(v, projectGroup);
        }
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("id");
                projectGroup.setId(this.getIntegerValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "id", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("groupId")) {
                if (parsed.contains("groupId")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("groupId");
                projectGroup.setGroupId(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("name");
                projectGroup.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("description")) {
                if (parsed.contains("description")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("description");
                projectGroup.setDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("projects")) {
                if (parsed.contains("projects")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("projects");
                ArrayList projects = new ArrayList();
                projectGroup.setProjects(projects);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("project")) {
                        projectGroup.addProject(this.parseProject("project", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("notifiers")) {
                if (parsed.contains("notifiers")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("notifiers");
                ArrayList notifiers = new ArrayList();
                projectGroup.setNotifiers(notifiers);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("notifier")) {
                        projectGroup.addNotifier(this.parseProjectNotifier("notifier", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("buildDefinitions")) {
                if (parsed.contains("buildDefinitions")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("buildDefinitions");
                ArrayList buildDefinitions = new ArrayList();
                projectGroup.setBuildDefinitions(buildDefinitions);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("buildDefinition")) {
                        projectGroup.addBuildDefinition(this.parseBuildDefinition("buildDefinition", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        this.projectGroupInstances.put(String.valueOf(projectGroup.getId()), projectGroup);
        return projectGroup;
    }

    private ProjectNotifier parseProjectNotifier(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        ProjectNotifier projectNotifier = new ProjectNotifier();
        projectNotifier.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("id");
                projectNotifier.setId(this.getIntegerValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "id", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("type")) {
                if (parsed.contains("type")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("type");
                projectNotifier.setType(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("from")) {
                if (parsed.contains("from")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("from");
                projectNotifier.setFrom(this.getIntegerValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "from", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("enabled")) {
                if (parsed.contains("enabled")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("enabled");
                projectNotifier.setEnabled(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "enabled", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("recipientType")) {
                if (parsed.contains("recipientType")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("recipientType");
                projectNotifier.setRecipientType(this.getIntegerValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "recipientType", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("sendOnSuccess")) {
                if (parsed.contains("sendOnSuccess")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("sendOnSuccess");
                projectNotifier.setSendOnSuccess(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "sendOnSuccess", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("sendOnFailure")) {
                if (parsed.contains("sendOnFailure")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("sendOnFailure");
                projectNotifier.setSendOnFailure(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "sendOnFailure", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("sendOnError")) {
                if (parsed.contains("sendOnError")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("sendOnError");
                projectNotifier.setSendOnError(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "sendOnError", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("sendOnWarning")) {
                if (parsed.contains("sendOnWarning")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("sendOnWarning");
                projectNotifier.setSendOnWarning(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "sendOnWarning", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("configuration")) {
                if (parsed.contains("configuration")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("configuration");
                while (xmlStreamReader.nextTag() == 1) {
                    String key = xmlStreamReader.getLocalName();
                    String value = xmlStreamReader.getElementText().trim();
                    projectNotifier.addConfiguration(key, value);
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return projectNotifier;
    }

    private Schedule parseSchedule(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        String v;
        Schedule schedule = new Schedule();
        schedule.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        if (this.scheduleInstances == null) {
            this.scheduleInstances = new HashMap();
        }
        if ((v = xmlStreamReader.getAttributeValue(null, "modello.id")) != null) {
            this.scheduleInstances.put(v, schedule);
        }
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("id")) {
                if (parsed.contains("id")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("id");
                schedule.setId(this.getIntegerValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "id", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("active")) {
                if (parsed.contains("active")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("active");
                schedule.setActive(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "active", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("name");
                schedule.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("description")) {
                if (parsed.contains("description")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("description");
                schedule.setDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("delay")) {
                if (parsed.contains("delay")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("delay");
                schedule.setDelay(this.getIntegerValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "delay", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("maxJobExecutionTime")) {
                if (parsed.contains("maxJobExecutionTime")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("maxJobExecutionTime");
                schedule.setMaxJobExecutionTime(this.getIntegerValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "maxJobExecutionTime", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("cronExpression")) {
                if (parsed.contains("cronExpression")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("cronExpression");
                schedule.setCronExpression(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        this.scheduleInstances.put(String.valueOf(schedule.getId()), schedule);
        return schedule;
    }

    private ScmResult parseScmResult(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        ScmResult scmResult = new ScmResult();
        scmResult.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("success")) {
                if (parsed.contains("success")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("success");
                scmResult.setSuccess(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "success", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("commandLine")) {
                if (parsed.contains("commandLine")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("commandLine");
                scmResult.setCommandLine(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("providerMessage")) {
                if (parsed.contains("providerMessage")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("providerMessage");
                scmResult.setProviderMessage(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("commandOutput")) {
                if (parsed.contains("commandOutput")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("commandOutput");
                scmResult.setCommandOutput(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("exception")) {
                if (parsed.contains("exception")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("exception");
                scmResult.setException(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("changes")) {
                if (parsed.contains("changes")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("changes");
                ArrayList changes = new ArrayList();
                scmResult.setChanges(changes);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("change")) {
                        scmResult.addChange(this.parseChangeSet("change", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return scmResult;
    }

    private SuiteResult parseSuiteResult(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        SuiteResult suiteResult = new SuiteResult();
        suiteResult.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("name");
                suiteResult.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("testCount")) {
                if (parsed.contains("testCount")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("testCount");
                suiteResult.setTestCount(this.getIntegerValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "testCount", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("failureCount")) {
                if (parsed.contains("failureCount")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("failureCount");
                suiteResult.setFailureCount(this.getIntegerValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "failureCount", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("totalTime")) {
                if (parsed.contains("totalTime")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("totalTime");
                suiteResult.setTotalTime(this.getLongValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "totalTime", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("failures")) {
                if (parsed.contains("failures")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("failures");
                ArrayList failures = new ArrayList();
                suiteResult.setFailures(failures);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("failure")) {
                        suiteResult.addFailure(this.parseTestCaseFailure("failure", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return suiteResult;
    }

    private SystemConfiguration parseSystemConfiguration(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        SystemConfiguration systemConfiguration = new SystemConfiguration();
        systemConfiguration.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("guestAccountEnabled")) {
                if (parsed.contains("guestAccountEnabled")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("guestAccountEnabled");
                systemConfiguration.setGuestAccountEnabled(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "guestAccountEnabled", xmlStreamReader));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("defaultScheduleDescription")) {
                if (parsed.contains("defaultScheduleDescription")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("defaultScheduleDescription");
                systemConfiguration.setDefaultScheduleDescription(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("defaultScheduleCronExpression")) {
                if (parsed.contains("defaultScheduleCronExpression")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("defaultScheduleCronExpression");
                systemConfiguration.setDefaultScheduleCronExpression(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("workingDirectory")) {
                if (parsed.contains("workingDirectory")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("workingDirectory");
                systemConfiguration.setWorkingDirectory(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("buildOutputDirectory")) {
                if (parsed.contains("buildOutputDirectory")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("buildOutputDirectory");
                systemConfiguration.setBuildOutputDirectory(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("deploymentRepositoryDirectory")) {
                if (parsed.contains("deploymentRepositoryDirectory")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("deploymentRepositoryDirectory");
                systemConfiguration.setDeploymentRepositoryDirectory(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("baseUrl")) {
                if (parsed.contains("baseUrl")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("baseUrl");
                systemConfiguration.setBaseUrl(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("initialized")) {
                if (parsed.contains("initialized")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("initialized");
                systemConfiguration.setInitialized(this.getBooleanValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "initialized", xmlStreamReader));
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return systemConfiguration;
    }

    private TestCaseFailure parseTestCaseFailure(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        TestCaseFailure testCaseFailure = new TestCaseFailure();
        testCaseFailure.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("name")) {
                if (parsed.contains("name")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("name");
                testCaseFailure.setName(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("exception")) {
                if (parsed.contains("exception")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("exception");
                testCaseFailure.setException(this.getTrimmedValue(xmlStreamReader.getElementText()));
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return testCaseFailure;
    }

    private TestResult parseTestResult(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding) throws IOException, XMLStreamException {
        TestResult testResult = new TestResult();
        testResult.setModelEncoding(encoding);
        HashSet<String> parsed = new HashSet<String>();
        while (xmlStreamReader.nextTag() == 1) {
            if (xmlStreamReader.getLocalName().equals("testCount")) {
                if (parsed.contains("testCount")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("testCount");
                testResult.setTestCount(this.getIntegerValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "testCount", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("failureCount")) {
                if (parsed.contains("failureCount")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("failureCount");
                testResult.setFailureCount(this.getIntegerValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "failureCount", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("totalTime")) {
                if (parsed.contains("totalTime")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("totalTime");
                testResult.setTotalTime(this.getLongValue(this.getTrimmedValue(xmlStreamReader.getElementText()), "totalTime", xmlStreamReader, strict));
                continue;
            }
            if (xmlStreamReader.getLocalName().equals("suiteResults")) {
                if (parsed.contains("suiteResults")) {
                    throw new XMLStreamException("Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                parsed.add("suiteResults");
                ArrayList suiteResults = new ArrayList();
                testResult.setSuiteResults(suiteResults);
                while (xmlStreamReader.nextTag() == 1) {
                    if (xmlStreamReader.getLocalName().equals("suiteResult")) {
                        testResult.addSuiteResult(this.parseSuiteResult("suiteResult", xmlStreamReader, strict, encoding));
                        continue;
                    }
                    throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
                }
                continue;
            }
            if (!strict) continue;
            throw new XMLStreamException("Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation());
        }
        return testResult;
    }

    public ContinuumDatabase read(Reader reader, boolean strict) throws IOException, XMLStreamException {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(reader);
        String encoding = xmlStreamReader.getCharacterEncodingScheme();
        ContinuumDatabase value = this.parseContinuumDatabase("continuumDatabase", xmlStreamReader, strict, encoding);
        this.resolveReferences(value);
        return value;
    }

    public ContinuumDatabase read(Reader reader) throws IOException, XMLStreamException {
        return this.read(reader, true);
    }

    public ContinuumDatabase read(String filePath, boolean strict) throws IOException, XMLStreamException {
        File file = new File(filePath);
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(file.toURL().toExternalForm(), new FileInputStream(file));
        String encoding = xmlStreamReader.getCharacterEncodingScheme();
        ContinuumDatabase value = this.parseContinuumDatabase("continuumDatabase", xmlStreamReader, strict, encoding);
        this.resolveReferences(value);
        return value;
    }

    public ContinuumDatabase read(String filePath) throws IOException, XMLStreamException {
        return this.read(filePath, true);
    }

    private void resolveReferences(ContinuumDatabase value) {
        Iterator i = value.getProjectGroups().iterator();
        while (i.hasNext()) {
            this.resolveReferences((ProjectGroup)i.next());
        }
        i = value.getProfiles().iterator();
        while (i.hasNext()) {
            this.resolveReferences((Profile)i.next());
        }
    }

    private void resolveReferences(Profile value) {
        String id;
        Installation ref;
        Map refs;
        if (this.installationReferences != null && (refs = (Map)this.installationReferences.get(value)) != null && (ref = (Installation)this.installationInstances.get(id = (String)refs.get("jdk"))) != null && !ref.equals(value.getJdk())) {
            value.setJdk(ref);
        }
        if (this.installationReferences != null && (refs = (Map)this.installationReferences.get(value)) != null && (ref = (Installation)this.installationInstances.get(id = (String)refs.get("builder"))) != null && !ref.equals(value.getBuilder())) {
            value.setBuilder(ref);
        }
        if (this.installationReferences != null && (refs = (Map)this.installationReferences.get(value)) != null) {
            for (int i = 0; i < value.getEnvironmentVariables().size(); ++i) {
                String id2 = (String)refs.get("environmentVariables." + i);
                Installation ref2 = (Installation)this.installationInstances.get(id2);
                if (ref2 == null) continue;
                value.getEnvironmentVariables().set(i, ref2);
            }
        }
    }

    private void resolveReferences(ProjectGroup value) {
        Iterator i = value.getProjects().iterator();
        while (i.hasNext()) {
            this.resolveReferences((Project)i.next());
        }
        i = value.getBuildDefinitions().iterator();
        while (i.hasNext()) {
            this.resolveReferences((BuildDefinition)i.next());
        }
    }

    private void resolveReferences(BuildDefinition value) {
        String id;
        PersistenceCapable ref;
        Map refs;
        if (this.scheduleReferences != null && (refs = (Map)this.scheduleReferences.get(value)) != null && (ref = (Schedule)this.scheduleInstances.get(id = (String)refs.get("schedule"))) != null && !ref.equals(value.getSchedule())) {
            value.setSchedule((Schedule)ref);
        }
        if (this.profileReferences != null && (refs = (Map)this.profileReferences.get(value)) != null && (ref = (Profile)this.profileInstances.get(id = (String)refs.get("profile"))) != null && !ref.equals(value.getProfile())) {
            value.setProfile((Profile)ref);
        }
    }

    private void resolveReferences(Project value) {
        String id;
        ProjectGroup ref;
        Map refs;
        Iterator i = value.getBuildResults().iterator();
        while (i.hasNext()) {
            this.resolveReferences((BuildResult)i.next());
        }
        if (this.projectGroupReferences != null && (refs = (Map)this.projectGroupReferences.get(value)) != null && (ref = (ProjectGroup)this.projectGroupInstances.get(id = (String)refs.get("projectGroup"))) != null && !ref.equals(value.getProjectGroup())) {
            value.setProjectGroup(ref);
        }
        i = value.getBuildDefinitions().iterator();
        while (i.hasNext()) {
            this.resolveReferences((BuildDefinition)i.next());
        }
    }

    private void resolveReferences(BuildResult value) {
        String id;
        PersistenceCapable ref;
        Map refs;
        if (this.projectReferences != null && (refs = (Map)this.projectReferences.get(value)) != null && (ref = (Project)this.projectInstances.get(id = (String)refs.get("project"))) != null && !ref.equals(value.getProject())) {
            value.setProject((Project)ref);
        }
        if (this.buildDefinitionReferences != null && (refs = (Map)this.buildDefinitionReferences.get(value)) != null && (ref = (BuildDefinition)this.buildDefinitionInstances.get(id = (String)refs.get("buildDefinition"))) != null && !ref.equals(value.getBuildDefinition())) {
            value.setBuildDefinition((BuildDefinition)ref);
        }
    }
}

